/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.doc.common.util;

import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class WaterPrintUtil {
    private WaterPrintUtil() {
    }

    public static int setWaterMark(String markedpdf, String unmarkedpdf, String watermark) throws DocumentException, IOException {
        String markText = watermark;
        FileOutputStream ops = new FileOutputStream(new File(markedpdf));
        BufferedOutputStream bos = new BufferedOutputStream(ops);
        PdfReader reader = new PdfReader(unmarkedpdf);
        PdfStamper stamper = new PdfStamper(reader, (OutputStream)bos);
        int pageCount = reader.getNumberOfPages();
        int total = pageCount + 1;
        BaseFont base = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)true);
        for (int i = 1; i < total; ++i) {
            PdfContentByte content = stamper.getUnderContent(i);
            content.beginText();
            content.setRGBColorFill(191, 191, 192);
            content.setFontAndSize(base, 50.0f);
            content.setTextMatrix(70.0f, 200.0f);
            content.showTextAligned(1, markText, 300.0f, 650.0f, 14.0f);
            content.showTextAligned(1, markText, 300.0f, 330.0f, 14.0f);
            content.endText();
        }
        stamper.close();
        bos.close();
        ops.close();
        return pageCount;
    }
}

