/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.doc.common.util;

import java.security.MessageDigest;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;
import java.util.UUID;

public class StringUtil {
    public static String getUUID() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public static String getString(Object obj) {
        if (obj != null) {
            return obj.toString();
        }
        return "";
    }

    public static Integer getInteger(Object obj) {
        if (obj != null) {
            return Integer.valueOf(obj.toString());
        }
        return 0;
    }

    public static Double getDouble(Object obj) {
        if (obj != null) {
            return Double.valueOf(obj.toString());
        }
        return 0.0;
    }

    public static Boolean getBoolean(Object obj) {
        if (obj != null) {
            return Boolean.valueOf(obj.toString());
        }
        return false;
    }

    public static boolean checkIsEmpty(String str) {
        return str == null || "".equals(str) || "null".equals(str);
    }

    public static String transferSqlParam(String paramStr) {
        if (paramStr == null) {
            return null;
        }
        return paramStr.replaceAll("\\%", "\\\\%").replaceAll("\\_", "\\\\_");
    }

    public static String transferSpecialChar(String str) {
        if (str == null) {
            return str;
        }
        if ("".equals(str)) {
            return str;
        }
        return str.replaceAll("\\+", "%20").replaceAll("%28", "\\(").replaceAll("%29", "\\)").replaceAll("%3B", ";").replaceAll("%40", "@").replaceAll("%23", "\\#").replaceAll("%26", "\\&").replaceAll("%2C", "\\,").replaceAll("%2B", "\\+").replaceAll("%7D", "\\}").replaceAll("%7B", "\\{").replaceAll("%24", "\\$").replaceAll("%5E", "\\^").replaceAll("%25", "\\%").replaceAll("%7E", "\\~").replaceAll("%3D", "\\=").replaceAll("%60", "\\`");
    }

    public static String applySha256(String input) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hash = digest.digest(input.getBytes("UTF-8"));
            StringBuilder hexString = new StringBuilder();
            for (int i = 0; i < hash.length; ++i) {
                String hex = Integer.toHexString(0xFF & hash[i]);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }
            return hexString.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String getRandomCode(int n) {
        String val = "";
        Random random = new Random();
        for (int i = 0; i < n; ++i) {
            String str;
            String string = str = random.nextInt(2) % 2 == 0 ? "num" : "char";
            if ("char".equalsIgnoreCase(str)) {
                int nextInt = random.nextInt(2) % 2 == 0 ? 65 : 97;
                val = val + (char)(nextInt + random.nextInt(26));
                continue;
            }
            if (!"num".equalsIgnoreCase(str)) continue;
            val = val + String.valueOf(random.nextInt(10));
        }
        return val;
    }

    public static Date stringToDate(String dateString) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
            Date date = sdf.parse(dateString);
            return date;
        }
        catch (ParseException e) {
            System.out.println(e.getMessage());
            return null;
        }
    }

    public static String captureName(String name) {
        name = name.substring(0, 1).toUpperCase() + name.substring(1);
        return name;
    }

    public static boolean isPdf(String docType) {
        switch (docType = docType.replace(".", "")) {
            case "doc": 
            case "docx": 
            case "dot": 
            case "xls": 
            case "wps": 
            case "xlt": 
            case "et": 
            case "ett": 
            case "ppts": 
            case "pot": 
            case "dps": 
            case "dpt": 
            case "xlsx": 
            case "txt": 
            case "pdf": 
            case "ceb": 
            case "ppt": 
            case "pptx": {
                return true;
            }
        }
        return false;
    }
}

