/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.doc.common.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesUtil {
    private Logger log = LoggerFactory.getLogger(PropertiesUtil.class);
    public static final int DEFAULT_PATH = 0;
    public static final int RELATIVE_PATH = 1;
    public static final int ABSOLUTE_PATH = 2;
    private static Object clockObj = PropertiesUtil.class;
    private static final String PROPERTY_FILE_PATH = "/";
    private static Map<String, PropertiesUtil> propertyUtilMap = new HashMap<String, PropertiesUtil>();
    private String filePath = null;
    private static Properties properties = null;
    private static Map<String, Properties> proMap = new HashMap<String, Properties>();
    private long modifyTime = 0L;
    private static boolean success = false;

    public PropertiesUtil(String propertyName, String path, int bln) {
        success = false;
        if (bln == 0) {
            this.filePath = this.getClassPath() + propertyName + ".properties";
        } else if (1 == bln) {
            this.filePath = this.getClassPath() + path + PROPERTY_FILE_PATH + propertyName + ".properties";
        } else if (2 == bln) {
            this.filePath = path + PROPERTY_FILE_PATH + propertyName + ".properties";
        }
        InputStream instream = null;
        try {
            if (this.filePath != null && !"".equals(this.filePath)) {
                File file = new File(this.filePath);
                if (file.exists()) {
                    instream = new FileInputStream(this.filePath);
                    properties = new Properties();
                    properties.load(instream);
                    proMap.put(propertyName, properties);
                    instream.close();
                    success = true;
                } else {
                    instream = PropertiesUtil.class.getClassLoader().getResourceAsStream(propertyName + ".properties");
                    if (instream != null) {
                        properties = new Properties();
                        properties.load(instream);
                        proMap.put(propertyName, properties);
                        instream.close();
                        success = true;
                    } else {
                        this.log.error("\u5c5e\u6027\u6587\u4ef6\u4e0d\u5b58\u5728! filePath = " + this.filePath);
                    }
                }
            } else {
                this.log.info("\u5c5e\u6027\u6587\u4ef6\u8def\u5f84\u4e3a\u7a7a!");
            }
        }
        catch (IOException e) {
            throw new RuntimeException("\u524d\u7f6e\u8282\u70b9\u914d\u7f6e\u6587\u4ef6\u52a0\u8f7d\u5931\u8d25\uff0c" + e.getMessage());
        }
        finally {
            if (instream != null) {
                try {
                    instream.close();
                    instream = null;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private String getClassPath() {
        URL url = this.getClass().getResource(PROPERTY_FILE_PATH);
        String path = null;
        try {
            path = URLDecoder.decode(url.getPath(), "UTF-8");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return path;
    }

    public static PropertiesUtil newInstance(String propertyName) {
        return PropertiesUtil.initPropertyUtil(propertyName, "", 0);
    }

    public static PropertiesUtil newInstance(String propertyName, String path, int bln) {
        return PropertiesUtil.initPropertyUtil(propertyName, path, bln);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PropertiesUtil initPropertyUtil(String propertyName, String path, int bln) {
        Object object = clockObj;
        synchronized (object) {
            PropertiesUtil propertyUtil = propertyUtilMap.get(propertyName);
            if (propertyUtil == null) {
                propertyUtil = new PropertiesUtil(propertyName, path, bln);
                if (success) {
                    propertyUtilMap.put(propertyName, propertyUtil);
                }
            }
            return propertyUtil;
        }
    }

    public static String getMsg(String key) {
        if (properties != null) {
            return properties.getProperty(key);
        }
        return null;
    }

    public static void setSnapMsg(String key, String value) {
        if (properties != null) {
            properties.put(key, value);
        }
    }

    public static Properties getSnapProps() {
        if (properties != null) {
            return properties;
        }
        return null;
    }

    public static void setSnapProps(Properties props) {
        properties = props;
    }

    public static String getMsg(String propertyName, String key) {
        if (proMap.get(propertyName) != null) {
            return proMap.get(propertyName).getProperty(key);
        }
        return null;
    }

    public String getMsg(String key, Object[] objs) {
        if (properties == null || properties.getProperty(key) == null) {
            return null;
        }
        return MessageFormat.format(properties.getProperty(key), objs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMsg(String key, String value) {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(this.filePath);
            properties.setProperty(key, value);
            properties.store(out, null);
        }
        catch (IOException e) {
            this.log.info("occur error when upate the property! filePath = " + this.filePath);
        }
        finally {
            if (out != null) {
                try {
                    out.flush();
                    ((OutputStream)out).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public String getFilePath() {
        return this.filePath;
    }

    public static Map<String, PropertiesUtil> getPropertyUtilMap() {
        return propertyUtilMap;
    }

    protected long getModifyTime() {
        return this.modifyTime;
    }

    protected Properties getProperties() {
        return properties;
    }
}

