/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.doc.common.util;

import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfWriter;
import com.jacob.activeX.ActiveXComponent;
import com.jacob.com.ComThread;
import com.jacob.com.Dispatch;
import com.jacob.com.Variant;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import org.apache.tika.detect.AutoDetectReader;
import org.apache.tika.exception.TikaException;

public class PdfUtil {
    private static final Integer WORD_TO_PDF_OPERAND = 17;
    private static final Integer PPT_TO_PDF_OPERAND = 32;
    private static final Integer EXCEL_TO_PDF_OPERAND = 0;

    private PdfUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void word2pdf(String srcFilePath, String pdfFilePath) {
        ActiveXComponent app;
        block8: {
            app = null;
            Dispatch word = null;
            try {
                ComThread.InitSTA();
                app = new ActiveXComponent("Word.Application");
                app.setProperty("Visible", false);
                Dispatch docs = app.getProperty("Documents").toDispatch();
                Object[] obj = new Object[]{srcFilePath, new Variant(false), new Variant(false), new Variant(false), new Variant((Object)"pwd")};
                word = Dispatch.invoke((Dispatch)docs, (String)"Open", (int)1, (Object[])obj, (int[])new int[1]).toDispatch();
                Dispatch.put((Dispatch)word, (String)"RemovePersonalInformation", (Object)false);
                Dispatch.call((Dispatch)word, (String)"ExportAsFixedFormat", (Object[])new Object[]{pdfFilePath, WORD_TO_PDF_OPERAND});
                if (word == null) break block8;
            }
            catch (Exception e) {
                block9: {
                    try {
                        e.printStackTrace();
                        if (word == null) break block9;
                    }
                    catch (Throwable throwable) {
                        if (word != null) {
                            Dispatch.call(word, (String)"Close", (Object[])new Object[]{false});
                        }
                        if (app != null) {
                            app.invoke("Quit", 0);
                        }
                        ComThread.Release();
                        throw throwable;
                    }
                    Dispatch.call(word, (String)"Close", (Object[])new Object[]{false});
                }
                if (app != null) {
                    app.invoke("Quit", 0);
                }
                ComThread.Release();
            }
            Dispatch.call((Dispatch)word, (String)"Close", (Object[])new Object[]{false});
        }
        if (app != null) {
            app.invoke("Quit", 0);
        }
        ComThread.Release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void ppt2pdf(String srcFilePath, String pdfFilePath) throws Exception {
        block9: {
            ActiveXComponent app;
            block8: {
                app = null;
                Dispatch ppt = null;
                try {
                    ComThread.InitSTA();
                    app = new ActiveXComponent("PowerPoint.Application");
                    Dispatch ppts = app.getProperty("Presentations").toDispatch();
                    ppt = Dispatch.call((Dispatch)ppts, (String)"Open", (Object[])new Object[]{srcFilePath, true, true, false}).toDispatch();
                    Dispatch.call((Dispatch)ppt, (String)"SaveAs", (Object[])new Object[]{pdfFilePath, PPT_TO_PDF_OPERAND});
                    if (ppt == null) break block8;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    break block9;
                }
                finally {
                    if (ppt != null) {
                        Dispatch.call(ppt, (String)"Close");
                    }
                    if (app != null) {
                        app.invoke("Quit");
                    }
                    ComThread.Release();
                }
                Dispatch.call((Dispatch)ppt, (String)"Close");
            }
            if (app != null) {
                app.invoke("Quit");
            }
            ComThread.Release();
        }
    }

    public static synchronized void excel2Pdf(String inFilePath, String outFilePath) throws Exception {
        ActiveXComponent ax;
        block7: {
            inFilePath = inFilePath.replaceAll("//", "/");
            ax = null;
            Dispatch excel = null;
            Dispatch sheets = null;
            Dispatch sheet = null;
            try {
                ComThread.InitSTA();
                ax = new ActiveXComponent("Excel.Application");
                ax.setProperty("Visible", new Variant(false));
                ax.setProperty("AutomationSecurity", new Variant(3));
                Dispatch excels = ax.getProperty("Workbooks").toDispatch();
                Object[] obj = new Object[]{inFilePath, new Variant(false), new Variant(false)};
                excel = Dispatch.invoke((Dispatch)excels, (String)"Open", (int)1, (Object[])obj, (int[])new int[9]).toDispatch();
                sheets = Dispatch.get((Dispatch)excel, (String)"Sheets").toDispatch();
                int count = Dispatch.get((Dispatch)sheets, (String)"Count").getInt();
                sheet = Dispatch.invoke((Dispatch)sheets, (String)"Item", (int)2, (Object[])new Object[]{new Integer(1)}, (int[])new int[1]).toDispatch();
                Dispatch.call((Dispatch)sheet, (String)"Activate");
                Dispatch pageSetup = Dispatch.get((Dispatch)sheet, (String)"PageSetup").toDispatch();
                Dispatch.put((Dispatch)pageSetup, (String)"Orientation", (Object)new Variant(2));
                Dispatch.put((Dispatch)pageSetup, (String)"Zoom", (Object)false);
                Dispatch.put((Dispatch)pageSetup, (String)"FitToPagesWide", (Object)1);
                Object[] obj2 = new Object[]{new Variant((Object)EXCEL_TO_PDF_OPERAND), outFilePath, new Variant(0)};
                Dispatch.invoke((Dispatch)sheet, (String)"ExportAsFixedFormat", (int)1, (Object[])obj2, (int[])new int[1]);
                if (excel == null) break block7;
            }
            catch (Exception es) {
                try {
                    es.printStackTrace();
                    throw es;
                }
                catch (Throwable throwable) {
                    if (excel != null) {
                        Dispatch.call(excel, (String)"Close", (Object[])new Object[]{new Variant(false)});
                    }
                    if (ax != null) {
                        ax.invoke("Quit", new Variant[0]);
                        ax = null;
                    }
                    ComThread.Release();
                    throw throwable;
                }
            }
            Dispatch.call((Dispatch)excel, (String)"Close", (Object[])new Object[]{new Variant(false)});
        }
        if (ax != null) {
            ax.invoke("Quit", new Variant[0]);
            ax = null;
        }
        ComThread.Release();
    }

    private void s() {
        Dispatch sheet = null;
        Dispatch sheets = null;
        ActiveXComponent actcom = new ActiveXComponent("Excel.Application");
        actcom.setProperty("Visible", new Variant(false));
        Dispatch excels = actcom.getProperty("Workbooks").toDispatch();
        Dispatch excel = Dispatch.invoke((Dispatch)excels, (String)"Open", (int)1, (Object[])new Object[]{"filePath", new Variant(false), new Variant(false)}, (int[])new int[9]).toDispatch();
        sheets = Dispatch.get((Dispatch)excel, (String)"Sheets").toDispatch();
        int count = Dispatch.get((Dispatch)sheets, (String)"Count").getInt();
        for (int j = 1; j <= count; ++j) {
            sheet = Dispatch.invoke((Dispatch)sheets, (String)"Item", (int)2, (Object[])new Object[]{new Integer(j)}, (int[])new int[1]).toDispatch();
            String sheetname = Dispatch.get((Dispatch)sheet, (String)"name").toString();
            Dispatch.call((Dispatch)sheet, (String)"Activate");
            Dispatch.call((Dispatch)sheet, (String)"Select");
            Dispatch.invoke((Dispatch)excel, (String)"SaveAs", (int)1, (Object[])new Object[]{"outFile", new Variant(57), new Variant(false), new Variant(57), new Variant(57), new Variant(false), new Variant(true), new Variant(57), new Variant(false), new Variant(true), new Variant(false)}, (int[])new int[1]);
        }
        Dispatch.call((Dispatch)excel, (String)"Close", (Object[])new Object[]{new Variant(true)});
        if (actcom != null) {
            actcom.invoke("Quit", new Variant[0]);
            actcom = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void txt2pdf(String inFilePath, String outFilePath) {
        Document document = new Document(PageSize.A4, 80.0f, 80.0f, 60.0f, 30.0f);
        try {
            PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(outFilePath));
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        document.open();
        FileInputStream fis = null;
        BufferedReader read = null;
        InputStreamReader isr = null;
        BaseFont bfChinese = null;
        try {
            bfChinese = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
            Font fontChinese = new Font(bfChinese, 18.0f, 0);
            Paragraph t = new Paragraph();
            t.setAlignment(1);
            t.setLeading(30.0f);
            document.add((Element)t);
            fontChinese = new Font(bfChinese, 11.0f, 0);
            fis = new FileInputStream(inFilePath);
            String codingFormat = PdfUtil.resolveCode(inFilePath);
            isr = new InputStreamReader((InputStream)fis, codingFormat);
            read = new BufferedReader(isr);
            String line = null;
            while ((line = read.readLine()) != null) {
                t = new Paragraph(line, fontChinese);
                t.setAlignment(0);
                t.setLeading(20.0f);
                try {
                    document.add((Element)t);
                }
                catch (DocumentException e) {
                    e.printStackTrace();
                }
            }
            if (fis != null) {
                fis.close();
            }
            if (read != null) {
                read.close();
            }
            if (isr != null) {
                isr.close();
            }
            if (document != null) {
                document.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (read != null) {
                try {
                    read.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (isr != null) {
                try {
                    isr.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (document != null) {
                document.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String resolveCode(String path) {
        FileInputStream inputStream = null;
        AutoDetectReader dr = null;
        String code = "gb2312";
        try {
            inputStream = new FileInputStream(path);
            dr = new AutoDetectReader((InputStream)inputStream);
            String drCode = dr.getCharset().name();
            if (drCode != null && !"".equals(drCode)) {
                code = dr.getCharset().name();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (TikaException e) {
            e.printStackTrace();
        }
        finally {
            if (inputStream != null) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (dr != null) {
                try {
                    dr.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return code;
    }
}

