/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.doc.common.util;

import java.awt.image.BufferedImage;
import java.io.File;
import javax.imageio.ImageIO;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;

public class PdfToImage {
    public static final float DEFAULT_DPI = 105.0f;

    private PdfToImage() {
    }

    public static void pdfToOneImage(File pdfPath, File imgPath) {
        try {
            if (!pdfPath.exists()) {
                return;
            }
            int width = 0;
            int shiftHeight = 0;
            BufferedImage imageResult = null;
            PDDocument pdDocument = PDDocument.load((File)pdfPath);
            PDFRenderer renderer = new PDFRenderer(pdDocument);
            int len = pdDocument.getNumberOfPages();
            for (int i = 0; i < len; ++i) {
                BufferedImage image = renderer.renderImageWithDPI(i, 105.0f, ImageType.RGB);
                int imageHeight = image.getHeight();
                int imageWidth = image.getWidth();
                if (i == 0) {
                    width = imageWidth;
                    imageResult = new BufferedImage(width, imageHeight * len, 1);
                } else {
                    shiftHeight += imageHeight;
                }
                int[] singleImgRGB = image.getRGB(0, 0, width, imageHeight, null, 0, width);
                imageResult.setRGB(0, shiftHeight, width, imageHeight, singleImgRGB, 0, width);
            }
            pdDocument.close();
            ImageIO.write(imageResult, "jpg", imgPath);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

