/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.doc.common.util;

import com.jxdinfo.doc.common.util.SpringContextUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Pattern;
import org.jodconverter.OfficeDocumentConverter;
import org.jodconverter.office.DefaultOfficeManagerBuilder;
import org.jodconverter.office.OfficeException;
import org.jodconverter.office.OfficeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;

public class LibreOfficePDFConvert {
    private static ApplicationContext appCtx = SpringContextUtil.getApplicationContext();
    private static final Logger logger = LoggerFactory.getLogger(LibreOfficePDFConvert.class);
    private static String officeHomeDir = null;
    private static Environment environment = (Environment)appCtx.getBean(Environment.class);

    public static String doDocToFdpLibre(File sourceFile, File tarPdfFile) throws OfficeException {
        File inputFile = sourceFile;
        officeHomeDir = environment.getProperty("docbase.officeHomeDir");
        String libreOfficePath = LibreOfficePDFConvert.getOfficeHome();
        DefaultOfficeManagerBuilder builder = new DefaultOfficeManagerBuilder();
        builder.setOfficeHome(new File(libreOfficePath));
        builder.setPortNumber(8100);
        builder.setTaskExecutionTimeout(3000000L);
        builder.setTaskQueueTimeout(864000000L);
        OfficeManager officeManager = builder.build();
        LibreOfficePDFConvert.startService(officeManager);
        OfficeDocumentConverter converter = new OfficeDocumentConverter(officeManager);
        File outputFile = tarPdfFile;
        converter.convert(inputFile, outputFile);
        LibreOfficePDFConvert.stopService(officeManager);
        String pdfPath = outputFile.getPath();
        return pdfPath;
    }

    private static String getOfficeHome() {
        if (null != officeHomeDir) {
            return officeHomeDir;
        }
        String osName = System.getProperty("os.name");
        if (Pattern.matches("Windows.*", osName)) {
            officeHomeDir = "C:\\Program Files\\LibreOffice";
            return officeHomeDir;
        }
        if (Pattern.matches("Linux.*", osName)) {
            officeHomeDir = "/opt/libreoffice6.0";
            return officeHomeDir;
        }
        if (Pattern.matches("Mac.*", osName)) {
            officeHomeDir = "/Application/openOfficeSoft";
            return officeHomeDir;
        }
        return null;
    }

    private static void stopService(OfficeManager officeManager) throws OfficeException {
        if (null != officeManager) {
            officeManager.stop();
        }
        logger.info("\u5173\u95edoffice\u8f6c\u6362\u6210\u529f!");
    }

    private static void startService(OfficeManager officeManager) {
        try {
            officeManager.start();
            logger.info("office\u8f6c\u6362\u670d\u52a1\u542f\u52a8\u6210\u529f");
        }
        catch (Exception ce) {
            logger.error("office\u8f6c\u6362\u670d\u52a1\u542f\u52a8\u5931\u8d25!\u8be6\u7ec6\u4fe1\u606f:{}", (Throwable)ce);
        }
    }

    public static void setOfficeHome(String officeHome) {
        officeHomeDir = officeHome;
    }

    public static void main(String[] args) {
        Path path = Paths.get("D:\\pdfconvert\\printsource", new String[0]);
        try {
            DirectoryStream<Path> paths = Files.newDirectoryStream(path);
            for (Path p : paths) {
                long t1 = System.currentTimeMillis();
                File f = p.toFile();
                System.out.println(path.getParent().toString() + "/printsourcelibre/" + f.getName().substring(0, f.getName().lastIndexOf(".")) + ".pdf");
                new LibreOfficePDFConvert();
                LibreOfficePDFConvert.doDocToFdpLibre(f, new File(path.getParent().toString() + "/printsourcelibre/" + f.getName().substring(0, f.getName().lastIndexOf(".")).toString() + ".pdf"));
                long t2 = System.currentTimeMillis();
                System.out.println("\u8017\u65f6\uff1a" + (t2 - t1));
            }
        }
        catch (IOException | OfficeException e) {
            e.printStackTrace();
        }
    }
}

