/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.doc.common.util;

import java.util.UUID;

public final class FilenameUtils {
    private static final String[] chars = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
    private static final String FILEPATTERN = "%s.%s";

    private FilenameUtils() {
    }

    public static String generateShortUuid() {
        StringBuffer shortBuffer = new StringBuffer();
        String uuid = UUID.randomUUID().toString().replace("-", "");
        for (int i = 0; i < 8; ++i) {
            String str = uuid.substring(i * 4, i * 4 + 4);
            int x = Integer.parseInt(str, 16);
            shortBuffer.append(chars[x % 62]);
        }
        return shortBuffer.toString();
    }

    public static String getExtension(String fileName) {
        return fileName.substring(fileName.lastIndexOf(".") + 1);
    }

    public static String getPrefix(String fileName) {
        return fileName.substring(0, fileName.lastIndexOf("."));
    }

    public static String getPrefixRandom(String fileName) {
        return fileName.substring(0, fileName.lastIndexOf(".")) + "_" + FilenameUtils.generateShortUuid();
    }

    public static String merge(String prefix, String ext) {
        return String.format(FILEPATTERN, prefix, ext);
    }
}

