/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.doc.common.util;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class DesUtil {
    private DesUtil() {
        throw new AssertionError((Object)"No DesCipherUtil instances for you!");
    }

    public static String encrypt(String encryptText, String key) {
        if (encryptText == null || key == null) {
            throw new IllegalArgumentException("encryptText or key must not be null");
        }
        try {
            DESKeySpec desKeySpec = new DESKeySpec(key.getBytes());
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("DES");
            SecretKey secretKey = secretKeyFactory.generateSecret(desKeySpec);
            Cipher cipher = Cipher.getInstance("DES/ECB/NoPadding", "");
            cipher.init(1, secretKey);
            byte[] bytes = cipher.doFinal(encryptText.getBytes(Charset.forName("UTF-8")));
            return Base64.getEncoder().encodeToString(bytes);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | InvalidKeySpecException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new RuntimeException("encrypt failed", e);
        }
    }

    public static String decrypt(String decryptText, String key) {
        if (decryptText == null || key == null) {
            throw new IllegalArgumentException("decryptText or key must not be null");
        }
        try {
            DESKeySpec desKeySpec = new DESKeySpec(key.getBytes());
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("DES");
            SecretKey secretKey = secretKeyFactory.generateSecret(desKeySpec);
            Cipher cipher = Cipher.getInstance("DES/ECB/PKCS7Padding", " BC");
            cipher.init(2, secretKey);
            byte[] bytes = new byte[]{};
            bytes = cipher.doFinal(decryptText.getBytes());
            return new String(bytes, Charset.forName("UTF-8"));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | InvalidKeySpecException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new RuntimeException("decrypt failed", e);
        }
    }

    public static String base64_decode_8859(String source) {
        String result = "";
        Base64.Decoder decoder = Base64.getDecoder();
        try {
            result = new String(decoder.decode(source), "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return result;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

