/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.doc.timer.job;

import com.jxdinfo.doc.common.docutil.service.BusinessService;
import com.jxdinfo.doc.common.util.SpringContextUtil;
import com.jxdinfo.doc.front.groupmanager.service.FrontDocGroupService;
import com.jxdinfo.doc.front.topicmanager.service.FrontTopicService;
import com.jxdinfo.doc.manager.statistics.service.FileStatisticsService;
import com.jxdinfo.hussar.common.quartz.job.HiJob;
import java.util.Collection;
import java.util.Date;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.mgt.eis.SessionDAO;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.context.ApplicationContext;

public class DeleteSession
extends HiJob {
    private static ApplicationContext appCtx = SpringContextUtil.getApplicationContext();
    private SessionDAO sessionDAO = (SessionDAO)appCtx.getBean(SessionDAO.class);
    private FileStatisticsService fileStatisticsService = (FileStatisticsService)appCtx.getBean(FileStatisticsService.class);
    private FrontTopicService frontTopicService = (FrontTopicService)appCtx.getBean(FrontTopicService.class);
    private BusinessService businessService = (BusinessService)appCtx.getBean(BusinessService.class);
    private FrontDocGroupService frontDocGroupService = (FrontDocGroupService)appCtx.getBean(FrontDocGroupService.class);

    public void execute(JobExecutionContext context) throws JobExecutionException {
        this.saveIndexCache();
    }

    public void saveIndexCache() {
        Collection collection = this.sessionDAO.getActiveSessions();
        for (Session session : collection) {
            Date lastAccessDate = session.getLastAccessTime();
            long timeout = session.getTimeout();
            if (lastAccessDate.getTime() + timeout >= new Date().getTime()) continue;
            this.sessionDAO.delete(session);
        }
    }
}

