/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.doc.newupload.thread;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.doc.common.docutil.service.CacheToolService;
import com.jxdinfo.doc.common.docutil.service.FastdfsService;
import com.jxdinfo.doc.common.util.ExceptionUtils;
import com.jxdinfo.doc.common.util.FileTool;
import com.jxdinfo.doc.common.util.PdfUtil;
import com.jxdinfo.doc.common.util.SpringContextUtil;
import com.jxdinfo.doc.common.util.StringUtil;
import com.jxdinfo.doc.common.util.TikaUtil;
import com.jxdinfo.doc.manager.docmanager.dao.FilesMapper;
import com.jxdinfo.doc.manager.docmanager.model.FsFile;
import com.jxdinfo.doc.newupload.service.UploadService;
import com.jxdinfo.doc.newupload.thread.CreateEsThread;
import com.jxdinfo.doc.timer.client.ApiClient;
import com.jxdinfo.hussar.encrypt.file.FileEncryptUtil;
import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.tomcat.util.threads.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class ChangeToPdfThread
extends Thread {
    private String docId = "";
    private static ApplicationContext appCtx = SpringContextUtil.getApplicationContext();
    private static ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(5, 20, 10000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue());
    public static final Logger LOGGER = LoggerFactory.getLogger(ChangeToPdfThread.class);
    private FastdfsService fastdfsService = (FastdfsService)appCtx.getBean(FastdfsService.class);
    private FilesMapper filesMapper = (FilesMapper)appCtx.getBean(FilesMapper.class);
    private CacheToolService cacheToolService = (CacheToolService)appCtx.getBean(CacheToolService.class);
    private UploadService uploadService = (UploadService)appCtx.getBean(UploadService.class);
    private FileTool fileTool = (FileTool)appCtx.getBean(FileTool.class);

    public ChangeToPdfThread(String id) {
        this.docId = id;
    }

    @Override
    public void run() {
        try {
            boolean theadFlag = true;
            HashMap<String, String> ready = new HashMap<String, String>();
            FsFile fsFileTemp = (FsFile)((Object)this.filesMapper.selectById((Serializable)((Object)this.docId)));
            LOGGER.info("******************\u6587\u4ef6:" + fsFileTemp.getFileName() + "\u8fdb\u5165ChangeToPdfThread\u7ebf\u7a0b\uff0c\u5f00\u59cb\u8f6c\u5316PDF******************");
            String pdfPathDir = this.cacheToolService.getPdfFileDir();
            String pdfKeyPath = this.cacheToolService.getPdfKeyFileDir();
            List<Map<String, String>> uploadList = this.uploadService.selectUpload(this.docId);
            String sourcePath = uploadList.get(0).get("sourcePath");
            ready.put("docId", this.docId);
            File sourceFile = new File(sourcePath);
            if (!sourceFile.getParentFile().exists()) {
                sourceFile.getParentFile().mkdirs();
            }
            if (sourceFile.exists()) {
                String pdfFilePath = sourcePath.substring(0, sourcePath.lastIndexOf(".")) + ".pdf";
                pdfFilePath = pdfPathDir + pdfFilePath.substring(pdfFilePath.lastIndexOf("/") + 1, pdfFilePath.length());
                String pdfKeyFilePath = pdfKeyPath + pdfFilePath.substring(pdfFilePath.lastIndexOf("/") + 1, pdfFilePath.length());
                File pdfFile = null;
                String content = null;
                FsFile fsFile = new FsFile();
                String contentType = uploadList.get(0).get("contentType");
                boolean flag = false;
                HashMap pdfInfo = new HashMap();
                if (sourcePath.endsWith(".ceb")) {
                    ApiClient client = new ApiClient();
                    JSONObject cebName = new JSONObject();
                    cebName.put("cebName", (Object)sourcePath);
                    String ceb = client.cebToPdf(cebName);
                    if (ceb != null && ceb.contains("true")) {
                        Map metadata = TikaUtil.autoParse((String)pdfFilePath);
                        content = metadata.get("content").toString().replaceAll("<", "<&nbsp;");
                        ready.put("content", content);
                    }
                } else if (contentType.contains("word") || contentType.contains("rtf")) {
                    PdfUtil.word2pdf((String)sourcePath, (String)pdfFilePath);
                } else if (contentType.contains("text/html") && (sourcePath.endsWith(".doc") || sourcePath.endsWith(".docx"))) {
                    PdfUtil.word2pdf((String)sourcePath, (String)pdfFilePath);
                } else if (contentType.contains("excel") || contentType.contains("spreadsheetml")) {
                    PdfUtil.excel2Pdf((String)sourcePath, (String)pdfFilePath);
                } else if (contentType.contains("powerpoint") || contentType.contains("presentationml")) {
                    PdfUtil.ppt2pdf((String)sourcePath, (String)pdfFilePath);
                } else if ((contentType.contains("octet-stream") || contentType.contains("text/plain")) && sourcePath.endsWith(".txt")) {
                    PdfUtil.txt2pdf((String)sourcePath, (String)pdfFilePath);
                    Map metadata = TikaUtil.autoParse((String)pdfFilePath);
                    content = metadata.get("content").toString().replaceAll("<", "<&nbsp;");
                    ready.put("content", content);
                } else {
                    LOGGER.info("******************\u6587\u4ef6:" + fsFileTemp.getFileName() + "\u4e0d\u9700\u8981\u8f6c\u5316PDF\uff0c\u8fdb\u884c\u4e0b\u4e00\u6b65******************");
                    theadFlag = false;
                }
                if (theadFlag) {
                    String pdfPath = null;
                    if (contentType == null || contentType.contains("application/pdf") || contentType.contains("audio") || contentType.contains("video")) {
                        pdfPath = fsFileTemp.getFilePath();
                        LOGGER.info("******************\u89c6\u9891\u97f3\u9891PDF\u6587\u4ef6:" + fsFileTemp.getFileName() + "\u4e0d\u9700\u8981\u8f6c\u5316PDF\uff0c");
                    } else if (!StringUtil.checkIsEmpty((String)pdfFilePath)) {
                        pdfFile = new File(pdfFilePath);
                        if (!pdfFile.getParentFile().exists()) {
                            pdfFile.getParentFile().mkdirs();
                        }
                        LOGGER.info("******************PDF\u6587\u4ef6:" + fsFileTemp.getFileName() + "\u521b\u5efa\u6210\u529f\uff0c\u8def\u5f84\u4e3a" + pdfFile.getPath() + ",\u5927\u5c0f\u4e3a" + pdfFile.length() + "******************");
                        if (this.cacheToolService.getFastDFSUsingFlag()) {
                            File pdfKeyDir = new File(pdfKeyFilePath);
                            if (!pdfKeyDir.getParentFile().exists()) {
                                pdfKeyDir.getParentFile().mkdirs();
                            }
                            String pdfKey = FileEncryptUtil.getInstance().encrypt(pdfFile, pdfKeyDir);
                            fsFile.setPdfKey(pdfKey);
                            pdfPath = this.fastdfsService.uploadFile(pdfKeyDir);
                            pdfKeyDir.delete();
                            pdfFile.delete();
                            LOGGER.info("******************\u52a0\u5bc6PDF\u6587\u4ef6:" + pdfKeyDir.getName() + "\u521b\u5efa\u6210\u529f\uff0c\u8def\u5f84\u4e3a" + pdfKeyDir.getPath() + ",\u5927\u5c0f\u4e3a" + pdfKeyDir.length() + ",\u5e76\u4e0a\u4f20\u5230fast\uff0cfast\u8fd4\u56de\u5730\u5740\u4e3a" + pdfPath + "******************");
                        } else {
                            pdfPath = pdfFilePath;
                        }
                    }
                    fsFile.setFileId(this.docId);
                    fsFile.setFilePdfPath(pdfPath);
                    this.filesMapper.updateById((Object)fsFile);
                    LOGGER.info("******************\u6587\u4ef6:" + fsFileTemp.getFileName() + "\u6b64\u7ebf\u7a0b\u7ed3\u675f\uff0c\u8fdb\u884c\u4e0b\u4e00\u6d41\u7a0b******************");
                    this.uploadService.updateUploadState(ready);
                }
                threadPoolExecutor.execute((Runnable)new CreateEsThread(this.docId));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u8f6c\u5316PDF\u5931\u8d25\uff1a" + ExceptionUtils.getErrorInfo((Exception)e));
        }
    }
}

