/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.doc.manager.topicmanager.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.toolkit.IdWorker;
import com.jxdinfo.doc.common.docutil.service.BusinessService;
import com.jxdinfo.doc.common.docutil.service.CacheToolService;
import com.jxdinfo.doc.common.util.CommonUtil;
import com.jxdinfo.doc.common.util.FileTool;
import com.jxdinfo.doc.common.util.StringUtil;
import com.jxdinfo.doc.common.util.UserInfoUtil;
import com.jxdinfo.doc.front.topicmanager.service.FrontTopicService;
import com.jxdinfo.doc.manager.docmanager.model.DocResourceLog;
import com.jxdinfo.doc.manager.docmanager.service.DocInfoService;
import com.jxdinfo.doc.manager.docmanager.service.FilesService;
import com.jxdinfo.doc.manager.foldermanager.model.FsFolderParams;
import com.jxdinfo.doc.manager.groupmanager.service.DocGroupService;
import com.jxdinfo.doc.manager.topicmanager.model.SpecialTopic;
import com.jxdinfo.doc.manager.topicmanager.service.ITopicDocManagerService;
import com.jxdinfo.doc.manager.topicmanager.service.SpecialTopicService;
import com.jxdinfo.hussar.bsp.permit.service.ISysIdtableService;
import com.jxdinfo.hussar.common.exception.BizExceptionEnum;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.core.exception.ServiceExceptionEnum;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/topic"})
public class TopicManageController {
    @Value(value="${docbase.uploadPath}")
    private String base;
    @Value(value="${docbase.filedir}")
    private String uploadPath;
    @Autowired
    private FilesService filesService;
    @Autowired
    private DocGroupService docGroupService;
    @Resource
    private BusinessService businessService;
    @Autowired
    private SpecialTopicService specialTopicService;
    @Autowired
    private ITopicDocManagerService topicDocManagerService;
    @Autowired
    private DocInfoService docInfoService;
    @Autowired
    private FrontTopicService frontTopicService;
    @Autowired
    private CacheToolService cacheToolService;
    @Autowired
    private ISysIdtableService sysIdtableService;

    @RequestMapping(value={"/getSpecialTopicFiles"})
    @ResponseBody
    public List getSpecialTopicFiles() {
        List list = new ArrayList();
        list = this.specialTopicService.getSpecialTopicFiles();
        return list;
    }

    @RequiresPermissions(value={"topic:topicListView"})
    @RequestMapping(value={"/topicListView"})
    public String topicListView() {
        return "/doc/manager/topicmanager/topic-list.html";
    }

    @RequestMapping(value={"/topicAdd"})
    public String topicAdd(Model model) {
        String currentCode = this.sysIdtableService.getCurrentCode("TOPIC_NUM", "doc_special_topic");
        int num = Integer.parseInt(currentCode);
        model.addAttribute("lastNum", (Object)num);
        model.addAttribute("num", (Object)(num + 1));
        return "/doc/manager/topicmanager/topic-add.html";
    }

    @RequestMapping(value={"/topicList"})
    @ResponseBody
    public JSON getTopicList(String topicName, int page, int limit) {
        int beginIndex = page * limit - limit;
        String topicNameStr = StringUtil.transferSqlParam((String)topicName);
        List<SpecialTopic> topicList = this.specialTopicService.topicList(topicNameStr, beginIndex, limit);
        int topicCount = this.frontTopicService.getTopicListCount(topicNameStr);
        JSONObject json = new JSONObject();
        json.put("count", (Object)topicCount);
        json.put("data", topicList);
        json.put("msg", (Object)"success");
        json.put("code", (Object)0);
        return json;
    }

    @RequestMapping(value={"/addTopic"})
    @ResponseBody
    public JSON addTopic(SpecialTopic specialTopic, String docIds) {
        String topicId = UUID.randomUUID().toString().replaceAll("-", "");
        specialTopic.setTopicId(topicId);
        specialTopic.setCreateUserId(ShiroKit.getUser().getId());
        JSONObject json = new JSONObject();
        int num = this.specialTopicService.checkTopicExist(specialTopic);
        if (num > 0) {
            json.put("result", (Object)"0");
        } else {
            int addNum = this.specialTopicService.addTopic(specialTopic, docIds);
            if (addNum == 1) {
                json.put("result", (Object)"1");
            } else {
                json.put("result", (Object)"2");
            }
        }
        return json;
    }

    @RequestMapping(value={"/delDocById"})
    @ResponseBody
    public int delDocById(String delIds, String topicId) {
        List<String> idList = Arrays.asList(delIds.split(","));
        int num = this.specialTopicService.delDocById(idList, topicId);
        return num;
    }

    @RequestMapping(value={"/editTopic"})
    @ResponseBody
    public JSON editTopic(SpecialTopic specialTopic, String docIds) {
        JSONObject json = new JSONObject();
        int num = this.specialTopicService.checkTopicExist(specialTopic);
        specialTopic.setUpdateTime(new Timestamp(System.currentTimeMillis()));
        specialTopic.setUpdateUserId(ShiroKit.getUser().getId());
        if (num > 0) {
            json.put("result", (Object)"0");
        } else {
            int editNum = this.specialTopicService.editTopic(specialTopic, docIds);
            if (editNum == 1) {
                json.put("result", (Object)"1");
            } else {
                json.put("result", (Object)"2");
            }
        }
        return json;
    }

    @RequestMapping(value={"/delTopics"})
    @ResponseBody
    public int delTopicsById(String ids) {
        List<String> list = Arrays.asList(ids.split(","));
        return this.specialTopicService.delDocs(list);
    }

    @RequestMapping(value={"/publishTopic"})
    @ResponseBody
    public int publishTopic(String ids, Integer topicShow) {
        List<String> list = Arrays.asList(ids.split(","));
        return this.specialTopicService.publishTopics(list, topicShow);
    }

    @RequestMapping(value={"/topicEdit"})
    public String topicEdit(Model model, String topicId) {
        SpecialTopic specialTopic = this.specialTopicService.searchTopicDetail(topicId);
        try {
            String topicCover = URLEncoder.encode(specialTopic.getTopicCover(), "UTF-8");
            specialTopic.setTopicCover(topicCover);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        int num = this.specialTopicService.getMaxOrder();
        model.addAttribute("lastNum", (Object)num);
        String userName = specialTopic.getAuthorName();
        model.addAttribute("users", (Object)userName);
        model.addAttribute("specialTopic", (Object)specialTopic);
        return "/doc/manager/topicmanager/topic-edit.html";
    }

    @RequestMapping(value={"/topicView"})
    public String topicView(Model model, String topicId) {
        SpecialTopic specialTopic = this.specialTopicService.searchTopicDetail(topicId);
        try {
            String topicCover = URLEncoder.encode(specialTopic.getTopicCover(), "UTF-8");
            specialTopic.setTopicCover(topicCover);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        int num = this.specialTopicService.getMaxOrder();
        model.addAttribute("lastNum", (Object)num);
        String userName = specialTopic.getAuthorName();
        model.addAttribute("users", (Object)userName);
        model.addAttribute("specialTopic", (Object)specialTopic);
        return "/doc/manager/topicmanager/topic-view.html";
    }

    @RequestMapping(value={"/topicDocList"})
    public String topicDocList(Model model, String topicId) {
        SpecialTopic specialTopic = this.specialTopicService.searchTopicDetail(topicId);
        int num = this.specialTopicService.getMaxOrder();
        model.addAttribute("lastNum", (Object)num);
        String userName = specialTopic.getAuthorName();
        model.addAttribute("users", (Object)userName);
        model.addAttribute("specialTopic", (Object)specialTopic);
        return "/doc/manager/topicmanager/topic_doc_list.html";
    }

    @RequestMapping(value={"/topicShowDoc"})
    @ResponseBody
    public JSON topicShowDoc(Model model, String topicId, int page, int limit) {
        int startNum = page * limit - limit;
        String userId = UserInfoUtil.getCurrentUser().getId();
        List<String> listGroup = this.docGroupService.getPremission(userId);
        FsFolderParams fsFolderParams = new FsFolderParams();
        fsFolderParams.setGroupList(listGroup);
        fsFolderParams.setUserId(userId);
        fsFolderParams.setType("2");
        List roleList = ShiroKit.getUser().getRolesList();
        Integer adminFlag = CommonUtil.getAdminFlag((List)roleList);
        String levelCode = this.businessService.getLevelCodeByUserUpload(fsFolderParams);
        String orgId = ShiroKit.getUser().getDeptName();
        List<Map<String, String>> docList = this.frontTopicService.getDocByTopicId(topicId, "create_time", startNum, limit, userId, listGroup, levelCode, adminFlag, orgId);
        int docCount = this.topicDocManagerService.getDocCountTopicId(topicId);
        docList = this.changeSize(docList);
        JSONObject json = new JSONObject();
        json.put("count", (Object)docCount);
        json.put("data", docList);
        json.put("msg", (Object)"success");
        json.put("code", (Object)0);
        return json;
    }

    @RequestMapping(value={"/delDoc"})
    @ResponseBody
    public int delDoc(String id, String topicId) {
        return this.specialTopicService.delDoc(id, topicId);
    }

    @RequestMapping(value={"/delDocs"})
    @ResponseBody
    public int delDocs(String ids, String topicId) {
        List<String> list = Arrays.asList(ids.split(","));
        return this.specialTopicService.delDocById(list, topicId);
    }

    @RequestMapping(value={"/cacheViewNum"})
    @ResponseBody
    public void saveCache(String topicId) {
        this.cacheToolService.getAndUpdateTopicReadNum(topicId);
        ArrayList<DocResourceLog> resInfoList = new ArrayList<DocResourceLog>();
        DocResourceLog docResourceLog = new DocResourceLog();
        String id = UUID.randomUUID().toString().replace("-", "");
        docResourceLog.setId(id);
        docResourceLog.setResourceId(topicId);
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        docResourceLog.setOperateTime(ts);
        docResourceLog.setResourceType(2);
        String userId = UserInfoUtil.getUserInfo().get("ID").toString();
        docResourceLog.setUserId(userId);
        docResourceLog.setOperateType(3);
        resInfoList.add(docResourceLog);
        this.docInfoService.insertResourceLog(resInfoList);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/upload"})
    @ResponseBody
    public JSONObject upload(@RequestPart(value="file") MultipartFile file) {
        JSONObject json = new JSONObject();
        String fileName = file.getOriginalFilename();
        String prefix = fileName.substring(fileName.lastIndexOf("."));
        String fName = IdWorker.get32UUID() + prefix;
        try {
            String filePath = this.filesService.upload(file, fName);
            json.put("fName", (Object)filePath);
            json.put("fileName", (Object)fileName);
        }
        catch (IOException e) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.UPLOAD_ERROR);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return json;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/viewTopicPic"})
    public void getList(HttpServletResponse response, String fName) {
        byte[] data = null;
        FileInputStream input = null;
        try {
            input = new FileInputStream(this.uploadPath + fName);
            data = new byte[input.available()];
            input.read(data);
            response.getOutputStream().write(data);
            input.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @RequestMapping(value={"/moveTopic"})
    @ResponseBody
    public int moveTopic(String table, String idColumn, String idOne, String idTwo) {
        int num = this.specialTopicService.moveTopic(table, idColumn, idTwo, idOne);
        return num;
    }

    public List<Map<String, String>> changeSize(List<Map<String, String>> list) {
        for (Map<String, String> map : list) {
            if (map.get("fileSize") == null || "".equals(map.get("fileSize"))) continue;
            map.put("fileSize", FileTool.longToString(String.valueOf(map.get("fileSize"))));
        }
        return list;
    }
}

