/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.doc.manager.system.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.jxdinfo.doc.common.constant.DocConstant;
import com.jxdinfo.doc.common.docutil.service.CacheToolService;
import com.jxdinfo.doc.common.util.ESUtil;
import com.jxdinfo.doc.common.util.FileTool;
import com.jxdinfo.doc.common.util.MD5Util;
import com.jxdinfo.doc.common.util.MathUtil;
import com.jxdinfo.doc.common.util.StringUtil;
import com.jxdinfo.doc.front.foldermanager.service.FrontFolderService;
import com.jxdinfo.doc.front.topicmanager.service.FrontTopicService;
import com.jxdinfo.doc.manager.docconfigure.model.DocConfigure;
import com.jxdinfo.doc.manager.docconfigure.service.DocConfigureService;
import com.jxdinfo.doc.manager.docmanager.ex.ServiceException;
import com.jxdinfo.doc.manager.docmanager.model.DocFileAuthority;
import com.jxdinfo.doc.manager.docmanager.model.DocInfo;
import com.jxdinfo.doc.manager.docmanager.model.DocResourceLog;
import com.jxdinfo.doc.manager.docmanager.model.FsFile;
import com.jxdinfo.doc.manager.docmanager.service.DocInfoService;
import com.jxdinfo.doc.manager.docmanager.service.FilesService;
import com.jxdinfo.doc.manager.docmanager.service.FsFileService;
import com.jxdinfo.doc.manager.foldermanager.model.DocFoldAuthority;
import com.jxdinfo.doc.manager.foldermanager.model.FsFolder;
import com.jxdinfo.doc.manager.foldermanager.service.IDocFoldAuthorityService;
import com.jxdinfo.doc.manager.foldermanager.service.IFsFolderService;
import com.jxdinfo.doc.manager.system.controller.JqxUploadController;
import com.jxdinfo.doc.manager.topicmanager.service.ITopicDocManagerService;
import com.jxdinfo.hussar.bsp.permit.service.ISysIdtableService;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/YYZCUpload"})
public class YYZCUploadController
extends BaseController {
    private static Logger logger = LogManager.getLogger(JqxUploadController.class);
    @Autowired
    private ISysIdtableService sysIdtableService;
    @Autowired
    private ESUtil esUtil;
    @Autowired
    private FileTool fileTool;
    @Autowired
    private CacheToolService cacheToolService;
    @Resource
    private DocConfigureService docConfigureService;
    @Autowired
    private FsFileService fsFileService;
    @Autowired
    private IFsFolderService iFsFolderService;
    @Autowired
    private ITopicDocManagerService iTopicDocManagerService;
    @Autowired
    private IDocFoldAuthorityService docFoldAuthorityService;
    @Autowired
    private DocInfoService idocInfoService;
    @Autowired
    protected FrontTopicService frontTopicService;
    @Autowired
    private FilesService filesService;
    @Value(value="${docbase.breakdir}")
    private String breakdir;
    @Value(value="${docbase.filedir}")
    private String tempdir;
    @Autowired
    private FrontFolderService frontFolderService;

    @RequestMapping(value={"/uploadFile"})
    @ResponseBody
    public String mergeOrCheckVersionChunks(@RequestParam(value="file") MultipartFile file, String userId, String typeId, String fileName, String tags, String proId, String proName) {
        String currentCode;
        FsFolder fsFolder;
        if (userId == null || "\u7ba1\u7406\u5458".equals(userId)) {
            userId = "superadmin";
        }
        String parentId = "";
        parentId = "1".equals(typeId) ? "0601" : ("2".equals(typeId) ? "0602" : ("3".equals(typeId) ? "0603" : ("4".equals(typeId) ? "0604" : ("5".equals(typeId) ? "0605" : "0606"))));
        FsFolder folder = (FsFolder)((Object)this.iFsFolderService.selectById((Serializable)((Object)proId)));
        if (folder != null) {
            fsFolder = new FsFolder();
            this.cacheToolService.updateLevelCodeCache(userId);
            fsFolder.setFolderId(proId);
            fsFolder.setFolderName(proName);
            folder.setParentFolderId(parentId);
            String folderParentId = fsFolder.getParentFolderId();
            if (folderParentId != null && !"".equals(folderParentId)) {
                FsFolder parentFolder = (FsFolder)((Object)this.iFsFolderService.selectById((Serializable)((Object)folderParentId)));
                String parentCode = parentFolder.getLevelCode();
                currentCode = this.iFsFolderService.getCurrentLevelCode(parentCode, parentFolder.getFolderId());
                fsFolder.setLevelCode(currentCode);
            }
            String currentCode2 = this.sysIdtableService.getCurrentCode("FOLDER_NUM", "fs_folder");
            int num = Integer.parseInt(currentCode2);
            fsFolder.setShowOrder(num);
            folder.setFolderName(proName);
            this.iFsFolderService.updateById((Object)folder);
            this.docFoldAuthorityService.delete(new EntityWrapper().eq("folder_id", (Object)proId).eq("author_id", (Object)userId));
            DocFoldAuthority docFoldAuthority = new DocFoldAuthority();
            docFoldAuthority.setId(UUID.randomUUID().toString().replaceAll("-", ""));
            docFoldAuthority.setAuthorId(userId);
            docFoldAuthority.setAuthorType("0");
            docFoldAuthority.setFoldId(proId);
            docFoldAuthority.setIsEdit("0");
            docFoldAuthority.setOperateType("2");
            this.docFoldAuthorityService.insert((Object)docFoldAuthority);
        } else {
            fsFolder = new FsFolder();
            this.cacheToolService.updateLevelCodeCache(userId);
            fsFolder.setFolderId(proId);
            fsFolder.setFolderName(proName);
            fsFolder.setIsEdit("0");
            fsFolder.setVisibleRange("0");
            fsFolder.setParentFolderId(parentId);
            Date date = new Date();
            Timestamp ts = new Timestamp(date.getTime());
            fsFolder.setCreateTime(ts);
            fsFolder.setCreateUserId(userId);
            String folderParentId = fsFolder.getParentFolderId();
            if (folderParentId != null && !"".equals(folderParentId)) {
                FsFolder parentFolder = (FsFolder)((Object)this.iFsFolderService.selectById((Serializable)((Object)folderParentId)));
                String parentCode = parentFolder.getLevelCode();
                String currentCode3 = this.iFsFolderService.getCurrentLevelCode(parentCode, parentFolder.getFolderId());
                fsFolder.setLevelCode(currentCode3);
            }
            currentCode = this.sysIdtableService.getCurrentCode("FOLDER_NUM", "fs_folder");
            int num = Integer.parseInt(currentCode);
            fsFolder.setShowOrder(num);
            this.iFsFolderService.insert((Object)fsFolder);
            this.docFoldAuthorityService.delete(new EntityWrapper().eq("folder_id", (Object)proId).eq("author_id", (Object)userId));
            DocFoldAuthority docFoldAuthority = new DocFoldAuthority();
            docFoldAuthority.setId(UUID.randomUUID().toString().replaceAll("-", ""));
            docFoldAuthority.setAuthorId(userId);
            docFoldAuthority.setAuthorType("0");
            docFoldAuthority.setFoldId(proId);
            docFoldAuthority.setIsEdit("0");
            docFoldAuthority.setOperateType("2");
            this.docFoldAuthorityService.insert((Object)docFoldAuthority);
        }
        ByteArrayOutputStream baos = null;
        try {
            baos = FileTool.cloneInputStream(file.getInputStream());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ByteArrayInputStream md5InputStream = new ByteArrayInputStream(baos.toByteArray());
        String md5 = MD5Util.getFileMD5((InputStream)md5InputStream);
        String json = "";
        int pointIndex = fileName.lastIndexOf(".");
        ArrayList<String> docNameList = new ArrayList<String>();
        docNameList.add(fileName);
        String suffix = fileName.substring(pointIndex).toLowerCase();
        if (fileName.length() > 64) {
            HashMap<String, String> resultMap = new HashMap<String, String>();
            resultMap.put("code", DocConstant.UPLOADRESULT.NAMELONG.getValue());
            return JSON.toJSONString(resultMap);
        }
        String regex = "^[^'\"\\|\\\\]*$";
        if (!Pattern.compile(regex).matcher(fileName).find()) {
            HashMap<String, String> resultMap = new HashMap<String, String>();
            resultMap.put("code", DocConstant.UPLOADRESULT.NAMEERROR.getValue());
            return JSON.toJSONString(resultMap);
        }
        List<DocConfigure> typeList = this.docConfigureService.getConfigure();
        if (typeList.get(0).getConfigValue().contains(suffix.toLowerCase())) {
            HashMap<String, String> resultMap = new HashMap<String, String>();
            resultMap.put("code", DocConstant.UPLOADRESULT.ERRORTYPE.getValue());
            return JSON.toJSONString(resultMap);
        }
        List<String> nameList = this.idocInfoService.checkFileExist(docNameList, proId);
        if (nameList != null && nameList.size() != 0) {
            HashMap<String, String> resultMap = new HashMap<String, String>();
            resultMap.put("name", nameList.get(0));
            resultMap.put("code", DocConstant.UPLOADRESULT.FILEEXIST.getValue());
            resultMap.put("docId", this.idocInfoService.selectExistId(docNameList, proId).get(0));
            if (tags != null) {
                DocInfo docInfo = new DocInfo();
                docInfo.setDocId(this.idocInfoService.selectExistId(docNameList, proId).get(0));
                docInfo.setTags(tags);
                this.idocInfoService.updateById(docInfo);
                HashMap<String, Object> map = new HashMap<String, Object>(1);
                map.put("tags", tags);
                this.esUtil.updateIndex(this.idocInfoService.selectExistId(docNameList, proId).get(0), map);
            }
            return JSON.toJSONString(resultMap);
        }
        try {
            String random = UUID.randomUUID().toString().replace("-", "");
            File outputFile = new File(this.tempdir + File.separator + random + suffix);
            try {
                if (!outputFile.getParentFile().exists()) {
                    outputFile.getParentFile().mkdirs();
                }
                outputFile.createNewFile();
            }
            catch (IOException e) {
                logger.error("IO Exception\uff1a", (Throwable)e);
                HashMap<String, String> resultMap = new HashMap<String, String>();
                resultMap.put("code", DocConstant.UPLOADRESULT.FAIL.getValue());
                json = JSONObject.toJSONString(resultMap);
                return json;
            }
            FileUtils.copyInputStreamToFile((InputStream)file.getInputStream(), (File)outputFile);
            List<FsFile> listMd5 = this.fsFileService.getInfoByMd5(md5);
            if (listMd5 != null && listMd5.size() != 0) {
                FsFile fsFile = listMd5.get(0);
                this.cacheToolService.updateLevelCodeCache(userId);
                String docId = this.filesService.uploadFastYYZC(proId, "0", "1", null, null, null, md5, fileName, fsFile, fsFile.getFileSize(), "1", userId, tags);
                if (docId == null) {
                    HashMap<String, String> resultMap = new HashMap<String, String>();
                    resultMap.put("code", DocConstant.UPLOADRESULT.FAIL.getValue());
                    json = JSONObject.toJSONString(resultMap);
                    return json;
                }
                HashMap<String, String> resultMap = new HashMap<String, String>();
                resultMap.put("code", DocConstant.UPLOADRESULT.FASTUPLOAD.getValue());
                resultMap.put("docId", docId);
                json = JSONObject.toJSONString(resultMap);
                return json;
            }
            try {
                String docId;
                String contentType = this.getContentType(suffix.toLowerCase());
                Timestamp ts = new Timestamp(System.currentTimeMillis());
                DocInfo docInfo = new DocInfo();
                String idStr = docId = UUID.randomUUID().toString().replace("-", "");
                docInfo.setDocId(docId);
                docInfo.setFileId(outputFile.getName());
                docInfo.setUserId(userId);
                docInfo.setAuthorId(userId);
                docInfo.setContactsId(userId);
                docInfo.setCreateTime(ts);
                if (tags != null) {
                    docInfo.setTags(tags);
                }
                docInfo.setFoldId(proId);
                docInfo.setDocType(suffix);
                docInfo.setTitle(fileName.substring(0, fileName.lastIndexOf(".")));
                docInfo.setReadNum(0);
                docInfo.setDownloadNum(0);
                docInfo.setValidFlag("1");
                docInfo.setAuthority("1");
                docInfo.setSetAuthority("0");
                docInfo.setVisibleRange(Integer.parseInt("1"));
                docInfo.setValidFlag("1");
                docInfo.setShareFlag("1");
                FsFile fileModel = new FsFile();
                fileModel.setCreateTime(ts);
                fileModel.setFileIcon("");
                fileModel.setFileId(docId);
                fileModel.setMd5(md5);
                fileModel.setFileName(fileName.substring(0, fileName.lastIndexOf(".")));
                double size = MathUtil.getDecimal((double)(outputFile.length() / 1024L), (int)2);
                fileModel.setFileSize(size + "KB");
                fileModel.setFileType(suffix);
                ArrayList<DocResourceLog> resInfoList = new ArrayList<DocResourceLog>();
                DocResourceLog docResourceLog = new DocResourceLog();
                String id = UUID.randomUUID().toString().replace("-", "");
                docResourceLog.setId(id);
                docResourceLog.setResourceId(docId);
                docResourceLog.setOperateTime(ts);
                docResourceLog.setResourceType(0);
                docResourceLog.setUserId(userId);
                docResourceLog.setOperateType(0);
                resInfoList.add(docResourceLog);
                ArrayList<DocFileAuthority> list = new ArrayList<DocFileAuthority>();
                ArrayList<String> indexList = new ArrayList<String>();
                String[] groupArr = "allpersonflag,6a7206343e4246f9b21db680dbcf1516".split(",");
                String[] authorTypeStrGroup = "3,1".split(",");
                String[] operateTypeStrGroup = "0,1".split(",");
                for (int i = 0; i < groupArr.length; ++i) {
                    DocFileAuthority docFileAuthority = new DocFileAuthority();
                    docFileAuthority.setFileAuthorityId(UUID.randomUUID().toString().replaceAll("-", ""));
                    docFileAuthority.setAuthorId(groupArr[i]);
                    docFileAuthority.setAuthorType(StringUtil.getInteger((Object)authorTypeStrGroup[i]));
                    docFileAuthority.setFileId(docId);
                    docFileAuthority.setAuthority(StringUtil.getInteger((Object)operateTypeStrGroup[i]));
                    list.add(docFileAuthority);
                    indexList.add(groupArr[i]);
                }
                indexList.add(userId);
                this.cacheToolService.updateLevelCodeCache(userId);
                this.filesService.uploadFile(outputFile, docInfo, fileModel, resInfoList, list, indexList, contentType);
                HashMap<String, String> resultMap = new HashMap<String, String>();
                resultMap.put("code", DocConstant.UPLOADRESULT.SUCCESS.getValue());
                resultMap.put("docId", docId);
                json = JSONObject.toJSONString(resultMap);
                return json;
            }
            catch (IOException e) {
                logger.error("IO Exception\uff1a", (Throwable)e);
                HashMap<String, String> resultMap = new HashMap<String, String>();
                resultMap.put("code", DocConstant.UPLOADRESULT.FAIL.getValue());
                json = JSONObject.toJSONString(resultMap);
                return json;
            }
        }
        catch (Exception e) {
            logger.error("IO Exception\uff1a", (Throwable)e);
            HashMap<String, String> resultMap = new HashMap<String, String>();
            resultMap.put("code", DocConstant.UPLOADRESULT.SUCCESS.getValue());
            return json;
        }
    }

    private String getContentType(String suffix) {
        String contentType = null;
        if (suffix.equals(".doc") || suffix.equals(".docx")) {
            contentType = "application/msword";
            return contentType;
        }
        if (suffix.equals(".ppt") || suffix.equals(".pptx")) {
            contentType = "application/vnd.openxmlformats-officedocument.presentationml.presentation";
            return contentType;
        }
        if (suffix.equals(".xls") || suffix.equals(".xlsx")) {
            contentType = "spreadsheetml";
            return contentType;
        }
        if (suffix.equals(".png") || suffix.equals(".gif") || suffix.equals(".jpg") || suffix.equals(".bmp")) {
            contentType = "image";
            return contentType;
        }
        if (suffix.equals(".txt")) {
            contentType = "text/plain";
            return contentType;
        }
        if (suffix.equals(".pdf")) {
            contentType = "application/pdf";
            return contentType;
        }
        if (suffix.equals(".mp3")) {
            contentType = "audio/mp3";
            return contentType;
        }
        if (suffix.equals(".mp4")) {
            contentType = "video/mp4";
            return contentType;
        }
        if (suffix.equals(".wav")) {
            contentType = "audio/wav";
            return contentType;
        }
        if (suffix.equals(".avi")) {
            contentType = "video/avi";
            return contentType;
        }
        if (suffix.equals(".ceb")) {
            contentType = "ceb";
            return contentType;
        }
        return null;
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response, String userId, String id) {
        byte[] bytes = null;
        try {
            bytes = this.filesService.downloadYYZC(id, null, request, response, userId);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(value={"/deleteScope"})
    @ResponseBody
    public int deleteScope(String ids, String userId) {
        this.cacheToolService.updateLevelCodeCache(userId);
        String[] strArr = ids.split(",");
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(Arrays.asList(strArr));
        int num = this.fsFileService.deleteScopeYYZC(list, userId);
        for (String id : strArr) {
            HashMap<String, Object> map = new HashMap<String, Object>(1);
            map.put("recycle", DocConstant.VALIDTYPE.INVALID.getValue());
            this.esUtil.updateIndex(id, map);
        }
        return num;
    }

    @RequestMapping(value={"/changeFolder"})
    @ResponseBody
    public boolean changeFolder(String ids, String userId, String proId, String proName, String typeId) {
        if (userId == null || "\u7ba1\u7406\u5458".equals(userId)) {
            userId = "superadmin";
        }
        String parentId = "";
        parentId = "1".equals(typeId) ? "0601" : ("2".equals(typeId) ? "0602" : ("3".equals(typeId) ? "0603" : ("4".equals(typeId) ? "0604" : ("5".equals(typeId) ? "0605" : "0606"))));
        FsFolder folder = (FsFolder)((Object)this.iFsFolderService.selectById((Serializable)((Object)proId)));
        if (folder != null) {
            FsFolder fsFolder = new FsFolder();
            this.cacheToolService.updateLevelCodeCache(userId);
            fsFolder.setFolderId(proId);
            fsFolder.setFolderName(proName);
            fsFolder.setParentFolderId(parentId);
            String folderParentId = fsFolder.getParentFolderId();
            if (folderParentId != null && !"".equals(folderParentId)) {
                FsFolder parentFolder = (FsFolder)((Object)this.iFsFolderService.selectById((Serializable)((Object)folderParentId)));
                String parentCode = parentFolder.getLevelCode();
                String currentCode = this.iFsFolderService.getCurrentLevelCode(parentCode, parentFolder.getFolderId());
                fsFolder.setLevelCode(currentCode);
            }
            String currentCode = this.sysIdtableService.getCurrentCode("FOLDER_NUM", "fs _folder");
            int num = Integer.parseInt(currentCode);
            fsFolder.setShowOrder(num);
            fsFolder.setFolderName(proName);
            fsFolder.setCreateUserId(userId);
            this.iFsFolderService.updateById((Object)fsFolder);
            this.docFoldAuthorityService.delete(new EntityWrapper().eq("folder_id", (Object)proId).eq("author_id", (Object)userId));
            DocFoldAuthority docFoldAuthority = new DocFoldAuthority();
            docFoldAuthority.setId(UUID.randomUUID().toString().replaceAll("-", ""));
            docFoldAuthority.setAuthorId(userId);
            docFoldAuthority.setAuthorType("0");
            docFoldAuthority.setFoldId(proId);
            docFoldAuthority.setIsEdit("0");
            docFoldAuthority.setOperateType("2");
            this.docFoldAuthorityService.insert((Object)docFoldAuthority);
            return true;
        }
        return false;
    }
}

