/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.doc.manager.statistics.controller;

import com.jxdinfo.doc.manager.docmanager.service.DocInfoService;
import com.jxdinfo.doc.manager.foldermanager.model.FsFolder;
import com.jxdinfo.doc.manager.foldermanager.service.IFsFolderService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/statistics"})
public class FsStatisticsController {
    @Autowired
    private IFsFolderService fsFolderService;
    @Autowired
    private DocInfoService docInfoService;
    private static final String PREFIX = "/doc/manager/statistics/";

    @RequiresPermissions(value={"statistics:view"})
    @RequestMapping(value={"/view"})
    public String index() {
        return "/doc/manager/statistics/statistics.html";
    }

    @RequestMapping(value={"/list"})
    @ResponseBody
    public Object index(@RequestParam(value="pageNumber", defaultValue="0") int pageNumber, @RequestParam(value="pageSize", defaultValue="300") int pageSize, String order, String name, String type, String nameFlag) {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        ArrayList<String> list = new ArrayList<String>();
        int totalNum = 0;
        ArrayList<Integer> numList = new ArrayList<Integer>();
        List<FsFolder> foldIds = this.fsFolderService.getChildrenByRoot(pageNumber, pageSize);
        for (int i = 0; i < foldIds.size(); ++i) {
            int num = this.docInfoService.getCount(foldIds.get(i).getLevelCode());
            totalNum += num;
            list.add(foldIds.get(i).getFolderName());
            numList.add(num);
        }
        result.put("total", foldIds.size());
        result.put("totalNum", totalNum);
        result.put("rows", foldIds);
        result.put("list", list);
        result.put("numList", numList);
        return result;
    }
}

