/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.doc.manager.statistics.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.plugins.Page;
import com.jxdinfo.doc.manager.statistics.service.FileStatisticsService;
import com.jxdinfo.hussar.core.util.DateUtil;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/fileStatistics"})
public class FileStatisticsController {
    @Autowired
    private FileStatisticsService fileStatisticsService;
    private static final String PREFIX = "/doc/manager/statistics/";

    @RequiresPermissions(value={"fileStatistics:view"})
    @RequestMapping(value={"/view"})
    public String index() {
        return "/doc/manager/statistics/fileStatistics.html";
    }

    @RequiresPermissions(value={"fileStatistics:viewFileList"})
    @RequestMapping(value={"/viewFileList"})
    public String viewFileList() {
        return "/doc/manager/statistics/fileDownloadStatistics.html";
    }

    @RequiresPermissions(value={"fileStatistics:viewFileUploadList"})
    @RequestMapping(value={"/viewFileUploadList"})
    public String viewFileUploadList() {
        return "/doc/manager/statistics/fileUploadStatistics.html";
    }

    @RequestMapping(value={"/getUserPreviewData"})
    @ResponseBody
    public Object getUserPreviewData() {
        return this.fileStatisticsService.getUserPreviewData("3");
    }

    @RequestMapping(value={"/getUserDownloadData"})
    @ResponseBody
    public Object getUserDownloadData() {
        return this.fileStatisticsService.getUserPreviewData("4");
    }

    @RequestMapping(value={"/getDeptData"})
    @ResponseBody
    public Object getDeptData() {
        return this.fileStatisticsService.getDeptData("3");
    }

    @RequestMapping(value={"/getDeptDownloadData"})
    @ResponseBody
    public Object getDeptDownloadData() {
        return this.fileStatisticsService.getDeptData("4");
    }

    @RequestMapping(value={"/getFileListData"})
    @ResponseBody
    public Object getFileListData(String opType, @RequestParam(value="pageNumber", defaultValue="1") int pageNumber, @RequestParam(value="pageSize", defaultValue="8") int pageSize) {
        pageSize = 8;
        Page page = new Page(pageNumber, pageSize);
        JSONObject json = new JSONObject();
        List list = this.fileStatisticsService.getFileListData(page, opType);
        json.put("count", (Object)page.getTotal());
        json.put("data", (Object)list);
        json.put("msg", (Object)"success");
        json.put("code", (Object)0);
        return json;
    }

    @RequestMapping(value={"/getDeptUploadData"})
    @ResponseBody
    public Object getDeptUploadData() {
        JSONObject json = new JSONObject();
        List<Map> list = this.fileStatisticsService.getUploadData("dept");
        json.put("data", list);
        json.put("msg", (Object)"success");
        json.put("code", (Object)0);
        return json;
    }

    @RequestMapping(value={"/getUserUploadData"})
    @ResponseBody
    public Object getUserUploadData() {
        JSONObject json = new JSONObject();
        List<Map> list = this.fileStatisticsService.getUploadData("user");
        json.put("data", list);
        json.put("msg", (Object)"success");
        json.put("code", (Object)0);
        return json;
    }

    @RequiresPermissions(value={"fileStatistics:statisticalAnalysis"})
    @RequestMapping(value={"/statisticalAnalysis"})
    public String statisticalAnalysis() {
        return "/doc/manager/statistics/statisticalAnalysis.html";
    }

    @RequestMapping(value={"/getFileNum"})
    @ResponseBody
    public Object getFileNum() {
        List<String> list = this.fileStatisticsService.getFileNums();
        return list;
    }

    @RequestMapping(value={"/getDeptActive"})
    @ResponseBody
    public Object getDeptActive(String dateStr) {
        dateStr = this.getStartTime(dateStr) + "";
        List<Map> data = this.fileStatisticsService.getDeptActive(dateStr);
        HashMap result = new HashMap();
        ArrayList xdata = new ArrayList();
        ArrayList ydata = new ArrayList();
        ArrayList wdata = new ArrayList();
        ArrayList zdata = new ArrayList();
        for (Map map : data) {
            xdata.add(map.get("NAME"));
            ydata.add(map.get("LOGINNUM"));
            wdata.add(map.get("PREVIEWNUM"));
            zdata.add(map.get("DOWNLOADNUM"));
        }
        result.put("xdata", xdata);
        result.put("ydata", ydata);
        result.put("wdata", wdata);
        result.put("zdata", zdata);
        return result;
    }

    public Timestamp getStartTime(String date_range) {
        String todayTime = DateUtil.formatDate((Date)new Date(), (String)"yyyy-MM-dd");
        todayTime = todayTime + " 00:00:00";
        Date date = DateUtil.parse((String)todayTime, (String)"yyyy-MM-dd HH:mm:ss");
        if (!"today".equals(date_range)) {
            if ("threeday".equals(date_range)) {
                date = DateUtil.addDay((Date)date, (int)-3);
            } else if ("week".equals(date_range)) {
                date = DateUtil.addWeek((Date)date, (int)-1);
            } else if ("month".equals(date_range)) {
                date = DateUtil.addMonth((Date)date, (int)-1);
            }
        }
        return new Timestamp(date.getTime());
    }
}

