/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.doc.manager.statistics.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.doc.common.util.CommonUtil;
import com.jxdinfo.doc.common.util.UserInfoUtil;
import com.jxdinfo.doc.manager.statistics.service.DeptStatisticsService;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.shiro.ShiroUser;
import java.util.List;
import java.util.Map;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/deptStatistics"})
public class DeptStatisticsController
extends BaseController {
    @Autowired
    private DeptStatisticsService deptStatisticsService;

    @RequiresPermissions(value={"deptStatistics:view"})
    @RequestMapping(value={"/view"})
    public String view() {
        return "/doc/manager/statistics/deptStatistics.html";
    }

    @RequestMapping(value={"/list"})
    @ResponseBody
    public JSON getTopicList(String topicName, int page, int limit) {
        int beginIndex = page * limit - limit;
        List<Map<String, Object>> list = this.deptStatisticsService.getStatisticsData();
        JSONObject json = new JSONObject();
        json.put("data", list);
        json.put("count", (Object)100);
        json.put("msg", (Object)"success");
        json.put("code", (Object)0);
        return json;
    }

    @RequestMapping(value={"/updateSpace"})
    @ResponseBody
    public JSON updateSpace(String id, String space) {
        this.deptStatisticsService.updateSpace(id, space);
        JSONObject json = new JSONObject();
        json.put("msg", (Object)"success");
        json.put("code", (Object)0);
        return json;
    }

    @RequestMapping(value={"/showSize"})
    @ResponseBody
    public JSON showSize() {
        ShiroUser shiroUser = UserInfoUtil.getCurrentUser();
        List roleList = ShiroKit.getUser().getRolesList();
        Integer adminFlag = CommonUtil.getAdminFlag((List)roleList);
        JSONObject json = new JSONObject();
        if (adminFlag != 1) {
            Map<String, String> space = this.deptStatisticsService.getSpaceByOrganId(shiroUser.getDeptId(), adminFlag);
            json.put("total", (Object)space.get("total"));
            json.put("lack", (Object)space.get("lack"));
            json.put("limit", (Object)space.get("limit"));
            json.put("present", (Object)space.get("present"));
        } else {
            json.put("limit", (Object)"0");
        }
        json.put("msg", (Object)"success");
        json.put("code", (Object)0);
        return json;
    }
}

