/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.doc.manager.personalcenter.controller;

import com.jxdinfo.doc.common.util.FileTool;
import com.jxdinfo.doc.manager.docmanager.model.FsFolderView;
import com.jxdinfo.doc.manager.foldermanager.service.IFsFolderService;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/personalUpload"})
public class PersonalUploadController {
    private String PREFIX = "/doc/manager/personalcenter/";
    @Autowired
    private IFsFolderService fsFolderService;

    @RequiresPermissions(value={"personalUpload:list"})
    @RequestMapping(value={"/list"})
    public String index() {
        return this.PREFIX + "personal_upload.html";
    }

    @RequestMapping(value={"/getlist"})
    @ResponseBody
    public Object getList(@RequestParam(value="pageNumber", defaultValue="1") int pageNumber, @RequestParam(value="pageSize", defaultValue="60") int pageSize, String name, String[] typeArr, String order) {
        String userId = ShiroKit.getUser().getId();
        List<Object> list = new ArrayList();
        list = this.fsFolderService.getPersonUpload(userId, (pageNumber - 1) * pageSize, pageSize, name, typeArr, order);
        list = this.changeSize(list);
        int num = this.fsFolderService.getPersonUploadNum(userId, name);
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        result.put("userId", ShiroKit.getUser().getName());
        result.put("total", num);
        result.put("rows", list);
        return result;
    }

    public List<FsFolderView> changeSize(List<FsFolderView> list) {
        for (FsFolderView fsFolderView : list) {
            if (fsFolderView.getFileSize() == null || "".equals(fsFolderView.getFileSize())) continue;
            fsFolderView.setFileSize(FileTool.longToString(fsFolderView.getFileSize()));
        }
        return list;
    }
}

