/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.doc.manager.personalcenter.controller;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.jxdinfo.doc.manager.docintegral.service.IntegralRecordService;
import com.jxdinfo.doc.manager.docintegral.service.IntegralRuleService;
import com.jxdinfo.hussar.bsp.permit.service.ISysUsersService;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.shiro.ShiroUser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/personalIntegral"})
public class PersonalIntegralController {
    @Resource
    private IntegralRecordService integralRecordService;
    @Resource
    private ISysUsersService iSysUsersService;
    @Resource
    private IntegralRuleService integralRuleService;

    @RequestMapping(value={"/list"})
    @ResponseBody
    public Map list(String ruleCodes, @RequestParam(value="pageNumber", defaultValue="1") int pageNumber, @RequestParam(defaultValue="60") int pageSize) {
        double total;
        ShiroUser shiroUser = ShiroKit.getUser();
        String userId = shiroUser.getId();
        String[] ruleCodesArray = null;
        if (ruleCodes != null && ruleCodes != "") {
            ruleCodesArray = ruleCodes.split(",");
        }
        List<Map<String, Object>> list = this.integralRecordService.getIntegralHistories(userId, "1", ruleCodesArray);
        int count = list.size();
        HashMap<String, Integer> integrals = new HashMap<String, Integer>();
        integrals.put("total", this.integralRecordService.showIntegral(userId));
        integrals.put("upload", this.integralRecordService.getIntegralByType(userId, new String[]{"upload"}));
        integrals.put("beDownloaded", this.integralRecordService.getIntegralByType(userId, new String[]{"beDownloaded"}));
        integrals.put("rewards", this.integralRecordService.getIntegralByType(userId, new String[]{"login", "search", "defaultBonus", "preview", "share"}));
        integrals.put("download", this.integralRecordService.getIntegralByType(userId, new String[]{"download"}));
        integrals.put("bePreviewed", this.integralRecordService.getIntegralByType(userId, new String[]{"bePreviewed"}));
        integrals.put("beShared", this.integralRecordService.getIntegralByType(userId, new String[]{"beShared"}));
        Integer rankTry = this.integralRecordService.getRankNum(userId);
        double rank = total = (double)this.iSysUsersService.selectCount(new EntityWrapper().ne("ACCOUNT_STATUS", (Object)"2"));
        if (rankTry != null) {
            rank = rankTry.intValue();
        }
        double present = 100.0 - rank / total * 100.0;
        int presentint = (int)present;
        HashMap<String, Object> histories = new HashMap<String, Object>();
        histories.put("msg", "success");
        histories.put("code", 0);
        histories.put("rows", list.stream().skip((pageNumber - 1) * pageSize).limit(pageSize).collect(Collectors.toList()));
        histories.put("count", count);
        histories.put("integrals", integrals);
        histories.put("present", presentint + "%");
        return histories;
    }

    @RequestMapping(value={"/ruleList"})
    @ResponseBody
    public Map ruleList() {
        ShiroUser shiroUser = ShiroKit.getUser();
        String userId = shiroUser.getId();
        List<Map> list = this.integralRuleService.getIntegralRule(0, 30);
        ArrayList<String> listNew = new ArrayList<String>();
        String times = "";
        String start = "";
        for (int i = 0; i < list.size(); ++i) {
            if ((list.get(i).get("valid") + "").equals("1") && !(list.get(i).get("ruleCode") + "").equals("defaultBonus") && !(list.get(i).get("ruleCode") + "").equals("dayLimit")) {
                String desc = "";
                times = list.get(i).get("maxTimes") + "";
                if (!"-1".equals(times)) {
                    desc = "\u6bcf\u65e5" + desc;
                    if ("1".equals(times)) {
                        desc = desc + "\u7b2c&nbsp;<span >" + times + "</span>&nbsp;\u6b21";
                        if (!(list.get(i).get("ruleCode") + "").equals("login")) {
                            desc = desc + "\u6587\u4ef6";
                        }
                        desc = desc + list.get(i).get("ruleName") + "";
                    } else {
                        desc = desc + "\u524d&nbsp;<span >" + times + "</span>&nbsp;\u6b21";
                        if (!(list.get(i).get("ruleCode") + "").equals("login")) {
                            desc = desc + "\u6587\u4ef6";
                        }
                        desc = desc + list.get(i).get("ruleName") + "";
                    }
                } else {
                    if (!(list.get(i).get("ruleCode") + "").equals("login")) {
                        desc = desc + "\u6587\u4ef6";
                    }
                    desc = desc + list.get(i).get("ruleName") + "";
                }
                Integer rank = (Integer)list.get(i).get("integral");
                String rankStr = "";
                if (rank < 0) {
                    rankStr = rank + "";
                    desc = desc + " \u79ef\u5206 <span style='color:#F86842'>" + rankStr + "</span>";
                } else {
                    rankStr = "+" + rank;
                    desc = desc + " \u79ef\u5206 <span style='color:#4DBF86'>" + rankStr + "</span>";
                }
                listNew.add(desc);
            }
            if (!(list.get(i).get("ruleCode") + "").equals("dayLimit")) continue;
            start = "\u6bcf\u65e5\u79ef\u5206\u4e0a\u9650\u4e3a\uff1a" + list.get(i).get("integral");
        }
        HashMap<String, Object> histories = new HashMap<String, Object>();
        histories.put("limit", start);
        histories.put("list", listNew);
        return histories;
    }

    @RequestMapping(value={"/ruleShow"})
    public String ruleShow(String fileId, String fileType, String fileName, Model model) {
        return "/doc/front/personalcenter/integral_rule.html";
    }

    @RequestMapping(value={"/rulesList"})
    @ResponseBody
    public Map rulesList() {
        ShiroUser shiroUser = ShiroKit.getUser();
        String userId = shiroUser.getId();
        List<Map> list = this.integralRuleService.getIntegralRule(0, 30);
        ArrayList listNew = new ArrayList();
        String times = "";
        String start = "";
        HashMap<String, List<Map>> histories = new HashMap<String, List<Map>>();
        histories.put("list", list);
        return histories;
    }
}

