/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.doc.manager.personalcenter.controller;

import com.jxdinfo.doc.common.docutil.service.BusinessService;
import com.jxdinfo.doc.common.util.CommonUtil;
import com.jxdinfo.doc.manager.docintegral.service.IntegralRecordService;
import com.jxdinfo.doc.manager.docmanager.model.DocResourceLog;
import com.jxdinfo.doc.manager.docmanager.service.DocInfoService;
import com.jxdinfo.doc.manager.foldermanager.model.FsFolderParams;
import com.jxdinfo.doc.manager.groupmanager.service.DocGroupService;
import com.jxdinfo.doc.manager.personalcenter.service.PersonalOperateService;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.shiro.ShiroUser;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/personalCollection"})
public class PersonalCollectionController {
    @Resource
    private PersonalOperateService operateService;
    @Autowired
    private DocInfoService docInfoService;
    @Resource
    private IntegralRecordService integralRecordService;
    @Autowired
    private DocGroupService docGroupService;
    @Resource
    private BusinessService businessService;

    @RequestMapping(value={"/list"})
    @ResponseBody
    public Map list(String name, String[] typeArr, @RequestParam(value="pageNumber", defaultValue="1") int pageNumber, @RequestParam(defaultValue="60") int pageSize, String order) {
        int beginIndex = pageNumber * pageSize - pageSize;
        List roleList = ShiroKit.getUser().getRolesList();
        Integer adminFlag = CommonUtil.getAdminFlag((List)roleList);
        ShiroUser shiroUser = ShiroKit.getUser();
        String userId = shiroUser.getId();
        FsFolderParams fsFolderParams = new FsFolderParams();
        List<String> listGroup = this.docGroupService.getPremission(userId);
        fsFolderParams.setUserId(userId);
        fsFolderParams.setGroupList(listGroup);
        fsFolderParams.setType("2");
        String levelCode = this.businessService.getLevelCodeByUserUpload(fsFolderParams);
        String orgId = ShiroKit.getUser().getDeptName();
        List<Map> list = this.operateService.getMyHistory(userId, "5", beginIndex, pageSize, name, typeArr, order, levelCode, orgId);
        int count = this.operateService.getMyHistoryCount(userId, "5", name);
        HashMap<String, Object> histories = new HashMap<String, Object>();
        histories.put("msg", "success");
        histories.put("code", 0);
        histories.put("adminFlag", adminFlag);
        histories.put("rows", list);
        histories.put("count", count);
        return histories;
    }

    @RequestMapping(value={""})
    public String collectionList() {
        return "/doc/manager/personalcenter/collection-list.html";
    }

    @RequestMapping(value={"cancelCollection"})
    @ResponseBody
    public Object cancelCollection(String docIds) {
        HashMap<String, String> result = new HashMap<String, String>(5);
        try {
            ShiroUser shiroUser = ShiroKit.getUser();
            String userId = shiroUser.getId();
            this.operateService.cancelCollection(docIds, userId, "5");
            result.put("success", "0");
        }
        catch (Exception e) {
            e.printStackTrace();
            result.put("success", "1");
        }
        return result;
    }

    @RequestMapping(value={"addCollection"})
    @ResponseBody
    public Object addCollection(String docIds) {
        HashMap<String, String> result = new HashMap<String, String>(5);
        try {
            ArrayList<DocResourceLog> resInfoList = new ArrayList<DocResourceLog>();
            Timestamp ts = new Timestamp(System.currentTimeMillis());
            DocResourceLog docResourceLog = new DocResourceLog();
            String id = UUID.randomUUID().toString().replace("-", "");
            ShiroUser shiroUser = ShiroKit.getUser();
            String userId = shiroUser.getId();
            docResourceLog.setId(id);
            docResourceLog.setResourceId(docIds);
            docResourceLog.setOperateTime(ts);
            docResourceLog.setResourceType(0);
            docResourceLog.setUserId(userId);
            docResourceLog.setOperateType(5);
            docResourceLog.setValidFlag("1");
            resInfoList.add(docResourceLog);
            this.docInfoService.insertResourceLog(resInfoList);
            result.put("success", "0");
        }
        catch (Exception e) {
            e.printStackTrace();
            result.put("success", "1");
        }
        return result;
    }

    @RequestMapping(value={"deleteCollection"})
    @ResponseBody
    public int deleteCollection(String[] ids) {
        return this.operateService.deleteCollection(ids);
    }
}

