/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.doc.manager.groupmanager.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.jxdinfo.doc.common.util.CommonUtil;
import com.jxdinfo.doc.common.util.StringUtil;
import com.jxdinfo.doc.manager.docmanager.service.DocFileAuthorityService;
import com.jxdinfo.doc.manager.foldermanager.service.IDocFoldAuthorityService;
import com.jxdinfo.doc.manager.groupmanager.model.DocGroup;
import com.jxdinfo.doc.manager.groupmanager.model.DocGroupSort;
import com.jxdinfo.doc.manager.groupmanager.service.DocGroupService;
import com.jxdinfo.hussar.bsp.permit.service.ISysIdtableService;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/group"})
public class DocGroupController
extends BaseController {
    private String PREFIX = "/doc/manager/groupmanager/";
    @Autowired
    private DocGroupService docGroupService;
    @Autowired
    private IDocFoldAuthorityService docFoldAuthorityService;
    @Autowired
    private DocFileAuthorityService docFileAuthorityService;
    @Autowired
    private ISysIdtableService sysIdtableService;

    @RequiresPermissions(value={"group:groupListView"})
    @RequestMapping(value={"/groupListView"})
    public String groupListView(Model model) {
        List roleList = ShiroKit.getUser().getRolesList();
        Integer adminFlag = CommonUtil.getAdminFlag((List)roleList);
        String loginId = "admin";
        if (adminFlag != 1) {
            loginId = ShiroKit.getUser().getId();
        }
        model.addAttribute("loginId", (Object)loginId);
        return this.PREFIX + "group_view.html";
    }

    @RequestMapping(value={"/groupAdd"})
    public String groupAdd(Model model, String sortId) {
        DocGroup docGroup = new DocGroup();
        if (null != sortId) {
            DocGroupSort parentSortName = this.docGroupService.selectSortInfo(sortId);
            docGroup.setSortName(parentSortName.getSortName());
            docGroup.setSortId(sortId);
        }
        model.addAttribute("docGroup", (Object)docGroup);
        return this.PREFIX + "group_edit_new.html";
    }

    @RequestMapping(value={"/groupTree"})
    @ResponseBody
    public List<Map<String, Object>> groupTree() {
        String deptId = super.getPara("treeType");
        List<Map<String, Object>> result = this.docGroupService.selectGroupByName("");
        HashMap<String, String> root = new HashMap<String, String>();
        root.put("ID", "af9090a8fdfe487f9487df9cdc6e88");
        root.put("CODE", "");
        root.put("TEXT", "\u7fa4\u7ec4");
        root.put("PARENT", "#");
        root.put("STRULEVEL", "0");
        root.put("ISLEAF", "0");
        root.put("TYPE", "isRoot");
        result.add(root);
        return result;
    }

    @RequestMapping(value={"/groupList"})
    @ResponseBody
    public JSON getTopicList(String groupId, String uerName, int page, int limit) {
        int beginIndex = page * limit - limit;
        String userName = StringUtil.transferSqlParam((String)uerName);
        List<DocGroup> groupList = this.docGroupService.groupList(groupId, userName, beginIndex, limit);
        int counts = this.docGroupService.getGroupListCount(groupId, userName);
        JSONObject json = new JSONObject();
        json.put("count", (Object)counts);
        json.put("data", groupList);
        json.put("msg", (Object)"success");
        json.put("code", (Object)0);
        return json;
    }

    @RequestMapping(value={"/addGroup"})
    @ResponseBody
    public JSON addGroup(DocGroup docGroup) {
        String groupId = UUID.randomUUID().toString().replaceAll("-", "");
        docGroup.setGroupId(groupId);
        String currentCode = this.sysIdtableService.getCurrentCode("GROUP_NUM", "doc_group");
        int bigNum = Integer.parseInt(currentCode);
        docGroup.setShowOrder(bigNum);
        JSONObject json = new JSONObject();
        int num = this.docGroupService.checkGroupExist(docGroup.getGroupName(), null);
        if (num > 0) {
            json.put("result", (Object)"0");
        } else {
            int addNum = this.docGroupService.addGroup(docGroup);
            if (addNum == 1) {
                json.put("result", (Object)"1");
            } else {
                json.put("result", (Object)"2");
            }
        }
        return json;
    }

    @RequestMapping(value={"/addGroupUser"})
    @ResponseBody
    public JSON addGroupUser(DocGroup docGroup) {
        JSONObject json = new JSONObject();
        int addNum = this.docGroupService.addGroupUser(docGroup);
        if (addNum > 0) {
            json.put("result", (Object)"1");
        } else {
            json.put("result", (Object)"2");
        }
        return json;
    }

    @RequestMapping(value={"/editGroup"})
    @ResponseBody
    public JSON editGroup(DocGroup docGroup) {
        JSONObject json = new JSONObject();
        int num = this.docGroupService.checkGroupExist(docGroup.getGroupName(), docGroup.getGroupId());
        if (num > 0) {
            json.put("result", (Object)"0");
        } else {
            int editNum = this.docGroupService.updateGroup(docGroup);
            if (editNum == 1) {
                json.put("result", (Object)"1");
            } else {
                json.put("result", (Object)"2");
            }
        }
        return json;
    }

    @RequestMapping(value={"/delGroupById"})
    @ResponseBody
    public int delGroupById(String groupId) {
        int isAuthority = this.docGroupService.getIsAuthority(groupId);
        if (isAuthority == 0) {
            this.docFoldAuthorityService.delete(new EntityWrapper().eq("author_id", (Object)groupId));
            this.docFileAuthorityService.delete(new EntityWrapper().eq("author_id", (Object)groupId));
            return this.docGroupService.delGroupById(groupId);
        }
        return 6;
    }

    @RequestMapping(value={"/delGroupUserById"})
    @ResponseBody
    public int delGroupUserById(String groupId, String delIds) {
        int num = 0;
        if (null != delIds) {
            List<String> idList = Arrays.asList(delIds.split(","));
            num = this.docGroupService.delGroupUserById(groupId, idList);
        }
        return num;
    }

    @RequestMapping(value={"/groupEdit"})
    public String topicView(Model model, String groupId) {
        DocGroup docGroup = this.docGroupService.selectGroupById(groupId);
        DocGroupSort parentSortName = this.docGroupService.selectSortInfo(docGroup.getSortId());
        docGroup.setSortId(parentSortName.getSortId());
        docGroup.setSortName(parentSortName.getSortName());
        model.addAttribute("docGroup", (Object)docGroup);
        return this.PREFIX + "group_edit_new.html";
    }

    @RequestMapping(value={"/getPersonList"})
    @ResponseBody
    public JSON getPersonList(String groupId, int page, int limit) {
        int beginIndex = page * limit - limit;
        List<Map> list = this.docGroupService.selectGroupUserById(groupId, beginIndex, limit);
        int counts = this.docGroupService.getGroupListCount(groupId, null);
        JSONObject json = new JSONObject();
        json.put("count", (Object)counts);
        json.put("data", list);
        json.put("msg", (Object)"success");
        json.put("code", (Object)0);
        return json;
    }

    @RequestMapping(value={"/sortAdd"})
    public String sortAdd(Model model, String groupId, String groupName) {
        model.addAttribute("parentSortId", (Object)groupId);
        model.addAttribute("parentSortName", (Object)groupName);
        model.addAttribute("sortId", (Object)"");
        model.addAttribute("sortName", (Object)"");
        return this.PREFIX + "sort_add.html";
    }

    @RequestMapping(value={"/sortAndGroupTree"})
    @ResponseBody
    public List<Map<String, Object>> selectSortAndGroup(String id) {
        List<Map<String, Object>> result = this.docGroupService.selectSortAndGroup(id);
        return result;
    }

    @RequestMapping(value={"/addSort"})
    @ResponseBody
    public JSON addSort(DocGroupSort docGroupSort) {
        JSONObject json = new JSONObject();
        int num = this.docGroupService.checkSortName(docGroupSort.getSortName(), docGroupSort.getParentSortId(), docGroupSort.getSortId());
        if (num > 0) {
            json.put("result", (Object)"0");
        } else {
            int savenum = this.docGroupService.addGroupSort(docGroupSort);
            if (savenum == 1) {
                json.put("result", (Object)"1");
            } else {
                json.put("result", (Object)"2");
            }
        }
        return json;
    }

    @RequestMapping(value={"/editSort"})
    @ResponseBody
    public JSON editSort(DocGroupSort docGroupSort) {
        JSONObject json = new JSONObject();
        int num = this.docGroupService.checkSortName(docGroupSort.getSortName(), docGroupSort.getParentSortId(), docGroupSort.getSortId());
        if (num > 0) {
            json.put("result", (Object)"0");
        } else {
            boolean res = this.docGroupService.updateSortInfo(docGroupSort);
            if (res) {
                json.put("result", (Object)"1");
            } else {
                json.put("result", (Object)"2");
            }
        }
        return json;
    }

    @RequestMapping(value={"/sortEdit"})
    @ResponseBody
    public JSONObject sortEdit(String groupId) {
        JSONObject json = new JSONObject();
        DocGroupSort docGroupSort = this.docGroupService.selectSortInfo(groupId);
        DocGroupSort ParentSortName = this.docGroupService.selectSortInfo(docGroupSort.getParentSortId());
        json.put("parentSortName", (Object)ParentSortName.getSortName());
        json.put("parentSortId", (Object)docGroupSort.getParentSortId());
        json.put("sortName", (Object)docGroupSort.getSortName());
        json.put("sortId", (Object)docGroupSort.getSortId());
        return json;
    }

    @RequestMapping(value={"/deleteSort"})
    @ResponseBody
    public int deleteSort(String groupId) {
        int num = this.docGroupService.delGroupSortById(groupId);
        return num;
    }

    @RequestMapping(value={"/getSortTree"})
    @ResponseBody
    public List<Map<String, Object>> getSortTreeData() {
        return this.docGroupService.getSortTreeData();
    }

    @RequestMapping(value={"/sortTree"})
    public String sortTree(Model model) {
        return this.PREFIX + "sort_tree.html";
    }
}

