/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.doc.manager.foldermanager.service.impl;

import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.jxdinfo.doc.common.docutil.dao.BusinessMapper;
import com.jxdinfo.doc.common.docutil.service.BusinessService;
import com.jxdinfo.doc.common.docutil.service.CacheToolService;
import com.jxdinfo.doc.manager.foldermanager.dao.DocFoldAuthorityMapper;
import com.jxdinfo.doc.manager.foldermanager.dao.FsFolderMapper;
import com.jxdinfo.doc.manager.foldermanager.model.DocFoldAuthority;
import com.jxdinfo.doc.manager.foldermanager.model.FsFolder;
import com.jxdinfo.doc.manager.foldermanager.model.FsFolderParams;
import com.jxdinfo.doc.manager.foldermanager.service.IDocFoldAuthorityService;
import com.jxdinfo.hussar.bsp.permit.model.SysUsers;
import com.jxdinfo.hussar.bsp.permit.service.ISysUsersService;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DocFoldAuthorityServiceImpl
extends ServiceImpl<DocFoldAuthorityMapper, DocFoldAuthority>
implements IDocFoldAuthorityService {
    @Resource
    private BusinessMapper businessMapper;
    @Resource
    private DocFoldAuthorityMapper docFoldAuthorityMapper;
    @Resource
    private FsFolderMapper fsFolderMapper;
    @Resource
    private BusinessService businessService;
    @Autowired
    private CacheToolService cacheToolService;
    @Autowired
    private ISysUsersService iSysUsersService;

    @Override
    public int findEdit(String id, List groupList, String userId) {
        ArrayList levelCodeList = new ArrayList();
        int editValue = 0;
        if (id != null) {
            int i;
            FsFolder fsFolderChild = (FsFolder)((Object)this.fsFolderMapper.selectById((Serializable)((Object)id)));
            String code = fsFolderChild.getLevelCode();
            FsFolderParams fsFolderParams = new FsFolderParams();
            fsFolderParams.setGroupList(groupList);
            fsFolderParams.setUserId(userId);
            fsFolderParams.setType("1");
            String levelCodes = this.businessService.getUpLevelCodeByUser(fsFolderParams);
            String levelCodeNew = "";
            if (levelCodes.length() != 0) {
                levelCodeNew = levelCodes.substring(1, levelCodes.length() - 1);
                String[] codeList = levelCodeNew.split(",");
                for (i = 0; i < codeList.length; ++i) {
                    if (!codeList[i].equals("'" + code + "'")) continue;
                    editValue = 1;
                    break;
                }
            } else {
                editValue = 0;
            }
            fsFolderParams.setType("2");
            levelCodes = this.businessService.getLevelCodeByUserUpload(fsFolderParams);
            if (levelCodes.length() != 0) {
                levelCodeNew = levelCodes.substring(1, levelCodes.length() - 1);
                String[] codeListNew = levelCodeNew.split(",");
                for (i = 0; i < codeListNew.length; ++i) {
                    if (!codeListNew[i].equals("'" + code + "'")) continue;
                    editValue = 2;
                    break;
                }
            }
        }
        return editValue;
    }

    @Override
    public int findEditByUpload(String id, List groupList, String userId) {
        ArrayList levelCodeList = new ArrayList();
        int editValue = 0;
        if (id != null) {
            int i;
            FsFolder fsFolderChild = (FsFolder)((Object)this.fsFolderMapper.selectById((Serializable)((Object)id)));
            String code = fsFolderChild.getLevelCode();
            FsFolderParams fsFolderParams = new FsFolderParams();
            fsFolderParams.setGroupList(groupList);
            fsFolderParams.setUserId(userId);
            fsFolderParams.setType("1");
            String orgId = ShiroKit.getUser().getDeptName();
            String groupIds = String.join((CharSequence)",", fsFolderParams.getGroupList());
            String levelCodes = this.businessService.getUpLevelCodeByUser(fsFolderParams);
            String levelCodeNew = "";
            if (levelCodes.length() != 0) {
                levelCodeNew = levelCodes.substring(1, levelCodes.length() - 1);
                String[] codeList = levelCodeNew.split(",");
                for (i = 0; i < codeList.length; ++i) {
                    if (!codeList[i].equals("'" + code + "'")) continue;
                    editValue = 1;
                    break;
                }
            } else {
                editValue = 0;
            }
            fsFolderParams.setType("2");
            levelCodes = this.cacheToolService.getLevelCodeByUserByUploadCache(groupIds, userId, "2", orgId);
            if (levelCodes == null) {
                levelCodes = "";
            }
            if (levelCodes.indexOf(",") == 0) {
                levelCodes = levelCodes.substring(1, levelCodes.length());
                levelCodes = "('" + levelCodes.replace(",", "','") + "')";
            } else {
                levelCodes = "('')";
            }
            if (levelCodes.length() != 0) {
                levelCodeNew = levelCodes.substring(1, levelCodes.length() - 1);
                String[] codeListNew = levelCodeNew.split(",");
                for (i = 0; i < codeListNew.length; ++i) {
                    if (!codeListNew[i].equals("'" + code + "'")) continue;
                    editValue = 2;
                    break;
                }
            }
        }
        return editValue;
    }

    @Override
    public int findEditByUploadMobile(String id, List groupList, String userId) {
        ArrayList levelCodeList = new ArrayList();
        int editValue = 0;
        if (id != null) {
            int i;
            FsFolder fsFolderChild = (FsFolder)((Object)this.fsFolderMapper.selectById((Serializable)((Object)id)));
            String code = fsFolderChild.getLevelCode();
            FsFolderParams fsFolderParams = new FsFolderParams();
            fsFolderParams.setGroupList(groupList);
            fsFolderParams.setUserId(userId);
            fsFolderParams.setType("1");
            String orgId = ((SysUsers)this.iSysUsersService.selectById((Serializable)((Object)userId))).getDepartmentId();
            String groupIds = String.join((CharSequence)",", fsFolderParams.getGroupList());
            String levelCodes = this.businessService.getUpLevelCodeByUser(fsFolderParams);
            String levelCodeNew = "";
            if (levelCodes.length() != 0) {
                levelCodeNew = levelCodes.substring(1, levelCodes.length() - 1);
                String[] codeList = levelCodeNew.split(",");
                for (i = 0; i < codeList.length; ++i) {
                    if (!codeList[i].equals("'" + code + "'")) continue;
                    editValue = 1;
                    break;
                }
            } else {
                editValue = 0;
            }
            fsFolderParams.setType("2");
            levelCodes = this.cacheToolService.getLevelCodeByUserByUploadCache(groupIds, userId, "2", orgId);
            if (levelCodes == null) {
                levelCodes = "";
            }
            if (levelCodes.indexOf(",") == 0) {
                levelCodes = levelCodes.substring(1, levelCodes.length());
                levelCodes = "('" + levelCodes.replace(",", "','") + "')";
            } else {
                levelCodes = "('')";
            }
            if (levelCodes.length() != 0) {
                levelCodeNew = levelCodes.substring(1, levelCodes.length() - 1);
                String[] codeListNew = levelCodeNew.split(",");
                for (i = 0; i < codeListNew.length; ++i) {
                    if (!codeListNew[i].equals("'" + code + "'")) continue;
                    editValue = 2;
                    break;
                }
            }
        }
        return editValue;
    }

    @Override
    public boolean saveDocFoldAuthority(FsFolderParams fsFolderParams) {
        boolean flag = false;
        ArrayList<DocFoldAuthority> list = new ArrayList<DocFoldAuthority>();
        if (ToolUtil.isNotEmpty((Object)fsFolderParams.getGroup())) {
            String[] groupArr = fsFolderParams.getGroup().split(",");
            String[] authorTypeStrGroup = fsFolderParams.getAuthorTypeStrGroup().split(",");
            String[] operateTypeStrGroup = fsFolderParams.getOperateTypeStrGroup().split(",");
            for (int i = 0; i < groupArr.length; ++i) {
                DocFoldAuthority docFoldAuthority = new DocFoldAuthority();
                docFoldAuthority.setId(UUID.randomUUID().toString().replaceAll("-", ""));
                docFoldAuthority.setAuthorId(groupArr[i]);
                docFoldAuthority.setAuthorType(authorTypeStrGroup[i]);
                docFoldAuthority.setFoldId(fsFolderParams.getFolderId());
                docFoldAuthority.setIsEdit(fsFolderParams.getIsEdit());
                docFoldAuthority.setOperateType(operateTypeStrGroup[i]);
                list.add(docFoldAuthority);
            }
        }
        if (ToolUtil.isNotEmpty((Object)fsFolderParams.getPerson())) {
            String[] personArr = fsFolderParams.getPerson().split(",");
            String[] personOrganArr = fsFolderParams.getPersonOrgan().split(",");
            String[] authorTypeStrPerson = fsFolderParams.getAuthorTypeStrPerson().split(",");
            String[] operateTypeStrPerson = fsFolderParams.getOperateTypeStrPerson().split(",");
            for (int i = 0; i < personArr.length; ++i) {
                DocFoldAuthority docFoldAuthority = new DocFoldAuthority();
                docFoldAuthority.setId(UUID.randomUUID().toString().replaceAll("-", ""));
                docFoldAuthority.setAuthorId(personArr[i]);
                docFoldAuthority.setAuthorType(authorTypeStrPerson[i]);
                docFoldAuthority.setFoldId(fsFolderParams.getFolderId());
                docFoldAuthority.setIsEdit(fsFolderParams.getIsEdit());
                docFoldAuthority.setOrganId(personOrganArr[i]);
                docFoldAuthority.setOperateType(operateTypeStrPerson[i]);
                list.add(docFoldAuthority);
            }
        }
        flag = list.size() > 0 ? this.insertBatch(list) : true;
        return flag;
    }

    @Override
    public int findEditNew(String id, List groupList, String userId) {
        FsFolder fsFolderChild;
        ArrayList<String> levelCodeList = new ArrayList<String>();
        String orgName = ShiroKit.getUser().getDeptName();
        if (id != null && (fsFolderChild = (FsFolder)((Object)this.fsFolderMapper.selectById((Serializable)((Object)id)))) != null) {
            for (int m = 0; m < fsFolderChild.getLevelCode().length() / 3; ++m) {
                String code = fsFolderChild.getLevelCode().substring(0, (m + 1) * 3);
                levelCodeList.add(code);
            }
        }
        return this.docFoldAuthorityMapper.findEditNew(levelCodeList, groupList, userId, orgName);
    }
}

