/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.doc.manager.docrecycle.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.doc.common.util.CommonUtil;
import com.jxdinfo.doc.common.util.UserInfoUtil;
import com.jxdinfo.doc.manager.docmanager.model.DocInfo;
import com.jxdinfo.doc.manager.docmanager.service.DocInfoService;
import com.jxdinfo.doc.manager.docmanager.service.FsFileService;
import com.jxdinfo.doc.manager.docrecycle.service.IDocRecycleService;
import com.jxdinfo.doc.manager.foldermanager.service.IDocFoldAuthorityService;
import com.jxdinfo.doc.manager.foldermanager.service.IFsFolderService;
import com.jxdinfo.doc.manager.groupmanager.service.DocGroupService;
import com.jxdinfo.doc.manager.statistics.service.DeptStatisticsService;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.shiro.ShiroUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/docRecycle"})
public class DocRecycleController
extends BaseController {
    @Resource
    private IDocRecycleService iDocRecycleService;
    @Autowired
    private DocGroupService docGroupService;
    @Autowired
    private IFsFolderService fsFolderService;
    @Autowired
    private IDocFoldAuthorityService docFoldAuthorityService;
    @Autowired
    private FsFileService fsFileService;
    @Autowired
    private DocInfoService docInfoService;
    @Autowired
    private DeptStatisticsService deptStatisticsService;
    private static String PREFIX = "/doc/manager/docrecycle/";

    @RequiresPermissions(value={"docRecycle:view"})
    @RequestMapping(value={"/view"})
    public String view() {
        return PREFIX + "docRecycle.html";
    }

    @RequestMapping(value={"/docRecycleList"})
    @ResponseBody
    public Object getLogTable() {
        String pageNum = super.getPara("page");
        String limitNum = super.getPara("limit");
        String fileName = super.getPara("fileName");
        Map<String, Object> list = this.iDocRecycleService.getDocRecycleList(pageNum, limitNum, fileName);
        return list;
    }

    @RequestMapping(value={"/restore"})
    @ResponseBody
    public JSON restore() {
        int isEdits;
        String userId = ShiroKit.getUser().getId();
        List<String> listGroup = this.docGroupService.getPremission(userId);
        List roleList = ShiroKit.getUser().getRolesList();
        Integer adminFlag = CommonUtil.getAdminFlag((List)roleList);
        JSONObject json = new JSONObject();
        String fileId = super.getPara("fileId");
        if (ToolUtil.isEmpty((Object)fileId)) {
            fileId = "";
        }
        String folderId = super.getPara("folderId");
        String fileName = super.getPara("fileName");
        ShiroUser shiroUser = UserInfoUtil.getCurrentUser();
        if (adminFlag != 1 && (isEdits = this.docFoldAuthorityService.findEdit(folderId, listGroup, userId)) == 0) {
            json.put("result", (Object)"3");
            return json;
        }
        boolean isChild = this.fsFileService.isChildren(folderId);
        if (isChild) {
            if (this.iDocRecycleService.checkDocExist(folderId, fileName)) {
                json.put("result", (Object)"0");
            } else {
                double lackShare;
                DocInfo docInfo = this.docInfoService.getDocDetail(fileId);
                if (docInfo != null && adminFlag != 1 && (lackShare = this.deptStatisticsService.getStatisticsDataByOrganId(shiroUser.getDeptId(), docInfo.getFileSize())) < 0.0) {
                    json.put("result", (Object)"5");
                    return json;
                }
                if (this.iDocRecycleService.restore(fileId, folderId)) {
                    json.put("result", (Object)"1");
                } else {
                    json.put("result", (Object)"2");
                }
            }
        } else {
            json.put("result", (Object)"4");
        }
        return json;
    }

    @RequestMapping(value={"/clear"})
    @ResponseBody
    public boolean clear() {
        boolean flag = this.iDocRecycleService.clear();
        return flag;
    }
}

