/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.doc.manager.docmanager.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.jxdinfo.doc.common.constant.DocConstant;
import com.jxdinfo.doc.common.docutil.model.DocES;
import com.jxdinfo.doc.common.docutil.service.BusinessService;
import com.jxdinfo.doc.common.docutil.service.CacheToolService;
import com.jxdinfo.doc.common.docutil.service.ESService;
import com.jxdinfo.doc.common.docutil.service.FastdfsService;
import com.jxdinfo.doc.common.docutil.service.PdfService;
import com.jxdinfo.doc.common.util.CommonUtil;
import com.jxdinfo.doc.common.util.ESUtil;
import com.jxdinfo.doc.common.util.FileTool;
import com.jxdinfo.doc.common.util.StringUtil;
import com.jxdinfo.doc.common.util.ThumbnailsUtil;
import com.jxdinfo.doc.common.util.UserInfoUtil;
import com.jxdinfo.doc.front.docmanager.dao.FrontDocInfoMapper;
import com.jxdinfo.doc.front.personalmanager.model.DocVersion;
import com.jxdinfo.doc.front.personalmanager.service.DocVersionService;
import com.jxdinfo.doc.manager.docmanager.dao.DocInfoMapper;
import com.jxdinfo.doc.manager.docmanager.dao.FilesMapper;
import com.jxdinfo.doc.manager.docmanager.dao.FsFileMapper;
import com.jxdinfo.doc.manager.docmanager.ex.ServiceException;
import com.jxdinfo.doc.manager.docmanager.model.DocFileAuthority;
import com.jxdinfo.doc.manager.docmanager.model.DocInfo;
import com.jxdinfo.doc.manager.docmanager.model.DocResourceLog;
import com.jxdinfo.doc.manager.docmanager.model.DocUploadParams;
import com.jxdinfo.doc.manager.docmanager.model.FsFile;
import com.jxdinfo.doc.manager.docmanager.service.DocFileAuthorityService;
import com.jxdinfo.doc.manager.docmanager.service.DocInfoService;
import com.jxdinfo.doc.manager.docmanager.service.FilesService;
import com.jxdinfo.doc.manager.docmanager.service.FsFileService;
import com.jxdinfo.doc.manager.foldermanager.model.FsFolder;
import com.jxdinfo.doc.manager.foldermanager.model.FsFolderParams;
import com.jxdinfo.doc.manager.foldermanager.service.IFsFolderService;
import com.jxdinfo.doc.manager.groupmanager.service.DocGroupService;
import com.jxdinfo.doc.manager.statistics.service.DocSpaceService;
import com.jxdinfo.doc.manager.topicmanager.model.TopicFile;
import com.jxdinfo.doc.manager.topicmanager.service.ITopicDocManagerService;
import com.jxdinfo.doc.newupload.service.UploadService;
import com.jxdinfo.doc.newupload.thread.ChangeToPdfThread;
import com.jxdinfo.hussar.bsp.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.bsp.organ.model.SysStru;
import com.jxdinfo.hussar.bsp.permit.service.ISysIdtableService;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.shiro.ShiroUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.encrypt.file.FileEncryptUtil;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.tomcat.util.threads.ThreadPoolExecutor;
import org.apache.tools.zip.ZipOutputStream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class FilesServiceImpl
implements FilesService {
    private static ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(5, 20, 10000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue());
    private static Logger logger = LogManager.getLogger(FilesServiceImpl.class);
    @Value(value="${docbase.filedir}")
    private String tempdir;
    @Value(value="${docbase.fileByKey}")
    private String fileByKey;
    @Value(value="${docbase.pdfFile}")
    private String pdfFileDir;
    @Value(value="${docbase.pdfFileByKey}")
    private String pdfFileByKey;
    @Value(value="${docbase.ThumbnailsDir}")
    private String ThumbnailsDir;
    @Value(value="${fastdfs.using}")
    private boolean fastdfsUsingFlag;
    @Value(value="${thread.core-pool-size}")
    private Integer poolSize;
    @Value(value="${thread.max-pool-size}")
    private Integer maxSize;
    @Value(value="${thread.keep-alive-time}")
    private Integer aliveTime;
    @Value(value="${docbase.zipDownloadPath}")
    private String zipDownloadPath;
    @Value(value="${examine.using}")
    private boolean examineUsingFlag;
    @Autowired
    private DocGroupService docGroupService;
    @Autowired
    private ITopicDocManagerService iTopicDocManagerService;
    @Autowired
    private ISysIdtableService sysIdtableService;
    @Autowired
    private IFsFolderService iFsFolderService;
    @Autowired
    private ESUtil esUtil;
    @Resource
    private UploadService uploadService;
    @Resource
    private FrontDocInfoMapper frontDocInfoMapper;
    @Resource
    private BusinessService businessService;
    @Autowired
    private FilesMapper filesMapper;
    @Autowired
    private FsFileService fsFileService;
    @Autowired
    private DocInfoMapper docInfoMapper;
    @Autowired
    private FastdfsService fastdfsService;
    @Autowired
    private ESService esService;
    @Autowired
    private PdfService pdfService;
    @Autowired
    private DocFileAuthorityService docFileAuthorityService;
    @Autowired
    private FileTool fileTool;
    @Autowired
    private FsFileMapper fsFileMapper;
    @Autowired
    private DocInfoService docInfoService;
    @Autowired
    private DocVersionService docVersionService;
    @Autowired
    private DocSpaceService docSpaceService;
    @Autowired
    private CacheToolService cacheToolService;
    @Autowired
    private SysStruMapper sysStruMapper;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Map<String, Object> upload(MultipartFile file, DocUploadParams uploadParams) throws Exception {
        DocInfo docInfo = new DocInfo();
        FsFile fsFile = new FsFile();
        ArrayList<DocResourceLog> resInfoList = new ArrayList<DocResourceLog>();
        ArrayList<DocFileAuthority> authoritylist = new ArrayList<DocFileAuthority>();
        ArrayList<String> indexList = new ArrayList<String>();
        Map<String, Object> resultMap = this.getUploadInfo(file, uploadParams, docInfo, fsFile, resInfoList, authoritylist, indexList);
        if (resultMap.get("releaseSize") == null) {
            return resultMap;
        }
        this.uploadFile(file, docInfo, fsFile, resInfoList, authoritylist, indexList);
        return resultMap;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String upload(MultipartFile file, String fName) throws Exception {
        File tempFile = null;
        try {
            tempFile = new File(this.tempdir, fName);
            if (!tempFile.getParentFile().exists()) {
                tempFile.getParentFile().mkdirs();
            }
            this.transFile(file, tempFile);
            String filePath = "";
            filePath = this.fastdfsUsingFlag ? this.fastdfsService.uploadFile(tempFile) : tempFile.getAbsolutePath();
            String string = filePath;
            this.deleteFile(tempFile);
            return string;
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                throw new Exception("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\u3002");
            }
            catch (Throwable throwable) {
                this.deleteFile(tempFile);
                throw throwable;
            }
        }
    }

    @Override
    public void download(String docIds, String docName, HttpServletRequest request, HttpServletResponse response) throws IOException, ServiceException {
        this.fileDownNew(docIds, docName, request, response);
    }

    @Override
    public byte[] downloadYYZC(String docIds, String docName, HttpServletRequest request, HttpServletResponse response, String userId) throws IOException, ServiceException {
        return this.fileDownYYZC(docIds, docName, request, response, userId);
    }

    @Override
    public void downloadMobile(String docIds, String docName, HttpServletRequest request, HttpServletResponse response, String userId, String orgId) throws IOException, ServiceException {
        this.fileDownNewMobile(docIds, docName, request, response, userId, orgId);
    }

    @Override
    public Map<String, Object> checkDeptSpace(String fileSize) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        ShiroUser shiroUser = UserInfoUtil.getCurrentUser();
        Integer adminFlag = CommonUtil.getAdminFlag((List)shiroUser.getRolesList());
        if (adminFlag != 1) {
            String deptId = shiroUser.getDeptId();
            SysStru sysStru = (SysStru)this.sysStruMapper.selectById((Serializable)((Object)deptId));
            String orgId = sysStru.getOrganId();
            Double deptSpace = 0.0;
            deptSpace = this.docSpaceService.getDocSpaceByDeptId(orgId) == null ? Double.valueOf(50.0) : this.docSpaceService.getDocSpaceByDeptId(orgId).getSpaceSize();
            Double newSize = StringUtil.getDouble((Object)fileSize.substring(0, fileSize.length() - 2));
            Double emptySize = 0.0;
            double usedSpace = this.cacheToolService.getDeptUsedSpace(orgId);
            if (deptSpace == null) {
                deptSpace = 0.0;
            }
            if ((emptySize = Double.valueOf(deptSpace * 1024.0 * 1024.0 - usedSpace - newSize)) < 0.0) {
                resultMap.put("flag", false);
                resultMap.put("size", 0.0);
            } else {
                this.cacheToolService.updateDeptUsedSpace(orgId, newSize);
                resultMap.put("flag", true);
                resultMap.put("size", 0.0 - newSize);
            }
        } else {
            resultMap.put("flag", true);
            resultMap.put("size", 0.0);
        }
        return resultMap;
    }

    private Object fileDownNew(String docIds, String docName, HttpServletRequest request, HttpServletResponse response) throws IOException, ServiceException {
        List<String> docIdList = Arrays.asList(docIds.split(","));
        String userId = UserInfoUtil.getCurrentUser().getId();
        List<String> listGroup = this.docGroupService.getPremission(userId);
        List<DocInfo> docInfoList = this.docInfoService.getDocInfo(docIdList);
        FsFolderParams fsFolderParams = new FsFolderParams();
        fsFolderParams.setGroupList(listGroup);
        fsFolderParams.setUserId(userId);
        fsFolderParams.setType("2");
        String levelCode = this.businessService.getLevelCodeByUserUpload(fsFolderParams);
        String orgId = ShiroKit.getUser().getDeptName();
        List<Map> list = this.fsFileService.getInfo(docIdList, userId, listGroup, levelCode, orgId);
        if (!this.checkDownLoadAuthority(list, userId).booleanValue()) {
            return "error";
        }
        if (ToolUtil.isEmpty(docInfoList)) {
            return "error";
        }
        if (docInfoList.size() > 1) {
            this.downLoadZipFile(request, response, docInfoList);
        } else if (docInfoList.size() == 1) {
            this.downLoadFile(request, response, docInfoList.get(0));
        }
        ArrayList<DocResourceLog> docDownloadInfoList = new ArrayList<DocResourceLog>();
        if (docInfoList != null && docInfoList.size() > 0) {
            userId = UserInfoUtil.getUserInfo().get("ID").toString();
            Timestamp ts = new Timestamp(new Date().getTime());
            for (DocInfo docInfo : docInfoList) {
                docDownloadInfoList.add(this.generateDocResourceLog(docInfo.getDocId(), userId, ts, 4, "1"));
            }
            this.docInfoService.insertResourceLog(docDownloadInfoList);
            this.docInfoService.updateDownloadNum(docDownloadInfoList);
        }
        return "sunccess";
    }

    private byte[] fileDownYYZC(String docIds, String docName, HttpServletRequest request, HttpServletResponse response, String userId) throws IOException, ServiceException {
        List<String> docIdList = Arrays.asList(docIds.split(","));
        List<DocInfo> docInfoList = this.docInfoService.getDocInfo(docIdList);
        if (ToolUtil.isEmpty(docInfoList)) {
            return null;
        }
        byte[] bytes = null;
        bytes = this.downLoadFileYYZC(request, response, docInfoList.get(0));
        ArrayList<DocResourceLog> docDownloadInfoList = new ArrayList<DocResourceLog>();
        if (docInfoList != null && docInfoList.size() > 0) {
            Timestamp ts = new Timestamp(new Date().getTime());
            for (DocInfo docInfo : docInfoList) {
                docDownloadInfoList.add(this.generateDocResourceLog(docInfo.getDocId(), userId, ts, 4, "1"));
            }
            this.docInfoService.insertResourceLog(docDownloadInfoList);
            this.docInfoService.updateDownloadNum(docDownloadInfoList);
        }
        return bytes;
    }

    private Object fileDownNewMobile(String docIds, String docName, HttpServletRequest request, HttpServletResponse response, String userId, String orgId) throws IOException, ServiceException {
        List<String> docIdList = Arrays.asList(docIds.split(","));
        List<String> listGroup = this.docGroupService.getPremission(userId);
        List<DocInfo> docInfoList = this.docInfoService.getDocInfo(docIdList);
        FsFolderParams fsFolderParams = new FsFolderParams();
        fsFolderParams.setGroupList(listGroup);
        fsFolderParams.setUserId(userId);
        fsFolderParams.setType("2");
        String levelCode = this.businessService.getLevelCodeByUserUploadMobile(userId, fsFolderParams);
        List<Map> list = this.fsFileService.getInfo(docIdList, userId, listGroup, levelCode, orgId);
        if (ToolUtil.isEmpty(docInfoList)) {
            return "error";
        }
        this.downLoadFile(request, response, docInfoList.get(0));
        ArrayList<DocResourceLog> docDownloadInfoList = new ArrayList<DocResourceLog>();
        if (docInfoList != null && docInfoList.size() > 0) {
            Timestamp ts = new Timestamp(new Date().getTime());
            for (DocInfo docInfo : docInfoList) {
                docDownloadInfoList.add(this.generateDocResourceLog(docInfo.getDocId(), userId, ts, 4, "1"));
            }
            this.docInfoService.insertResourceLog(docDownloadInfoList);
            this.docInfoService.updateDownloadNum(docDownloadInfoList);
        }
        return "sunccess";
    }

    @Override
    public void uploadFile(MultipartFile file, DocInfo docInfo, FsFile fsFile, List<DocResourceLog> resInfoList, List<DocFileAuthority> list, List<String> indexList) throws Exception {
        String sourcePath = null;
        String targetPath = null;
        File tempFile = null;
        File pdfFile = null;
        File pdfTempFile = null;
        String fileId = docInfo.getFileId();
        String docId = docInfo.getDocId();
        try {
            tempFile = new File(this.tempdir, fileId);
            if (!tempFile.getParentFile().exists()) {
                tempFile.getParentFile().mkdirs();
            }
            this.transFile(file, tempFile);
            sourcePath = tempFile.getAbsolutePath();
            targetPath = tempFile.getParentFile() + File.separator + tempFile.getName().substring(0, tempFile.getName().lastIndexOf(".")) + ".pdf";
            Map<String, Object> pdfInfo = this.pdfService.changeToPdf(sourcePath, targetPath, file.getSize(), file.getContentType(), fileId);
            pdfTempFile = new File(targetPath);
            if (!pdfTempFile.getParentFile().exists()) {
                pdfTempFile.getParentFile().mkdirs();
            }
            String pdfPath = null;
            String markedpdfPath = String.valueOf(pdfInfo.get("markPdfPath"));
            String targetTempPath = String.valueOf(pdfInfo.get("targetPath"));
            String filePath = "";
            filePath = this.fastdfsUsingFlag ? this.fastdfsService.uploadFile(tempFile) : sourcePath;
            if (!StringUtil.checkIsEmpty((String)markedpdfPath)) {
                pdfFile = new File(markedpdfPath);
                if (!pdfFile.getParentFile().exists()) {
                    pdfFile.getParentFile().mkdirs();
                }
                pdfPath = this.fastdfsUsingFlag ? this.fastdfsService.uploadFile(pdfFile) : markedpdfPath;
            }
            fsFile.setFilePath(filePath);
            fsFile.setFilePdfPath(pdfPath);
            this.filesMapper.insert((Object)fsFile);
            docInfo.setFileId(docId);
            String content = StringUtil.getString((Object)pdfInfo.get("content"));
            this.docInfoMapper.insert(docInfo);
            if (list != null && list.size() > 0) {
                this.docFileAuthorityService.insertBatch(list);
            }
            this.docInfoService.insertResourceLog(resInfoList);
            DocES docEs = this.generateDocES(docInfo, pdfInfo, indexList);
            this.esService.createESIndex(docEs);
            this.deleteFile(tempFile);
            this.deleteFile(pdfTempFile);
            this.deleteFile(pdfFile);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                throw new Exception("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\u3002");
            }
            catch (Throwable throwable) {
                this.deleteFile(tempFile);
                this.deleteFile(pdfTempFile);
                this.deleteFile(pdfFile);
                throw throwable;
            }
        }
    }

    private Map<String, Object> getUploadInfo(MultipartFile file, DocUploadParams uploadParams, DocInfo docInfo, FsFile fsFile, List<DocResourceLog> resInfoList, List<DocFileAuthority> authoritylist, List<String> indexList) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        String fileId = file.getOriginalFilename();
        if (fileId.contains(DocConstant.SPECIALCHAR.DOUBLESLASH.getValue())) {
            fileId = fileId.substring(fileId.lastIndexOf(DocConstant.SPECIALCHAR.DOUBLESLASH.getValue()) + 1);
        }
        Map<String, String> docInfoMap = FileTool.fileUploadInfo(file, "", fileId);
        List dataList = (List)JSON.parseObject((String)uploadParams.getUploadData(), (TypeReference)new TypeReference<List<Map<String, Object>>>(){}, (Feature[])new Feature[0]);
        HashMap<String, Object> dataMap = new HashMap(16);
        for (int i = 0; i < dataList.size(); ++i) {
            Map map = (Map)dataList.get(i);
            if (!map.get("docName").toString().equals(docInfoMap.get("docName") + docInfoMap.get("type"))) continue;
            dataMap = (Map)dataList.get(i);
        }
        Map<String, Object> deptSpaceIsFreeMap = this.checkDeptSpace(StringUtil.getString(dataMap.get("size")));
        Boolean deptSpaceIsFree = StringUtil.getBoolean((Object)deptSpaceIsFreeMap.get("flag"));
        Double releaseSize = StringUtil.getDouble((Object)deptSpaceIsFreeMap.get("size"));
        if (!deptSpaceIsFree.booleanValue()) {
            resultMap.put("code", DocConstant.UPLOADRESULT.NOSPACE.getValue());
            return resultMap;
        }
        String userId = UserInfoUtil.getUserInfo().get("ID").toString();
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        String docId = uploadParams.getDocId();
        this.generateDocInfo(docId, userId, fileId, ts, dataMap, docInfoMap, uploadParams, docInfo);
        this.generateFsFile(docId, ts, dataMap, docInfoMap, fsFile);
        DocResourceLog docResourceLog = this.generateDocResourceLog(docId, userId, ts, 0, "1");
        resInfoList.add(docResourceLog);
        if (DocConstant.NUMBER.ZERO.getName().equals(uploadParams.getVisible())) {
            indexList.add("1");
        } else {
            this.generateAuthorityList(docId, authoritylist, indexList, uploadParams.getGroup(), 1);
            this.generateAuthorityList(docId, authoritylist, indexList, uploadParams.getPerson(), 0);
        }
        resultMap.put("releaseSize", releaseSize);
        return resultMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downLoadZipFile(HttpServletRequest request, HttpServletResponse response, List<DocInfo> docInfoList) throws IOException {
        String zipName = this.generateZipFileName();
        String zipDownloadPath = this.zipDownloadPath + File.separator + zipName;
        File zip = new File(zipDownloadPath);
        if (!zip.exists()) {
            if (!zip.getParentFile().exists()) {
                zip.getParentFile().mkdirs();
            }
            zip.createNewFile();
        }
        FileOutputStream fos = new FileOutputStream(zip);
        ZipOutputStream zos = new ZipOutputStream((OutputStream)fos);
        zos.setEncoding("GBK");
        for (int i = 0; i < docInfoList.size(); ++i) {
            boolean bl;
            List<FsFile> list;
            File tempFile;
            DocInfo docInfo = docInfoList.get(i);
            String fileType = docInfo.getDocType();
            String fileName = docInfo.getTitle() + fileType;
            if (!this.fastdfsUsingFlag) {
                tempFile = new File(docInfo.getFilePath());
                if (!tempFile.getParentFile().exists()) {
                    tempFile.getParentFile().mkdirs();
                }
                if ((list = this.fsFileMapper.getInfoByPath(docInfo.getFilePath())).size() != 0 && list.get(0).getSourceKey() != null) {
                    bl = FileEncryptUtil.getInstance().decrypt(tempFile.getAbsolutePath(), list.get(0).getSourceKey());
                }
                FileTool.zipFile(tempFile, zos, fileName);
                continue;
            }
            try {
                tempFile = new File(this.tempdir, fileName);
                if (!tempFile.getParentFile().exists()) {
                    tempFile.getParentFile().mkdirs();
                }
                if (!tempFile.exists()) {
                    this.fastdfsService.download(docInfo.getFilePath(), tempFile.getAbsolutePath());
                    list = this.fsFileMapper.getInfoByPath(docInfo.getFilePath());
                    if (list.size() != 0 && list.get(0).getSourceKey() != null) {
                        bl = FileEncryptUtil.getInstance().decrypt(tempFile.getAbsolutePath(), list.get(0).getSourceKey());
                    }
                }
                FileTool.zipFile(tempFile, zos, fileName);
                tempFile.delete();
                continue;
            }
            catch (ServiceException e) {
                e.printStackTrace();
            }
        }
        this.closeFileIO(zos);
        this.closeFileIO(fos);
        try {
            response.setContentType(request.getServletContext().getMimeType(zip.getName()));
            response.setHeader("Content-type", "application/octet-stream");
            response.setHeader("Content-Disposition", "attachment;fileName=" + URLEncoder.encode(zipName, "UTF-8"));
            response.getOutputStream().write(FileUtils.readFileToByteArray((File)zip));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            zip.delete();
        }
    }

    private byte[] downLoadFileYYZC(HttpServletRequest request, HttpServletResponse response, DocInfo docInfo) throws IOException, ServiceException {
        String filePath = docInfo.getFilePath();
        String fileName = docInfo.getTitle();
        String docType = docInfo.getDocType();
        FileInputStream input = null;
        try {
            byte[] bytes = this.fileTool.downLoadFile(input, filePath, null);
            String realName = "";
            String userAgent = request.getHeader("User-Agent");
            if (!StringUtil.checkIsEmpty((String)userAgent) && userAgent.toLowerCase().indexOf("firefox") > 0) {
                fileName = fileName + docType;
                byte[] sbytes = userAgent.contains("MSIE") ? fileName.getBytes() : fileName.getBytes("UTF-8");
                realName = new String(sbytes, "ISO-8859-1");
            } else {
                realName = StringUtil.transferSpecialChar((String)URLEncoder.encode(fileName + docType, "UTF-8"));
            }
            response.setContentType(request.getServletContext().getMimeType(realName));
            response.setHeader("Content-type", "application/octet-stream");
            response.setHeader("Content-Length", String.valueOf(bytes.length));
            response.setHeader("Content-Disposition", String.format("attachment; filename=\"%s\"", realName));
            response.getOutputStream().write(bytes);
            byte[] byArray = bytes;
            return byArray;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IOException("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25IO");
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                } else {
                    response.getOutputStream().flush();
                    response.getOutputStream().close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void downLoadFile(HttpServletRequest request, HttpServletResponse response, DocInfo docInfo) throws IOException, ServiceException {
        String filePath = docInfo.getFilePath();
        String fileName = docInfo.getTitle();
        String docType = docInfo.getDocType();
        FileInputStream input = null;
        try {
            byte[] bytes = this.fileTool.downLoadFile(input, filePath, null);
            String realName = "";
            String userAgent = request.getHeader("User-Agent");
            if (!StringUtil.checkIsEmpty((String)userAgent) && userAgent.toLowerCase().indexOf("firefox") > 0) {
                fileName = fileName + docType;
                byte[] sbytes = userAgent.contains("MSIE") ? fileName.getBytes() : fileName.getBytes("UTF-8");
                realName = new String(sbytes, "ISO-8859-1");
            } else {
                realName = StringUtil.transferSpecialChar((String)URLEncoder.encode(fileName + docType, "UTF-8"));
            }
            response.setContentType(request.getServletContext().getMimeType(realName));
            response.setHeader("Content-type", "application/octet-stream");
            response.setHeader("Content-Length", String.valueOf(bytes.length));
            response.setHeader("Content-Disposition", String.format("attachment; filename=\"%s\"", realName));
            response.getOutputStream().write(bytes);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IOException("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25IO");
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                } else {
                    response.getOutputStream().flush();
                    response.getOutputStream().close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private File transFile(MultipartFile fromFile, File toFile) throws IllegalStateException, IOException {
        if (!toFile.getParentFile().exists()) {
            toFile.getParentFile().mkdirs();
        }
        fromFile.transferTo(toFile);
        return toFile;
    }

    private void deleteFile(File file) {
        if (file == null) {
            return;
        }
        if (this.fastdfsUsingFlag) {
            try {
                file.delete();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private DocFileAuthority createFileAuthority(String docId, String authorId, Integer type) {
        DocFileAuthority docFileAuthority = new DocFileAuthority();
        docFileAuthority.setFileAuthorityId(StringUtil.getUUID());
        docFileAuthority.setAuthorId(authorId);
        docFileAuthority.setAuthorType(type);
        docFileAuthority.setFileId(docId);
        return docFileAuthority;
    }

    private void generateAuthorityList(String docId, List<DocFileAuthority> authoritylist, List<String> indexList, String authorityStr, Integer type) {
        if (!StringUtil.checkIsEmpty((String)authorityStr)) {
            String[] authorityArr;
            for (String authorId : authorityArr = authorityStr.split(",")) {
                authoritylist.add(this.createFileAuthority(docId, authorId, type));
                indexList.add(authorId);
            }
        }
    }

    private void generateDocInfo(String docId, String userId, String fileId, Timestamp ts, Map<String, Object> dataMap, Map<String, String> docInfoMap, DocUploadParams uploadParams, DocInfo docInfo) {
        docInfo.setDocId(docId);
        docInfo.setFileId(fileId);
        docInfo.setUserId(userId);
        docInfo.setAuthorId(dataMap.get("authorId").toString());
        docInfo.setContactsId(dataMap.get("contactsId").toString());
        docInfo.setCreateTime(ts);
        docInfo.setFoldId(uploadParams.getFoldId());
        docInfo.setDocAbstract(dataMap.get("brief").toString());
        docInfo.setDocType(docInfoMap.get("type"));
        docInfo.setTitle(dataMap.get("title").toString());
        docInfo.setReadNum(0);
        docInfo.setDownloadNum(0);
        docInfo.setValidFlag(uploadParams.getVisible());
        docInfo.setAuthority(uploadParams.getDownloadAble());
        docInfo.setVisibleRange(Integer.parseInt(uploadParams.getVisible()));
        docInfo.setWatermarkUser(uploadParams.getWatermarkUser());
        docInfo.setWatermarkCompany(uploadParams.getWatermarkCompany());
        docInfo.setValidFlag("1");
    }

    private void generateFsFile(String docId, Timestamp ts, Map<String, Object> dataMap, Map<String, String> docInfoMap, FsFile fsFile) {
        fsFile.setCreateTime(ts);
        fsFile.setFileIcon("");
        fsFile.setFileId(docId);
        fsFile.setFileName(dataMap.get("title").toString());
        fsFile.setFileSize(dataMap.get("size").toString());
        fsFile.setFileType(docInfoMap.get("type"));
    }

    private DocResourceLog generateDocResourceLog(String docId, String userId, Timestamp ts, Integer operateType, String validFlag) {
        DocResourceLog docResourceLog = new DocResourceLog();
        docResourceLog.setId(StringUtil.getUUID());
        docResourceLog.setResourceId(docId);
        docResourceLog.setOperateTime(ts);
        docResourceLog.setResourceType(0);
        docResourceLog.setUserId(userId);
        docResourceLog.setOperateType(operateType);
        docResourceLog.setValidFlag(validFlag);
        return docResourceLog;
    }

    private DocES generateDocES(DocInfo docInfo, Map<String, Object> pdfInfo, List<String> indexList) {
        DocES docES = new DocES();
        docES.setId(docInfo.getDocId());
        docES.setTitle(docInfo.getTitle());
        docES.setRecycle("1");
        docES.setContentType(StringUtil.getString((Object)pdfInfo.get("contentType")));
        docES.setUpDate(new Date());
        docES.setContent(StringUtil.getString((Object)pdfInfo.get("content")));
        return docES;
    }

    private Boolean checkDownLoadAuthority(List<Map> docfileIdList, String userId) {
        Integer adminFlag = CommonUtil.getAdminFlag();
        if (adminFlag == DocConstant.ADMINFLAG.WKADMIN.getValue()) {
            return true;
        }
        boolean authorityAble = true;
        for (Map map : docfileIdList) {
            String folderId = (String)map.get("folderId");
            FsFolder ff = (FsFolder)((Object)this.iFsFolderService.selectById((Serializable)((Object)folderId)));
            if (ff.getCreateUserId().equals(userId)) {
                authorityAble = true;
                break;
            }
            if (map.get("authority") == null) {
                authorityAble = false;
                break;
            }
            if (!map.get("authority").equals("0")) continue;
            authorityAble = false;
            break;
        }
        return authorityAble;
    }

    private String generateZipFileName() {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
        return df.format(new Date()) + StringUtil.getString((Object)Math.round(Math.random() * 100.0)) + ".zip";
    }

    private void closeFileIO(Object io) {
        if (io == null) {
            return;
        }
        if (io instanceof ZipOutputStream) {
            try {
                ((ZipOutputStream)io).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (io instanceof FileOutputStream) {
            try {
                ((FileOutputStream)io).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void uploadFile(File file, DocInfo docInfo, FsFile fsFile, List<DocResourceLog> resInfoList, List<DocFileAuthority> list, List<String> indexList, String contentType) throws Exception {
        String sourcePath = null;
        String pdfFilePath = null;
        File pdfFile = null;
        String pdfPath = null;
        File newFile = null;
        String thumbNewPath = null;
        File newThumb = null;
        String thumbNewPathFast = null;
        boolean isCreateThumb = false;
        String docId = docInfo.getDocId();
        boolean isImg = false;
        try {
            HashMap<String, String> map;
            sourcePath = file.getAbsolutePath().replace("\\", "/");
            pdfFilePath = this.pdfFileDir + File.separator + file.getName().substring(0, file.getName().lastIndexOf(".")) + ".pdf";
            if (contentType != null && contentType.contains("image")) {
                isImg = true;
                pdfFilePath = this.pdfFileDir + File.separator + file.getName().substring(0, file.getName().lastIndexOf(".")) + "_Thumbnails.jpg";
                this.createThumbnails(sourcePath, pdfFilePath);
                thumbNewPath = this.ThumbnailsDir + File.separator + file.getName().substring(0, file.getName().lastIndexOf(".")) + "_Thumbnails_level_2.jpg";
                isCreateThumb = ThumbnailsUtil.createThumbnails((String)sourcePath, (String)thumbNewPath, (double)1080.0, (double)857.0);
                if (!StringUtil.checkIsEmpty((String)pdfFilePath)) {
                    String size;
                    Map newThumbInfo;
                    pdfFile = new File(pdfFilePath);
                    if (!pdfFile.getParentFile().exists()) {
                        pdfFile.getParentFile().mkdirs();
                    }
                    logger.info("******************\u56fe\u7247\u6587\u4ef6:" + pdfFile.getName() + "\u521b\u5efa\u6210\u529f\uff0c\u8def\u5f84\u4e3a" + pdfFile.getPath() + ",\u5927\u5c0f\u4e3a" + pdfFile.length() + "******************");
                    newThumb = new File(thumbNewPath);
                    if (!newThumb.getParentFile().exists()) {
                        newThumb.getParentFile().mkdirs();
                    }
                    logger.info("******************\u56fe\u7247\u7f29\u7565\u56fe\u6587\u4ef6:" + newThumb.getName() + "\u521b\u5efa\u6210\u529f\uff0c\u8def\u5f84\u4e3a" + newThumb.getPath() + ",\u5927\u5c0f\u4e3a" + newThumb.length() + "******************");
                    HashMap<String, String> map2 = new HashMap<String, String>();
                    map2.put("sourceId", StringUtil.getUUID());
                    map2.put("sourceLevel", "2");
                    map2.put("fileId", docId);
                    if (isCreateThumb) {
                        newThumbInfo = ThumbnailsUtil.getHeightAndWidth((String)thumbNewPath);
                        size = ThumbnailsUtil.pathSize((String)thumbNewPath);
                        map2.put("sourceSize", size);
                        map2.putAll(newThumbInfo);
                    } else {
                        newThumbInfo = ThumbnailsUtil.getHeightAndWidth((String)sourcePath);
                        size = ThumbnailsUtil.pathSize((String)sourcePath);
                        map2.put("sourceSize", size);
                        map2.putAll(newThumbInfo);
                    }
                    if (this.fastdfsUsingFlag) {
                        String pdfFileKeyStr = this.pdfFileByKey + pdfFile.getName();
                        File pdfFileKey = new File(pdfFileKeyStr);
                        if (!pdfFileKey.getParentFile().exists()) {
                            pdfFileKey.getParentFile().mkdirs();
                        }
                        String pdfKey = FileEncryptUtil.getInstance().encrypt(pdfFile, pdfFileKey);
                        fsFile.setPdfKey(pdfKey);
                        pdfPath = this.fastdfsService.uploadFile(pdfFileKey);
                        logger.info("******************\u52a0\u5bc6\u56fe\u7247\u6587\u4ef6:" + pdfFileKey.getName() + "\u521b\u5efa\u6210\u529f\uff0c\u8def\u5f84\u4e3a" + pdfFileKey.getPath() + ",\u5927\u5c0f\u4e3a" + pdfFileKey.length() + ",\u5e76\u4e0a\u4f20\u5230fast\uff0cfast\u8fd4\u56de\u5730\u5740\u4e3a" + pdfPath + "******************");
                        if (this.fastdfsUsingFlag) {
                            pdfFileKey.delete();
                            pdfFile.delete();
                        }
                        if (isCreateThumb) {
                            String newThumbKeyStr = this.pdfFileByKey + newThumb.getName();
                            File newThumbKeyFile = new File(pdfFileKeyStr);
                            if (!newThumbKeyFile.getParentFile().exists()) {
                                newThumbKeyFile.getParentFile().mkdirs();
                            }
                            String newThumbKey = FileEncryptUtil.getInstance().encrypt(newThumb, newThumbKeyFile);
                            thumbNewPathFast = this.fastdfsService.uploadFile(newThumb);
                            map2.put("sourceKey", newThumbKey);
                            map2.put("sourcePath", thumbNewPathFast);
                            logger.info("******************\u52a0\u5bc6\u7f29\u7565\u56fe\u6587\u4ef6:" + newThumbKeyFile.getName() + "\u521b\u5efa\u6210\u529f\uff0c\u8def\u5f84\u4e3a" + newThumbKeyFile.getPath() + ",\u5927\u5c0f\u4e3a" + newThumbKeyFile.length() + ",\u5e76\u4e0a\u4f20\u5230fast\uff0cfast\u8fd4\u56de\u5730\u5740\u4e3a" + thumbNewPathFast + "******************");
                        }
                    } else {
                        pdfPath = pdfFilePath;
                        if (isCreateThumb) {
                            map2.put("sourceKey", null);
                            map2.put("sourcePath", thumbNewPath.replace("\\", "/"));
                        } else {
                            map2.put("sourceKey", null);
                            map2.put("sourcePath", sourcePath.replace("\\", "/"));
                        }
                    }
                    this.frontDocInfoMapper.setNewThumbInfo(map2);
                }
            }
            String filePath = "";
            String newFilePath = this.fileByKey + File.separator + file.getName().substring(0, file.getName().lastIndexOf(".")) + "_new" + file.getName().substring(file.getName().indexOf("."), file.getName().length());
            newFile = new File(newFilePath);
            if (!newFile.getParentFile().exists()) {
                newFile.getParentFile().mkdirs();
            }
            if (this.fastdfsUsingFlag) {
                String sourceKey = FileEncryptUtil.getInstance().encrypt(file, newFile);
                fsFile.setSourceKey(sourceKey);
                filePath = this.fastdfsService.uploadFile(newFile);
                logger.info("******************\u52a0\u5bc6\u6587\u4ef6:" + newFile.getName() + "\u521b\u5efa\u6210\u529f\uff0c\u8def\u5f84\u4e3a" + newFile.getPath() + ",\u5927\u5c0f\u4e3a" + newFile.length() + ",\u5e76\u4e0a\u4f20\u5230fast\uff0cfast\u8fd4\u56de\u5730\u5740\u4e3a" + filePath + "******************");
                if (!isCreateThumb) {
                    HashMap<String, String> map3 = new HashMap<String, String>();
                    map3.put("fileId", docId);
                    map3.put("sourceKey", sourceKey);
                    map3.put("sourcePath", filePath);
                    this.frontDocInfoMapper.updateNewThumbInfo(map3);
                }
            } else if (contentType != null) {
                if (contentType.contains("image")) {
                    map = new HashMap();
                    map.put("fileId", docId);
                    filePath = sourcePath;
                    this.frontDocInfoMapper.updateNewThumbInfo(map);
                } else if (contentType.contains("video")) {
                    map = new HashMap();
                    map.put("fileId", docId);
                    filePath = sourcePath;
                    this.frontDocInfoMapper.updateNewThumbInfo(map);
                } else {
                    filePath = sourcePath;
                    map = new HashMap();
                    map.put("fileId", docId);
                    map.put("sourceKey", null);
                    map.put("sourcePath", filePath);
                    this.frontDocInfoMapper.updateNewThumbInfo(map);
                }
            } else {
                filePath = sourcePath;
                map = new HashMap<String, String>();
                map.put("fileId", docId);
                map.put("sourceKey", null);
                map.put("sourcePath", filePath);
                this.frontDocInfoMapper.updateNewThumbInfo(map);
            }
            if (contentType == null || contentType.contains("application/pdf") || contentType.contains("audio") || contentType.contains("video")) {
                pdfPath = filePath;
            }
            fsFile.setFilePath(filePath.replace("\\", "/"));
            if (null != pdfPath) {
                fsFile.setFilePdfPath(pdfPath.replace("\\", "/"));
            }
            this.filesMapper.insert((Object)fsFile);
            docInfo.setFileId(docId);
            this.docInfoMapper.insert(docInfo);
            if (list != null && list.size() > 0) {
                this.docFileAuthorityService.insertBatch(list);
            }
            this.docInfoService.insertResourceLog(resInfoList);
            logger.info("******************\u6587\u4ef6:" + docInfo.getTitle() + "\u5f00\u59cb\u751f\u6210es\u7d22\u5f15******************");
            DocES docVO = new DocES();
            if (this.fastdfsUsingFlag) {
                newFile.delete();
            }
            if (isImg) {
                docVO.setContentType(contentType);
            }
            docVO.setId(docId);
            docVO.setTitle(docInfo.getTitle());
            FsFolder fsFolder = new FsFolder();
            if (docInfo.getFoldId() != null) {
                fsFolder = (FsFolder)((Object)this.iFsFolderService.selectById((Serializable)((Object)docInfo.getFoldId())));
            }
            if (fsFolder != null) {
                docVO.setCategory(fsFolder.getFolderName());
            }
            if (docInfo.getTags() != null && !"".equals(docInfo.getTags())) {
                docVO.setTags(docInfo.getTags());
            }
            docVO.setRecycle("1");
            docVO.setUpDate(new Date());
            docVO.setPermission(indexList.toArray(new String[indexList.size()]));
            this.esService.createESIndex(docVO);
            logger.info("******************\u6587\u4ef6:" + docInfo.getTitle() + "\u751f\u6210es\u7d22\u5f15\u7ed3\u675f******************");
            logger.info("******************\u6587\u4ef6:" + docInfo.getTitle() + "\u5f00\u59cb\u5b58\u50a8\u4e0a\u4f20\u72b6\u6001******************");
            HashMap<String, String> toPdf = new HashMap<String, String>();
            toPdf.put("docId", docId);
            toPdf.put("sourcePath", sourcePath);
            toPdf.put("contentType", contentType);
            toPdf.put("state", "1");
            String address = InetAddress.getLocalHost().toString().replace(".", "");
            toPdf.put("address", address);
            this.cacheToolService.setUploadState(toPdf);
            this.cacheToolService.setReadyToChangePdf(toPdf, address);
            this.uploadService.newUploadState(toPdf);
            logger.info("******************\u6587\u4ef6:" + docInfo.getTitle() + "\u5b58\u50a8\u4e0a\u4f20\u72b6\u6001\u7ed3\u675f\uff0c\u6b64\u6d41\u7a0b\u7ed3\u675f******************");
            threadPoolExecutor.execute((Runnable)new ChangeToPdfThread(docId));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\u3002");
        }
        finally {
            if (this.fastdfsUsingFlag && pdfFile != null && pdfFile.exists()) {
                pdfFile.delete();
            }
        }
    }

    @Override
    public String uploadFastJqx(String categoryId, String downloadAble, String visible, String group, String person, String watermarkUser, String md5, String fileName, FsFile fsFile, String size, String shareFlag, String userId, String topicId) {
        String[] operateTypeStrGroup;
        String[] authorTypeStrGroup;
        String[] groupArr;
        DocFileAuthority docFileAuthority;
        int pointIndex = fileName.lastIndexOf(".");
        String suffix = fileName.substring(pointIndex).toLowerCase();
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        DocInfo docInfo = new DocInfo();
        String docId = UUID.randomUUID().toString().replace("-", "");
        docInfo.setDocId(docId);
        docInfo.setFileId(docId);
        docInfo.setUserId(userId);
        docInfo.setAuthorId(userId);
        docInfo.setContactsId(userId);
        docInfo.setCreateTime(ts);
        docInfo.setFoldId(categoryId);
        docInfo.setDocType(suffix);
        docInfo.setTitle(fileName.substring(0, fileName.lastIndexOf(".")));
        docInfo.setReadNum(0);
        docInfo.setDownloadNum(0);
        docInfo.setValidFlag("1");
        docInfo.setAuthority(downloadAble);
        docInfo.setVisibleRange(Integer.parseInt(visible));
        docInfo.setWatermarkUser(watermarkUser);
        docInfo.setSetAuthority("0");
        docInfo.setValidFlag("1");
        docInfo.setShareFlag(shareFlag);
        FsFile fileModel = new FsFile();
        fileModel.setCreateTime(ts);
        fileModel.setFileIcon("");
        fileModel.setFileId(docId);
        fileModel.setMd5(md5);
        fileModel.setFileName(fileName.substring(0, fileName.lastIndexOf(".")));
        fileModel.setFileSize(size);
        fileModel.setFileType(suffix);
        ArrayList<DocResourceLog> resInfoList = new ArrayList<DocResourceLog>();
        DocResourceLog docResourceLog = new DocResourceLog();
        String id = UUID.randomUUID().toString().replace("-", "");
        docResourceLog.setId(id);
        docResourceLog.setResourceId(docId);
        docResourceLog.setOperateTime(ts);
        docResourceLog.setResourceType(0);
        docResourceLog.setUserId(userId);
        docResourceLog.setOperateType(0);
        docResourceLog.setValidFlag("1");
        resInfoList.add(docResourceLog);
        ArrayList<DocFileAuthority> list = new ArrayList<DocFileAuthority>();
        ArrayList<String> indexList = new ArrayList<String>();
        if ("555dd41471c2461aa3391af9e8282fc1".equals(categoryId) || "1a5168f3a50f4f32b57bf454c5895457".equals(categoryId) || "2d8ed2e02fc34be2a587f7e68a848e91".equals(categoryId) || "339d8cd61b3746e1839ebf725aacb824".equals(categoryId) || "5e5d93580f3a443eb3057627be68ffa6".equals(categoryId) || "5f7bf94d27224db7a41e6c694def6e46".equals(categoryId) || "784ba4775a734014a8f251783606f23d".equals(categoryId) || "795aa5765d9d49e4805a88ac7fefbc8d".equals(categoryId) || "831f8b19eee44ad094ae21d7a7242578".equals(categoryId) || "85eb0d9b8b1a428f847e7f5bc8ff43b9".equals(categoryId) || "9670e7b36ce549ffa074f6592bbda284".equals(categoryId) || "a18c3d4a7fbe4de5868bb6b45eaad1e2".equals(categoryId) || "a63df52c36584f8c9378ebc801499977".equals(categoryId) || "bbb99e2f9a15474cbdcaba2d8da63db9".equals(categoryId) || "c4960ef211d745a497a31e7e9e2c3db0".equals(categoryId) || "add316b125a84d519578694955a5af36".equals(categoryId) || "caf4bd7d5f3e42a9aff6beae6154576f".equals(categoryId) || "e4daf328be6648f99281fb33b282bf62".equals(categoryId) || "645e6a2e155740949cdb81df3fa350b1".equals(categoryId) || "8c56ad616c674d7eba191e79f0cda882".equals(categoryId)) {
            docFileAuthority = new DocFileAuthority();
            docFileAuthority.setFileAuthorityId(UUID.randomUUID().toString().replaceAll("-", ""));
            docFileAuthority.setAuthorId("allpersonflag");
            docFileAuthority.setAuthorType(3);
            docFileAuthority.setFileId(docId);
            docFileAuthority.setAuthority(1);
            list.add(docFileAuthority);
            indexList.add("allpersonflag");
            indexList.add(userId);
        } else if ("6b46e675e46a4a69a9c2fc93af143aae".equals(categoryId)) {
            groupArr = "6091a4f767e24ba29f87719bd1b2cef8,allpersonflag,2817292a04944e3c96a800c7ad2c3857,6a7206343e4246f9b21db680dbcf1516,337babeee7a8453290146c0ce8a96478".split(",");
            authorTypeStrGroup = "1,3,1,1,1".split(",");
            operateTypeStrGroup = "1,0,1,1,1".split(",");
            for (int i = 0; i < groupArr.length; ++i) {
                DocFileAuthority docFileAuthority2 = new DocFileAuthority();
                docFileAuthority2.setFileAuthorityId(UUID.randomUUID().toString().replaceAll("-", ""));
                docFileAuthority2.setAuthorId(groupArr[i]);
                docFileAuthority2.setAuthorType(StringUtil.getInteger((Object)authorTypeStrGroup[i]));
                docFileAuthority2.setFileId(docId);
                docFileAuthority2.setAuthority(StringUtil.getInteger((Object)operateTypeStrGroup[i]));
                list.add(docFileAuthority2);
                indexList.add(groupArr[i]);
            }
            indexList.add(userId);
        } else if ("0404".equals(categoryId)) {
            groupArr = "8d6e50d29336428f8964c42248510c6d,6091a4f767e24ba29f87719bd1b2cef8,6a7206343e4246f9b21db680dbcf1516,52ed3715582245a48ad633052ce289d3,30e66bdf2a66453cba0d38e5e7af4ae7".split(",");
            authorTypeStrGroup = "1,1,1,1,1".split(",");
            operateTypeStrGroup = "0,0,0,0,0".split(",");
            for (int i = 0; i < groupArr.length; ++i) {
                DocFileAuthority docFileAuthority3 = new DocFileAuthority();
                docFileAuthority3.setFileAuthorityId(UUID.randomUUID().toString().replaceAll("-", ""));
                docFileAuthority3.setAuthorId(groupArr[i]);
                docFileAuthority3.setAuthorType(StringUtil.getInteger((Object)authorTypeStrGroup[i]));
                docFileAuthority3.setFileId(docId);
                docFileAuthority3.setAuthority(StringUtil.getInteger((Object)operateTypeStrGroup[i]));
                list.add(docFileAuthority3);
                indexList.add(groupArr[i]);
            }
            indexList.add(userId);
        } else if ("0101".equals(categoryId)) {
            docFileAuthority = new DocFileAuthority();
            docFileAuthority.setFileAuthorityId(UUID.randomUUID().toString().replaceAll("-", ""));
            docFileAuthority.setAuthorId("allpersonflag");
            docFileAuthority.setAuthorType(3);
            docFileAuthority.setFileId(docId);
            docFileAuthority.setAuthority(0);
            list.add(docFileAuthority);
            indexList.add("allpersonflag");
            indexList.add(userId);
        } else if ("0403".equals(categoryId)) {
            docFileAuthority = new DocFileAuthority();
            docFileAuthority.setFileAuthorityId(UUID.randomUUID().toString().replaceAll("-", ""));
            docFileAuthority.setAuthorId("allpersonflag");
            docFileAuthority.setAuthorType(3);
            docFileAuthority.setFileId(docId);
            docFileAuthority.setAuthority(0);
            list.add(docFileAuthority);
            indexList.add("allpersonflag");
            indexList.add(userId);
        } else if ("508bf3dd2d4b408684313051a487fdcd".equals(categoryId)) {
            docFileAuthority = new DocFileAuthority();
            docFileAuthority.setFileAuthorityId(UUID.randomUUID().toString().replaceAll("-", ""));
            docFileAuthority.setAuthorId("allpersonflag");
            docFileAuthority.setAuthorType(3);
            docFileAuthority.setFileId(docId);
            docFileAuthority.setAuthority(0);
            list.add(docFileAuthority);
            indexList.add("allpersonflag");
            indexList.add(userId);
        } else if ("0304".equals(categoryId)) {
            String[] personArr = "\u516c\u53f8\u9886\u5bfc".split(",");
            String[] personOrganArr = "5A154DE6E1F94FBA9D7C48A11EF7F1C6".split(",");
            String[] authorTypeStrPerson = "2".split(",");
            String[] operateTypeStrPerson = "0".split(",");
            for (int i = 0; i < personArr.length; ++i) {
                DocFileAuthority docFileAuthority4 = new DocFileAuthority();
                docFileAuthority4.setFileAuthorityId(UUID.randomUUID().toString().replaceAll("-", ""));
                docFileAuthority4.setAuthorId(personArr[i]);
                docFileAuthority4.setAuthorType(StringUtil.getInteger((Object)authorTypeStrPerson[i]));
                docFileAuthority4.setFileId(docId);
                docFileAuthority4.setAuthority(Integer.parseInt(operateTypeStrPerson[i]));
                docFileAuthority4.setOrganId(personOrganArr[i]);
                list.add(docFileAuthority4);
                if (StringUtil.getInteger((Object)authorTypeStrPerson[i]) == 0) {
                    indexList.add(personArr[i]);
                }
                if (StringUtil.getInteger((Object)authorTypeStrPerson[i]) != 2) continue;
                indexList.add(personOrganArr[i]);
            }
        } else if ("900f060aa5ad49e981da10f5d619ec2a".equals(categoryId)) {
            docFileAuthority = new DocFileAuthority();
            docFileAuthority.setFileAuthorityId(UUID.randomUUID().toString().replaceAll("-", ""));
            docFileAuthority.setAuthorId("allpersonflag");
            docFileAuthority.setAuthorType(3);
            docFileAuthority.setFileId(docId);
            docFileAuthority.setAuthority(1);
            list.add(docFileAuthority);
            indexList.add("allpersonflag");
            indexList.add(userId);
        } else if ("1085dd96c43f4036b0654b66e9f163af".equals(categoryId)) {
            groupArr = "6a7206343e4246f9b21db680dbcf1516,30e66bdf2a66453cba0d38e5e7af4ae7".split(",");
            authorTypeStrGroup = "1,1".split(",");
            operateTypeStrGroup = "1,1".split(",");
            for (int i = 0; i < groupArr.length; ++i) {
                DocFileAuthority docFileAuthority5 = new DocFileAuthority();
                docFileAuthority5.setFileAuthorityId(UUID.randomUUID().toString().replaceAll("-", ""));
                docFileAuthority5.setAuthorId(groupArr[i]);
                docFileAuthority5.setAuthorType(StringUtil.getInteger((Object)authorTypeStrGroup[i]));
                docFileAuthority5.setFileId(docId);
                docFileAuthority5.setAuthority(StringUtil.getInteger((Object)operateTypeStrGroup[i]));
                list.add(docFileAuthority5);
                indexList.add(groupArr[i]);
            }
            indexList.add(userId);
        } else if ("8bea2cb2184c44c4a296710bad0d9673".equals(categoryId)) {
            indexList.add(userId);
        } else if ("0521e2de1a93438d9fa5ecd512fc0105".equals(categoryId)) {
            docFileAuthority = new DocFileAuthority();
            docFileAuthority.setFileAuthorityId(UUID.randomUUID().toString().replaceAll("-", ""));
            docFileAuthority.setAuthorId("allpersonflag");
            docFileAuthority.setAuthorType(3);
            docFileAuthority.setFileId(docId);
            docFileAuthority.setAuthority(1);
            list.add(docFileAuthority);
            indexList.add("allpersonflag");
            indexList.add(userId);
        } else if ("5c8cee3afd0f47aba7ed4893d6ed9e66".equals(categoryId)) {
            docFileAuthority = new DocFileAuthority();
            docFileAuthority.setFileAuthorityId(UUID.randomUUID().toString().replaceAll("-", ""));
            docFileAuthority.setAuthorId("allpersonflag");
            docFileAuthority.setAuthorType(3);
            docFileAuthority.setFileId(docId);
            docFileAuthority.setAuthority(1);
            list.add(docFileAuthority);
            indexList.add("allpersonflag");
            indexList.add(userId);
        } else if ("0504".equals(categoryId) || "050402".equals(categoryId) || "050403".equals(categoryId) || "7d9f267b319741ca90844efc7108db87".equals(categoryId)) {
            docFileAuthority = new DocFileAuthority();
            docFileAuthority.setFileAuthorityId(UUID.randomUUID().toString().replaceAll("-", ""));
            docFileAuthority.setAuthorId("allpersonflag");
            docFileAuthority.setAuthorType(3);
            docFileAuthority.setFileId(docId);
            docFileAuthority.setAuthority(1);
            list.add(docFileAuthority);
            indexList.add("allpersonflag");
            indexList.add(userId);
        } else {
            docFileAuthority = new DocFileAuthority();
            docFileAuthority.setFileAuthorityId(UUID.randomUUID().toString().replaceAll("-", ""));
            docFileAuthority.setAuthorId("allpersonflag");
            docFileAuthority.setAuthorType(3);
            docFileAuthority.setFileId(docId);
            docFileAuthority.setAuthority(0);
            list.add(docFileAuthority);
            indexList.add("allpersonflag");
            indexList.add(userId);
        }
        fileModel.setFilePath(fsFile.getFilePath());
        fileModel.setFilePdfPath(fsFile.getFilePdfPath());
        fileModel.setPdfKey(fsFile.getPdfKey());
        fileModel.setSourceKey(fsFile.getSourceKey());
        TopicFile topicFile = new TopicFile();
        topicFile.setTopicFileId(UUID.randomUUID().toString().replaceAll("-", ""));
        topicFile.setDocId(docId);
        topicFile.setSpecialTopicId(topicId);
        String currentCode = this.sysIdtableService.getCurrentCode("TOPIC_FILE_NUM", "doc_special_topic_files");
        int bigNum = Integer.parseInt(currentCode);
        topicFile.setShowOrder(bigNum);
        ArrayList<TopicFile> topicList = new ArrayList<TopicFile>();
        topicList.add(topicFile);
        if (topicList != null && topicList.size() > 0) {
            this.iTopicDocManagerService.saveTopicDoc(topicId, topicList);
        }
        this.filesMapper.insert((Object)fileModel);
        this.docInfoMapper.insert(docInfo);
        if (list != null && list.size() > 0) {
            this.docFileAuthorityService.insertBatch(list);
        }
        this.docInfoService.insertResourceLog(resInfoList);
        int state = this.esService.copyIndex(fsFile.getFileId(), docId);
        if (state == -1) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("permission", indexList.toArray(new String[indexList.size()]));
        map.put("tags", "");
        FsFolder fsFolder = new FsFolder();
        if (docInfo.getFoldId() != null) {
            fsFolder = (FsFolder)((Object)this.iFsFolderService.selectById((Serializable)((Object)docInfo.getFoldId())));
        }
        if (".png".equals(suffix) || ".jpg".equals(suffix) || ".gif".equals(suffix) || ".bmp".equals(suffix) || ".jpeg".equals(suffix)) {
            this.frontDocInfoMapper.insertThumbInfoFast(StringUtil.getUUID(), docId, md5);
        }
        map.put("category", fsFolder.getFolderName());
        this.esUtil.updateIndex(docId, map);
        return docId;
    }

    @Override
    public String uploadFastYYZC(String categoryId, String downloadAble, String visible, String group, String person, String watermarkUser, String md5, String fileName, FsFile fsFile, String size, String shareFlag, String userId, String tags) {
        int pointIndex = fileName.lastIndexOf(".");
        String suffix = fileName.substring(pointIndex).toLowerCase();
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        DocInfo docInfo = new DocInfo();
        String docId = UUID.randomUUID().toString().replace("-", "");
        docInfo.setDocId(docId);
        docInfo.setFileId(docId);
        docInfo.setUserId(userId);
        docInfo.setAuthorId(userId);
        docInfo.setContactsId(userId);
        docInfo.setCreateTime(ts);
        docInfo.setFoldId(categoryId);
        docInfo.setDocType(suffix);
        docInfo.setTitle(fileName.substring(0, fileName.lastIndexOf(".")));
        docInfo.setReadNum(0);
        if (tags != null) {
            docInfo.setTags(tags);
        }
        docInfo.setDownloadNum(0);
        docInfo.setValidFlag("1");
        docInfo.setAuthority(downloadAble);
        docInfo.setVisibleRange(Integer.parseInt(visible));
        docInfo.setWatermarkUser(watermarkUser);
        docInfo.setSetAuthority("0");
        docInfo.setValidFlag("1");
        docInfo.setShareFlag(shareFlag);
        FsFile fileModel = new FsFile();
        fileModel.setCreateTime(ts);
        fileModel.setFileIcon("");
        fileModel.setFileId(docId);
        fileModel.setMd5(md5);
        fileModel.setFileName(fileName.substring(0, fileName.lastIndexOf(".")));
        fileModel.setFileSize(size);
        fileModel.setFileType(suffix);
        ArrayList<DocResourceLog> resInfoList = new ArrayList<DocResourceLog>();
        DocResourceLog docResourceLog = new DocResourceLog();
        String id = UUID.randomUUID().toString().replace("-", "");
        docResourceLog.setId(id);
        docResourceLog.setResourceId(docId);
        docResourceLog.setOperateTime(ts);
        docResourceLog.setResourceType(0);
        docResourceLog.setUserId(userId);
        docResourceLog.setOperateType(0);
        docResourceLog.setValidFlag("1");
        resInfoList.add(docResourceLog);
        ArrayList<DocFileAuthority> list = new ArrayList<DocFileAuthority>();
        ArrayList<String> indexList = new ArrayList<String>();
        DocFileAuthority docFileAuthority = new DocFileAuthority();
        docFileAuthority.setFileAuthorityId(UUID.randomUUID().toString().replaceAll("-", ""));
        docFileAuthority.setAuthorId("allpersonflag");
        docFileAuthority.setAuthorType(3);
        docFileAuthority.setFileId(docId);
        docFileAuthority.setAuthority(0);
        list.add(docFileAuthority);
        indexList.add("allpersonflag");
        indexList.add(userId);
        fileModel.setFilePath(fsFile.getFilePath());
        fileModel.setFilePdfPath(fsFile.getFilePdfPath());
        fileModel.setPdfKey(fsFile.getPdfKey());
        fileModel.setSourceKey(fsFile.getSourceKey());
        this.filesMapper.insert((Object)fileModel);
        this.docInfoMapper.insert(docInfo);
        if (list != null && list.size() > 0) {
            this.docFileAuthorityService.insertBatch(list);
        }
        this.docInfoService.insertResourceLog(resInfoList);
        int state = this.esService.copyIndex(fsFile.getFileId(), docId);
        if (state == -1) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("permission", indexList.toArray(new String[indexList.size()]));
        map.put("tags", tags);
        FsFolder fsFolder = new FsFolder();
        if (docInfo.getFoldId() != null) {
            fsFolder = (FsFolder)((Object)this.iFsFolderService.selectById((Serializable)((Object)docInfo.getFoldId())));
        }
        if (".png".equals(suffix) || ".jpg".equals(suffix) || ".gif".equals(suffix) || ".bmp".equals(suffix) || ".jpeg".equals(suffix)) {
            this.frontDocInfoMapper.insertThumbInfoFast(StringUtil.getUUID(), docId, md5);
        }
        if (fsFolder != null) {
            map.put("category", fsFolder.getFolderName());
        }
        this.esUtil.updateIndex(docId, map);
        return docId;
    }

    @Override
    public String uploadFast(String categoryId, String downloadAble, String visible, String group, String person, String watermarkUser, String md5, String fileName, FsFile fsFile, String size, String shareFlag, String userId) {
        int pointIndex = fileName.lastIndexOf(".");
        String suffix = fileName.substring(pointIndex).toLowerCase();
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        DocInfo docInfo = new DocInfo();
        String docId = UUID.randomUUID().toString().replace("-", "");
        docInfo.setDocId(docId);
        docInfo.setFileId(docId);
        docInfo.setUserId(userId);
        docInfo.setAuthorId(userId);
        docInfo.setContactsId(userId);
        docInfo.setCreateTime(ts);
        docInfo.setFoldId(categoryId);
        docInfo.setDocType(suffix);
        docInfo.setTitle(fileName.substring(0, fileName.lastIndexOf(".")));
        docInfo.setReadNum(0);
        docInfo.setDownloadNum(0);
        docInfo.setValidFlag("1");
        docInfo.setAuthority(downloadAble);
        docInfo.setVisibleRange(Integer.parseInt(visible));
        docInfo.setWatermarkUser(watermarkUser);
        docInfo.setSetAuthority("0");
        docInfo.setValidFlag("1");
        docInfo.setShareFlag(shareFlag);
        FsFile fileModel = new FsFile();
        fileModel.setCreateTime(ts);
        fileModel.setFileIcon("");
        fileModel.setFileId(docId);
        fileModel.setMd5(md5);
        fileModel.setFileName(fileName.substring(0, fileName.lastIndexOf(".")));
        fileModel.setFileSize(size);
        fileModel.setFileType(suffix);
        ArrayList<DocResourceLog> resInfoList = new ArrayList<DocResourceLog>();
        DocResourceLog docResourceLog = new DocResourceLog();
        String id = UUID.randomUUID().toString().replace("-", "");
        docResourceLog.setId(id);
        docResourceLog.setResourceId(docId);
        docResourceLog.setOperateTime(ts);
        docResourceLog.setResourceType(0);
        docResourceLog.setUserId(userId);
        docResourceLog.setOperateType(0);
        docResourceLog.setValidFlag("1");
        resInfoList.add(docResourceLog);
        ArrayList<DocFileAuthority> list = new ArrayList<DocFileAuthority>();
        ArrayList<String> indexList = new ArrayList<String>();
        DocFileAuthority docFileAuthority = new DocFileAuthority();
        docFileAuthority.setFileAuthorityId(UUID.randomUUID().toString().replaceAll("-", ""));
        docFileAuthority.setAuthorId("allpersonflag");
        docFileAuthority.setAuthorType(3);
        docFileAuthority.setFileId(docId);
        docFileAuthority.setAuthority(0);
        list.add(docFileAuthority);
        fileModel.setFilePath(fsFile.getFilePath());
        fileModel.setFilePdfPath(fsFile.getFilePdfPath());
        fileModel.setPdfKey(fsFile.getPdfKey());
        fileModel.setSourceKey(fsFile.getSourceKey());
        this.filesMapper.insert((Object)fileModel);
        this.docInfoMapper.insert(docInfo);
        if (list != null && list.size() > 0) {
            this.docFileAuthorityService.insertBatch(list);
        }
        this.docInfoService.insertResourceLog(resInfoList);
        int state = this.esService.copyIndex(fsFile.getFileId(), docId);
        if (state == -1) {
            return null;
        }
        indexList.add(userId);
        indexList.add("allpersonflag");
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("permission", indexList.toArray(new String[indexList.size()]));
        map.put("tags", "");
        FsFolder fsFolder = new FsFolder();
        if (docInfo.getFoldId() != null) {
            fsFolder = (FsFolder)((Object)this.iFsFolderService.selectById((Serializable)((Object)docInfo.getFoldId())));
        }
        if (".png".equals(suffix) || ".jpg".equals(suffix) || ".gif".equals(suffix) || ".bmp".equals(suffix) || ".jpeg".equals(suffix)) {
            this.frontDocInfoMapper.insertThumbInfoFast(StringUtil.getUUID(), docId, md5);
        }
        if (fsFolder != null) {
            map.put("category", fsFolder.getFolderName());
        }
        this.esUtil.updateIndex(docId, map);
        return docId;
    }

    @Override
    public String uploadVersionFast(String categoryId, String downloadAble, String visible, String group, String person, String watermarkUser, String md5, String fileName, FsFile fsFile, String size, String shareFlag, String oldDocId) {
        String userId = UserInfoUtil.getUserInfo().get("ID").toString();
        int pointIndex = fileName.lastIndexOf(".");
        String suffix = fileName.substring(pointIndex).toLowerCase();
        DocInfo oldDocInfo = (DocInfo)this.docInfoService.selectOne(new EntityWrapper().eq("doc_id", (Object)oldDocId));
        if (this.docVersionService.selectCount(new EntityWrapper().eq("doc_id", (Object)oldDocId)) == 0) {
            DocVersion oldVersion = new DocVersion();
            oldVersion.setDocId(oldDocId);
            oldVersion.setVersionReference(UUID.randomUUID().toString().replace("-", ""));
            oldVersion.setValidFlag("1");
            oldVersion.setApplyTime(oldDocInfo.getCreateTime());
            oldVersion.setApplyUserId(oldDocInfo.getUserId());
            this.docVersionService.insert((Object)oldVersion);
        }
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        DocInfo docInfo = new DocInfo();
        String docId = UUID.randomUUID().toString().replace("-", "");
        docInfo.setDocId(docId);
        docInfo.setFileId(docId);
        docInfo.setUserId(userId);
        docInfo.setAuthorId(userId);
        docInfo.setContactsId(userId);
        docInfo.setCreateTime(ts);
        docInfo.setFoldId(categoryId);
        docInfo.setDocType(suffix);
        docInfo.setTitle(fileName.substring(0, fileName.lastIndexOf(".")));
        docInfo.setReadNum(oldDocInfo.getReadNum());
        docInfo.setDownloadNum(oldDocInfo.getDownloadNum());
        docInfo.setTags(oldDocInfo.getTags());
        docInfo.setValidFlag(visible);
        docInfo.setAuthority(downloadAble);
        docInfo.setVisibleRange(Integer.parseInt(visible));
        docInfo.setWatermarkUser(watermarkUser);
        docInfo.setSetAuthority("0");
        docInfo.setValidFlag("1");
        docInfo.setShareFlag(oldDocInfo.getShareFlag());
        FsFile fileModel = new FsFile();
        fileModel.setCreateTime(ts);
        fileModel.setFileIcon("");
        fileModel.setFileId(docId);
        fileModel.setMd5(md5);
        fileModel.setFileName(fileName.substring(0, fileName.lastIndexOf(".")));
        fileModel.setFileSize(size);
        fileModel.setFileType(suffix);
        ArrayList<DocResourceLog> resInfoList = new ArrayList<DocResourceLog>();
        DocResourceLog docResourceLog = new DocResourceLog();
        String id = UUID.randomUUID().toString().replace("-", "");
        docResourceLog.setId(id);
        docResourceLog.setResourceId(docId);
        docResourceLog.setOperateTime(ts);
        docResourceLog.setResourceType(0);
        docResourceLog.setUserId(userId);
        docResourceLog.setOperateType(0);
        docResourceLog.setValidFlag("1");
        resInfoList.add(docResourceLog);
        List list = new ArrayList();
        ArrayList<String> indexList = new ArrayList<String>();
        list = this.docFileAuthorityService.selectList(new EntityWrapper().eq("file_id", (Object)oldDocId));
        for (int i = 0; i < list.size(); ++i) {
            DocFileAuthority item = (DocFileAuthority)((Object)list.get(i));
            String esId = item.getAuthorId();
            if (item.getAuthorType() == 2) {
                esId = item.getOrganId();
            }
            indexList.add(esId);
            ((DocFileAuthority)((Object)list.get(i))).setFileId(docId);
            ((DocFileAuthority)((Object)list.get(i))).setFileAuthorityId(null);
        }
        indexList.add(userId);
        fileModel.setFilePath(fsFile.getFilePath());
        fileModel.setFilePdfPath(fsFile.getFilePdfPath());
        fileModel.setPdfKey(fsFile.getPdfKey());
        fileModel.setSourceKey(fsFile.getSourceKey());
        this.filesMapper.insert((Object)fileModel);
        this.docInfoMapper.insert(docInfo);
        if (list != null && list.size() > 0) {
            this.docFileAuthorityService.insertBatch(list);
        }
        this.docInfoService.insertResourceLog(resInfoList);
        this.esService.copyIndex(fsFile.getFileId(), docId);
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("permission", indexList.toArray(new String[indexList.size()]));
        map.put("recycle", "1");
        map.put("tags", "");
        FsFolder fsFolder = new FsFolder();
        if (docInfo.getFoldId() != null) {
            fsFolder = (FsFolder)((Object)this.iFsFolderService.selectById((Serializable)((Object)docInfo.getFoldId())));
        }
        map.put("category", fsFolder.getFolderName());
        this.esUtil.updateIndex(docId, map);
        this.docInfoService.updateValidFlag(oldDocId, "0");
        HashMap<String, Object> map1 = new HashMap<String, Object>(1);
        map1.put("recycle", DocConstant.VALIDTYPE.INVALID.getValue());
        this.esUtil.updateIndex(oldDocId, map1);
        DocVersion oldVersion = (DocVersion)((Object)this.docVersionService.selectOne(new EntityWrapper().eq("doc_id", (Object)oldDocId)));
        DocVersion newVersion = new DocVersion();
        newVersion.setVersionReference(oldVersion.getVersionReference());
        newVersion.setDocId(docInfo.getDocId());
        newVersion.setValidFlag("1");
        newVersion.setApplyTime(docInfo.getCreateTime());
        newVersion.setApplyUserId(docInfo.getUserId());
        this.docVersionService.insert((Object)newVersion);
        return docId;
    }

    private void createThumbnails(String sourcePath, String targetPath) throws Exception {
        double oldHeight;
        double toWidth = 290.0;
        String[] stringArray = new String[]{"jpg", "png", "gif", "bmp"};
        BufferedImage imageList = this.getImageList(sourcePath, stringArray);
        double oldWidth = imageList.getWidth();
        if (oldWidth / (oldHeight = (double)imageList.getHeight()) > 4.0) {
            double toHeight = 200.0;
            toWidth = toHeight / oldHeight * oldWidth;
            this.writeHighQuality(targetPath, this.zoomImage(imageList, (int)toWidth, (int)toHeight));
        } else {
            double toHeight = toWidth / oldWidth * oldHeight;
            this.writeHighQuality(targetPath, this.zoomImage(imageList, (int)toWidth, (int)toHeight));
        }
    }

    private BufferedImage getImageList(String ImgList, String[] type) throws IOException {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        for (String s : type) {
            map.put(s, true);
        }
        BufferedImage imageList = null;
        File file = null;
        file = new File(ImgList);
        if (!file.exists()) {
            file.mkdir();
        }
        try {
            if (file.length() != 0L && map.get(this.getExtension(file.getName())) != null) {
                imageList = ImageIO.read(file);
            }
        }
        catch (Exception e) {
            imageList = null;
        }
        return imageList;
    }

    private String getExtension(String fileName) {
        try {
            return fileName.split("\\.")[fileName.split("\\.").length - 1].toLowerCase();
        }
        catch (Exception e) {
            return null;
        }
    }

    private boolean writeHighQuality(String path, BufferedImage im) throws IOException {
        FileOutputStream newimage = null;
        try {
            newimage = new FileOutputStream(path);
            JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)newimage);
            JPEGEncodeParam jep = JPEGCodec.getDefaultJPEGEncodeParam((BufferedImage)im);
            jep.setQuality(1.0f, true);
            encoder.encode(im, jep);
            newimage.close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private BufferedImage zoomImage(BufferedImage im, int toWidth, int toHeight) {
        BufferedImage result = new BufferedImage(toWidth, toHeight, 1);
        result.getGraphics().drawImage(im.getScaledInstance(toWidth, toHeight, 4), 0, 0, null);
        return result;
    }
}

