/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.doc.manager.docmanager.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.jxdinfo.doc.common.constant.DocConstant;
import com.jxdinfo.doc.common.docutil.service.BusinessService;
import com.jxdinfo.doc.common.docutil.service.CacheToolService;
import com.jxdinfo.doc.common.docutil.service.DocConfigService;
import com.jxdinfo.doc.common.util.CommonUtil;
import com.jxdinfo.doc.common.util.ESUtil;
import com.jxdinfo.doc.common.util.FileTool;
import com.jxdinfo.doc.common.util.StringUtil;
import com.jxdinfo.doc.common.util.UserInfoUtil;
import com.jxdinfo.doc.manager.docconfigure.model.DocConfigure;
import com.jxdinfo.doc.manager.docconfigure.service.DocConfigureService;
import com.jxdinfo.doc.manager.docmanager.model.DocFileAuthority;
import com.jxdinfo.doc.manager.docmanager.model.DocInfo;
import com.jxdinfo.doc.manager.docmanager.model.DocResourceLog;
import com.jxdinfo.doc.manager.docmanager.model.FsFile;
import com.jxdinfo.doc.manager.docmanager.model.FsFolderView;
import com.jxdinfo.doc.manager.docmanager.service.DocFileAuthorityService;
import com.jxdinfo.doc.manager.docmanager.service.DocInfoService;
import com.jxdinfo.doc.manager.docmanager.service.FsFileService;
import com.jxdinfo.doc.manager.docrecycle.service.IDocRecycleService;
import com.jxdinfo.doc.manager.foldermanager.model.DocFoldAuthority;
import com.jxdinfo.doc.manager.foldermanager.model.FsFolder;
import com.jxdinfo.doc.manager.foldermanager.model.FsFolderParams;
import com.jxdinfo.doc.manager.foldermanager.service.IDocFoldAuthorityService;
import com.jxdinfo.doc.manager.foldermanager.service.IFsFolderService;
import com.jxdinfo.doc.manager.groupmanager.service.DocGroupService;
import com.jxdinfo.hussar.bsp.permit.model.SysUsers;
import com.jxdinfo.hussar.bsp.permit.service.ISysUsersService;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/fsFile"})
public class FsFileController
extends BaseController {
    private String PREFIX = "/doc/manager/docmanager/";
    @Autowired
    private FsFileService fsFileService;
    @Autowired
    private ISysUsersService sysUsersService;
    @Autowired
    private ESUtil esUtil;
    @Resource
    private IDocRecycleService iDocRecycleService;
    @Resource
    private DocConfigureService docConfigureService;
    @Autowired
    private DocGroupService docGroupService;
    @Autowired
    private DocInfoService docInfoService;
    @Autowired
    private IFsFolderService fsFolderService;
    @Autowired
    private DocFileAuthorityService docFileAuthorityService;
    @Autowired
    private CacheToolService cacheToolService;
    @Autowired
    private DocConfigService docConfigService;
    @Resource
    private BusinessService businessService;
    @Autowired
    private IDocFoldAuthorityService docFoldAuthorityService;

    @RequiresPermissions(value={"fsFile:view"})
    @RequestMapping(value={"/view"})
    public String index() {
        return this.PREFIX + "resourceManager.html";
    }

    @RequestMapping(value={"/authority"})
    public String authority() {
        return this.PREFIX + "authority.html";
    }

    @RequestMapping(value={"/getRoot"})
    @ResponseBody
    public Map getRoot() {
        List<FsFolder> list = this.fsFileService.getRoot();
        HashMap<String, String> map = new HashMap<String, String>();
        FsFolder fsFile = list.get(0);
        map.put("root", fsFile.getFolderId());
        map.put("rootName", fsFile.getFolderName());
        return map;
    }

    @RequestMapping(value={"/add"})
    @ResponseBody
    public Object add(FsFile fsFile, String group, String person) {
        String userId = UserInfoUtil.getUserInfo().get("ID").toString();
        this.cacheToolService.updateLevelCodeCache(userId);
        if (fsFile.getFileId() != null && !"".equals(fsFile.getFileId())) {
            this.updateFsFile(fsFile);
        } else {
            DocFoldAuthority docFoldAuthority;
            Date date = new Date();
            Timestamp ts = new Timestamp(date.getTime());
            fsFile.setCreateTime(ts);
            fsFile.setFileType("folder");
            fsFile.setFileIcon("default");
            String fileId = UUID.randomUUID().toString().replaceAll("-", "");
            fsFile.setFileId(fileId);
            this.fsFileService.insert((Object)fsFile);
            ArrayList<DocFoldAuthority> list = new ArrayList<DocFoldAuthority>();
            if (group != null) {
                String[] groupArr;
                for (String element : groupArr = group.split(",")) {
                    docFoldAuthority = new DocFoldAuthority();
                    docFoldAuthority.setId(UUID.randomUUID().toString().replaceAll("-", ""));
                    docFoldAuthority.setAuthorId(element);
                    docFoldAuthority.setAuthorType(DocConstant.AUTHORTYPE.GROUP.toString());
                    docFoldAuthority.setFoldId(fileId);
                    list.add(docFoldAuthority);
                }
            }
            if (person != null) {
                String[] personArr;
                for (String element : personArr = person.split(",")) {
                    docFoldAuthority = new DocFoldAuthority();
                    docFoldAuthority.setId(UUID.randomUUID().toString().replaceAll("-", ""));
                    docFoldAuthority.setAuthorId(element);
                    docFoldAuthority.setAuthorType(DocConstant.AUTHORTYPE.USER.toString());
                    docFoldAuthority.setFoldId(fileId);
                    list.add(docFoldAuthority);
                }
            }
            this.docFoldAuthorityService.insertBatch(list);
        }
        return SUCCESS_TIP;
    }

    @RequestMapping(value={"/editFile"})
    @ResponseBody
    public Object editFile(FsFile fsFile, String authorId, String contactsId) {
        this.updateFsFile(fsFile);
        this.fsFileService.updateFileAuthor(fsFile.getFileId(), authorId, contactsId);
        return SUCCESS_TIP;
    }

    @RequestMapping(value={"/addCheck"})
    @ResponseBody
    public String addCheck(String name, String filePid) {
        List<FsFile> list = this.fsFileService.addCheck(filePid, name);
        if (list.size() > 0) {
            return "false";
        }
        return "true";
    }

    @RequestMapping(value={"/delete"})
    @ResponseBody
    public String delete(@RequestParam String fsFileIds) {
        String[] strArr = fsFileIds.split(",");
        String userId = ShiroKit.getUser().getId();
        this.cacheToolService.updateLevelCodeCache(userId);
        ArrayList<String> list = new ArrayList<String>();
        for (String element : strArr) {
            String ids = this.fsFileService.getChildFsFile(element);
            String[] childArr = ids.split(",");
            list.addAll(Arrays.asList(childArr));
        }
        int num = this.fsFileService.deleteInIds(list);
        return "success";
    }

    @RequestMapping(value={"/deleteScope"})
    @ResponseBody
    public int deleteScope(@RequestParam String fsFileIds) {
        String userId = ShiroKit.getUser().getId();
        this.cacheToolService.updateLevelCodeCache(userId);
        String[] strArr = fsFileIds.split(",");
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(Arrays.asList(strArr));
        int num = this.fsFileService.deleteScope(list);
        for (String id : strArr) {
            HashMap<String, Object> map = new HashMap<String, Object>(1);
            map.put("recycle", DocConstant.VALIDTYPE.INVALID.getValue());
            this.esUtil.updateIndex(id, map);
        }
        return num;
    }

    @RequestMapping(value={"/checkChild"})
    @ResponseBody
    public String checkChild(@RequestParam String fsFileIds, @RequestParam String id) {
        String[] strArr;
        for (String element : strArr = fsFileIds.split(",")) {
            String ids = this.fsFileService.getChildFsFile(element);
            String[] childArr = ids.split(",");
            for (int i = 0; i < childArr.length; ++i) {
                if (!childArr[i].equals(id)) continue;
                return "have";
            }
        }
        return "success";
    }

    @RequestMapping(value={"/checkFileType"})
    @ResponseBody
    public Object checkFileType(@RequestParam String ids) {
        String[] strArr;
        for (String element : strArr = ids.split(",")) {
            String types = this.fsFileService.checkChildType(element);
            String[] typeArr = types.split(",");
            for (int j = 0; j < typeArr.length; ++j) {
                if ("folder".equals(typeArr[j])) continue;
                return "haveFile";
            }
        }
        return SUCCESS_TIP;
    }

    @RequestMapping(value={"/edit"})
    @ResponseBody
    public DocInfo edit(Model model, String id) {
        String authorId;
        DocInfo docInfo = this.docInfoService.getDocDetail(id);
        if (docInfo != null && (authorId = docInfo.getAuthorId()) != null) {
            SysUsers user = (SysUsers)this.sysUsersService.selectById((Serializable)((Object)authorId));
            docInfo.setAuthorName(user.getUserName());
        }
        return docInfo;
    }

    @RequestMapping(value={"/getChildren"})
    @ResponseBody
    public Object getChildren(@RequestParam String id, @RequestParam(value="pageNumber", defaultValue="1") int pageNumber, @RequestParam(value="pageSize", defaultValue="60") int pageSize, String order, String name, String type, String nameFlag, String operateType) {
        String folderAmount;
        String[] typeArr;
        HashMap<String, String> orderMap = new HashMap<String, String>();
        HashMap<String, String> typeMap = new HashMap<String, String>();
        String isDesc = "0";
        if ("1".equals(order) || "3".equals(order)) {
            isDesc = "1";
        }
        orderMap.put("0", "fileName");
        orderMap.put("1", "fileName");
        orderMap.put("2", "createTime");
        orderMap.put("3", "createTime");
        typeMap.put("1", ".doc,.docx");
        typeMap.put("2", ".ppt,.pptx");
        typeMap.put("3", ".txt");
        typeMap.put("4", ".pdf");
        typeMap.put("5", ".xls,.xlsx");
        String orderResult = (String)orderMap.get(order);
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        List<Object> list = new ArrayList();
        int num = 0;
        boolean isChild = this.fsFileService.isChildren(id);
        String userId = ShiroKit.getUser().getId();
        List<String> listGroup = this.docGroupService.getPremission(userId);
        List roleList = ShiroKit.getUser().getRolesList();
        Integer adminFlag = CommonUtil.getAdminFlag((List)roleList);
        FsFolder fsFolder = (FsFolder)((Object)this.fsFolderService.selectById((Serializable)((Object)id)));
        if (type == null) {
            type = "0";
        }
        if ("0".equals(type)) {
            typeArr = null;
        } else {
            String typeResult = (String)typeMap.get(type);
            typeArr = typeResult.split(",");
        }
        name = StringUtil.transferSqlParam((String)name);
        FsFolder folder = (FsFolder)((Object)this.fsFolderService.selectById((Serializable)((Object)id)));
        FsFolderParams fsFolderParams = new FsFolderParams();
        fsFolderParams.setGroupList(listGroup);
        fsFolderParams.setUserId(userId);
        fsFolderParams.setType(operateType);
        fsFolderParams.setLevelCodeString(folder.getLevelCode());
        fsFolderParams.setId(id);
        String levelCodeString = this.businessService.getFileLevelCode(fsFolderParams);
        fsFolderParams.setType("2");
        String levelCode = this.businessService.getLevelCodeByUserUpload(fsFolderParams);
        String orgId = ShiroKit.getUser().getDeptName();
        list = this.fsFolderService.getFilesAndFloder((pageNumber - 1) * pageSize, pageSize, id, typeArr, name, orderResult, listGroup, userId, adminFlag, operateType, levelCodeString, levelCode, isDesc, orgId);
        list = this.changeSize(list);
        num = this.fsFolderService.getFilesAndFloderNum(id, typeArr, name, orderResult, listGroup, userId, adminFlag, operateType, levelCodeString, levelCode, orgId);
        int amount = this.fsFolderService.getFileNum(id, typeArr, name, listGroup, userId, adminFlag, operateType, levelCode, orgId);
        if (adminFlag != 1) {
            int isEdits = this.docFoldAuthorityService.findEditByUpload(id, listGroup, userId);
            result.put("noChildPower", isEdits);
        }
        if (userId.equals(fsFolder.getCreateUserId())) {
            result.put("noChildPower", 2);
        }
        if ((folderAmount = this.docConfigService.getConfigValueByKey("folder_amount")) == null || Integer.parseInt(folderAmount) < 4) {
            folderAmount = "4";
        }
        result.put("folderAmount", folderAmount);
        if (adminFlag != 1) {
            int isEdits = this.docFoldAuthorityService.findEditNew(id, listGroup, userId);
            result.put("noChildPowerFolder", isEdits);
        }
        if (userId.equals(fsFolder.getCreateUserId())) {
            result.put("noChildPowerFolder", 1);
        }
        result.put("userId", ShiroKit.getUser().getId());
        result.put("isAdmin", adminFlag);
        result.put("total", num);
        result.put("rows", list);
        result.put("amount", amount);
        return result;
    }

    @RequestMapping(value={"/getChildreTable"})
    @ResponseBody
    public Object getChildrenTable(@RequestParam String id, @RequestParam(value="pageNumber", defaultValue="1") int pageNumber, @RequestParam(value="pageSize", defaultValue="60") int pageSize, String order, String name, String type, String nameFlag) {
        boolean isChild = this.fsFileService.isChildren(id);
        HashMap<String, String> orderMap = new HashMap<String, String>();
        HashMap<String, String> typeMap = new HashMap<String, String>();
        orderMap.put("0", "create_time");
        orderMap.put("1", "file_name");
        orderMap.put("2", "file_type");
        typeMap.put("1", ".doc,.docx");
        typeMap.put("2", ".ppt,.pptx");
        typeMap.put("3", ".txt");
        typeMap.put("4", ".pdf");
        typeMap.put("5", ".xls,.xlsx");
        String orderResult = (String)orderMap.get(order);
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        List<Object> list = new ArrayList();
        int num = 0;
        String userId = ShiroKit.getUser().getId();
        List<String> listGroup = this.docGroupService.getPremission(userId);
        List roleList = ShiroKit.getUser().getRolesList();
        Integer adminFlag = CommonUtil.getAdminFlag((List)roleList);
        if ("0".equals(type)) {
            if (nameFlag == null || "".equals(nameFlag)) {
                list = this.fsFileService.getChildren((pageNumber - 1) * pageSize, pageSize, id, null, null, orderResult, listGroup, userId, adminFlag);
                num = this.fsFileService.getNum(id, null, null, listGroup, userId, adminFlag);
            } else {
                list = this.fsFileService.getChildren((pageNumber - 1) * pageSize, pageSize, id, null, name, orderResult, listGroup, userId, adminFlag);
                num = this.fsFileService.getNum(id, null, name, listGroup, userId, adminFlag);
            }
        } else {
            String typeResult = (String)typeMap.get(type);
            String[] typeArr = typeResult.split(",");
            if (nameFlag == null || "".equals(nameFlag)) {
                list = this.fsFileService.getChildren((pageNumber - 1) * pageSize, pageSize, id, typeArr, null, orderResult, listGroup, userId, adminFlag);
                num = this.fsFileService.getNum(id, typeArr, null, listGroup, userId, adminFlag);
            } else {
                list = this.fsFileService.getChildren((pageNumber - 1) * pageSize, pageSize, id, typeArr, name, orderResult, listGroup, userId, adminFlag);
                num = this.fsFileService.getNum(id, typeArr, name, listGroup, userId, adminFlag);
            }
        }
        result.put("userId", ShiroKit.getUser().getName());
        result.put("isAdmin", adminFlag);
        result.put("total", num);
        result.put("rows", list);
        result.put("isChild", isChild);
        return result;
    }

    @RequestMapping(value={"/getInfo"})
    @ResponseBody
    public List<Map> getInfo(@RequestParam String ids) {
        String orgId;
        List<String> listGroup;
        String[] strArr = ids.split(",");
        ArrayList<String> idList = new ArrayList<String>();
        for (String element : strArr) {
            idList.add(element);
        }
        String userId = UserInfoUtil.getCurrentUser().getId();
        List<Map> list = this.fsFileService.getInfo(idList, userId, listGroup = this.docGroupService.getPremission(userId), null, orgId = ShiroKit.getUser().getDeptName());
        if (list != null) {
            int j = list.size();
            for (int i = 0; i < j; ++i) {
                Map dataMap = list.get(i);
                int readNum = this.cacheToolService.getReadNum(StringUtil.getString(dataMap.get("fileId")));
                dataMap.put("readNum", readNum);
                list.set(i, dataMap);
            }
        }
        return list;
    }

    @RequestMapping(value={"/update"})
    @ResponseBody
    public String update(String ids, String filePid, String fileName, String type) {
        if (fileName == null || "".equals(fileName)) {
            String[] strArr = ids.split(",");
            ArrayList<DocInfo> listDocInfos = new ArrayList<DocInfo>();
            for (String element : strArr) {
                DocInfo docInfo = new DocInfo();
                docInfo.setFileId(element);
                docInfo.setDocId(element);
                docInfo.setFoldId(filePid);
                listDocInfos.add(docInfo);
            }
            this.docInfoService.insertOrUpdateBatch(listDocInfos);
        } else if (!"folder".equals(type)) {
            List<Map> idList = this.fsFileService.getDocId(ids);
            Map mapParam = idList.get(0);
            String docId = (String)mapParam.get("id");
            this.docInfoService.updateDocName(docId, fileName);
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            map.put("title", fileName);
            this.esUtil.updateIndex(docId, map);
        }
        return "success";
    }

    public String updateFsFile(FsFile fsFile) {
        if (fsFile.getFileName() == null || "".equals(fsFile.getFileName())) {
            this.fsFileService.updateById((Object)fsFile);
        } else {
            this.fsFileService.updateById((Object)fsFile);
            if (!"folder".equals(fsFile.getFileType())) {
                List<Map> idList = this.fsFileService.getDocId(fsFile.getFileId());
                Map mapParam = idList.get(0);
                String docId = (String)mapParam.get("id");
                this.docInfoService.updateDocName(docId, fsFile.getFileName());
                HashMap<String, Object> map = new HashMap<String, Object>(16);
                map.put("title", fsFile.getFileName());
                this.esUtil.updateIndex(docId, map);
            }
        }
        return "success";
    }

    @RequestMapping(value={"/getDocId"})
    @ResponseBody
    public String getDocId(String id) {
        List<Map> idList = this.fsFileService.getDocId(id);
        Map map = idList.get(0);
        String fileId = (String)map.get("id");
        return fileId;
    }

    @RequestMapping(value={"/checkName"})
    @ResponseBody
    public String checkName(String typeStr, String nameStr, String filePid) {
        String[] typeArr = typeStr.split(",");
        String[] nameArr = nameStr.split("\\*");
        ArrayList list = new ArrayList();
        for (int i = 0; i < typeArr.length; ++i) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("name", nameArr[i]);
            map.put("type", typeArr[i]);
            list.add(map);
        }
        List<FsFile> listFs = this.fsFileService.countFileName(filePid, list);
        if (listFs.size() > 0) {
            return "fail";
        }
        return "success";
    }

    @RequestMapping(value={"/getTreeDataLazy"})
    @ResponseBody
    public List getTreeDataLazy(String id, String type) {
        List<Object> resultList = new ArrayList();
        FsFolderParams fsFolderParams = new FsFolderParams();
        List roleList = UserInfoUtil.getCurrentUser().getRolesList();
        String userId = UserInfoUtil.getCurrentUser().getId();
        Integer adminFlag = CommonUtil.getAdminFlag((List)roleList);
        List<String> listGroup = this.docGroupService.getPremission(userId);
        FsFolder folder = new FsFolder();
        if ("#".equals(id)) {
            String fid = "2bb61cdb2b3c11e8aacf429ff4208431";
            folder = (FsFolder)((Object)this.fsFolderService.selectById((Serializable)((Object)fid)));
        } else {
            folder = (FsFolder)((Object)this.fsFolderService.selectById((Serializable)((Object)id)));
        }
        fsFolderParams.setAdminFlag(adminFlag);
        fsFolderParams.setGroupList(listGroup);
        fsFolderParams.setUserId(userId);
        fsFolderParams.setType(type);
        fsFolderParams.setLevelCodeString(folder.getLevelCode());
        fsFolderParams.setId(id);
        String levelCodeString = this.businessService.getFileLevelCode(fsFolderParams);
        fsFolderParams.setLevelCodeString(levelCodeString);
        if ("#".equals(id)) {
            String idParam = "root";
            ArrayList<String> firstList = new ArrayList<String>();
            ArrayList<String> secondList = new ArrayList<String>();
            fsFolderParams.setId(idParam);
            fsFolderParams.setType(DocConstant.OPERATETYPE.FRONT.getValue());
            List<FsFolder> list = this.fsFolderService.getTreeDataLazy(fsFolderParams);
            for (int i = 0; i < list.size(); ++i) {
                FsFolder fsFile = list.get(i);
                firstList.add(fsFile.getFolderId());
            }
            List<FsFolder> childList = this.fsFolderService.getChildList(firstList, listGroup, userId, adminFlag, type, levelCodeString);
            for (int i = 0; i < childList.size(); ++i) {
                FsFolder fsFile = childList.get(i);
                secondList.add(fsFile.getFolderId());
            }
            List<Map> childCountList = this.fsFolderService.getChildCountList(secondList, listGroup, userId, adminFlag, type, levelCodeString);
            List<Map> childResultList = this.fsFolderService.checkChildCount(childList, childCountList);
            for (int i = 0; i < list.size(); ++i) {
                HashMap<String, Object> parentMap = new HashMap<String, Object>();
                FsFolder fsFile = list.get(i);
                parentMap.put("id", fsFile.getFolderId());
                parentMap.put("text", fsFile.getFolderName());
                ArrayList<Map> childMapList = new ArrayList<Map>();
                for (int j = 0; j < childResultList.size(); ++j) {
                    Map map = childResultList.get(j);
                    if (!fsFile.getFolderId().equals(map.get("pid"))) continue;
                    childMapList.add(map);
                }
                parentMap.put("children", childMapList);
                parentMap.put("opened", true);
                resultList.add(parentMap);
            }
        } else {
            ArrayList<String> firstList = new ArrayList<String>();
            fsFolderParams.setId(id);
            fsFolderParams.setType(type);
            List<FsFolder> list = this.fsFolderService.getTreeDataLazy(fsFolderParams);
            for (int i = 0; i < list.size(); ++i) {
                FsFolder fsFile = list.get(i);
                firstList.add(fsFile.getFolderId());
            }
            List<Map> childCountList = this.fsFolderService.getChildCountList(firstList, listGroup, userId, adminFlag, type, levelCodeString);
            resultList = this.fsFolderService.checkChildCount(list, childCountList);
        }
        return resultList;
    }

    @RequestMapping(value={"/upload.do"})
    public String upload() {
        return this.PREFIX + "upload.html";
    }

    @RequestMapping(value={"/cacheViewNum"})
    @ResponseBody
    public void saveCache(String docId) {
        this.cacheToolService.getAndUpdateReadNum(docId);
        ArrayList<DocResourceLog> resInfoList = new ArrayList<DocResourceLog>();
        DocResourceLog docResourceLog = new DocResourceLog();
        String id = UUID.randomUUID().toString().replace("-", "");
        docResourceLog.setId(id);
        docResourceLog.setResourceId(docId);
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        docResourceLog.setOperateTime(ts);
        docResourceLog.setResourceType(0);
        String userId = UserInfoUtil.getUserInfo().get("ID").toString();
        docResourceLog.setUserId(userId);
        docResourceLog.setOperateType(3);
        docResourceLog.setValidFlag("1");
        resInfoList.add(docResourceLog);
        this.docInfoService.insertResourceLog(resInfoList);
    }

    @RequestMapping(value={"/searchLevel"})
    @ResponseBody
    public JSON searchLevel(HttpServletRequest request, HttpServletResponse response) {
        List list = this.fsFileService.searchLevel();
        JSONObject json = new JSONObject();
        json.put("data", (Object)list);
        return json;
    }

    @RequestMapping(value={"/getFsFolderDetail"})
    @ResponseBody
    public JSON getFsFolderDetail(String fsFileId) {
        List list = this.fsFileService.getFsFolderDetail(fsFileId);
        JSONObject json = new JSONObject();
        json.put("data", (Object)list);
        return json;
    }

    @RequestMapping(value={"/getFsFileDetail"})
    @ResponseBody
    public JSON getFsFileDetail(String fsFileId) {
        List list = this.fsFileService.getFsfileDetail(fsFileId);
        JSONObject json = new JSONObject();
        json.put("data", (Object)list);
        return json;
    }

    @RequestMapping(value={"/getPersonList"})
    @ResponseBody
    public JSON getPersonList(String name, @RequestParam(value="pageNumber", defaultValue="1") int pageNumber, @RequestParam(value="pageSize", defaultValue="15") int pageSize, String deptId) {
        List<Map> list = this.fsFileService.getPersonList((pageNumber - 1) * pageSize, pageSize, name, deptId);
        int num = this.fsFileService.getPersonNum(name, deptId);
        JSONObject json = new JSONObject();
        json.put("count", (Object)num);
        json.put("data", list);
        json.put("msg", (Object)"success");
        json.put("code", (Object)0);
        return json;
    }

    @RequestMapping(value={"/downloadAble"})
    @ResponseBody
    public JSON downloadAble(HttpServletRequest request, HttpServletResponse response) {
        List list = this.fsFileService.downloadAble();
        JSONObject json = new JSONObject();
        json.put("data", (Object)list);
        return json;
    }

    @RequestMapping(value={"/getAuthority"})
    @ResponseBody
    public List getAuthority(String fileId) {
        String authorId;
        DocInfo docInfo = this.docInfoService.getDocDetail(fileId);
        if (docInfo != null && (authorId = docInfo.getAuthorId()) != null) {
            SysUsers sysUsers = (SysUsers)this.sysUsersService.selectById((Serializable)((Object)authorId));
        }
        List list = this.fsFileService.getAuthority(fileId);
        return list;
    }

    @RequestMapping(value={"/editAuthority"})
    @ResponseBody
    public boolean editAuthority(String fileId, String group, String person, String authorId, String personOrgan, String authorTypeGroup, String authorTypePerson, String operateTypeGroup, String operateTypePerson) {
        String userId = ShiroKit.getUser().getId();
        this.cacheToolService.updateLevelCodeCache(userId);
        Date date = new Date();
        DocInfo docInfo = new DocInfo();
        Timestamp ts = new Timestamp(date.getTime());
        docInfo.setUpdateTime(ts);
        docInfo.setDocId(fileId);
        docInfo.setSetAuthority("0");
        this.docInfoService.updateById(docInfo);
        this.docFileAuthorityService.delete(new EntityWrapper().eq("file_id", (Object)fileId));
        ArrayList<String> indexList = new ArrayList<String>();
        ArrayList<DocFileAuthority> list = new ArrayList<DocFileAuthority>();
        if (group != null && !"".equals(group)) {
            String[] groupArr = group.split(",");
            String[] authorTypeStrGroup = authorTypeGroup.split(",");
            String[] operateTypeStrGroup = operateTypeGroup.split(",");
            for (int i = 0; i < groupArr.length; ++i) {
                DocFileAuthority docFileAuthority = new DocFileAuthority();
                docFileAuthority.setFileAuthorityId(UUID.randomUUID().toString().replaceAll("-", ""));
                docFileAuthority.setAuthorId(groupArr[i]);
                docFileAuthority.setAuthorType(StringUtil.getInteger((Object)authorTypeStrGroup[i]));
                docFileAuthority.setFileId(fileId);
                docFileAuthority.setAuthority(StringUtil.getInteger((Object)operateTypeStrGroup[i]));
                list.add(docFileAuthority);
                indexList.add(groupArr[i]);
            }
        }
        if (person != null && !"".equals(person)) {
            String[] personArr = person.split(",");
            String[] personOrganArr = personOrgan.split(",");
            String[] authorTypeStrPerson = authorTypePerson.split(",");
            String[] operateTypeStrPerson = operateTypePerson.split(",");
            for (int i = 0; i < personArr.length; ++i) {
                DocFileAuthority docFileAuthority = new DocFileAuthority();
                docFileAuthority.setFileAuthorityId(UUID.randomUUID().toString().replaceAll("-", ""));
                docFileAuthority.setAuthorId(personArr[i]);
                docFileAuthority.setAuthorType(StringUtil.getInteger((Object)authorTypeStrPerson[i]));
                docFileAuthority.setFileId(fileId);
                docFileAuthority.setAuthority(Integer.parseInt(operateTypeStrPerson[i]));
                docFileAuthority.setOrganId(personOrganArr[i]);
                list.add(docFileAuthority);
                if (StringUtil.getInteger((Object)authorTypeStrPerson[i]) == 0) {
                    indexList.add(personArr[i]);
                }
                if (StringUtil.getInteger((Object)authorTypeStrPerson[i]) != 2) continue;
                indexList.add(personOrganArr[i]);
            }
        }
        indexList.add(authorId);
        HashMap<String, Object> map = new HashMap<String, Object>(1);
        map.put("permission", indexList.toArray(new String[indexList.size()]));
        this.esUtil.updateIndex(fileId, map);
        boolean flag = true;
        if (list.size() > 0) {
            flag = this.docFileAuthorityService.insertBatch(list);
        }
        return flag;
    }

    public List<FsFolderView> changeSize(List<FsFolderView> list) {
        for (FsFolderView fsFolderView : list) {
            if (fsFolderView.getFileSize() == null || "".equals(fsFolderView.getFileSize())) continue;
            fsFolderView.setFileSize(FileTool.longToString(fsFolderView.getFileSize()));
        }
        return list;
    }

    @RequestMapping(value={"/fileAuthority"})
    public String fileAuthority() {
        return "/doc/manager/docmanager/fileAuthority.html";
    }

    @RequestMapping(value={"/addtip"})
    @ResponseBody
    public JSON addtip(String docId, String tip) {
        DocInfo docInfo = new DocInfo();
        docInfo.setDocId(docId);
        docInfo.setTags(tip);
        JSONObject json = new JSONObject();
        boolean success = this.docInfoService.updateById(docInfo);
        HashMap<String, Object> map = new HashMap<String, Object>(1);
        map.put("tags", tip);
        this.esUtil.updateIndex(docId, map);
        json.put("success", (Object)success);
        return json;
    }

    @RequestMapping(value={"/setShareFlag"})
    @ResponseBody
    public String setShareFlag(String docId, String shareFlag) {
        DocInfo docInfo = new DocInfo();
        docInfo.setDocId(docId);
        docInfo.setShareFlag(shareFlag);
        return this.docInfoService.updateById(docInfo) + "";
    }

    @RequestMapping(value={"/setShareFlags"})
    @ResponseBody
    public String setShareFlags(String docIds, String shareFlag) {
        List<String> list = Arrays.asList(docIds.split(","));
        ArrayList<DocInfo> docInfos = new ArrayList<DocInfo>();
        for (String i : list) {
            DocInfo docInfo = new DocInfo();
            docInfo.setShareFlag(shareFlag);
            docInfo.setDocId(i);
            docInfos.add(docInfo);
        }
        return this.docInfoService.updateBatchById(docInfos) + "";
    }

    @RequestMapping(value={"/shareFlagView"})
    public String shareFlagView(String docId, String docIds, Model model) {
        if (docId != null) {
            DocInfo docInfo = this.docInfoService.getDocDetail(docId);
            String shareFlag = docInfo.getShareFlag() == null ? "0" : docInfo.getShareFlag();
            model.addAttribute("shareFlag", (Object)shareFlag);
            model.addAttribute("docId", (Object)docId);
            model.addAttribute("fileName", (Object)docInfo.getTitle());
            model.addAttribute("docIds", (Object)-1);
        } else {
            model.addAttribute("shareFlag", (Object)0);
            model.addAttribute("docId", (Object)-1);
            model.addAttribute("docIds", (Object)docIds);
        }
        return "/doc/front/personalcenter/share_flag_view.html";
    }

    @RequestMapping(value={"/gettip"})
    @ResponseBody
    public JSON gettip(String docId) {
        DocInfo docInfo = this.docInfoService.getDocDetail(docId);
        JSONObject json = new JSONObject();
        if (docInfo.getTags() != null) {
            json.put("tip", (Object)docInfo.getTags());
        }
        return json;
    }

    @RequestMapping(value={"/setTip"})
    public String setTip() {
        return "/doc/manager/docmanager/setTip.html";
    }

    @RequestMapping(value={"/getMoveTreeDataLazy"})
    @ResponseBody
    public List getMoveTreeDataLazy(String id, String type) {
        List<Object> resultList = new ArrayList();
        FsFolderParams fsFolderParams = new FsFolderParams();
        List roleList = UserInfoUtil.getCurrentUser().getRolesList();
        String userId = UserInfoUtil.getCurrentUser().getId();
        Integer adminFlag = CommonUtil.getAdminFlag((List)roleList);
        List<String> listGroup = this.docGroupService.getPremission(userId);
        fsFolderParams.setAdminFlag(adminFlag);
        fsFolderParams.setGroupList(listGroup);
        fsFolderParams.setUserId(userId);
        fsFolderParams.setType("2");
        String levelCodeString = this.businessService.getLevelCodeByUser(fsFolderParams);
        fsFolderParams.setLevelCodeString(levelCodeString);
        if ("#".equals(id)) {
            String idParam = "root";
            ArrayList<String> firstList = new ArrayList<String>();
            ArrayList<String> secondList = new ArrayList<String>();
            fsFolderParams.setId(idParam);
            fsFolderParams.setType(DocConstant.OPERATETYPE.FRONT.getValue());
            List<FsFolder> list = this.fsFolderService.getTreeDataLazy(fsFolderParams);
            for (int i = 0; i < list.size(); ++i) {
                FsFolder fsFile = list.get(i);
                firstList.add(fsFile.getFolderId());
            }
            List<FsFolder> childList = this.fsFolderService.getChildList(firstList, listGroup, userId, adminFlag, type, levelCodeString);
            for (int i = 0; i < childList.size(); ++i) {
                FsFolder fsFile = childList.get(i);
                secondList.add(fsFile.getFolderId());
            }
            List<Map> childCountList = this.fsFolderService.getChildCountList(secondList, listGroup, userId, adminFlag, type, levelCodeString);
            List<Map> childResultList = this.fsFolderService.checkChildCount(childList, childCountList);
            for (int i = 0; i < list.size(); ++i) {
                HashMap<String, Object> parentMap = new HashMap<String, Object>();
                FsFolder fsFile = list.get(i);
                parentMap.put("id", fsFile.getFolderId());
                parentMap.put("text", fsFile.getFolderName());
                ArrayList<Map> childMapList = new ArrayList<Map>();
                for (int j = 0; j < childResultList.size(); ++j) {
                    Map map = childResultList.get(j);
                    if (!fsFile.getFolderId().equals(map.get("pid"))) continue;
                    childMapList.add(map);
                }
                parentMap.put("children", childMapList);
                parentMap.put("opened", true);
                resultList.add(parentMap);
            }
        } else {
            ArrayList<String> firstList = new ArrayList<String>();
            fsFolderParams.setId(id);
            fsFolderParams.setType(type);
            List<FsFolder> list = this.fsFolderService.getTreeDataLazy(fsFolderParams);
            for (int i = 0; i < list.size(); ++i) {
                FsFolder fsFile = list.get(i);
                firstList.add(fsFile.getFolderId());
            }
            List<Map> childCountList = this.fsFolderService.getChildCountList(firstList, listGroup, userId, adminFlag, type, levelCodeString);
            resultList = this.fsFolderService.checkChildCount(list, childCountList);
        }
        return resultList;
    }

    @RequestMapping(value={"/move"})
    @ResponseBody
    public JSON move() {
        String userId = ShiroKit.getUser().getId();
        this.cacheToolService.updateLevelCodeCache(userId);
        List<String> listGroup = this.docGroupService.getPremission(userId);
        List roleList = ShiroKit.getUser().getRolesList();
        Integer adminFlag = CommonUtil.getAdminFlag((List)roleList);
        JSONObject json = new JSONObject();
        String fileId = super.getPara("fileId");
        if (ToolUtil.isEmpty((Object)fileId)) {
            fileId = "";
        }
        String folderId = super.getPara("folderId");
        boolean isChild = this.fsFileService.isChildren(folderId);
        String fileName = super.getPara("fileName");
        String[] strFileId = fileId.split(",");
        String[] strFileName = fileName.split(",");
        for (int i = 0; i < strFileId.length; ++i) {
            int isEdits;
            if (adminFlag != 1 && (isEdits = this.docFoldAuthorityService.findEdit(folderId, listGroup, userId)) != 2) {
                json.put("result", (Object)"3");
                return json;
            }
            if (this.iDocRecycleService.checkDocExist(folderId, strFileName[i])) {
                json.put("result", (Object)"0");
                return json;
            }
            if (this.fsFileService.remove(strFileId[i], folderId)) {
                json.put("result", (Object)"1");
                continue;
            }
            json.put("result", (Object)"2");
        }
        return json;
    }

    @RequestMapping(value={"/getMoveTreeDataLazyNew"})
    @ResponseBody
    public List getMoveTreeDataLazyNew(String id, String type) {
        List<Object> resultList = new ArrayList();
        FsFolderParams fsFolderParams = new FsFolderParams();
        List roleList = UserInfoUtil.getCurrentUser().getRolesList();
        String userId = UserInfoUtil.getCurrentUser().getId();
        Integer adminFlag = CommonUtil.getAdminFlag((List)roleList);
        List<String> listGroup = this.docGroupService.getPremission(userId);
        fsFolderParams.setAdminFlag(adminFlag);
        fsFolderParams.setGroupList(listGroup);
        fsFolderParams.setUserId(userId);
        fsFolderParams.setType("2");
        String levelCodeString = this.businessService.getLevelCodeByUserRecycle(fsFolderParams);
        fsFolderParams.setLevelCodeString(levelCodeString);
        if ("#".equals(id)) {
            String idParam = "root";
            ArrayList<String> firstList = new ArrayList<String>();
            ArrayList<String> secondList = new ArrayList<String>();
            fsFolderParams.setId(idParam);
            fsFolderParams.setType(DocConstant.OPERATETYPE.FRONT.getValue());
            List<FsFolder> list = this.fsFolderService.getTreeDataLazy(fsFolderParams);
            for (int i = 0; i < list.size(); ++i) {
                FsFolder fsFile = list.get(i);
                firstList.add(fsFile.getFolderId());
            }
            List<FsFolder> childList = this.fsFolderService.getChildList(firstList, listGroup, userId, adminFlag, type, levelCodeString);
            for (int i = 0; i < childList.size(); ++i) {
                FsFolder fsFile = childList.get(i);
                secondList.add(fsFile.getFolderId());
            }
            List<Map> childCountList = this.fsFolderService.getChildCountList(secondList, listGroup, userId, adminFlag, type, levelCodeString);
            List<Map> childResultList = this.fsFolderService.checkChildCount(childList, childCountList);
            for (int i = 0; i < list.size(); ++i) {
                HashMap<String, Object> parentMap = new HashMap<String, Object>();
                FsFolder fsFile = list.get(i);
                parentMap.put("id", fsFile.getFolderId());
                parentMap.put("text", fsFile.getFolderName());
                ArrayList<Map> childMapList = new ArrayList<Map>();
                for (int j = 0; j < childResultList.size(); ++j) {
                    Map map = childResultList.get(j);
                    if (!fsFile.getFolderId().equals(map.get("pid"))) continue;
                    childMapList.add(map);
                }
                parentMap.put("children", childMapList);
                parentMap.put("opened", true);
                resultList.add(parentMap);
            }
        } else {
            ArrayList<String> firstList = new ArrayList<String>();
            fsFolderParams.setId(id);
            fsFolderParams.setType(type);
            List<FsFolder> list = this.fsFolderService.getTreeDataLazy(fsFolderParams);
            for (int i = 0; i < list.size(); ++i) {
                FsFolder fsFile = list.get(i);
                firstList.add(fsFile.getFolderId());
            }
            List<Map> childCountList = this.fsFolderService.getChildCountList(firstList, listGroup, userId, adminFlag, type, levelCodeString);
            resultList = this.fsFolderService.checkChildCount(list, childCountList);
        }
        return resultList;
    }

    @RequestMapping(value={"/getPreviewType"})
    @ResponseBody
    public Map<String, String> getPreviewType(String docId, String suffix) {
        String json = "";
        suffix = suffix.substring(1, suffix.length());
        List<DocConfigure> typeList = this.docConfigureService.getConfigure();
        if (typeList.get(5).getConfigValue().contains(suffix.toLowerCase())) {
            HashMap<String, String> resultMap = new HashMap<String, String>();
            resultMap.put("code", "1");
            return resultMap;
        }
        if (typeList.get(6).getConfigValue().contains(suffix.toLowerCase())) {
            HashMap<String, String> resultMap = new HashMap<String, String>();
            resultMap.put("code", "2");
            return resultMap;
        }
        if (typeList.get(7).getConfigValue().contains(suffix.toLowerCase())) {
            HashMap<String, String> resultMap = new HashMap<String, String>();
            resultMap.put("code", "3");
            return resultMap;
        }
        if (typeList.get(8).getConfigValue().contains(suffix.toLowerCase())) {
            HashMap<String, String> resultMap = new HashMap<String, String>();
            resultMap.put("code", "4");
            return resultMap;
        }
        if (suffix.equals("component")) {
            HashMap<String, String> resultMap = new HashMap<String, String>();
            resultMap.put("code", "10");
            return resultMap;
        }
        HashMap<String, String> resultMap = new HashMap<String, String>();
        resultMap.put("code", "5");
        return resultMap;
    }
}

