/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.doc.manager.docmanager.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.jxdinfo.doc.common.constant.DocConstant;
import com.jxdinfo.doc.common.docutil.service.CacheToolService;
import com.jxdinfo.doc.common.util.ExceptionUtils;
import com.jxdinfo.doc.common.util.StringUtil;
import com.jxdinfo.doc.common.util.UserInfoUtil;
import com.jxdinfo.doc.manager.docmanager.model.DocUploadParams;
import com.jxdinfo.doc.manager.docmanager.service.DocInfoService;
import com.jxdinfo.doc.manager.docmanager.service.FilesService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/files"})
public class FilesController {
    private static Logger LOGGER = LoggerFactory.getLogger(FilesController.class);
    @Value(value="${fastdfs.using}")
    private boolean fastdfsUsingFlag;
    @Autowired
    private DocInfoService docInfoService;
    @Autowired
    private FilesService filesService;
    @Autowired
    private CacheToolService cacheToolService;

    @RequestMapping(value={"/uploadData"})
    @ResponseBody
    public String uploadData(MultipartFile file, DocUploadParams uploadParams) {
        String uploadData = uploadParams.getUploadData();
        Map<Object, Object> resultMap = new HashMap<String, Object>(16);
        if (uploadData == null) {
            resultMap.put("code", DocConstant.UPLOADRESULT.EMPTY.getValue());
            resultMap.put("successful", 0);
            return JSON.toJSONString(resultMap);
        }
        Double releaseSize = 0.0;
        final String docId = StringUtil.getUUID();
        try {
            uploadParams.setDocId(docId);
            resultMap = this.filesService.upload(file, uploadParams);
            Object obj = resultMap.get("releaseSize");
            if (obj == null) {
                resultMap.put("code", DocConstant.UPLOADRESULT.NOSPACE.getValue());
                resultMap.put("successful", 0);
                return JSON.toJSONString(resultMap);
            }
            releaseSize = StringUtil.getDouble((Object)obj);
        }
        catch (Exception e) {
            LOGGER.error("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25" + ExceptionUtils.getErrorInfo((Exception)e));
            e.printStackTrace();
            resultMap.put("code", DocConstant.UPLOADRESULT.FAIL.getValue());
            resultMap.put("successful", 0);
            return JSON.toJSONString(resultMap);
        }
        resultMap.put("docId", new ArrayList<String>(){
            private static final long serialVersionUID = 1L;
            {
                this.add(docId);
            }
        });
        String resultKey = "code";
        if (resultMap.get(resultKey) == null) {
            resultMap.put("code", DocConstant.UPLOADRESULT.SUCCESS.getValue());
            resultMap.put("successful", DocConstant.NUMBER.ONE.getValue());
        } else if (resultMap.get(resultKey) == DocConstant.UPLOADRESULT.FAIL.getValue()) {
            this.cacheToolService.updateDeptUsedSpace(UserInfoUtil.getCurrentUser().getDeptId(), releaseSize);
        }
        return JSON.toJSONString(resultMap);
    }

    @RequestMapping(value={"/fileDownNew"})
    public Object fileDownNew(String docIds, String docName, HttpServletRequest request, HttpServletResponse response) {
        try {
            this.filesService.download(docIds, docName, request, response);
        }
        catch (Exception e) {
            LOGGER.error("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25" + ExceptionUtils.getErrorInfo((Exception)e));
            e.printStackTrace();
            return "error";
        }
        return "success";
    }

    @RequestMapping(value={"/checkFileExist"})
    @ResponseBody
    public JSON checkFileExist(String uploadData, String pid) {
        List dataList = (List)JSON.parseObject((String)uploadData, (TypeReference)new TypeReference<List<Map<String, Object>>>(){}, (Feature[])new Feature[0]);
        JSONObject json = new JSONObject();
        ArrayList<String> docNameList = new ArrayList<String>();
        for (Map map : dataList) {
            String filename = map.get("docName").toString();
            String extendName = filename.substring(filename.lastIndexOf("."));
            String needCheckFileName = map.get("title").toString() + extendName;
            docNameList.add(needCheckFileName);
        }
        List<String> nameList = this.docInfoService.checkFileExist(docNameList, pid);
        json.put("result", nameList);
        return json;
    }

    @RequestMapping(value={"/getLoginUser"})
    @ResponseBody
    public JSON getLoginUser() {
        JSONObject json = new JSONObject();
        String userId = UserInfoUtil.getUserInfo().get("ID").toString();
        String userName = UserInfoUtil.getUserInfo().get("NAME").toString();
        json.put("userId", (Object)userId);
        json.put("userName", (Object)userName);
        return json;
    }
}

