/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.doc.manager.docintegral.service.impl;

import com.jxdinfo.doc.common.docutil.service.CacheToolService;
import com.jxdinfo.doc.manager.docintegral.dao.IntegralRuleMapper;
import com.jxdinfo.doc.manager.docintegral.service.IntegralRuleService;
import com.jxdinfo.hussar.core.cache.HussarCacheManager;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IntegralRuleServiceImpl
implements IntegralRuleService {
    @Resource
    private IntegralRuleMapper integralRuleMapper;
    @Resource
    private CacheToolService cacheToolService;
    @Autowired
    private HussarCacheManager hussarCacheManager;

    @Override
    public int newIntegralRule(Map map) {
        return this.integralRuleMapper.newIntegralRule(map);
    }

    @Override
    public int updateIntegralRule(Map map) {
        if (null != map.get("ruleCode")) {
            this.hussarCacheManager.setObject("RULECODELIST", "RULECODELIST" + map.get("ruleCode").toString(), null);
        }
        return this.integralRuleMapper.updateIntegralRule(map);
    }

    @Override
    public int getIntegralRuleCount() {
        return this.integralRuleMapper.getIntegralRuleCount();
    }

    @Override
    public List<Map> getIntegralRule(int startIndex, int pageSize) {
        return this.integralRuleMapper.getIntegralRule(startIndex, pageSize);
    }

    @Override
    public int inputCheck(Map map) {
        return this.integralRuleMapper.inputCheck(map);
    }

    @Override
    public Map getIntegralRuleById(String ruleId) {
        return this.integralRuleMapper.getIntegralRuleById(ruleId);
    }

    @Override
    public int deleteIntegralRule(String[] ids) {
        List<Map> rules = this.integralRuleMapper.getIntegralRuleByIds(ids);
        rules.forEach(rule -> {
            if (null != rule.get("ruleCode")) {
                String ruleCode = rule.get("ruleCode").toString();
                this.hussarCacheManager.setObject("RULECODELIST", "RULECODELIST" + ruleCode, null);
            }
        });
        return this.integralRuleMapper.deleteIntegralRule(ids);
    }

    @Override
    public List<Map<String, Object>> getRuleByCode(String code) {
        return this.cacheToolService.getRuleByCode(code);
    }
}

