/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.doc.manager.docintegral.controller;

import com.jxdinfo.doc.common.util.StringUtil;
import com.jxdinfo.doc.manager.docintegral.service.IntegralRuleService;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@RequestMapping(value={"/integralRule"})
@Controller
public class IntegralRuleController
extends BaseController {
    private String prefix = "/doc/manager/integral/";
    @Resource
    private IntegralRuleService integralRuleService;

    @RequestMapping(value={"/view"})
    public String integralRuleView() {
        return this.prefix + "rule_view.html";
    }

    @RequestMapping(value={"/list"})
    @ResponseBody
    public Map integralRuleList() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        int count = this.integralRuleService.getIntegralRuleCount();
        String page = super.getPara("page");
        int pageNum = Integer.parseInt(page);
        String size = super.getPara("limit");
        int pageSize = Integer.parseInt(size);
        int startIndex = (pageNum - 1) * pageSize;
        List<Map> list = this.integralRuleService.getIntegralRule(startIndex, pageSize);
        map.put("data", list);
        map.put("count", count);
        map.put("msg", "success");
        map.put("code", 0);
        return map;
    }

    @RequestMapping(value={"/add"})
    @ResponseBody
    public int newIntegralRule(@RequestParam Map map) {
        int check = this.integralRuleService.inputCheck(map);
        if (check != 0) {
            return 0;
        }
        map.put("ruleId", StringUtil.getUUID());
        if (StringUtil.checkIsEmpty((String)map.get("maxTimes").toString())) {
            map.put("maxTimes", -1);
        }
        return this.integralRuleService.newIntegralRule(map);
    }

    @RequestMapping(value={"/addView"})
    public String addView() {
        return this.prefix + "rule_add.html";
    }

    @RequestMapping(value={"/update"})
    @ResponseBody
    public int updateIntegralRule(@RequestParam Map map) {
        HashMap checkMap = new HashMap();
        checkMap.put("ruleName", map.get("ruleName"));
        checkMap.put("ruleId", map.get("ruleId"));
        int check = this.integralRuleService.inputCheck(checkMap);
        if (check != 0) {
            return 0;
        }
        if (StringUtil.checkIsEmpty((String)map.get("maxTimes").toString()) || "\u65e0\u4e0a\u9650".equals(map.get("maxTimes").toString())) {
            map.put("maxTimes", -1);
        }
        return this.integralRuleService.updateIntegralRule(map);
    }

    @RequestMapping(value={"/editView"})
    public String updateView(String ruleId, Model model) {
        Map rule = this.integralRuleService.getIntegralRuleById(ruleId);
        if (null != rule.get("maxTimes") && "-1".equals(rule.get("maxTimes").toString())) {
            rule.put("maxTimes", "\u65e0\u4e0a\u9650");
        }
        model.addAttribute("rule", (Object)rule);
        return this.prefix + "rule_edit.html";
    }

    @RequestMapping(value={"/delete"})
    @ResponseBody
    public int deleteIntegralRule(String[] ids) {
        return this.integralRuleService.deleteIntegralRule(ids);
    }
}

