/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.doc.manager.docintegral.controller;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.jxdinfo.doc.common.util.StringUtil;
import com.jxdinfo.doc.common.util.UserInfoUtil;
import com.jxdinfo.doc.manager.docintegral.service.IntegralRecordService;
import com.jxdinfo.doc.manager.docintegral.service.IntegralRuleService;
import com.jxdinfo.doc.manager.docmanager.service.DocInfoService;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/integral"})
public class IntegralRecordController
extends BaseController {
    private String prefix = "/doc/manager/integral/";
    @Resource
    private IntegralRecordService integralRecordService;
    @Resource
    private IntegralRuleService integralRuleService;
    @Resource
    private DocInfoService idocInfoService;

    @RequestMapping(value={"/rankView"})
    public String view() {
        return this.prefix + "integral_rank.html";
    }

    @RequestMapping(value={"/rankList"})
    @ResponseBody
    public Map rankList() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        int count = this.integralRecordService.getIntegralUserCount();
        String page = super.getPara("page");
        int pageNum = Integer.parseInt(page);
        String size = super.getPara("limit");
        int pageSize = Integer.parseInt(size);
        int startIndex = (pageNum - 1) * pageSize;
        List<Map<String, Object>> list = this.integralRecordService.getIntegralRank(startIndex, pageSize);
        map.put("data", list);
        map.put("count", count);
        map.put("msg", "success");
        map.put("code", 0);
        return map;
    }

    @RequestMapping(value={"/addIntegral"})
    @ResponseBody
    public Map addIntegral(String docId, String ruleCode) {
        String docAuthorId = "";
        if (!StringUtil.checkIsEmpty((String)docId)) {
            docAuthorId = this.idocInfoService.getDocDetail(docId).getAuthorId();
        }
        Integer integral = 0;
        String msg = "";
        HashMap<String, Object> result = new HashMap<String, Object>();
        String userId = ShiroKit.getUser().getId();
        switch (ruleCode) {
            case "login": 
            case "search": {
                integral = this.integralRecordService.addIntegral(null, userId, ruleCode);
                msg = msg + "+" + integral + "";
                break;
            }
            case "download": 
            case "share": 
            case "preview": {
                if (docAuthorId.equals(userId)) {
                    return null;
                }
                if (this.integralRecordService.selectCount(new EntityWrapper().eq("doc_id", (Object)docId).eq("user_id", (Object)userId).eq("operate_rule_code", (Object)ruleCode)) > 0) {
                    return null;
                }
                integral = this.integralRecordService.addIntegral(docId, userId, ruleCode);
                if (integral == null) {
                    return null;
                }
                if (integral == 0 && "download".equals(ruleCode)) {
                    msg = msg + "\u79ef\u5206\u4e0d\u8db3";
                    break;
                }
                if (integral == 0) {
                    msg = msg + integral + "";
                    break;
                }
                String captureName = StringUtil.captureName((String)ruleCode);
                String beRuleCoded = captureName.substring(captureName.length() - 1).equals("e") ? "be" + captureName + "d" : "be" + captureName + "ed";
                this.integralRecordService.addIntegral(docId, docAuthorId, beRuleCoded);
                if (integral > 0) {
                    msg = msg + "+" + integral + "";
                    break;
                }
                msg = msg + integral + "";
                break;
            }
            case "upload": {
                integral = this.integralRecordService.addIntegral(docId, userId, ruleCode);
                msg = msg + "+" + integral + "";
                break;
            }
        }
        result.put("msg", msg);
        result.put("integral", integral);
        return result;
    }

    @RequestMapping(value={"/integralForMulDownLoad"})
    @ResponseBody
    public Map integralForMulDownLoad(String[] ids, String ruleCode) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String userId = ShiroKit.getUser().getId();
        Integer myDocs = this.integralRecordService.selectDocCountByUser(ids, userId);
        int downloadedNum = this.integralRecordService.selectDownloadedCount(ids, userId);
        Integer integralCount = this.integralRecordService.showIntegral(userId);
        String status = "";
        Integer ruleIntegral = 0;
        Integer maxTimes = 0;
        if (userId.equals("superadmin") || userId.equals("wkadmin")) {
            status = "2";
            result.put("status", status);
            return result;
        }
        if (!"".equals(ruleCode) && ruleCode != null) {
            List<Map<String, Object>> list = this.integralRuleService.getRuleByCode(ruleCode);
            if (list == null || list.size() == 0) {
                status = "2";
                result.put("status", status);
                return result;
            }
            Map<String, Object> map = list.get(0);
            if (map.get("valid").equals("0")) {
                status = "2";
                result.put("status", status);
                return result;
            }
            ruleIntegral = (Integer)map.get("ruleIntegral");
            maxTimes = (Integer)map.get("max_times");
        }
        int amount = ids.length - (myDocs + downloadedNum);
        Integer integral = 0;
        if (amount * Math.abs(ruleIntegral) > integralCount) {
            status = "-1";
            result.put("status", status);
            result.put("msg", "\u79ef\u5206\u4e0d\u8db3");
            result.put("integral", 0);
            return result;
        }
        Integer todayTimes = this.integralRecordService.getIntegralTimesByToday(userId, ruleCode);
        if (maxTimes != -1 && maxTimes < todayTimes + ids.length) {
            status = "-1";
            result.put("msg", "\u5df2\u8fbe\u4e0a\u9650");
            result.put("status", status);
            return result;
        }
        status = "2";
        for (String id : ids) {
            Map map = this.addIntegral(id, ruleCode);
            if (null == map) continue;
            status = "1";
            integral = integral + Integer.parseInt(map.get("integral").toString());
        }
        result.put("status", status);
        result.put("msg", integral);
        result.put("integral", integral);
        return result;
    }

    @RequestMapping(value={"/getTotalIntegral"})
    @ResponseBody
    public Integer getTotalIntegral() {
        return this.integralRecordService.showIntegral(ShiroKit.getUser().getId());
    }

    @RequestMapping(value={"/downloadIntegral"})
    @ResponseBody
    public Map downloadIntegral(String docId, String ruleCode) {
        List<Map<String, Object>> list = this.integralRuleService.getRuleByCode("download");
        HashMap<String, String> result = new HashMap<String, String>();
        Integer rank = 0;
        Integer addRank = Integer.parseInt(list.get(0).get("ruleIntegral") + "");
        if (!list.get(0).get("valid").equals("1")) {
            result.put("status", "0");
            return result;
        }
        String[] docIds = docId.split(",");
        String userId = UserInfoUtil.getUserInfo().get("ID").toString();
        String docAuthorId = "";
        boolean flag = true;
        for (int i = 0; i < docIds.length; ++i) {
            if (!StringUtil.checkIsEmpty((String)docIds[i])) {
                docAuthorId = this.idocInfoService.getDocDetail(docIds[i]).getAuthorId();
            }
            if (userId.equals("wkadmin") || userId.equals("superadmin")) {
                result.put("status", "0");
                return result;
            }
            if (docAuthorId.equals(userId) || this.integralRecordService.selectCount(new EntityWrapper().eq("doc_id", (Object)docIds[i]).eq("user_id", (Object)userId).eq("operate_rule_code", (Object)ruleCode)) > 0 || this.integralRecordService.checkInDoc(docIds[i]) > 0) continue;
            flag = false;
            rank = addRank + rank;
        }
        if (flag) {
            result.put("status", "0");
            return result;
        }
        String integral = rank + "";
        if (integral.substring(0, 1).equals("-")) {
            integral = integral.substring(1);
        }
        result.put("integral", integral);
        result.put("status", "1");
        return result;
    }
}

