/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.doc.manager.docbanner.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.toolkit.IdWorker;
import com.jxdinfo.doc.common.util.StringUtil;
import com.jxdinfo.doc.manager.docbanner.model.DocBanner;
import com.jxdinfo.doc.manager.docbanner.service.BannerService;
import com.jxdinfo.doc.manager.docmanager.model.FsFile;
import com.jxdinfo.doc.manager.docmanager.service.FilesService;
import com.jxdinfo.doc.manager.docmanager.service.FsFileService;
import com.jxdinfo.hussar.bsp.permit.service.ISysIdtableService;
import com.jxdinfo.hussar.common.exception.BizExceptionEnum;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.core.exception.ServiceExceptionEnum;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/banner"})
public class BannerController {
    @Autowired
    private BannerService bannerService;
    @Value(value="${docbase.uploadPath}")
    private String base;
    @Value(value="${docbase.filedir}")
    private String uploadPath;
    @Autowired
    private FilesService filesService;
    @Autowired
    private FsFileService fsFileService;
    @Autowired
    private ISysIdtableService sysIdtableService;

    @RequestMapping(value={"/bannerListView"})
    public String topicListView() {
        return "/doc/manager/docbanner/banner-list.html";
    }

    @RequestMapping(value={"/bannerList"})
    @ResponseBody
    public JSON getTopicList(String bannerName, int page, int limit) {
        int beginIndex = page * limit - limit;
        String bannerNameStr = StringUtil.transferSqlParam((String)bannerName);
        List<DocBanner> bannerList = this.bannerService.bannerList(bannerNameStr, beginIndex, limit);
        int bannerCount = this.bannerService.bannerListCount(bannerNameStr);
        JSONObject json = new JSONObject();
        json.put("count", (Object)bannerCount);
        json.put("data", bannerList);
        json.put("msg", (Object)"success");
        json.put("code", (Object)0);
        return json;
    }

    @RequestMapping(value={"/bannerAdd"})
    public String bannerAdd(Model model) {
        String currentCode = this.sysIdtableService.getCurrentCode("BANNER_NUM", "doc_banner_file");
        int num = Integer.parseInt(currentCode);
        model.addAttribute("lastNum", (Object)num);
        model.addAttribute("num", (Object)(num + 1));
        return "/doc/manager/docbanner/banner-add.html";
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/upload"})
    @ResponseBody
    public JSONObject upload(@RequestPart(value="file") MultipartFile file) {
        JSONObject json = new JSONObject();
        String fileName = file.getOriginalFilename();
        String prefix = fileName.substring(fileName.lastIndexOf("."));
        String fName = IdWorker.get32UUID() + prefix;
        try {
            String filePath = this.filesService.upload(file, fName);
            json.put("fName", (Object)filePath);
            json.put("fileName", (Object)fileName);
        }
        catch (IOException e) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.UPLOAD_ERROR);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return json;
    }

    @RequestMapping(value={"/addBanner"})
    @ResponseBody
    public JSON addBanner(DocBanner docBanner, String docIds) {
        String bannerId = UUID.randomUUID().toString().replaceAll("-", "");
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        docBanner.setBannerId(bannerId);
        docBanner.setCreateTime(ts);
        JSONObject json = new JSONObject();
        int num = this.bannerService.checkBannerExist(docBanner);
        if (num > 0) {
            json.put("result", (Object)"0");
        } else {
            int addNum = this.bannerService.addBanner(docBanner);
            if (addNum == 1) {
                json.put("result", (Object)"1");
            } else {
                json.put("result", (Object)"2");
            }
        }
        return json;
    }

    @RequestMapping(value={"/bannerEdit"})
    public String bannerEdit(Model model, String bannerId) {
        DocBanner docBanner = this.bannerService.searchBannerDetail(bannerId);
        try {
            String topicCover = URLEncoder.encode(docBanner.getBannerPath(), "UTF-8");
            docBanner.setBannerPath(topicCover);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        int num = this.bannerService.getMaxOrder();
        model.addAttribute("lastNum", (Object)num);
        model.addAttribute("docBanner", (Object)docBanner);
        return "/doc/manager/docbanner/banner-edit.html";
    }

    @RequestMapping(value={"/editBanner"})
    @ResponseBody
    public JSON editBanner(DocBanner docBanner, String docIds) {
        JSONObject json = new JSONObject();
        int num = this.bannerService.checkBannerExist(docBanner);
        if (num > 0) {
            json.put("result", (Object)"0");
        } else {
            int editNum = this.bannerService.editBanner(docBanner);
            if (editNum == 1) {
                json.put("result", (Object)"1");
            } else {
                json.put("result", (Object)"2");
            }
        }
        return json;
    }

    @RequestMapping(value={"/bannerView"})
    public String topicView(Model model, String bannerId) {
        DocBanner docBanner = this.bannerService.searchBannerDetail(bannerId);
        try {
            String topicCover = URLEncoder.encode(docBanner.getBannerPath(), "UTF-8");
            docBanner.setBannerPath(topicCover);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        int num = this.bannerService.getMaxOrder();
        model.addAttribute("lastNum", (Object)num);
        model.addAttribute("docBanner", (Object)docBanner);
        return "/doc/manager/docbanner/banner-view.html";
    }

    @RequestMapping(value={"/delBanners"})
    @ResponseBody
    public int delBannersById(String ids) {
        List<String> list = Arrays.asList(ids.split(","));
        return this.bannerService.delBanners(list);
    }

    @RequestMapping(value={"/moveBanner"})
    @ResponseBody
    public int moveBanner(String table, String idColumn, String idOne, String idTwo) {
        int num = this.bannerService.moveBanner(table, idColumn, idTwo, idOne);
        return num;
    }

    @RequestMapping(value={"/openDoc"})
    public String index() {
        return "/doc/manager/docbanner/banner-open-doc.html";
    }

    @RequestMapping(value={"/bannerName"})
    @ResponseBody
    public String bannerName(String docId) {
        FsFile fsFile = (FsFile)((Object)this.fsFileService.selectById((Serializable)((Object)docId)));
        String str = fsFile.getFileType();
        return str;
    }
}

