/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.doc.front.personalmanager.controller;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.jxdinfo.doc.common.docutil.service.BusinessService;
import com.jxdinfo.doc.common.util.CommonUtil;
import com.jxdinfo.doc.common.util.UserInfoUtil;
import com.jxdinfo.doc.front.personalmanager.service.DocVersionService;
import com.jxdinfo.doc.manager.docintegral.service.IntegralRecordService;
import com.jxdinfo.doc.manager.docmanager.service.FsFileService;
import com.jxdinfo.doc.manager.foldermanager.model.FsFolderParams;
import com.jxdinfo.doc.manager.foldermanager.service.IFsFolderService;
import com.jxdinfo.doc.manager.groupmanager.service.DocGroupService;
import com.jxdinfo.doc.manager.personalcenter.service.PersonalOperateService;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/personalcenter"})
public class PersonalCenterController {
    @Autowired
    private IntegralRecordService integralRecordService;
    @Autowired
    private IFsFolderService fsFolderService;
    @Resource
    private BusinessService businessService;
    @Resource
    private PersonalOperateService operateService;
    @Autowired
    private DocGroupService docGroupService;
    @Autowired
    private FsFileService fsFileService;
    @Autowired
    private DocVersionService docVersionService;

    @RequestMapping(value={""})
    public String index(Model model, @RequestParam(defaultValue="false") boolean toUpload, String menu) {
        String userId = UserInfoUtil.getUserInfo().get("ID").toString();
        String userName = ShiroKit.getUser().getName();
        model.addAttribute("userName", (Object)userName);
        Integer totalIntegral = this.integralRecordService.showIntegral(userId);
        List roleList = ShiroKit.getUser().getRolesList();
        Integer adminFlag = CommonUtil.getAdminFlag((List)roleList);
        if (userId.equals("wkadmin") || userId.equals("superadmin")) {
            model.addAttribute("adminFlag", (Object)1);
        } else {
            model.addAttribute("adminFlag", (Object)2);
        }
        model.addAttribute("totalIntegral", (Object)totalIntegral);
        int uploadNum = this.fsFolderService.getPersonUploadNum(userId, null);
        model.addAttribute("uploadNum", (Object)uploadNum);
        int downloadNum = this.operateService.getMyHistoryCount(userId, "4", "");
        model.addAttribute("downloadNum", (Object)downloadNum);
        model.addAttribute("toUpload", (Object)toUpload);
        model.addAttribute("menu", (Object)menu);
        model.addAttribute("isPersonCenter", (Object)true);
        return "/doc/front/personalcenter/member_center.html";
    }

    @RequestMapping(value={"/getInfo"})
    @ResponseBody
    public Object getInfo(@RequestParam String ids) {
        String[] strArr = ids.split(",");
        ArrayList<String> idList = new ArrayList<String>();
        for (String element : strArr) {
            idList.add(element);
        }
        String userId = UserInfoUtil.getCurrentUser().getId();
        HashMap<String, String> result = new HashMap<String, String>(5);
        List<String> listGroup = this.docGroupService.getPremission(userId);
        FsFolderParams fsFolderParams = new FsFolderParams();
        fsFolderParams.setGroupList(listGroup);
        fsFolderParams.setUserId(userId);
        fsFolderParams.setType("2");
        String levelCode = this.businessService.getLevelCodeByUserUpload(fsFolderParams);
        String orgId = ShiroKit.getUser().getDeptName();
        List<Map> list = this.fsFileService.getInfo(idList, userId, listGroup, levelCode, orgId);
        List roleList = ShiroKit.getUser().getRolesList();
        Integer adminFlag = CommonUtil.getAdminFlag((List)roleList);
        boolean fileState = false;
        if (list != null && list.size() != 0) {
            Integer validFlag = Integer.parseInt(list.get(0).get("validFlag").toString());
            if (validFlag == 0) {
                if (this.docVersionService.selectCount(new EntityWrapper().eq("doc_id", (Object)list.get(0).get("fileId").toString())) == 0) {
                    result.put("result", "1");
                } else {
                    result.put("result", "5");
                }
            } else {
                if (adminFlag == 1) {
                    result.put("result", "4");
                    return result;
                }
                if (list.get(0).get("authority") == null) {
                    result.put("result", "2");
                } else {
                    Integer power = Integer.parseInt(list.get(0).get("authority").toString());
                    if (power < 1) {
                        result.put("result", "3");
                    }
                }
            }
        }
        return result;
    }
}

