/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.doc.front.personalmanager.controller;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.jxdinfo.doc.common.constant.DocConstant;
import com.jxdinfo.doc.common.util.CommonUtil;
import com.jxdinfo.doc.common.util.ESUtil;
import com.jxdinfo.doc.common.util.UserInfoUtil;
import com.jxdinfo.doc.front.personalmanager.model.DocVersion;
import com.jxdinfo.doc.front.personalmanager.service.DocVersionService;
import com.jxdinfo.doc.manager.docmanager.model.DocFileAuthority;
import com.jxdinfo.doc.manager.docmanager.model.DocInfo;
import com.jxdinfo.doc.manager.docmanager.service.DocFileAuthorityService;
import com.jxdinfo.doc.manager.docmanager.service.DocInfoService;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/frontVersion"})
public class FrontVersionController {
    @Autowired
    private DocVersionService docVersionService;
    @Autowired
    private DocInfoService docInfoService;
    @Autowired
    private DocFileAuthorityService docFileAuthorityService;
    @Autowired
    private ESUtil esUtil;

    @RequestMapping(value={"/viewUpload"})
    public String viewUploadVersion(Model model, String openFileId, String path, String oldDocId, String type) {
        try {
            String filePath = null;
            filePath = path != null ? URLDecoder.decode(path, "UTF-8") : path;
            String userId = UserInfoUtil.getUserInfo().get("ID").toString();
            String userName = ShiroKit.getUser().getName();
            model.addAttribute("userName", (Object)userName);
            model.addAttribute("userId", (Object)userId);
            model.addAttribute("openFileId", (Object)openFileId);
            model.addAttribute("path", (Object)filePath);
            model.addAttribute("oldDocId", (Object)oldDocId);
            model.addAttribute("fileType", (Object)type);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return "/doc/front/personalcenter/uploadVersion.html";
    }

    @RequestMapping(value={"/viewHistory"})
    public String viewHistoryVersions(Model model, String oldDocId) {
        model.addAttribute("oldDocId", (Object)oldDocId);
        return "/doc/front/personalcenter/versionHistory.html";
    }

    @RequestMapping(value={"/list"})
    @ResponseBody
    public Map list(String name, @RequestParam(value="pageNumber", defaultValue="1") int pageNumber, @RequestParam(defaultValue="7") int pageSize, String oldDocId, String order) {
        int beginIndex = pageNumber * pageSize - pageSize;
        List roleList = ShiroKit.getUser().getRolesList();
        Integer adminFlag = CommonUtil.getAdminFlag((List)roleList);
        List<DocInfo> list = this.docVersionService.selectVersionHistoriesByDocId(oldDocId, order, name);
        int count = list.size();
        list = list.stream().skip(beginIndex).limit(pageSize).collect(Collectors.toList());
        HashMap<String, Object> histories = new HashMap<String, Object>();
        histories.put("msg", "success");
        histories.put("code", 0);
        histories.put("adminFlag", adminFlag);
        histories.put("rows", list);
        histories.put("count", count);
        return histories;
    }

    @RequestMapping(value={"/deleteVersion"})
    @ResponseBody
    public int deleteVersion(String histories) {
        String[] docIds = histories.split(",");
        return this.docVersionService.updateValidFlag(docIds);
    }

    @RequestMapping(value={"/setVersion"})
    @ResponseBody
    public String setVersion(String oldDocId, String docId) {
        String userId = ShiroKit.getUser().getId();
        DocInfo oldDoc = (DocInfo)this.docInfoService.selectById((Serializable)((Object)oldDocId));
        DocInfo doc = (DocInfo)this.docInfoService.selectById((Serializable)((Object)docId));
        doc.setDownloadNum(oldDoc.getDownloadNum());
        doc.setReadNum(oldDoc.getReadNum());
        doc.setTags(oldDoc.getTags());
        doc.setShareFlag(oldDoc.getShareFlag());
        doc.setValidFlag("1");
        oldDoc.setValidFlag("0");
        HashMap<String, Object> map = new HashMap<String, Object>(1);
        map.put("recycle", DocConstant.VALIDTYPE.INVALID.getValue());
        boolean validOld = this.esUtil.updateIndex(oldDocId, map) != 0;
        map.put("recycle", DocConstant.VALIDTYPE.VALID.getValue());
        boolean validNew = this.esUtil.updateIndex(docId, map) != 0;
        ArrayList<DocInfo> docInfos = new ArrayList<DocInfo>();
        docInfos.add(doc);
        docInfos.add(oldDoc);
        boolean infoFlag = this.docInfoService.updateBatchById(docInfos);
        this.docFileAuthorityService.delete(new EntityWrapper().eq("file_id", (Object)docId));
        ArrayList<String> indexList = new ArrayList<String>();
        List list = this.docFileAuthorityService.selectList(new EntityWrapper().eq("file_id", (Object)oldDocId));
        for (int i = 0; i < list.size(); ++i) {
            DocFileAuthority item = (DocFileAuthority)((Object)list.get(i));
            String esId = item.getAuthorId();
            if (item.getAuthorType() == 2) {
                esId = item.getOrganId();
            }
            indexList.add(esId);
            ((DocFileAuthority)((Object)list.get(i))).setFileId(docId);
            ((DocFileAuthority)((Object)list.get(i))).setFileAuthorityId(null);
        }
        indexList.add(userId);
        HashMap<String, Object> mapEs = new HashMap<String, Object>(1);
        mapEs.put("permission", indexList.toArray(new String[indexList.size()]));
        boolean esFlag = this.esUtil.updateIndex(docId, mapEs) != 0;
        boolean authorityFlag = true;
        if (list.size() > 0) {
            authorityFlag = this.docFileAuthorityService.insertBatch(list);
        }
        DocVersion docVersion = new DocVersion();
        docVersion.setApplyTime(new Timestamp(System.currentTimeMillis()));
        docVersion.setApplyUserId(userId);
        boolean timeFlag = this.docVersionService.update((Object)docVersion, new EntityWrapper().eq("doc_id", (Object)docId));
        return (infoFlag && esFlag && authorityFlag && timeFlag && validOld && validNew) + "";
    }
}

