/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.doc.front.personalmanager.controller;

import com.jxdinfo.doc.common.docutil.service.BusinessService;
import com.jxdinfo.doc.common.util.CommonUtil;
import com.jxdinfo.doc.common.util.UserInfoUtil;
import com.jxdinfo.doc.front.groupmanager.service.FrontDocGroupService;
import com.jxdinfo.doc.front.personalmanager.service.FrontUploadService;
import com.jxdinfo.doc.manager.foldermanager.model.FsFolder;
import com.jxdinfo.doc.manager.foldermanager.model.FsFolderParams;
import com.jxdinfo.doc.manager.foldermanager.service.IDocFoldAuthorityService;
import com.jxdinfo.doc.manager.foldermanager.service.IFsFolderService;
import com.jxdinfo.doc.manager.groupmanager.service.DocGroupService;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/frontUpload"})
public class FrontUploadController {
    @Autowired
    private DocGroupService docGroupService;
    @Resource
    private IFsFolderService fsFolderService;
    @Autowired
    private IDocFoldAuthorityService docFoldAuthorityService;
    @Resource
    private BusinessService businessService;
    @Resource
    private FrontUploadService frontUploadService;
    @Resource
    private FrontDocGroupService frontDocGroupService;

    @RequestMapping(value={"/list"})
    public String index(Model model) {
        String userId = UserInfoUtil.getUserInfo().get("ID").toString();
        String userName = ShiroKit.getUser().getName();
        model.addAttribute("userName", (Object)userName);
        return "/doc/front/personalcenter/upload.html";
    }

    @RequestMapping(value={"/upload"})
    public String upload(Model model, String openFileId, String folderName, String returnDocId) {
        try {
            String filePath = null;
            filePath = folderName != null ? URLDecoder.decode(folderName, "UTF-8") : folderName;
            String userId = UserInfoUtil.getUserInfo().get("ID").toString();
            String userName = ShiroKit.getUser().getName();
            model.addAttribute("userName", (Object)userName);
            model.addAttribute("openFileId", (Object)openFileId);
            model.addAttribute("folderName", (Object)filePath);
            model.addAttribute("returnDocId", (Object)(returnDocId == null ? "" : returnDocId));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return "/doc/front/personalcenter/uploadList.html";
    }

    @RequestMapping(value={"/uploadFile"})
    public String uploadFile(Model model, String openFileId, String path) {
        try {
            String filePath = null;
            filePath = path != null ? URLDecoder.decode(path, "UTF-8") : path;
            String userId = UserInfoUtil.getUserInfo().get("ID").toString();
            String userName = ShiroKit.getUser().getName();
            model.addAttribute("userName", (Object)userName);
            model.addAttribute("userId", (Object)userId);
            model.addAttribute("openFileId", (Object)openFileId);
            model.addAttribute("path", (Object)filePath);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return "/doc/front/personalcenter/uploadFile.html";
    }

    @RequestMapping(value={"/folderList"})
    @ResponseBody
    public Object folderList(String id, String type) {
        FsFolder folder;
        String userId = UserInfoUtil.getUserInfo().get("ID").toString();
        String userName = ShiroKit.getUser().getName();
        FsFolderParams fsFolderParams = new FsFolderParams();
        List<Object> resultList = new ArrayList();
        if ("#".equals(id)) {
            String fid = "2bb61cdb2b3c11e8aacf429ff4208431";
            folder = (FsFolder)((Object)this.fsFolderService.selectById((Serializable)((Object)fid)));
        } else {
            folder = (FsFolder)((Object)this.fsFolderService.selectById((Serializable)((Object)id)));
        }
        List roleList = ShiroKit.getUser().getRolesList();
        List<String> listGroup = this.frontDocGroupService.getPremission(userId);
        Integer adminFlag = CommonUtil.getAdminFlag((List)roleList);
        fsFolderParams.setAdminFlag(adminFlag);
        fsFolderParams.setGroupList(listGroup);
        fsFolderParams.setUserId(userId);
        fsFolderParams.setType(type);
        fsFolderParams.setLevelCodeString(folder.getLevelCode());
        String levelCodeString = this.businessService.getUploadLevelCodeFront(fsFolderParams);
        fsFolderParams.setLevelCodeString(levelCodeString);
        List<Object> list = new ArrayList();
        if ("#".equals(id)) {
            String idParam = "root";
            fsFolderParams.setId(idParam);
            fsFolderParams.setType("0");
            list = this.frontUploadService.getTreeDataLazy(fsFolderParams);
            ArrayList<String> firstList = new ArrayList<String>();
            for (int i = 0; i < list.size(); ++i) {
                FsFolder fsFolder = (FsFolder)((Object)list.get(i));
                firstList.add(fsFolder.getFolderId());
            }
            List<FsFolder> childList = this.frontUploadService.getChildList(firstList, listGroup, userId, adminFlag, type, levelCodeString);
            ArrayList<String> secondList = new ArrayList<String>();
            for (int i = 0; i < childList.size(); ++i) {
                FsFolder fsFolder = childList.get(i);
                secondList.add(fsFolder.getFolderId());
            }
            List<Map> childCountList = this.frontUploadService.getChildCountList(secondList, listGroup, userId, adminFlag, type, levelCodeString);
            List<Map> childResultList = this.frontUploadService.checkChildCount(childList, childCountList);
            for (int i = 0; i < list.size(); ++i) {
                HashMap<String, Object> parentMap = new HashMap<String, Object>();
                FsFolder fsFolder = (FsFolder)((Object)list.get(i));
                parentMap.put("id", fsFolder.getFolderId());
                parentMap.put("text", fsFolder.getFolderName());
                ArrayList<Map> childMapList = new ArrayList<Map>();
                for (int j = 0; j < childResultList.size(); ++j) {
                    Map map = childResultList.get(j);
                    if (!fsFolder.getFolderId().equals(map.get("pid"))) continue;
                    childMapList.add(map);
                }
                parentMap.put("children", childMapList);
                parentMap.put("opened", true);
                resultList.add(parentMap);
            }
        } else {
            fsFolderParams.setId(id);
            fsFolderParams.setType(type);
            list = this.frontUploadService.getTreeDataLazy(fsFolderParams);
            ArrayList<String> firstList = new ArrayList<String>();
            for (int i = 0; i < list.size(); ++i) {
                FsFolder fsFolder = (FsFolder)((Object)list.get(i));
                firstList.add(fsFolder.getFolderId());
            }
            List<Map> childCountList = this.frontUploadService.getChildCountList(firstList, listGroup, userId, adminFlag, type, levelCodeString);
            resultList = this.frontUploadService.checkChildCount(list, childCountList);
        }
        return resultList;
    }

    @RequestMapping(value={"/changeFolder"})
    @ResponseBody
    public Object changeFolder(String id) {
        String userId = ShiroKit.getUser().getId();
        List<String> listGroup = this.docGroupService.getPremission(userId);
        List roleList = ShiroKit.getUser().getRolesList();
        Integer adminFlag = CommonUtil.getAdminFlag((List)roleList);
        HashMap<String, Integer> result = new HashMap<String, Integer>(5);
        if (adminFlag != 1) {
            int isEdits = this.docFoldAuthorityService.findEditByUpload(id, listGroup, userId);
            result.put("noChildPower", isEdits);
        } else {
            result.put("noChildPower", 2);
        }
        return result;
    }
}

