/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.doc.front.homemanager.controller;

import com.baomidou.mybatisplus.plugins.Page;
import com.jxdinfo.doc.common.docutil.service.BusinessService;
import com.jxdinfo.doc.common.docutil.service.CacheToolService;
import com.jxdinfo.doc.common.docutil.service.DocConfigService;
import com.jxdinfo.doc.common.util.CommonUtil;
import com.jxdinfo.doc.common.util.FileTool;
import com.jxdinfo.doc.common.util.UserInfoUtil;
import com.jxdinfo.doc.front.docmanager.service.FrontFsFileService;
import com.jxdinfo.doc.front.foldermanager.service.FrontFolderService;
import com.jxdinfo.doc.front.groupmanager.service.FrontDocGroupService;
import com.jxdinfo.doc.front.topicmanager.service.FrontTopicService;
import com.jxdinfo.doc.manager.docmanager.model.DocInfo;
import com.jxdinfo.doc.manager.docmanager.model.FsFolderView;
import com.jxdinfo.doc.manager.foldermanager.model.FsFolder;
import com.jxdinfo.doc.manager.foldermanager.model.FsFolderParams;
import com.jxdinfo.doc.manager.statistics.service.FileStatisticsService;
import com.jxdinfo.doc.manager.topicmanager.model.SpecialTopic;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.cache.HussarCacheManager;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class IndexController
extends BaseController {
    private static Logger LOGGER = LoggerFactory.getLogger(IndexController.class);
    @Autowired
    private HussarCacheManager hussarCacheManager;
    @Autowired
    private DocConfigService docConfigService;
    @Autowired
    private FrontFsFileService frontFsFileService;
    @Autowired
    private FrontTopicService frontTopicService;
    @Autowired
    private CacheToolService cacheToolService;
    @Autowired
    private FrontFolderService frontFolderService;
    @Autowired
    private FrontDocGroupService frontDocGroupService;
    @Resource
    private BusinessService businessService;
    @Autowired
    private FileStatisticsService fileStatisticsService;
    @Value(value="${company.using}")
    private boolean companyFlag;

    @RequestMapping(value={"/"})
    public String showIndexView(Model model) {
        if (ToolUtil.isEmpty((Object)ShiroKit.getUser())) {
            return BaseController.REDIRECT + "/login";
        }
        String id = UserInfoUtil.getUserInfo().get("ID").toString();
        String username = UserInfoUtil.getUserInfo().get("NAME").toString();
        String userId = UserInfoUtil.getUserInfo().get("ID").toString();
        List<String> listGroup = this.frontDocGroupService.getPremission(userId);
        List roleList = ShiroKit.getUser().getRolesList();
        Integer adminFlag = CommonUtil.getAdminFlag((List)roleList);
        List<FsFolder> fsList = this.frontFsFileService.getFsFileList(userId, listGroup, adminFlag);
        List<SpecialTopic> topicList = this.frontTopicService.getTopicList(0, 4);
        try {
            String groupIds = String.join((CharSequence)",", listGroup);
            String orgId = ShiroKit.getUser().getDeptName();
            this.cacheToolService.updateLevelCodeCache(userId);
            if (topicList != null && topicList.size() > 0) {
                for (SpecialTopic specialTopic : topicList) {
                    String topicId = specialTopic.getTopicId();
                    String topicCover = URLEncoder.encode(specialTopic.getTopicCover(), "UTF-8");
                    specialTopic.setTopicCover(topicCover);
                    FsFolderParams fsFolderParams = new FsFolderParams();
                    fsFolderParams.setGroupList(listGroup);
                    fsFolderParams.setUserId(userId);
                    fsFolderParams.setType("2");
                    String levelCode = this.businessService.getLevelCodeByUserUpload(fsFolderParams);
                    List docList = this.frontTopicService.getDocByTopicId(topicId, "create_time", 0, 5, userId, listGroup, levelCode, adminFlag, orgId);
                    specialTopic.setDocList(docList);
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        int fileCount = this.fileStatisticsService.getFilesCount();
        model.addAttribute("userId", (Object)id);
        model.addAttribute("userName", (Object)username);
        model.addAttribute("isPersonCenter", (Object)false);
        model.addAttribute("fsFileList", fsList);
        model.addAttribute("topicList", topicList);
        model.addAttribute("fileCount", (Object)fileCount);
        if (userId.equals("wkadmin") || userId.equals("superadmin")) {
            model.addAttribute("adminFlag", (Object)1);
        } else {
            model.addAttribute("adminFlag", (Object)2);
        }
        if (this.companyFlag) {
            return "/doc/front/homemanager/index.html";
        }
        return "/doc/front/homemanager/index2.html";
    }

    @RequestMapping(value={"/getNav"})
    @ResponseBody
    public List getNav() {
        String userId = UserInfoUtil.getUserInfo().get("ID").toString();
        List<String> listGroup = this.frontDocGroupService.getPremission(userId);
        List roleList = ShiroKit.getUser().getRolesList();
        Integer adminFlag = CommonUtil.getAdminFlag((List)roleList);
        List<FsFolder> fsList = this.frontFsFileService.getFsFileList(userId, listGroup, adminFlag);
        return fsList;
    }

    @RequestMapping(value={"/getOpTypeRank"})
    @ResponseBody
    public Object getRank(String opType, @RequestParam(defaultValue="1") int pageNumber, @RequestParam(defaultValue="8") int pageSize) {
        Page page = new Page(pageNumber, pageSize);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        List<Map> list = this.frontFsFileService.hotWord(page);
        int total = this.frontFsFileService.hotWordCount();
        resultMap.put("list", list);
        resultMap.put("total", total);
        resultMap.put("pageNumber", pageNumber);
        return resultMap;
    }

    @RequestMapping(value={"/getUploadRank"})
    @ResponseBody
    public List<Map> getUploadRank() {
        String type = "user";
        List<Map> list = this.cacheToolService.getUploadData(type);
        return list;
    }

    @RequestMapping(value={"/newMessge"})
    @ResponseBody
    public List<DocInfo> newMessge(@RequestParam(defaultValue="1") int pageNumber, @RequestParam(defaultValue="9") int pageSize) {
        List<DocInfo> list = this.frontFsFileService.getList(pageNumber, pageSize);
        list = this.changeTime(list);
        return list;
    }

    @RequestMapping(value={"/newMessgeFolder"})
    @ResponseBody
    public List<DocInfo> newMessgeFolder(@RequestParam(defaultValue="1") int pageNumber, @RequestParam(defaultValue="9") int pageSize, String folderId) {
        String top_folder = this.docConfigService.getConfigValueByKey("top_folder");
        if (top_folder == null) {
            top_folder = folderId;
        }
        List<DocInfo> list = this.frontFsFileService.getListByFolderId(pageNumber, pageSize, top_folder);
        list = this.changeTime(list);
        return list;
    }

    @RequestMapping(value={"/typeCommand"})
    @ResponseBody
    public List<FsFolderView> typeCommand(@RequestParam(defaultValue="1") int pageNumber, @RequestParam(defaultValue="6") int pageSize, String folderId) {
        List<FsFolder> list = this.frontFolderService.getFsFolderByName(folderId);
        if (list != null && list.size() > 0) {
            String levelCode = this.frontFolderService.getFsFolderByName(folderId).get(0).getLevelCode();
            List<FsFolderView> viewlist = this.frontFsFileService.getListByType(pageNumber, pageSize, levelCode);
            viewlist = this.changeSize(viewlist);
            return viewlist;
        }
        return null;
    }

    public List<FsFolderView> changeSize(List<FsFolderView> list) {
        for (FsFolderView fsFolderView : list) {
            if (fsFolderView.getFileSize() == null || "".equals(fsFolderView.getFileSize())) continue;
            fsFolderView.setFileSize(FileTool.longToString(fsFolderView.getFileSize()));
        }
        return list;
    }

    @RequestMapping(value={"/getTopicData"})
    @ResponseBody
    public List getTopicData() {
        List<SpecialTopic> topicList = this.frontTopicService.getTopicList(0, 5);
        String userId = UserInfoUtil.getUserInfo().get("ID").toString();
        List<String> listGroup = this.frontDocGroupService.getPremission(userId);
        try {
            if (topicList != null && topicList.size() > 0) {
                for (SpecialTopic specialTopic : topicList) {
                    String topicId = specialTopic.getTopicId();
                    String topicCover = URLEncoder.encode(specialTopic.getTopicCover(), "UTF-8");
                    specialTopic.setTopicCover(topicCover);
                    FsFolderParams fsFolderParams = new FsFolderParams();
                    fsFolderParams.setGroupList(listGroup);
                    fsFolderParams.setUserId(userId);
                    fsFolderParams.setType("2");
                    String levelCode = this.businessService.getLevelCodeByUserUpload(fsFolderParams);
                    List roleList = ShiroKit.getUser().getRolesList();
                    Integer adminFlag = CommonUtil.getAdminFlag((List)roleList);
                    String orgId = ShiroKit.getUser().getDeptName();
                    List docList = this.frontTopicService.getDocByTopicId(topicId, "create_time", 0, 4, userId, listGroup, levelCode, adminFlag, orgId);
                    docList.forEach(doc -> {
                        Timestamp createTime = (Timestamp)doc.get("createTime");
                        if (System.currentTimeMillis() - createTime.getTime() <= 604800000L) {
                            doc.put("isNew", true);
                        }
                    });
                    specialTopic.setDocList(docList);
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        for (int i = 0; i < topicList.size(); ++i) {
            topicList.get(i).setTopicCover("/preview/list?fileId=" + topicList.get(i).getTopicCover());
        }
        return topicList;
    }

    @RequestMapping(value={"/getFolderData"})
    @ResponseBody
    public List getFolderData() {
        String userId = UserInfoUtil.getUserInfo().get("ID").toString();
        List<String> listGroup = this.frontDocGroupService.getPremission(userId);
        List roleList = ShiroKit.getUser().getRolesList();
        Integer adminFlag = CommonUtil.getAdminFlag((List)roleList);
        List<Map> pFolders = this.frontFolderService.getFolderList("2bb61cdb2b3c11e8aacf429ff4208431", 0, 8, userId, listGroup, adminFlag);
        pFolders.forEach(pFolder -> {
            String pId = pFolder.get("FOLDERID").toString();
            List<Map> childFolders = this.frontFolderService.getFolderList(pId, 0, 2, userId, listGroup, adminFlag);
            pFolder.put("childs", childFolders);
        });
        return pFolders;
    }

    public List<DocInfo> changeTime(List<DocInfo> list) {
        for (DocInfo docInfo : list) {
            Timestamp ts = docInfo.getCreateTime();
            Long tsLong = ts.getTime();
            Long nowTs = new Date().getTime();
            Long lackTs = nowTs - tsLong;
            if (lackTs < 60000L) {
                docInfo.setShowTime("\u521a\u521a");
                continue;
            }
            if (lackTs >= 60000L && lackTs < 3600000L) {
                docInfo.setShowTime(lackTs / 60000L + "\u5206\u949f\u524d");
                continue;
            }
            if (lackTs >= 3600000L && lackTs < 86400000L) {
                docInfo.setShowTime(lackTs / 3600000L + "\u5c0f\u65f6\u524d");
                continue;
            }
            if (lackTs >= 86400000L && lackTs < 604800000L) {
                docInfo.setShowTime(lackTs / 86400000L + "\u5929\u524d");
                continue;
            }
            String time = ts + "";
            time = time.substring(0, time.indexOf(" "));
            docInfo.setShowTime(time);
        }
        return list;
    }

    @RequestMapping(value={"/newMessagePhone"})
    @ResponseBody
    public Object newMessagePhone(Integer amount) {
        HashMap<String, Object> result = new HashMap<String, Object>(3);
        try {
            List<DocInfo> list = this.frontFsFileService.getList(0, amount);
            list = this.changeTime(list);
            result.put("success", true);
            result.put("msg", "");
            result.put("data", list);
        }
        catch (Exception e) {
            result.put("success", false);
        }
        return result;
    }

    @RequestMapping(value={"/newMessageByPermission"})
    @ResponseBody
    public List<DocInfo> newMessgeDehua(@RequestParam(defaultValue="1") int pageNumber, @RequestParam(defaultValue="9") int pageSize) {
        List<DocInfo> list = this.frontFsFileService.getListByPermission(pageNumber, pageSize);
        list = this.changeTime(list);
        return list;
    }
}

