/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.doc.front.docsharemanager.controller;

import com.jxdinfo.doc.common.util.StringUtil;
import com.jxdinfo.doc.front.docmanager.service.FrontDocInfoService;
import com.jxdinfo.doc.front.docsharemanager.service.ShareResourceService;
import com.jxdinfo.hussar.core.cache.HussarCacheManager;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.shiro.ShiroUser;
import java.util.Date;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/s"})
public class ShareResourceController {
    @Autowired
    private FrontDocInfoService frontDocInfoService;
    @Resource
    private ShareResourceService shareResourceService;
    @Autowired
    private HussarCacheManager hussarCacheManager;

    @RequestMapping(value={"/shareHref"})
    @ResponseBody
    public Map shareHref(String fileId, String fileType, @RequestParam(defaultValue="0") int pwdFlag, @RequestParam(defaultValue="0") int validTime, HttpServletRequest request) {
        return this.shareResourceService.newShareResource(fileId, fileType, pwdFlag, validTime, request);
    }

    @RequestMapping(value={"/{hash}"})
    public String viewShare(@PathVariable String hash, Model model, String pwd) {
        model.addAttribute("hash", (Object)hash);
        Map shareResource = this.shareResourceService.getShareResource(hash);
        String loginFlag = shareResource.get("loginFlag").toString();
        String pwdFlag = shareResource.get("pwdFlag").toString();
        String valid = shareResource.get("valid").toString();
        String rightPwd = shareResource.get("pwd").toString();
        String docValid = shareResource.get("docValid").toString();
        String shareFlag = shareResource.get("shareFlag").toString();
        Date validTime = StringUtil.stringToDate((String)shareResource.get("validTime").toString());
        String title = shareResource.get("title").toString();
        model.addAttribute("title", (Object)title);
        Date today = new Date();
        if ("0".equals(valid) || today.after(validTime) || "0".equals(docValid) || "0".equals(shareFlag)) {
            model.addAttribute("error_msg", (Object)"\u8be5\u5206\u4eab\u94fe\u63a5\u5df2\u5931\u6548");
            model.addAttribute("isPersonCenter", (Object)false);
            return "/doc/front/preview/share_error.html";
        }
        if ("1".equals(pwdFlag)) {
            if (StringUtil.checkIsEmpty((String)pwd)) {
                model.addAttribute("isPersonCenter", (Object)false);
                return "/doc/front/preview/share_verify.html";
            }
            if (!pwd.equals(rightPwd)) {
                model.addAttribute("pwd_error", (Object)"\u63d0\u53d6\u7801\u9519\u8bef");
                model.addAttribute("isPersonCenter", (Object)false);
                return "/doc/front/preview/share_verify.html";
            }
        }
        Map<String, String> mapCompany = this.frontDocInfoService.getConfigure("watermark_company");
        model.addAttribute("watermark_company_flag", (Object)mapCompany.get("configValidFlag"));
        model.addAttribute("companyValue", (Object)mapCompany.get("configValue"));
        model.addAttribute("watermark_user_flag", (Object)1);
        model.addAttribute("isPersonCenter", (Object)false);
        model.addAttribute("shareUser", shareResource.get("shareUser"));
        String href = shareResource.get("href").toString();
        ShiroUser shiroUser = ShiroKit.getUser();
        if (null != shiroUser) {
            href = href.replaceAll("sharefile", "preview");
        }
        return "forward:" + href;
    }

    @RequestMapping(value={"/shareConfirm"})
    public String shareConfirm(String fileId, String fileType, String fileName, Model model) {
        if (!this.shareResourceService.getShareFlagByDocId(fileId)) {
            model.addAttribute("shareFlag", (Object)"0");
        } else {
            model.addAttribute("shareFlag", (Object)"1");
        }
        model.addAttribute("fileId", (Object)fileId);
        model.addAttribute("fileType", (Object)fileType);
        model.addAttribute("fileName", (Object)fileName);
        model.addAttribute("isPersonCenter", (Object)false);
        return "/doc/front/preview/share_confirm.html";
    }

    @RequestMapping(value={"/verify"})
    @ResponseBody
    public String verify(String hash, String pwd) {
        String rightPwd = this.shareResourceService.getPwdByHash(hash);
        if (rightPwd.equals(pwd)) {
            return "1";
        }
        return "\u63d0\u53d6\u7801\u9519\u8bef";
    }

    @RequestMapping(value={"/saveServerAddress"})
    @ResponseBody
    public void saveServerAddress() {
        this.hussarCacheManager.setObject("SERVERADDRESS", "SERVERADDRESS", null);
    }
}

