/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.doc.front.docmanager.controller;

import com.jxdinfo.doc.common.docutil.model.ESResponse;
import com.jxdinfo.doc.common.docutil.service.BusinessService;
import com.jxdinfo.doc.common.docutil.service.CacheToolService;
import com.jxdinfo.doc.common.docutil.service.ESService;
import com.jxdinfo.doc.common.docutil.service.FastdfsService;
import com.jxdinfo.doc.common.util.CommonUtil;
import com.jxdinfo.doc.common.util.ExceptionUtils;
import com.jxdinfo.doc.common.util.FileTool;
import com.jxdinfo.doc.common.util.StringUtil;
import com.jxdinfo.doc.common.util.UserInfoUtil;
import com.jxdinfo.doc.front.docmanager.service.FrontDocInfoService;
import com.jxdinfo.doc.front.docmanager.service.PreviewService;
import com.jxdinfo.doc.front.docsharemanager.service.ShareResourceService;
import com.jxdinfo.doc.front.groupmanager.service.FrontDocGroupService;
import com.jxdinfo.doc.manager.docmanager.ex.ServiceException;
import com.jxdinfo.doc.manager.docmanager.model.DocInfo;
import com.jxdinfo.doc.manager.foldermanager.model.FsFolderParams;
import com.jxdinfo.doc.manager.groupmanager.service.DocGroupService;
import com.jxdinfo.doc.manager.personalcenter.service.PersonalOperateService;
import com.jxdinfo.doc.newupload.service.UploadService;
import com.jxdinfo.hussar.core.cache.HussarCacheManager;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.shiro.ShiroUser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/preview"})
public class PreviewController {
    private static Logger LOGGER = LoggerFactory.getLogger(PreviewController.class);
    @Value(value="${docbase.uploadPath}")
    private String base;
    @Resource
    private PersonalOperateService operateService;
    @Value(value="${fastdfs.using}")
    private boolean fastdfsUsingFlag;
    private String fileType;
    private String orderType;
    private String fileName;
    private String pdfFileId;
    @Autowired
    private PreviewService previewService;
    @Autowired
    FastdfsService fastdfsService;
    @Autowired
    private FrontDocInfoService frontDocInfoService;
    @Resource
    private BusinessService businessService;
    @Autowired
    private CacheToolService cacheToolService;
    @Autowired
    private DocGroupService docGroupService;
    @Autowired
    private HussarCacheManager hussarCacheManager;
    @Autowired
    private FileTool fileTool;
    @Autowired
    private FrontDocGroupService frontDocGroupService;
    @Autowired
    private ESService esService;
    @Resource
    private ShareResourceService shareResourceService;
    @Resource
    private UploadService uploadService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/video"})
    public void getVideo(HttpServletRequest request, HttpServletResponse response) {
        String uuid = UUID.randomUUID().toString();
        RandomAccessFile randomFile = null;
        ServletOutputStream out = null;
        this.pdfFileId = request.getParameter("fileId");
        Map readInfo = new HashMap<String, String>();
        Object cacheMap = this.hussarCacheManager.getObject("MP4READLOCK", this.pdfFileId);
        if (cacheMap != null) {
            readInfo = (Map)cacheMap;
        }
        readInfo.put(uuid, "READING");
        this.hussarCacheManager.setObject("MP4READLOCK", this.pdfFileId, readInfo);
        File file = null;
        try {
            file = this.fileTool.downLoadFile(this.pdfFileId);
            randomFile = new RandomAccessFile(file, "r");
            long contentLength = file.length();
            String range = request.getHeader("Range");
            int start = 0;
            int end = 0;
            if (range != null && range.startsWith("bytes=")) {
                String[] values = range.split("=")[1].split("-");
                start = Integer.parseInt(values[0]);
                if (values.length > 1) {
                    end = Integer.parseInt(values[1]);
                }
            }
            int requestSize = 0;
            requestSize = end != 0 && end > start ? end - start + 1 : Integer.MAX_VALUE;
            byte[] buffer = new byte[4096];
            response.setContentType("video/mp4");
            response.setHeader("Accept-Ranges", "bytes");
            response.setHeader("ETag", this.fileName);
            response.setHeader("Last-Modified", new Date().toString());
            if (range == null) {
                response.setHeader("Content-length", contentLength + "");
            } else {
                response.setStatus(206);
                long requestStart = 0L;
                long requestEnd = 0L;
                String[] ranges = range.split("=");
                if (ranges.length > 1) {
                    String[] rangeDatas = ranges[1].split("-");
                    requestStart = Integer.parseInt(rangeDatas[0]);
                    if (rangeDatas.length > 1) {
                        requestEnd = Integer.parseInt(rangeDatas[1]);
                    }
                }
                long length = 0L;
                if (requestEnd > 0L) {
                    length = requestEnd - requestStart + 1L;
                    response.setHeader("Content-length", "" + length);
                    response.setHeader("Content-Range", "bytes " + requestStart + "-" + requestEnd + "/" + contentLength);
                } else {
                    length = contentLength - requestStart;
                    response.setHeader("Content-length", "" + length);
                    response.setHeader("Content-Range", "bytes " + requestStart + "-" + (contentLength - 1L) + "/" + contentLength);
                }
            }
            out = response.getOutputStream();
            randomFile.seek(start);
            for (int needSize = requestSize; needSize > 0; needSize -= buffer.length) {
                int len = randomFile.read(buffer);
                if (needSize < buffer.length) {
                    out.write(buffer, 0, needSize);
                    continue;
                }
                out.write(buffer, 0, len);
                if (len >= buffer.length) continue;
                break;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            LOGGER.error("\u6587\u4ef6\u9884\u89c8\u5931\u8d25\uff1a" + ExceptionUtils.getErrorInfo((Exception)e));
        }
        catch (ServiceException e) {
            e.printStackTrace();
            LOGGER.error("\u6587\u4ef6\u9884\u89c8\u5931\u8d25\uff1a" + ExceptionUtils.getErrorInfo((Exception)e));
        }
        finally {
            if (randomFile != null) {
                try {
                    randomFile.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    LOGGER.error("\u6587\u4ef6\u9884\u89c8\u5931\u8d25\uff1a" + ExceptionUtils.getErrorInfo((Exception)e));
                    e.printStackTrace();
                }
            }
            if ((cacheMap = this.hussarCacheManager.getObject("MP4READLOCK", this.pdfFileId)) != null) {
                readInfo = (Map)cacheMap;
            }
            readInfo.remove(uuid);
            this.hussarCacheManager.setObject("MP4READLOCK", this.pdfFileId, readInfo);
            if (readInfo.size() == 0 && this.fastdfsUsingFlag && file != null) {
                file.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/list"})
    public void getList(HttpServletRequest request, HttpServletResponse response) {
        String pdfFileId = request.getParameter("fileId");
        String isThumbnails = request.getParameter("isThumbnails");
        FileInputStream input = null;
        try {
            byte[] bytes = this.fileTool.downLoadFile(input, pdfFileId, isThumbnails);
            if (bytes.length < 512000) {
                response.setDateHeader("expires", System.currentTimeMillis() + 604800000L);
            }
            response.getOutputStream().write(bytes);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            LOGGER.error("\u6ca1\u6709\u627e\u5230\u6587\u4ef6\uff1a" + ExceptionUtils.getErrorInfo((Exception)e));
        }
        catch (IOException e) {
            e.printStackTrace();
            LOGGER.error("\u6587\u4ef6\u9884\u89c8\u5931\u8d25\uff1a" + ExceptionUtils.getErrorInfo((Exception)e));
        }
        catch (ServiceException e) {
            e.printStackTrace();
            LOGGER.error("\u6587\u4ef6\u9884\u89c8\u5931\u8d25\uff1a" + ExceptionUtils.getErrorInfo((Exception)e));
        }
        catch (Exception e) {
            LOGGER.error("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff1a" + ExceptionUtils.getErrorInfo((Exception)e));
            e.printStackTrace();
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    LOGGER.error("\u6587\u4ef6\u9884\u89c8\u5931\u8d25\uff1a" + ExceptionUtils.getErrorInfo((Exception)e));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/listForShare"})
    public void getListForShare(HttpServletRequest request, HttpServletResponse response) {
        String isThumbnails = request.getParameter("isThumbnails");
        String hash = request.getParameter("hash");
        FileInputStream input = null;
        try {
            String docType = "";
            String pdfPath = "";
            Map getHash = this.shareResourceService.getPdfPath(hash);
            if (null != getHash.get("docType")) {
                docType = getHash.get("docType").toString();
            }
            pdfPath = StringUtil.isPdf((String)docType) ? getHash.get("pdfPath").toString() : getHash.get("filePath").toString();
            byte[] bytes = this.fileTool.downLoadFile(input, pdfPath, isThumbnails);
            response.getOutputStream().write(bytes);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            LOGGER.error("\u6ca1\u6709\u627e\u5230\u6587\u4ef6\uff1a" + ExceptionUtils.getErrorInfo((Exception)e));
        }
        catch (IOException e) {
            e.printStackTrace();
            LOGGER.error("\u6587\u4ef6\u9884\u89c8\u5931\u8d25\uff1a" + ExceptionUtils.getErrorInfo((Exception)e));
        }
        catch (ServiceException e) {
            e.printStackTrace();
            LOGGER.error("\u6587\u4ef6\u9884\u89c8\u5931\u8d25\uff1a" + ExceptionUtils.getErrorInfo((Exception)e));
        }
        catch (Exception e) {
            LOGGER.error("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff1a" + ExceptionUtils.getErrorInfo((Exception)e));
            e.printStackTrace();
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    LOGGER.error("\u6587\u4ef6\u9884\u89c8\u5931\u8d25\uff1a" + ExceptionUtils.getErrorInfo((Exception)e));
                }
            }
        }
    }

    @RequestMapping(value={"/toShowPDF"})
    public ModelAndView toShowPDF(String fileType, String keyWords, String id, HttpServletRequest request) {
        ModelAndView mv = new ModelAndView("/doc/front/preview/showPDF.html");
        String keyword = request.getParameter("keyword");
        String userId = UserInfoUtil.getCurrentUser().getId();
        List<String> listGroup = this.docGroupService.getPremission(userId);
        FsFolderParams fsFolderParams = new FsFolderParams();
        fsFolderParams.setGroupList(listGroup);
        fsFolderParams.setUserId(userId);
        fsFolderParams.setType("2");
        String levelCode = this.businessService.getLevelCodeByUserUpload(fsFolderParams);
        DocInfo docInfo = this.frontDocInfoService.getDocDetail(id, userId, listGroup, levelCode);
        Map<String, String> mapCompany = this.frontDocInfoService.getConfigure("watermark_company");
        Map<String, String> mapUser = this.frontDocInfoService.getConfigure("watermark_user");
        String userName = UserInfoUtil.getUserInfo().get("NAME").toString();
        String type = fileType == null ? "" : fileType;
        String docName = keyWords == null ? "" : keyWords;
        mv.addObject("fileType", (Object)type);
        mv.addObject("key", (Object)docName);
        mv.addObject("id", (Object)id);
        mv.addObject("isPersonCenter", (Object)false);
        mv.addObject("fileName", (Object)keyword);
        mv.addObject("fileType", (Object)fileType);
        mv.addObject("category", (Object)this.orderType);
        mv.addObject("userName", (Object)userName);
        mv.addObject("favorite", (Object)false);
        mv.addObject("watermark_user_flag", (Object)mapUser.get("configValidFlag"));
        mv.addObject("watermark_company_flag", (Object)mapCompany.get("configValidFlag"));
        mv.addObject("companyValue", (Object)mapCompany.get("configValue"));
        return mv;
    }

    @RequestMapping(value={"/getFoldPath"})
    @ResponseBody
    public List<Map<String, String>> getFoldPathByDocId(String docId) {
        return this.previewService.getFoldPathByDocId(docId);
    }

    @RequestMapping(value={"/fileDetail"})
    @ResponseBody
    public Map<String, Object> getFileDetail(String id) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (id != null) {
            String userId = UserInfoUtil.getCurrentUser().getId();
            List<String> listGroup = this.docGroupService.getPremission(userId);
            FsFolderParams fsFolderParams = new FsFolderParams();
            fsFolderParams.setGroupList(listGroup);
            fsFolderParams.setUserId(userId);
            fsFolderParams.setType("2");
            String levelCode = this.businessService.getLevelCodeByUserUpload(fsFolderParams);
            DocInfo docInfo = this.frontDocInfoService.getDocDetail(id, userId, listGroup, levelCode);
            int collection = this.operateService.getMyHistoryCountByFileId(docInfo.getDocId(), userId, "5");
            List roleList = ShiroKit.getUser().getRolesList();
            Integer adminFlag = CommonUtil.getAdminFlag((List)roleList);
            map.put("adminFlag", adminFlag);
            map.put("collection", collection);
            map.put("authority", docInfo.getAuthority());
            map.put("id", docInfo.getDocId());
            map.put("filePath", docInfo.getFilePath());
            map.put("filePdfPath", docInfo.getFilePdfPath());
            map.put("userId", docInfo.getUserId());
            map.put("author", docInfo.getAuthorName());
            map.put("createTime", docInfo.getCreateTime());
            map.put("title", docInfo.getTitle());
            map.put("shareFlag", docInfo.getShareFlag());
            map.put("tags", docInfo.getTags());
            String fileSuffixName = docInfo.getDocType().substring(docInfo.getDocType().lastIndexOf(".") + 1);
            map.put("downloadNum", docInfo.getDownloadNum());
            map.put("readNum", this.cacheToolService.getReadNum(docInfo.getDocId()) + 1);
            map.put("fileSuffixName", fileSuffixName);
            map.put("docAbstract", docInfo.getDocAbstract());
            if (StringUtil.checkIsEmpty((String)docInfo.getFilePdfPath())) {
                this.uploadService.checkUploadState(id);
            }
            map.put("uploadState", !StringUtil.checkIsEmpty((String)docInfo.getFilePdfPath()));
            if (docInfo.getFileSize() != null && !"".equals(docInfo.getFileSize())) {
                map.put("fileSize", FileTool.longToString(docInfo.getFileSize()));
            }
        }
        return map;
    }

    @RequestMapping(value={"/toShowIMG"})
    public ModelAndView toShowIMG(String fileType, String keyWords, String id) {
        ModelAndView mv = new ModelAndView("/doc/front/preview/showImg.html");
        String userId = UserInfoUtil.getCurrentUser().getId();
        List<String> listGroup = this.docGroupService.getPremission(userId);
        FsFolderParams fsFolderParams = new FsFolderParams();
        fsFolderParams.setGroupList(listGroup);
        fsFolderParams.setUserId(userId);
        fsFolderParams.setType("2");
        String levelCode = this.businessService.getLevelCodeByUserUpload(fsFolderParams);
        DocInfo docInfo = this.frontDocInfoService.getDocDetail(id, userId, listGroup, levelCode);
        String imgPath = this.frontDocInfoService.getThumbByIdAndLevel(id, "2") == null ? docInfo.getFilePath() : this.frontDocInfoService.getThumbByIdAndLevel(id, "2") + "&&isThumbnails=2";
        String userName = UserInfoUtil.getUserInfo().get("NAME").toString();
        String type = fileType == null ? "" : fileType;
        String docName = keyWords == null ? "" : keyWords;
        String folderId = docInfo.getFoldId();
        mv.addObject("fileType", (Object)type);
        mv.addObject("key", (Object)docName);
        mv.addObject("isPersonCenter", (Object)false);
        mv.addObject("folderId", (Object)folderId);
        mv.addObject("id", (Object)id);
        mv.addObject("path", (Object)docInfo.getFilePath());
        mv.addObject("tags", (Object)docInfo.getTags());
        mv.addObject("fileType", (Object)fileType);
        mv.addObject("category", (Object)this.orderType);
        mv.addObject("userName", (Object)userName);
        mv.addObject("watermark_user_flag", (Object)docInfo.getWatermarkUser());
        mv.addObject("fileName", (Object)docInfo.getTitle());
        mv.addObject("imgPath", (Object)imgPath);
        return mv;
    }

    @RequestMapping(value={"/toShowVoice"})
    public String toShowVoice(String fileType, String keyWords, String id, Model model) {
        String type = fileType == null ? "" : fileType;
        String docName = keyWords == null ? "" : keyWords;
        model.addAttribute("fileType", (Object)type);
        model.addAttribute("key", (Object)docName);
        model.addAttribute("id", (Object)id);
        model.addAttribute("fileType", (Object)fileType);
        model.addAttribute("isPersonCenter", (Object)false);
        model.addAttribute("category", (Object)this.orderType);
        String userName = UserInfoUtil.getUserInfo().get("NAME").toString();
        model.addAttribute("userName", (Object)userName);
        return "/doc/front/preview/showVoice.html";
    }

    @RequestMapping(value={"/toShowVideo"})
    public String toShowVideo(String fileType, String keyWords, String id, Model model) {
        String type = fileType == null ? "" : fileType;
        String docName = keyWords == null ? "" : keyWords;
        model.addAttribute("fileType", (Object)type);
        model.addAttribute("key", (Object)docName);
        model.addAttribute("id", (Object)id);
        model.addAttribute("fileType", (Object)fileType);
        model.addAttribute("category", (Object)this.orderType);
        model.addAttribute("isPersonCenter", (Object)false);
        String userName = UserInfoUtil.getUserInfo().get("NAME").toString();
        model.addAttribute("userName", (Object)userName);
        return "/doc/front/preview/showVideo.html";
    }

    @RequestMapping(value={"/toShowOthers"})
    public String toShowOthers(String fileType, String keyWords, String id, Model model) {
        String type = fileType == null ? "" : fileType;
        String docName = keyWords == null ? "" : keyWords;
        model.addAttribute("fileType", (Object)type);
        model.addAttribute("key", (Object)docName);
        model.addAttribute("isPersonCenter", (Object)false);
        model.addAttribute("id", (Object)id);
        return "/doc/front/preview/showOthers.html";
    }

    @RequestMapping(value={"/folderIMG"})
    @ResponseBody
    public Map<String, Object> folderIMG(Integer page, Integer size, String folderId, String docId) {
        HashMap<String, Object> imgs = new HashMap<String, Object>();
        ArrayList list = new ArrayList();
        int totalPages = 0;
        int total = 0;
        if (folderId != null) {
            String userId = UserInfoUtil.getCurrentUser().getId();
            List<String> listGroup = this.docGroupService.getPremission(userId);
            FsFolderParams fsFolderParams = new FsFolderParams();
            fsFolderParams.setGroupList(listGroup);
            fsFolderParams.setUserId(userId);
            fsFolderParams.setType("2");
            String levelCode = this.businessService.getLevelCodeByUserUpload(fsFolderParams);
            List roleList = ShiroKit.getUser().getRolesList();
            Integer adminFlag = CommonUtil.getAdminFlag((List)roleList);
            String orgId = ShiroKit.getUser().getDeptName();
            total = this.frontDocInfoService.getFolderImgCount(folderId, userId, listGroup, levelCode, adminFlag, orgId);
            List<DocInfo> docInfos = this.frontDocInfoService.getFolderIMG(page, size, folderId, userId, listGroup, levelCode, adminFlag, orgId);
            for (DocInfo docInfo : docInfos) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("adminFlag", adminFlag);
                map.put("authority", docInfo.getAuthority());
                map.put("id", docInfo.getDocId());
                map.put("filePath", docInfo.getFilePath());
                map.put("filePdfPath", docInfo.getFilePdfPath());
                map.put("userId", docInfo.getUserId());
                map.put("author", docInfo.getAuthorName());
                map.put("createTime", docInfo.getCreateTime());
                map.put("title", docInfo.getTitle());
                map.put("docType", docInfo.getDocType().replace(".", ""));
                map.put("docId", docInfo.getDocId());
                map.put("thumbPath", docInfo.getThumbPath());
                if (docInfo.getFileSize() != null && !"".equals(docInfo.getFileSize())) {
                    map.put("fileSize", FileTool.longToString(docInfo.getFileSize()));
                }
                if (docInfo.getDocId().equals(docId)) {
                    map.put("isSelf", true);
                    list.add(map);
                    continue;
                }
                map.put("isSelf", false);
                list.add(map);
            }
        }
        totalPages = total % size == 0 ? total / size : total / size + 1;
        imgs.put("items", list);
        imgs.put("success", true);
        imgs.put("total", total);
        imgs.put("totalPages", totalPages);
        return imgs;
    }

    @RequestMapping(value={"/recommendIMG"})
    @ResponseBody
    public List<Map> recommendIMG(String keyword, Integer page, Integer size, String folderId, String tagString) {
        ShiroUser shiroUser = ShiroKit.getUser();
        List rolesList = shiroUser.getRolesList();
        Boolean adminFlag = CommonUtil.getAdminFlag((List)rolesList) == 1;
        String keywordResult = "";
        try {
            keywordResult = URLDecoder.decode(keyword.replaceAll("%", "%25"), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        ESResponse<Map<String, Object>> sd = this.esService.search(keywordResult, "image", page, adminFlag, size, tagString);
        List<Map<String, Object>> list = sd.getItems();
        List<Map> docList = new ArrayList<Map>();
        if (null != list && list.size() > 0) {
            ArrayList<String> idList = new ArrayList<String>();
            for (int i = 0; i < list.size(); ++i) {
                Map<String, Object> map = list.get(i);
                String id = map.get("id") == null ? "" : map.get("id").toString();
                idList.add(id);
            }
            docList = this.frontDocInfoService.getRecommendIMG(idList, folderId);
        }
        if (docList.size() == 0) {
            docList = this.frontDocInfoService.getPopularImg(folderId);
        }
        docList.forEach(doc -> doc.put("docType", doc.get("docType").toString().replace(".", "")));
        return docList;
    }

    @RequestMapping(value={"/recommendArticle"})
    @ResponseBody
    public List<Map> recommendArticle(String currentId, String keyword, Integer pageNumber, Integer pageSize, String tagString) {
        ShiroUser shiroUser = ShiroKit.getUser();
        List rolesList = shiroUser.getRolesList();
        Boolean adminFlag = CommonUtil.getAdminFlag((List)rolesList) == 1;
        String keywordResult = "";
        try {
            keywordResult = URLDecoder.decode(keyword.replaceAll("%", "%25"), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        ESResponse<Map<String, Object>> sd = this.esService.search(keywordResult, "allword", pageNumber, adminFlag, pageSize, null);
        List<Map<String, Object>> list = sd.getItems();
        List<Map> docList = new ArrayList<Map>();
        int size = 0;
        if (null != list && list.size() > 0) {
            ArrayList<String> idList = new ArrayList<String>();
            for (int i = 0; i < list.size(); ++i) {
                String id;
                Map<String, Object> map = list.get(i);
                String string = id = map.get("id") == null ? "" : map.get("id").toString();
                if (id.equals(currentId)) continue;
                idList.add(id);
            }
            if (idList.size() != 0) {
                docList = this.frontDocInfoService.getRecommendArticle(idList, currentId);
            }
            size = 5 - docList.size();
        }
        docList.addAll(this.frontDocInfoService.getArticleByReadNum(size, docList, currentId));
        return docList;
    }

    @RequestMapping(value={"/guessYouLike"})
    @ResponseBody
    public List<Map> guessYouLike(String currentId) {
        if (currentId != null && !currentId.equals("")) {
            return this.frontDocInfoService.guessYouLike(currentId);
        }
        return null;
    }

    @RequestMapping(value={"/checkUploadState"})
    @ResponseBody
    public boolean checkUploadState(String docId) {
        return this.uploadService.checkUploadStateFromFast(docId);
    }

    @RequestMapping(value={"/folderViewerFlow"})
    public String folderViewerFlow(String fileName, String docId, String folderId, Model model) {
        model.addAttribute("docId", (Object)docId);
        model.addAttribute("folderId", (Object)folderId);
        String userName = UserInfoUtil.getUserInfo().get("NAME").toString();
        List roleList = ShiroKit.getUser().getRolesList();
        Integer adminFlag = CommonUtil.getAdminFlag((List)roleList);
        String type = this.fileType == null ? "" : this.fileType;
        model.addAttribute("fileType", (Object)type);
        model.addAttribute("userName", (Object)userName);
        model.addAttribute("fileName", (Object)fileName);
        model.addAttribute("adminFlag", (Object)adminFlag);
        model.addAttribute("isPersonCenter", (Object)false);
        return "/doc/front/preview/folder-imgFlow.html";
    }
}

