/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.doc.front.docmanager.controller;

import com.jxdinfo.doc.common.docutil.service.BusinessService;
import com.jxdinfo.doc.common.docutil.service.CacheToolService;
import com.jxdinfo.doc.common.util.CommonUtil;
import com.jxdinfo.doc.common.util.FileTool;
import com.jxdinfo.doc.common.util.StringUtil;
import com.jxdinfo.doc.common.util.UserInfoUtil;
import com.jxdinfo.doc.front.docmanager.service.FrontFsFileService;
import com.jxdinfo.doc.front.foldermanager.service.FrontFoldAuthorityService;
import com.jxdinfo.doc.front.foldermanager.service.FrontFolderService;
import com.jxdinfo.doc.front.groupmanager.service.FrontDocGroupService;
import com.jxdinfo.doc.manager.docmanager.model.FsFolderView;
import com.jxdinfo.doc.manager.foldermanager.model.FsFolder;
import com.jxdinfo.doc.manager.foldermanager.model.FsFolderParams;
import com.jxdinfo.doc.manager.foldermanager.service.IFsFolderService;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/frontFile"})
public class FrontFsFileController {
    @Autowired
    private FrontFsFileService frontFsFileService;
    @Autowired
    private FrontFolderService frontFolderService;
    @Autowired
    private CacheToolService cacheToolService;
    @Autowired
    private FrontFoldAuthorityService frontFoldAuthorityService;
    private IFsFolderService fsFolderService;
    @Resource
    private BusinessService businessService;
    @Autowired
    private FrontDocGroupService frontDocGroupService;

    @RequestMapping(value={""})
    public String index(String fileId, String fileName, Model model) {
        String id = fileId == null ? "" : fileId;
        String name = fileName == null ? "" : fileName;
        String userName = ShiroKit.getUser().getName();
        model.addAttribute("id", (Object)id);
        model.addAttribute("userName", (Object)userName);
        model.addAttribute("fileName", (Object)name);
        model.addAttribute("isPersonCenter", (Object)false);
        return "/doc/front/docmanager/frontResourceManager.html";
    }

    @RequestMapping(value={"/getRoot"})
    @ResponseBody
    public Map getRoot() {
        List<FsFolder> list = this.frontFsFileService.getRoot();
        HashMap<String, String> map = new HashMap<String, String>();
        FsFolder fsFile = list.get(0);
        map.put("root", fsFile.getFolderId());
        map.put("rootName", fsFile.getFolderName());
        return map;
    }

    @RequestMapping(value={"/getInfo"})
    @ResponseBody
    public List<Map> getInfo(@RequestParam String ids) {
        List<String> listGroup;
        String[] strArr = ids.split(",");
        ArrayList<String> idList = new ArrayList<String>();
        for (String element : strArr) {
            idList.add(element);
        }
        String userId = UserInfoUtil.getCurrentUser().getId();
        List<Map> list = this.frontFsFileService.getInfo(idList, userId, listGroup = this.frontDocGroupService.getPremission(userId));
        if (list != null) {
            int j = list.size();
            for (int i = 0; i < j; ++i) {
                Map dataMap = list.get(i);
                int readNum = this.cacheToolService.getReadNum(StringUtil.getString(dataMap.get("fileId")));
                dataMap.put("readNum", readNum);
                list.set(i, dataMap);
            }
        }
        return list;
    }

    @RequestMapping(value={"/getChildren"})
    @ResponseBody
    public Object getChildren(@RequestParam String id, @RequestParam(value="pageNumber", defaultValue="1") int pageNumber, @RequestParam(value="pageSize", defaultValue="20") int pageSize, String order, String name, String type, String nameFlag, String operateType) {
        String[] typeArr;
        HashMap<String, String> orderMap = new HashMap<String, String>();
        HashMap<String, String> typeMap = new HashMap<String, String>();
        orderMap.put("0", "createTime");
        orderMap.put("1", "fileName");
        orderMap.put("2", "fileType");
        typeMap.put("1", ".doc,.docx");
        typeMap.put("2", ".ppt,.pptx");
        typeMap.put("3", ".txt");
        typeMap.put("4", ".pdf");
        typeMap.put("5", ".xls,.xlsx");
        String orderResult = (String)orderMap.get(order);
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        List<Object> list = new ArrayList();
        int num = 0;
        boolean isChild = this.frontFsFileService.isChildren(id);
        String userId = ShiroKit.getUser().getId();
        List<String> listGroup = this.frontDocGroupService.getPremission(userId);
        List roleList = ShiroKit.getUser().getRolesList();
        Integer adminFlag = CommonUtil.getAdminFlag((List)roleList);
        FsFolder fsFolder = (FsFolder)((Object)this.frontFolderService.selectById((Serializable)((Object)id)));
        if (type == null) {
            type = "0";
        }
        if ("0".equals(type)) {
            typeArr = null;
        } else {
            String typeResult = (String)typeMap.get(type);
            typeArr = typeResult.split(",");
        }
        name = StringUtil.transferSqlParam((String)name);
        FsFolderParams fsFolderParams = new FsFolderParams();
        fsFolderParams.setGroupList(listGroup);
        fsFolderParams.setUserId(userId);
        fsFolderParams.setType(operateType);
        fsFolderParams.setLevelCodeString(fsFolder.getLevelCode());
        String levelCodeString = this.businessService.getFileLevelCodeFront(fsFolderParams);
        fsFolderParams.setType("2");
        String levelCode = this.businessService.getLevelCodeByUserUpload(fsFolderParams);
        String orgId = ShiroKit.getUser().getDeptName();
        list = this.frontFolderService.getFilesAndFloder((pageNumber - 1) * pageSize, pageSize, id, typeArr, name, orderResult, listGroup, userId, adminFlag, operateType, levelCodeString, levelCode, orgId);
        list = this.changeSize(list);
        num = this.frontFolderService.getFilesAndFloderNum(id, typeArr, name, orderResult, listGroup, userId, adminFlag, operateType, levelCodeString, levelCode, orgId);
        int amount = this.frontFolderService.getFileNum(id, typeArr, name, listGroup, userId, adminFlag, operateType, levelCode, orgId);
        if (adminFlag != 1) {
            int isEdits = this.frontFoldAuthorityService.findEdit(id, listGroup, userId);
            result.put("noChildPower", isEdits);
        }
        if (userId.equals(fsFolder.getCreateUserId())) {
            result.put("noChildPower", 2);
        }
        result.put("userId", ShiroKit.getUser().getName());
        result.put("isAdmin", adminFlag);
        result.put("total", num);
        result.put("rows", list);
        result.put("isChild", isChild);
        result.put("amount", amount);
        return result;
    }

    public List<FsFolderView> changeSize(List<FsFolderView> list) {
        for (FsFolderView fsFolderView : list) {
            if (fsFolderView.getFileSize() == null || "".equals(fsFolderView.getFileSize())) continue;
            fsFolderView.setFileSize(FileTool.longToString(fsFolderView.getFileSize()));
        }
        return list;
    }
}

