/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.doc.common.util;

import com.jxdinfo.doc.common.docutil.service.FastdfsService;
import com.jxdinfo.doc.common.util.ThumbnailsUtil;
import com.jxdinfo.doc.manager.docmanager.dao.FsFileMapper;
import com.jxdinfo.doc.manager.docmanager.ex.ServiceException;
import com.jxdinfo.doc.manager.docmanager.model.FsFile;
import com.jxdinfo.doc.manager.docmanager.service.DocDeleteService;
import com.jxdinfo.hussar.encrypt.file.FileEncryptUtil;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Resource;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class FileTool {
    public static final Logger logger = LoggerFactory.getLogger(FileTool.class);
    @Value(value="${fastdfs.using}")
    private boolean fastdfsUsingFlag;
    @Autowired
    private FastdfsService fastdfsService;
    @Autowired
    private DocDeleteService docDeleteService;
    @Value(value="${docbase.downloadFile}")
    private String downloadFile;
    @Value(value="${docbase.downloadPdfFile}")
    private String downloadPdfFile;
    @Value(value="${docbase.downloadFileByKey}")
    private String downloadFileByKey;
    @Value(value="${docbase.downloadPdfFileByKey}")
    private String downloadPdfFileByKey;
    @Value(value="${docbase.ThumbnailsDir}")
    private String ThumbnailsDir;
    @Resource
    private FsFileMapper fsFileMapper;

    public static Map<String, String> fileUploadInfo(MultipartFile file, String rootPath, String fileId) {
        HashMap<String, String> map = new HashMap<String, String>(16);
        String originalFileName = file.getOriginalFilename();
        if (originalFileName.contains("\\")) {
            originalFileName = originalFileName.substring(originalFileName.lastIndexOf("\\") + 1);
        }
        String oldName = originalFileName.substring(0, originalFileName.lastIndexOf("."));
        String id = UUID.randomUUID().toString();
        String extendName = originalFileName.substring(originalFileName.lastIndexOf("."));
        String fileName = id + extendName;
        long fileLength = file.getSize();
        String fileSize = FileTool.longToString(fileLength * 1024L);
        map.put("docId", id);
        map.put("fileId", fileId);
        map.put("pdfFileId", "");
        map.put("fileName", fileName);
        map.put("docName", oldName);
        map.put("type", extendName);
        map.put("size", fileSize);
        return map;
    }

    public static List<Map<String, String>> fileUploadInfo(List<MultipartFile> files, String rootPath, String fileId) {
        ArrayList<Map<String, String>> docInfoList = new ArrayList<Map<String, String>>();
        for (MultipartFile file : files) {
            docInfoList.add(FileTool.fileUploadInfo(file, rootPath, fileId));
        }
        return docInfoList;
    }

    public static String longToString(String fileSize) {
        return FileTool.doubleToString(Double.parseDouble(fileSize.substring(0, fileSize.length() - 2)));
    }

    public static String longToString(long size) {
        return FileTool.doubleToString(size);
    }

    public static String doubleToString(double size) {
        double kb = 1.0;
        double mb = kb * 1024.0;
        double gb = mb * 1024.0;
        String ret = "";
        DecimalFormat df = new DecimalFormat("0.0");
        DecimalFormat df1 = new DecimalFormat("0.00");
        if (size >= gb) {
            ret = df1.format(size / (gb * 1.0)) + " GB";
        } else if (size >= mb) {
            ret = df.format(size / (mb * 1.0)) + " MB";
        } else if (size >= 0.0) {
            ret = df.format(size / (kb * 1.0)) + " KB";
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipFile(File inputFile, ZipOutputStream zipoutputStream, String fileName) {
        if (inputFile.exists() && inputFile.isFile()) {
            FileInputStream fis = null;
            BufferedInputStream bis = null;
            try {
                fis = new FileInputStream(inputFile);
                bis = new BufferedInputStream(fis);
                ZipEntry ze = new ZipEntry(fileName);
                zipoutputStream.putNextEntry(ze);
                zipoutputStream.setEncoding("GBK");
                int l = 0;
                while ((l = bis.read()) != -1) {
                    zipoutputStream.write(l);
                }
                bis.close();
                fis.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (bis != null) {
                        bis.close();
                    }
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public byte[] downLoadFile(FileInputStream input, String filePath, String isThumbnails) throws IOException, ServiceException {
        byte[] bytes = null;
        if ("".equals(filePath) || filePath == null || "undefined".equals(filePath)) {
            return bytes;
        }
        String suffix = filePath.substring(filePath.lastIndexOf("."));
        FileOutputStream fos = null;
        byte[] buffer = null;
        if (".pdf".equals(suffix) || "0".equals(isThumbnails)) {
            List<FsFile> list = this.fsFileMapper.getInfoByPdfPath(filePath);
            if (!this.fastdfsUsingFlag) {
                input = new FileInputStream(filePath);
                bytes = new byte[input.available()];
                input.read(bytes);
            } else {
                bytes = this.fastdfsService.download(filePath);
            }
            if (list != null && list.size() > 0) {
                String name = list.get(0).getFileName();
                logger.info("******************\u6587\u4ef6:" + name + "\u8fdb\u5165\u6587\u4ef6\u9884\u89c8\uff0c******************");
                if (list.get(0).getPdfKey() == null && list.get(0).getSourceKey() == null) {
                    return bytes;
                }
                String random = list.get(0).getMd5();
                File file = new File(this.downloadPdfFileByKey + "\\" + random + suffix);
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                boolean fileExist = false;
                File fileKey = new File(this.downloadPdfFile + "" + random + suffix);
                if (!fileKey.getParentFile().exists()) {
                    fileKey.getParentFile().mkdirs();
                }
                if (!fileKey.exists()) {
                    fos = new FileOutputStream(file);
                    fos.write(bytes, 0, bytes.length);
                    fos.close();
                } else {
                    fileExist = true;
                }
                logger.info("******************\u6587\u4ef6:" + name + "\u4ecefast\u4e0b\u8f7d\u5b8c\u6210\uff0c\u8def\u5f84\u4e3a" + file.getPath() + ",\u5927\u5c0f\u4e3a" + file.length() + "******************");
                String key = list.get(0).getPdfKey();
                if (key == null) {
                    key = list.get(0).getSourceKey();
                }
                boolean isDecrypt = false;
                isDecrypt = !fileExist ? FileEncryptUtil.getInstance().decrypt(this.downloadPdfFileByKey + "" + random + suffix, this.downloadPdfFile + "" + random + suffix, key) : true;
                logger.info("******************\u6587\u4ef6:" + name + "\u89e3\u5bc6\u5b8c\u6210\uff0c\u8def\u5f84\u4e3a" + fileKey.getPath() + ",\u5927\u5c0f\u4e3a" + fileKey.length() + "******************");
                if (isDecrypt) {
                    int n;
                    if (!this.fastdfsUsingFlag) {
                        FileInputStream fis = new FileInputStream(fileKey);
                        bytes = new byte[fis.available()];
                        fis.read(bytes);
                        fis.close();
                        return bytes;
                    }
                    FileInputStream fis = new FileInputStream(fileKey);
                    ByteArrayOutputStream bus = new ByteArrayOutputStream(bytes.length);
                    byte[] b = new byte[1024];
                    while ((n = fis.read(b)) != -1) {
                        bus.write(b, 0, n);
                    }
                    fis.close();
                    bus.close();
                    buffer = bus.toByteArray();
                    file.delete();
                    fileKey.delete();
                    logger.info("******************\u6587\u4ef6:" + name + "\u6587\u4ef6\u9884\u89c8\u5b8c\u6210\uff0c******************");
                    return buffer;
                }
            }
        } else if ("2".equals(isThumbnails)) {
            List<FsFile> list = this.fsFileMapper.getThumbByPath(filePath);
            if (!this.fastdfsUsingFlag) {
                input = new FileInputStream(filePath);
                bytes = new byte[input.available()];
                input.read(bytes);
            } else {
                bytes = this.fastdfsService.download(filePath);
            }
            if (list != null && list.size() > 0) {
                String name = list.get(0).getFileName();
                logger.info("******************\u6587\u4ef6:" + name + "\u8fdb\u5165\u6587\u4ef6\u4e0b\u8f7d\uff0c******************");
                if (list.get(0).getSourceKey() == null) {
                    return bytes;
                }
                String random = list.get(0).getMd5();
                File file = new File(this.ThumbnailsDir + "\\" + random + suffix);
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                boolean fileExist = false;
                if (!file.exists()) {
                    fos = new FileOutputStream(file);
                    fos.write(bytes, 0, bytes.length);
                    fos.close();
                } else {
                    fileExist = true;
                }
                logger.info("******************\u6587\u4ef6:" + name + "\u4ecefast\u4e0b\u8f7d\u5b8c\u6210\uff0c\u8def\u5f84\u4e3a" + file.getPath() + ",\u5927\u5c0f\u4e3a" + file.length() + "******************");
                boolean isDecrypt = false;
                isDecrypt = !fileExist ? FileEncryptUtil.getInstance().decrypt(this.ThumbnailsDir + "\\" + random + suffix, list.get(0).getSourceKey()) : true;
                if (isDecrypt) {
                    int n;
                    if (!this.fastdfsUsingFlag) {
                        FileInputStream fis = new FileInputStream(file);
                        bytes = new byte[fis.available()];
                        fis.read(bytes);
                        fis.close();
                        return bytes;
                    }
                    FileInputStream fis = new FileInputStream(file);
                    ByteArrayOutputStream bus = new ByteArrayOutputStream(bytes.length);
                    byte[] b = new byte[1024];
                    while ((n = fis.read(b)) != -1) {
                        bus.write(b, 0, n);
                    }
                    fis.close();
                    bus.close();
                    buffer = bus.toByteArray();
                    file.delete();
                    return buffer;
                }
            }
        } else {
            List<FsFile> list = this.fsFileMapper.getInfoByPath(filePath);
            if (!this.fastdfsUsingFlag) {
                input = new FileInputStream(filePath);
                bytes = new byte[input.available()];
                input.read(bytes);
            } else {
                bytes = this.fastdfsService.download(filePath);
            }
            if (list != null && list.size() > 0) {
                if (list.get(0).getSourceKey() == null) {
                    return bytes;
                }
                String random = list.get(0).getMd5();
                String name = list.get(0).getFileName();
                logger.info("******************\u6587\u4ef6:" + name + "\u8fdb\u5165\u6587\u4ef6\u4e0b\u8f7d\uff0c******************");
                File file = new File(this.downloadFileByKey + "\\" + random + suffix);
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                boolean fileExist = false;
                File fileKey = new File(this.downloadFile + "\\" + random + suffix);
                if (!fileKey.getParentFile().exists()) {
                    fileKey.getParentFile().mkdirs();
                }
                if (!fileKey.exists()) {
                    fos = new FileOutputStream(file);
                    fos.write(bytes, 0, bytes.length);
                    fos.close();
                } else {
                    fileExist = true;
                }
                logger.info("******************\u6587\u4ef6:" + name + "\u4ecefast\u4e0b\u8f7d\u5b8c\u6210\uff0c\u8def\u5f84\u4e3a" + file.getPath() + ",\u5927\u5c0f\u4e3a" + file.length() + "******************");
                boolean isDecrypt = false;
                isDecrypt = !fileExist ? FileEncryptUtil.getInstance().decrypt(this.downloadFileByKey + "\\" + random + suffix, this.downloadFile + "\\" + random + suffix, list.get(0).getSourceKey()) : true;
                logger.info("******************\u6587\u4ef6:" + name + "\u89e3\u5bc6\u5b8c\u6210\uff0c\u8def\u5f84\u4e3a" + fileKey.getPath() + ",\u5927\u5c0f\u4e3a" + fileKey.length() + "******************");
                if (isDecrypt) {
                    int n;
                    if (!this.fastdfsUsingFlag) {
                        FileInputStream fis = new FileInputStream(fileKey);
                        bytes = new byte[fis.available()];
                        fis.read(bytes);
                        fis.close();
                        return bytes;
                    }
                    FileInputStream fis = new FileInputStream(fileKey);
                    ByteArrayOutputStream bus = new ByteArrayOutputStream(bytes.length);
                    byte[] b = new byte[1024];
                    while ((n = fis.read(b)) != -1) {
                        bus.write(b, 0, n);
                    }
                    fis.close();
                    bus.close();
                    buffer = bus.toByteArray();
                    file.delete();
                    fileKey.delete();
                    return buffer;
                }
            }
        }
        return bytes;
    }

    public double[] getFileData(String filePath, String isThumbnails) throws IOException, ServiceException {
        byte[] bytes = null;
        if ("".equals(filePath) || filePath == null || "undefined".equals(filePath) || "null".equals(filePath)) {
            return null;
        }
        String suffix = filePath.substring(filePath.lastIndexOf("."));
        FileOutputStream fos = null;
        Object buffer = null;
        if (".pdf".equals(suffix) || "0".equals(isThumbnails)) {
            List<FsFile> list = this.fsFileMapper.getInfoByPdfPath(filePath);
            bytes = this.fastdfsService.download(filePath);
            if (bytes == null) {
                return null;
            }
            if (list != null && list.size() > 0) {
                if (list.get(0).getPdfKey() == null && list.get(0).getSourceKey() == null) {
                    return null;
                }
                String random = list.get(0).getMd5();
                boolean fileExist = false;
                File file = new File(this.downloadPdfFileByKey + "\\" + random + suffix);
                File fileKey = new File(this.downloadFile + "\\" + random + suffix);
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                if (!fileKey.getParentFile().exists()) {
                    fileKey.getParentFile().mkdirs();
                }
                if (!fileKey.exists()) {
                    fos = new FileOutputStream(file);
                    fos.write(bytes, 0, bytes.length);
                    fos.close();
                } else {
                    fileExist = true;
                }
                String key = list.get(0).getPdfKey();
                if (key == null) {
                    key = list.get(0).getSourceKey();
                }
                boolean isDecrypt = false;
                if (!fileExist) {
                    isDecrypt = FileEncryptUtil.getInstance().decrypt(this.downloadPdfFileByKey + "\\" + random + suffix, this.downloadPdfFile + "\\" + random + suffix, key);
                    fileKey.delete();
                } else {
                    isDecrypt = true;
                }
                if (isDecrypt) {
                    try {
                        double[] data = new double[2];
                        if (suffix.equals(".jpg") || suffix.equals(".png") || suffix.equals(".gif") || suffix.equals(".bmp")) {
                            Map map = ThumbnailsUtil.getHeightAndWidth((String)(this.downloadPdfFile + "\\" + random + suffix));
                            data[0] = (Double)map.get("width");
                            data[1] = (Double)map.get("height");
                            file.delete();
                            return data;
                        }
                        return null;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return null;
    }

    public File downLoadFile(String filePath) throws ServiceException {
        Object buffer = null;
        String realPath = this.downloadPdfFileByKey + filePath;
        List<FsFile> list = this.fsFileMapper.getInfoByPdfPath(filePath);
        String random = list.get(0).getMd5();
        String suffix = filePath.substring(filePath.lastIndexOf("."));
        boolean fileExist = false;
        File file = new File(this.downloadFileByKey + "\\" + random + suffix);
        File fileKey = new File(this.downloadFile + "\\" + random + suffix);
        if (!fileKey.getParentFile().exists()) {
            fileKey.getParentFile().mkdirs();
        }
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        if (!this.fastdfsUsingFlag) {
            realPath = filePath;
            file = new File(realPath);
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            if (list != null && list.size() > 0 && list.get(0).getSourceKey() == null) {
                return file;
            }
        } else {
            if (!fileKey.exists()) {
                this.fastdfsService.download(filePath, file);
            } else {
                fileExist = true;
            }
            if (list != null && list.size() > 0) {
                if (list.get(0).getSourceKey() == null) {
                    return file;
                }
                boolean isDecrypt = false;
                isDecrypt = !fileExist ? FileEncryptUtil.getInstance().decrypt(this.downloadFileByKey + "\\" + random + suffix, this.downloadFile + "\\" + random + suffix, list.get(0).getSourceKey()) : true;
            }
        }
        return fileKey;
    }

    public static boolean deleteFile(String fileName) {
        File file = new File(fileName);
        if (file.exists() && file.isFile()) {
            if (file.delete()) {
                System.out.println("\u5220\u9664\u5355\u4e2a\u6587\u4ef6" + fileName + "\u6210\u529f\uff01");
                return true;
            }
            System.out.println("\u5220\u9664\u5355\u4e2a\u6587\u4ef6" + fileName + "\u5931\u8d25\uff01");
            return false;
        }
        System.out.println("\u5220\u9664\u5355\u4e2a\u6587\u4ef6\u5931\u8d25\uff1a" + fileName + "\u4e0d\u5b58\u5728\uff01");
        return false;
    }

    public static ByteArrayOutputStream cloneInputStream(InputStream input) {
        try {
            int len;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((len = input.read(buffer)) > -1) {
                baos.write(buffer, 0, len);
            }
            baos.flush();
            return baos;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

