/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.doc.common.docutil.service.impl;

import com.jxdinfo.doc.common.docutil.service.FastdfsService;
import com.jxdinfo.doc.common.docutil.service.FileValidateService;
import com.jxdinfo.doc.common.model.MasterAndSlave;
import com.jxdinfo.doc.common.util.CodeUtil;
import com.jxdinfo.doc.common.util.FdfsFileUtil;
import com.jxdinfo.doc.common.util.FilenameUtils;
import com.jxdinfo.doc.manager.docmanager.dto.ImageWH;
import com.jxdinfo.doc.manager.docmanager.ex.ParamException;
import com.jxdinfo.doc.manager.docmanager.ex.ServiceException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.coobird.thumbnailator.Thumbnails;
import org.apache.commons.io.FileUtils;
import org.csource.common.MyException;
import org.csource.fastdfs.FileInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class FastdfsServiceImpl
implements FastdfsService {
    @Autowired
    private FileValidateService fileValidateService;
    @Autowired
    FdfsFileUtil fdfsFileUtil;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String uploadFile(String groupName, File file) throws ServiceException {
        String path = "";
        FileInputStream fileIO = null;
        try {
            long fileSize = file.length();
            if (fileSize <= 0L) {
                throw new ParamException("file is null.");
            }
            fileIO = new FileInputStream(file);
            path = this.fdfsFileUtil.upload(groupName, (InputStream)fileIO, file.getName());
            if (path == null) {
                throw new ServiceException("upload error.");
            }
        }
        catch (FileNotFoundException e) {
            throw new ServiceException(e);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (MyException e) {
            e.printStackTrace();
        }
        finally {
            if (fileIO != null) {
                try {
                    fileIO.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return path;
    }

    @Override
    public String uploadFile(File file) throws ServiceException {
        String path = "";
        FileInputStream fis = null;
        try {
            this.fileValidateService.validateFile(file);
            long fileSize = file.length();
            if (fileSize <= 0L) {
                throw new ParamException("file is null.");
            }
            fis = new FileInputStream(file);
            path = this.fdfsFileUtil.upload((InputStream)fis, file.getName());
            if (path == null) {
                throw new ServiceException("upload error.");
            }
            String string = path;
            return string;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new ServiceException("upload error.");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceException("upload error.");
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String uploadSlaveFile(String masterFileId, File file) throws ServiceException {
        FileInputStream fis = null;
        try {
            this.fileValidateService.validateFile(file);
            long fileSize = file.length();
            if (fileSize <= 0L) {
                throw new ParamException("file is null.");
            }
            fis = new FileInputStream(file);
            String fileName = file.getName();
            String filePrefixName = FilenameUtils.getPrefixRandom((String)fileName);
            String path = this.fdfsFileUtil.uploadSlave(masterFileId, (InputStream)fis, filePrefixName, fileName);
            if (path == null) {
                throw new ServiceException("slave upload error.");
            }
            String string = path;
            return string;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (MyException e) {
            e.printStackTrace();
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String uploadSlaveFile(String masterFilename, String prefixName, File file) throws ServiceException {
        FileInputStream fis = null;
        try {
            this.fileValidateService.validateFile(file);
            long fileSize = file.length();
            if (fileSize <= 0L) {
                throw new ParamException("file is null.");
            }
            fis = new FileInputStream(file);
            String path = this.fdfsFileUtil.uploadSlave(masterFilename, (InputStream)fis, prefixName = prefixName + "_" + FilenameUtils.generateShortUuid(), file.getName());
            if (path == null) {
                throw new ServiceException("slave upload error.");
            }
            String string = path;
            return string;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (MyException e) {
            e.printStackTrace();
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MasterAndSlave uploadImageAndThumb(String groupName, String cutSize, File file) throws ServiceException {
        FileInputStream fis = null;
        try {
            this.fileValidateService.validateFile(file);
            long fileSize = file.length();
            if (fileSize <= 0L) {
                throw new ParamException("file is null.");
            }
            if (StringUtils.isEmpty((Object)cutSize)) {
                throw new ParamException("cutSize is null.");
            }
            if (StringUtils.isEmpty((Object)groupName)) {
                throw new ParamException("groupName is null.");
            }
            String ext = FilenameUtils.getExtension((String)file.getName());
            File sourceFile = new File(CodeUtil.getUUID());
            fis = new FileInputStream(file);
            FileUtils.copyInputStreamToFile((InputStream)fis, (File)sourceFile);
            List<ImageWH> whs = this.loadCutSize(cutSize);
            if (whs != null) {
                MasterAndSlave uploadMasterAndSlave;
                int len = whs.size();
                InputStream[] slaveInputs = new InputStream[len];
                ArrayList<String> slaveNames = new ArrayList<String>(len);
                for (int i = 0; i < len; ++i) {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    ImageWH wh = whs.get(i);
                    Thumbnails.of((File[])new File[]{sourceFile}).size(wh.getW(), wh.getH()).toOutputStream((OutputStream)out);
                    slaveInputs[i] = new ByteArrayInputStream(out.toByteArray());
                    slaveNames.add(FilenameUtils.merge((String)String.format("%dx%d", wh.getW(), wh.getH()), (String)ext));
                }
                fis = new FileInputStream(file);
                MasterAndSlave masterAndSlave = uploadMasterAndSlave = this.fdfsFileUtil.uploadMasterAndSlave(groupName, (InputStream)fis, file.getName(), slaveNames, slaveInputs);
                return masterAndSlave;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return new MasterAndSlave();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MasterAndSlave uploadImageAndThumb(String cutSize, File file) throws ServiceException {
        FileInputStream fis = null;
        try {
            this.fileValidateService.validateFile(file);
            long fileSize = file.length();
            if (fileSize <= 0L) {
                throw new ParamException("file is null.");
            }
            if (StringUtils.isEmpty((Object)cutSize)) {
                throw new ParamException("cutSize is null.");
            }
            String ext = FilenameUtils.getExtension((String)file.getName());
            File sourceFile = new File(CodeUtil.getUUID());
            FileUtils.copyInputStreamToFile((InputStream)new FileInputStream(file), (File)sourceFile);
            List<ImageWH> whs = this.loadCutSize(cutSize);
            if (whs != null) {
                int len = whs.size();
                InputStream[] slaveInputs = new InputStream[len];
                ArrayList<String> slaveNames = new ArrayList<String>(len);
                for (int i = 0; i < len; ++i) {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    ImageWH wh = whs.get(i);
                    Thumbnails.of((File[])new File[]{sourceFile}).size(wh.getW(), wh.getH()).toOutputStream((OutputStream)out);
                    slaveInputs[i] = new ByteArrayInputStream(out.toByteArray());
                    slaveNames.add(String.format("%dx%d", wh.getW(), wh.getH()) + "." + ext);
                }
                fis = new FileInputStream(file);
                MasterAndSlave uploadMasterAndSlave = this.fdfsFileUtil.uploadMasterAndSlave(null, (InputStream)fis, file.getName(), slaveNames, slaveInputs);
                FileUtils.deleteQuietly((File)sourceFile);
                MasterAndSlave masterAndSlave = uploadMasterAndSlave;
                return masterAndSlave;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return new MasterAndSlave();
    }

    @Override
    public boolean cutImage(String fileName, String cutSize) throws ServiceException {
        if (StringUtils.isEmpty((Object)fileName)) {
            throw new ParamException("fileName is null");
        }
        if (StringUtils.isEmpty((Object)cutSize)) {
            throw new ParamException("cutSize is null");
        }
        File tmpFile = new File(CodeUtil.getUUID());
        try {
            List<ImageWH> whs = this.loadCutSize(cutSize);
            String string = FilenameUtils.getExtension((String)fileName);
        }
        catch (NullPointerException e) {
            throw new ServiceException(e);
        }
        finally {
            tmpFile.delete();
        }
        return true;
    }

    @Override
    public boolean removeFile(String fileName) throws ServiceException {
        if (StringUtils.isEmpty((Object)fileName)) {
            throw new ParamException("fileName is null");
        }
        try {
            this.fdfsFileUtil.delete(fileName);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (MyException e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public void download(String fileId, String destFile) throws ServiceException {
        if (StringUtils.isEmpty((Object)fileId)) {
            throw new ParamException("fileId is null");
        }
        try {
            this.fdfsFileUtil.download(fileId, destFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (MyException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void download(String fileId, File destFile) throws ServiceException {
        if (StringUtils.isEmpty((Object)fileId)) {
            throw new ParamException("fileId is null");
        }
        try {
            this.fdfsFileUtil.download(fileId, destFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (MyException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public byte[] download(String fileId) throws ServiceException {
        if (StringUtils.isEmpty((Object)fileId)) {
            throw new ParamException("fileId is null");
        }
        try {
            return this.fdfsFileUtil.downloadFile(fileId);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private List<ImageWH> loadCutSize(String cutSize) throws ParamException {
        ArrayList<ImageWH> whs = null;
        if (!StringUtils.isEmpty((Object)cutSize)) {
            List<String> sizes = Arrays.asList(cutSize.split(","));
            whs = new ArrayList<ImageWH>();
            for (String size : sizes) {
                String[] vals = size.split("x");
                int w = Integer.parseInt(vals[0]);
                int h = Integer.parseInt(vals[1]);
                whs.add(new ImageWH(w, h));
            }
        }
        return whs;
    }

    @Override
    public com.jxdinfo.doc.manager.docmanager.dto.FileInfo getFileInfo(String fileId) throws ServiceException {
        if (StringUtils.isEmpty((Object)fileId)) {
            throw new ParamException("fileId is null");
        }
        try {
            FileInfo fileInfo = this.fdfsFileUtil.getFileInfo(fileId);
            if (null == fileInfo) {
                throw new ServiceException("\u6587\u4ef6\u4e0d\u5b58\u5728");
            }
            com.jxdinfo.doc.manager.docmanager.dto.FileInfo info = new com.jxdinfo.doc.manager.docmanager.dto.FileInfo();
            info.setCrc32(fileInfo.getCrc32());
            info.setCreate_timestamp(fileInfo.getCreateTimestamp().getTime());
            info.setFile_size(fileInfo.getFileSize());
            return info;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (MyException e) {
            e.printStackTrace();
        }
        return new com.jxdinfo.doc.manager.docmanager.dto.FileInfo();
    }
}

