/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.doc.common.docutil.service.impl;

import com.jxdinfo.doc.common.docutil.model.DocES;
import com.jxdinfo.doc.common.docutil.model.ESResponse;
import com.jxdinfo.doc.common.docutil.service.ESService;
import com.jxdinfo.doc.common.util.ESUtil;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ESServiceImpl
implements ESService {
    public static final Logger LOGGER = LoggerFactory.getLogger(ESServiceImpl.class);
    @Autowired
    private ESUtil esUtil;

    @Override
    public int createESIndex(DocES docES) throws Exception {
        return this.esUtil.index(docES.getId(), docES.toMap());
    }

    @Override
    public ESResponse<Map<String, Object>> search(String keyword, int page, Boolean adminFlag, Integer size) {
        return this.esUtil.multiMatchQuery(keyword, page, adminFlag, size);
    }

    @Override
    public ESResponse<Map<String, Object>> search(String keyword, String contentType, int page, Boolean adminFlag, Integer size, String tagString) {
        return this.esUtil.boolQuery(keyword, contentType, page, adminFlag, size, tagString);
    }

    @Override
    public ESResponse<Map<String, Object>> searchMobile(String keyword, String contentType, int page, Boolean adminFlag, Integer size, String tagString, String userId) {
        return this.esUtil.boolQuery(keyword, contentType, page, adminFlag, size, tagString, userId);
    }

    @Override
    public ESResponse<Map<String, Object>> searchMobile(String keyword, int page, Boolean adminFlag, Integer size, String userId) {
        return this.esUtil.multiMatchQuery(keyword, page, adminFlag, size, userId);
    }

    @Override
    public int copyIndex(String oldDocId, String newDocId) {
        int reslutStatus = this.esUtil.copyIndex(oldDocId, newDocId);
        return reslutStatus;
    }

    @Override
    public int updateIndex(String docId, Map<String, Object> source) {
        int updateStatus = this.esUtil.updateIndex(docId, source);
        return updateStatus;
    }

    @Override
    public ESResponse<Map<String, Object>> searchWord(String keyword, int size) {
        return this.esUtil.onlyMatchWordQuery(keyword, size);
    }
}

