/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.doc.common.docutil.service.impl;

import com.jxdinfo.doc.common.docutil.dao.BusinessMapper;
import com.jxdinfo.doc.common.docutil.service.BusinessService;
import com.jxdinfo.doc.common.docutil.service.CacheToolService;
import com.jxdinfo.doc.common.util.StringUtil;
import com.jxdinfo.doc.manager.foldermanager.dao.DocFoldAuthorityMapper;
import com.jxdinfo.doc.manager.foldermanager.dao.FsFolderMapper;
import com.jxdinfo.doc.manager.foldermanager.model.FsFolderParams;
import com.jxdinfo.hussar.bsp.permit.model.SysUsers;
import com.jxdinfo.hussar.bsp.permit.service.ISysUsersService;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BusinessServiceImpl
implements BusinessService {
    @Resource
    private FsFolderMapper fsFolderMapper;
    @Resource
    private DocFoldAuthorityMapper docFoldAuthorityMapper;
    @Resource
    private BusinessMapper businessMapper;
    @Autowired
    private CacheToolService cacheToolService;
    @Resource
    private ISysUsersService iSysUsersService;

    @Override
    public List<String> getlevelCodeList(List groupList, String userId, String type) {
        String orgId;
        String groupIds = String.join((CharSequence)",", groupList);
        String levelCodes = this.cacheToolService.getLevelCodeByUserCache(groupIds, userId, type, orgId = ShiroKit.getUser().getDeptName());
        if (levelCodes.indexOf(",") == 0) {
            levelCodes = levelCodes.substring(1, levelCodes.length());
        }
        String[] str = levelCodes.split(",");
        ArrayList<String> levelCodeList = new ArrayList<String>();
        HashSet<String> hs = new HashSet<String>(Arrays.asList(str));
        levelCodeList.addAll(hs);
        levelCodeList.add("");
        return levelCodeList;
    }

    @Override
    public int changeShowOrder(String table, String cloum, String id, String nextid) {
        return this.businessMapper.changeShowOrder(table, cloum, id, nextid);
    }

    @Override
    public String getLevelCodeByUser(FsFolderParams fsFolderParams) {
        String groupIds = String.join((CharSequence)",", fsFolderParams.getGroupList());
        String orgId = ShiroKit.getUser().getDeptName();
        String levelCodes = this.cacheToolService.getLevelCodeByUserCache(groupIds, fsFolderParams.getUserId(), fsFolderParams.getType(), orgId);
        if (levelCodes == null) {
            levelCodes = "";
        }
        if (levelCodes.indexOf(",") == 0) {
            levelCodes = levelCodes.substring(1, levelCodes.length());
            levelCodes = "('" + levelCodes.replace(",", "','") + "')";
        } else {
            levelCodes = "('')";
        }
        return levelCodes;
    }

    @Override
    public String getLevelCodeByUserRecycle(FsFolderParams fsFolderParams) {
        String groupIds = String.join((CharSequence)",", fsFolderParams.getGroupList());
        String orgId = ShiroKit.getUser().getDeptName();
        String levelCodes = this.cacheToolService.getLevelCodeByUserCache(groupIds, fsFolderParams.getUserId(), fsFolderParams.getType(), orgId);
        String levelCodesUp = this.cacheToolService.getUpLevelCodeByUserByUploadCache(groupIds, fsFolderParams.getUserId(), "1", orgId);
        if (levelCodes == null) {
            levelCodes = "";
        }
        if ((levelCodes = levelCodes + levelCodesUp).indexOf(",") == 0) {
            levelCodes = levelCodes.substring(1, levelCodes.length());
            levelCodes = "('" + levelCodes.replace(",", "','") + "')";
        } else {
            levelCodes = "('')";
        }
        return levelCodes;
    }

    @Override
    public String getLevelCodeByUserUpload(FsFolderParams fsFolderParams) {
        String groupIds = String.join((CharSequence)",", fsFolderParams.getGroupList());
        String orgId = ShiroKit.getUser().getDeptName();
        String levelCodes = this.cacheToolService.getLevelCodeByUserByUploadCache(groupIds, fsFolderParams.getUserId(), fsFolderParams.getType(), orgId);
        if (levelCodes == null) {
            levelCodes = "";
        }
        if (levelCodes.indexOf(",") == 0) {
            levelCodes = levelCodes.substring(1, levelCodes.length());
            levelCodes = "('" + levelCodes.replace(",", "','") + "')";
        } else {
            levelCodes = "('')";
        }
        return levelCodes;
    }

    @Override
    public String getLevelCodeByUserUploadMobile(String userId, FsFolderParams fsFolderParams) {
        String groupIds = String.join((CharSequence)",", fsFolderParams.getGroupList());
        String orgId = ((SysUsers)this.iSysUsersService.selectById((Serializable)((Object)userId))).getDepartmentId();
        String levelCodes = this.cacheToolService.getLevelCodeByUserByUploadCache(groupIds, fsFolderParams.getUserId(), fsFolderParams.getType(), orgId);
        if (levelCodes == null) {
            levelCodes = "";
        }
        if (levelCodes.indexOf(",") == 0) {
            levelCodes = levelCodes.substring(1, levelCodes.length());
            levelCodes = "('" + levelCodes.replace(",", "','") + "')";
        } else {
            levelCodes = "('')";
        }
        return levelCodes;
    }

    @Override
    public String getLevelCodeByUserMobile(FsFolderParams fsFolderParams) {
        String groupIds = String.join((CharSequence)",", fsFolderParams.getGroupList());
        String orgId = ((SysUsers)this.iSysUsersService.selectById((Serializable)((Object)fsFolderParams.getUserId()))).getDepartmentId();
        String levelCodes = this.cacheToolService.getLevelCodeByUserCache(groupIds, fsFolderParams.getUserId(), fsFolderParams.getType(), orgId);
        if (levelCodes == null) {
            levelCodes = "";
        }
        if (levelCodes.indexOf(",") == 0) {
            levelCodes = levelCodes.substring(1, levelCodes.length());
            levelCodes = "('" + levelCodes.replace(",", "','") + "')";
        } else {
            levelCodes = "('')";
        }
        return levelCodes;
    }

    @Override
    public String getUpLevelCodeByUser(FsFolderParams fsFolderParams) {
        String groupIds = String.join((CharSequence)",", fsFolderParams.getGroupList());
        String orgId = ShiroKit.getUser().getDeptName();
        String levelCodes = this.cacheToolService.getUpLevelCodeByUserCache(groupIds, fsFolderParams.getUserId(), fsFolderParams.getType(), orgId);
        if (levelCodes.indexOf(",") == 0) {
            levelCodes = levelCodes.substring(1, levelCodes.length());
            levelCodes = "('" + levelCodes.replace(",", "','") + "')";
        } else {
            levelCodes = "('')";
        }
        return levelCodes;
    }

    @Override
    public String getUploadLevelCodeFront(FsFolderParams fsFolderParams) {
        String orgId = ShiroKit.getUser().getDeptName();
        String groupIds = String.join((CharSequence)",", fsFolderParams.getGroupList());
        String levelCodes = this.cacheToolService.getLevelCodeByUserCache(groupIds, fsFolderParams.getUserId(), "2", orgId);
        String upLevelCodes = this.cacheToolService.getUpLevelCodeByUserByUploadCache(groupIds, fsFolderParams.getUserId(), "1", orgId);
        if (StringUtil.checkIsEmpty((String)(levelCodes = levelCodes + upLevelCodes))) {
            return "('')";
        }
        levelCodes = levelCodes.substring(1, levelCodes.length());
        levelCodes = "('" + levelCodes.replace(",", "','") + "')";
        return levelCodes;
    }

    @Override
    public String getFileLevelCode(FsFolderParams fsFolderParams) {
        String orgId = ShiroKit.getUser().getDeptName();
        String groupIds = String.join((CharSequence)",", fsFolderParams.getGroupList());
        String levelCodes = this.cacheToolService.getLevelCodeByUserCache(groupIds, fsFolderParams.getUserId(), "2", orgId);
        String levelCodesFile = this.cacheToolService.getFileUpLevelCodeCache(groupIds, fsFolderParams.getUserId(), fsFolderParams.getLevelCodeString(), orgId, "");
        if (levelCodesFile == null) {
            levelCodesFile = "";
        }
        if (StringUtil.checkIsEmpty((String)(levelCodes = levelCodes + levelCodesFile))) {
            return "('')";
        }
        levelCodes = levelCodes.substring(1, levelCodes.length());
        levelCodes = "('" + levelCodes.replace(",", "','") + "')";
        return levelCodes;
    }

    @Override
    public String getFileLevelCodeFront(FsFolderParams fsFolderParams) {
        String orgId = ShiroKit.getUser().getDeptName();
        String groupIds = String.join((CharSequence)",", fsFolderParams.getGroupList());
        String levelCodes = this.cacheToolService.getLevelCodeByUserCache(groupIds, fsFolderParams.getUserId(), "2", orgId);
        if (StringUtil.checkIsEmpty((String)(levelCodes = levelCodes + this.cacheToolService.getFileUpLevelCodeCache(groupIds, fsFolderParams.getUserId(), fsFolderParams.getLevelCodeString(), orgId, "front")))) {
            return "('')";
        }
        levelCodes = levelCodes.substring(1, levelCodes.length());
        levelCodes = "('" + levelCodes.replace(",", "','") + "')";
        return levelCodes;
    }

    @Override
    public String getFileLevelCodeFrontMobile(FsFolderParams fsFolderParams) {
        String orgId = ((SysUsers)this.iSysUsersService.selectById((Serializable)((Object)fsFolderParams.getUserId()))).getDepartmentId();
        String groupIds = String.join((CharSequence)",", fsFolderParams.getGroupList());
        String levelCodes = this.cacheToolService.getLevelCodeByUserCache(groupIds, fsFolderParams.getUserId(), "2", orgId);
        if (StringUtil.checkIsEmpty((String)(levelCodes = levelCodes + this.cacheToolService.getFileUpLevelCodeCache(groupIds, fsFolderParams.getUserId(), fsFolderParams.getLevelCodeString(), orgId, "front")))) {
            return "('')";
        }
        levelCodes = levelCodes.substring(1, levelCodes.length());
        levelCodes = "('" + levelCodes.replace(",", "','") + "')";
        return levelCodes;
    }

    @Override
    public String getMoveFileLevelCode(FsFolderParams fsFolderParams) {
        String orgId = ShiroKit.getUser().getDeptName();
        String groupIds = String.join((CharSequence)",", fsFolderParams.getGroupList());
        String levelCodes = this.cacheToolService.getLevelCodeByUserCache(groupIds, fsFolderParams.getUserId(), "2", orgId);
        String upLevelCodes = this.cacheToolService.getUpLevelCodeByUserCache(groupIds, fsFolderParams.getUserId(), "1", orgId);
        if (StringUtil.checkIsEmpty((String)(levelCodes = levelCodes + upLevelCodes))) {
            return "('')";
        }
        levelCodes = levelCodes.substring(1, levelCodes.length());
        levelCodes = "('" + levelCodes.replace(",", "','") + "')";
        return levelCodes;
    }
}

