/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.df.common.constant.app;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;

public enum DataSetTypeEnum {
    DATA_SET("0", "DATASET", "\u666e\u901a\u6570\u636e\u96c6"),
    SQL_DATA_SET("1", "SQL_DATASET", "sql\u6570\u636e\u96c6");

    private String value;
    private String functionType;
    private String common;

    private DataSetTypeEnum(String value, String functionType, String common) {
        this.value = value;
        this.functionType = functionType;
        this.common = common;
    }

    public String getValue() {
        return this.value;
    }

    public String getFunctionType() {
        return this.functionType;
    }

    public String getCommon() {
        return this.common;
    }

    public static String getFunctionTypeByValue(String value) {
        for (DataSetTypeEnum dataSetType : DataSetTypeEnum.values()) {
            if (!dataSetType.getValue().equals(value)) continue;
            return dataSetType.getFunctionType();
        }
        return DATA_SET.getFunctionType();
    }

    public static String getValueByFunctionType(String functionType) {
        for (DataSetTypeEnum dataSetType : DataSetTypeEnum.values()) {
            if (!dataSetType.getFunctionType().equals(functionType)) continue;
            return dataSetType.getValue();
        }
        return DATA_SET.getValue();
    }

    public static String parseFunctionType(String functionType) {
        if (HussarUtils.isBlank((CharSequence)functionType)) {
            return DATA_SET.getFunctionType();
        }
        for (DataSetTypeEnum dataSetType : DataSetTypeEnum.values()) {
            if (!dataSetType.getValue().equals(functionType)) continue;
            return dataSetType.getFunctionType();
        }
        return DATA_SET.getFunctionType();
    }
}

