/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.df.common.util;

import com.jxdinfo.hussar.df.common.constant.DfEngineColumnType;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class DfColumnTypeUtil {
    private static final List<DfEngineColumnType> DF_ENGINE_COLUMN_TYPES = new ArrayList<DfEngineColumnType>();

    public static Optional<DfEngineColumnType> getEngineColumnType(String dataType) {
        return DF_ENGINE_COLUMN_TYPES.stream().filter(x -> x.getDataType().equalsIgnoreCase(dataType)).findFirst();
    }

    public static Optional<DfEngineColumnType> getEngineColumnTypeByJavaType(String javaType) {
        return DF_ENGINE_COLUMN_TYPES.stream().filter(x -> x.getJavaType().equalsIgnoreCase(javaType)).findFirst();
    }

    static {
        DF_ENGINE_COLUMN_TYPES.add(new DfEngineColumnType(JDBCType.INTEGER, Integer.class.getName(), "int"));
        DF_ENGINE_COLUMN_TYPES.add(new DfEngineColumnType(JDBCType.VARCHAR, String.class.getName(), "string"));
        DF_ENGINE_COLUMN_TYPES.add(new DfEngineColumnType(JDBCType.VARCHAR, String.class.getName(), "arrayPrimary"));
        DF_ENGINE_COLUMN_TYPES.add(new DfEngineColumnType(JDBCType.VARCHAR, String.class.getName(), "treeObject"));
        DF_ENGINE_COLUMN_TYPES.add(new DfEngineColumnType(JDBCType.DOUBLE, Double.class.getName(), "double"));
        DF_ENGINE_COLUMN_TYPES.add(new DfEngineColumnType(JDBCType.DECIMAL, BigDecimal.class.getName(), "long"));
        DF_ENGINE_COLUMN_TYPES.add(new DfEngineColumnType(JDBCType.DATE, LocalDateTime.class.getName(), "date"));
        DF_ENGINE_COLUMN_TYPES.add(new DfEngineColumnType(JDBCType.DATE, Date.class.getName(), "datetime"));
        DF_ENGINE_COLUMN_TYPES.add(new DfEngineColumnType(JDBCType.TIME, Time.class.getName(), "time"));
        DF_ENGINE_COLUMN_TYPES.add(new DfEngineColumnType(JDBCType.TIMESTAMP, Timestamp.class.getName(), "timestamp"));
        DF_ENGINE_COLUMN_TYPES.add(new DfEngineColumnType(JDBCType.TINYINT, Boolean.class.getName(), "boolean"));
        DF_ENGINE_COLUMN_TYPES.add(new DfEngineColumnType(JDBCType.BIGINT, Long.class.getName(), "long"));
    }
}

