/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.df.data.set.server.table.service.impl;

import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysApplicationBoService;
import com.jxdinfo.hussar.datasource.manager.api.entity.MetadataColumn;
import com.jxdinfo.hussar.datasource.manager.api.entity.MetadataTable;
import com.jxdinfo.hussar.datasource.manager.plugin.metadata.service.MetadataColumnService;
import com.jxdinfo.hussar.datasource.manager.plugin.metadata.service.MetadataTableService;
import com.jxdinfo.hussar.df.common.constant.HussarDfType;
import com.jxdinfo.hussar.df.common.properties.DfProperties;
import com.jxdinfo.hussar.df.data.set.api.customsql.model.DfColumnValue;
import com.jxdinfo.hussar.df.data.set.api.model.DataSetModelBase;
import com.jxdinfo.hussar.df.data.set.api.model.ProjectionField;
import com.jxdinfo.hussar.df.data.set.api.table.service.DfTableService;
import com.jxdinfo.hussar.df.data.set.api.table.vo.LinkedDataSetVo;
import com.jxdinfo.hussar.df.data.set.server.table.form.model.SysDfForm;
import com.jxdinfo.hussar.df.data.set.server.table.form.service.ISysDfFormService;
import com.jxdinfo.hussar.df.data.set.server.table.util.DfTableTransFormUtil;
import com.jxdinfo.hussar.df.data.set.server.table.vo.DataSetTableVo;
import com.jxdinfo.hussar.df.data.set.server.table.vo.MetaTableInfo;
import com.jxdinfo.hussar.df.data.set.server.util.DataSetUtil;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.DatasourceConfigDTO;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.model.TableField;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.model.TableInfo;
import com.jxdinfo.hussar.formdesign.back.service.DatasourceDataService;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.external.require.engine.utils.LrEngineUtil;
import com.jxdinfo.hussar.formdesign.file.fileoperate.vo.DataSetTierTable;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.support.service.DynamicDatasourceService;
import com.jxdinfo.hussar.support.engine.api.entity.ModelRelationship;
import com.jxdinfo.hussar.support.engine.api.service.RelationshipService;
import com.jxdinfo.hussar.support.engine.plugin.model.application.IEnginePluginModelApp;
import com.jxdinfo.hussar.support.engine.plugin.model.service.ModelRelationshipService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DfTableServiceImpl
implements DfTableService {
    @Resource
    private MetadataTableService metadataTableService;
    @Resource
    private ModelRelationshipService modelRelationshipService;
    @Resource
    private ISysApplicationBoService sysApplicationBoService;
    @Resource
    private MetadataColumnService metadataColumnService;
    @Autowired(required=false)
    private ISysDfFormService formService;
    @Resource
    private DatasourceDataService datasourceDataService;
    @Autowired
    private DfProperties dfProperties;
    @Autowired
    private DynamicDatasourceService datasourceService;
    private final IEnginePluginModelApp iEnginePluginModelApp;
    private final RelationshipService relationshipService;

    public DfTableServiceImpl(IEnginePluginModelApp iEnginePluginModelApp, RelationshipService relationshipService) {
        this.iEnginePluginModelApp = iEnginePluginModelApp;
        this.relationshipService = relationshipService;
    }

    public Object list(Long id, String type) throws IOException, LcdpException {
        if (HussarDfType.LOW_CODE.getType().equals(this.dfProperties.getHussarType())) {
            return this.lowCodetableList(id, type);
        }
        return this.noCodeSqlList(false);
    }

    public List<DataSetTierTable> sqlList(Long id, String type) throws IOException, LcdpException {
        if (HussarDfType.LOW_CODE.getType().equals(this.dfProperties.getHussarType())) {
            return this.lowCodeSqlList(id, type);
        }
        return this.noCodeSqlList(true);
    }

    public List<ProjectionField> dataSetColumn(Long dataSetId) throws IOException, LcdpException {
        DataSetModelBase dataSetModelBase = DataSetUtil.getDataModelBase(dataSetId);
        return dataSetModelBase.getProjection();
    }

    public List<DfColumnValue> dataSetParam(Long dataSetId) {
        DataSetModelBase dataSetModelBase = DataSetUtil.getDataModelBase(dataSetId);
        return dataSetModelBase.getParameterValues();
    }

    public List<DatasourceConfigDTO> getDataSourceList() throws IOException {
        List datasourceConfigDTOS = this.datasourceDataService.getList();
        if (this.dfProperties.isNoCode()) {
            String currentDatasourceName = this.datasourceService.getCurrentDatasourceName();
            datasourceConfigDTOS = datasourceConfigDTOS.stream().filter(e -> HussarUtils.equals((Object)currentDatasourceName, (Object)e.getName())).collect(Collectors.toList());
        }
        return datasourceConfigDTOS;
    }

    public LinkedDataSetVo getTableInfo(Long id, String type, String tableName) throws IOException, LcdpException {
        Optional optionalTableInfo = this.datasourceDataService.filterTable(id, type, tableName);
        if (!optionalTableInfo.isPresent()) {
            throw new IOException("\u6570\u636e\u6e90\u4e0d\u5b58\u5728");
        }
        TableInfo tableInfo = (TableInfo)optionalTableInfo.get();
        LinkedDataSetVo table = new LinkedDataSetVo();
        table.setName(tableInfo.getName());
        table.setCode(table.getName());
        table.setComment(tableInfo.getComment());
        table.setType("2");
        table.setTableId(Long.valueOf(LrEngineUtil.nextId()));
        for (TableField tableField : tableInfo.getFields()) {
            LinkedDataSetVo field = new LinkedDataSetVo();
            field.setName(tableField.getName());
            field.setColumnId(Long.valueOf(LrEngineUtil.nextId()));
            field.setCode(tableInfo.getName() + "_" + tableField.getName());
            field.setRealName(tableField.getRealName());
            field.setComment(tableField.getComment());
            field.setDataType(tableField.getType());
            field.setType("3");
            table.addField(field);
        }
        return table;
    }

    private List<DataSetTableVo> noCodeList() {
        List forms = this.formService.list();
        List applications = this.sysApplicationBoService.list();
        List modelRelationships = this.modelRelationshipService.list();
        List metadataTables = this.metadataTableService.list();
        List metadataColumns = this.metadataColumnService.list();
        HashMap<Long, SysApplication> applicationMap = new HashMap<Long, SysApplication>();
        HashMap<String, SysDfForm> formMap = new HashMap<String, SysDfForm>();
        HashMap<Long, DataSetTableVo> dataSetTableVoHashMap = new HashMap<Long, DataSetTableVo>();
        HashMap<Long, MetadataTable> metadataTableMap = new HashMap<Long, MetadataTable>();
        HashMap<Long, ModelRelationship> modelRelationshipMap = new HashMap<Long, ModelRelationship>();
        HashMap<Long, Map<Long, List<DataSetTableVo>>> dataSetTableVoMap = new HashMap<Long, Map<Long, List<DataSetTableVo>>>();
        for (SysApplication application : applications) {
            applicationMap.put(application.getId(), application);
        }
        for (SysDfForm form : forms) {
            formMap.put(form.getTableName(), form);
        }
        for (MetadataTable metadataTable : metadataTables) {
            SysApplication application;
            metadataTableMap.put(metadataTable.getTableId(), metadataTable);
            SysDfForm form = (SysDfForm)((Object)formMap.get(metadataTable.getTableAlias()));
            if (HussarUtils.isEmpty((Object)((Object)form)) || HussarUtils.isEmpty((Object)(application = (SysApplication)applicationMap.get(form.getAppId())))) continue;
            DataSetTableVo dataSetTableVo = DfTableTransFormUtil.transformTable(metadataTable);
            dataSetTableVo.setAppId(form.getAppId());
            dataSetTableVo.setAppName(application.getAppName());
            dataSetTableVoHashMap.put(dataSetTableVo.getTableId(), dataSetTableVo);
            this.addDataSetTableVoMap(dataSetTableVoMap, form.getAppId(), metadataTable.getTableId(), dataSetTableVo);
        }
        for (ModelRelationship modelRelationship : modelRelationships) {
            modelRelationshipMap.put(modelRelationship.getRelatedId(), modelRelationship);
        }
        for (ModelRelationship modelRelationship : modelRelationships) {
            DataSetTableVo parentDataSetTableVo;
            ModelRelationship parentModelRelationship;
            Long parentId = modelRelationship.getParentId();
            if (HussarUtils.isEmpty((Object)parentId) || HussarUtils.isEmpty((Object)(parentModelRelationship = (ModelRelationship)modelRelationshipMap.get(parentId))) || HussarUtils.isEmpty((Object)(parentDataSetTableVo = (DataSetTableVo)dataSetTableVoHashMap.get(parentModelRelationship.getTableId())))) continue;
            MetadataTable metadataTable = (MetadataTable)metadataTableMap.get(modelRelationship.getTableId());
            DataSetTableVo dataSetTableVo = (DataSetTableVo)dataSetTableVoHashMap.get(modelRelationship.getTableId());
            if (!HussarUtils.isEmpty((Object)dataSetTableVo)) continue;
            dataSetTableVo = DfTableTransFormUtil.transformTable(metadataTable);
            dataSetTableVoHashMap.put(dataSetTableVo.getTableId(), dataSetTableVo);
            this.addDataSetTableVoMap(dataSetTableVoMap, parentDataSetTableVo.getAppId(), parentDataSetTableVo.getTableId(), dataSetTableVo);
            dataSetTableVo.setParentTabName(parentDataSetTableVo.getName());
            dataSetTableVo.setParentTabComm(parentDataSetTableVo.getComment());
            dataSetTableVo.setAppName(parentDataSetTableVo.getAppName());
        }
        for (MetadataColumn metadataColumn : metadataColumns) {
            DataSetTableVo dataSetTableVo = (DataSetTableVo)dataSetTableVoHashMap.get(metadataColumn.getTableId());
            if (HussarUtils.isEmpty((Object)dataSetTableVo)) continue;
            dataSetTableVo.addFields(DfTableTransFormUtil.transformField(metadataColumn));
        }
        return this.transFormMapToList(dataSetTableVoMap);
    }

    private List<DataSetTierTable> noCodeSqlList(Boolean linkedDataSet) {
        ArrayList<DataSetTierTable> appTables = new ArrayList<DataSetTierTable>();
        List forms = this.formService.list();
        List applications = this.sysApplicationBoService.list();
        HashMap formAppMap = new HashMap();
        for (SysApplication application : applications) {
            List collect = forms.stream().filter(form -> form.getAppId().equals(application.getId())).collect(Collectors.toList());
            if (collect.size() <= 0) continue;
            formAppMap.put(application.getId(), collect);
        }
        List metadataTables = this.metadataTableService.list();
        Map<Long, MetadataTable> metadataTableMap = metadataTables.stream().collect(Collectors.toMap(MetadataTable::getTableId, Function.identity(), (K1, K2) -> K1));
        List metadataColumns = this.metadataColumnService.list();
        List modelRelationships = this.modelRelationshipService.list();
        Map<Long, ModelRelationship> modelRelationshipMap = modelRelationships.stream().collect(Collectors.toMap(ModelRelationship::getRelatedId, Function.identity()));
        HashMap<String, MetadataTable> masterTableMap = new HashMap<String, MetadataTable>();
        for (SysDfForm form2 : forms) {
            MetadataTable metadataTable1 = metadataTables.stream().filter(metadataTable -> metadataTable.getTableName().equalsIgnoreCase(form2.getTableName())).findFirst().orElse(null);
            if (HussarUtils.isEmpty((Object)metadataTable1)) continue;
            masterTableMap.put(metadataTable1.getTableName().toUpperCase(), metadataTable1);
        }
        HashMap<Long, List<MetaTableInfo>> slaveTableVoMap = new HashMap<Long, List<MetaTableInfo>>();
        this.dealSlaveTable(modelRelationships, modelRelationshipMap, slaveTableVoMap, metadataColumns, metadataTableMap, metadataTables);
        for (SysApplication application : applications) {
            DataSetTierTable appInfo = new DataSetTierTable();
            appInfo.setName(application.getAppCode());
            appInfo.setCode(application.getAppCode());
            appInfo.setComment(application.getAppName());
            appInfo.setType("1");
            appInfo.setAppId(application.getId());
            List sysForms = (List)formAppMap.get(application.getId());
            if (HussarUtils.isEmpty((Object)sysForms)) continue;
            for (SysDfForm sysForm : sysForms) {
                MetadataTable metadataTable2 = (MetadataTable)masterTableMap.get(sysForm.getTableName().toUpperCase());
                if (!HussarUtils.isNotEmpty((Object)metadataTable2)) continue;
                List<MetadataColumn> metadataColumnStream = metadataColumns.stream().filter(column -> column.getTableId().equals(metadataTable2.getTableId())).collect(Collectors.toList());
                this.transMasterFileds(appInfo, metadataTable2, metadataColumnStream, linkedDataSet);
                List metaTableInfos = (List)slaveTableVoMap.get(metadataTable2.getTableId());
                if (!HussarUtils.isNotEmpty((Object)metaTableInfos)) continue;
                for (MetaTableInfo metaTableInfo : metaTableInfos) {
                    this.transSlaveFileds(appInfo, metaTableInfo, linkedDataSet);
                }
            }
            appTables.add(appInfo);
        }
        return appTables;
    }

    private void transMasterFileds(DataSetTierTable appTables, MetadataTable metadataTable, List<MetadataColumn> metadataColumns, Boolean linkedDataSet) {
        DataSetTierTable table = new DataSetTierTable();
        table.setName(metadataTable.getTableName());
        table.setCode(metadataTable.getTableName());
        table.setComment(metadataTable.getTableDec());
        table.setType("2");
        table.setTableId(metadataTable.getTableId());
        for (MetadataColumn metadataColumn : metadataColumns) {
            DataSetTierTable field = new DataSetTierTable();
            field.setName(metadataColumn.getColumnName());
            field.setCode(metadataTable.getTableName() + "_" + metadataColumn.getColumnName());
            field.setComment(metadataColumn.getColumnComment());
            field.setColumnId(metadataColumn.getColumnId());
            field.setType("3");
            field.setDataType(metadataColumn.getJdbcType());
            field.setJavaType(metadataColumn.getJavaType());
            if (linkedDataSet.booleanValue()) {
                table.addChild(field);
                continue;
            }
            table.addfields(field);
        }
        if (HussarUtils.isNotEmpty((Object)table)) {
            appTables.addChild(table);
        }
    }

    private void transSlaveFileds(DataSetTierTable appTables, MetaTableInfo metaTableInfo, Boolean linkedDataSet) {
        DataSetTierTable table = new DataSetTierTable();
        MetadataTable metadataTable = metaTableInfo.getMetadataTable();
        List<MetadataColumn> metadataColumnList = metaTableInfo.getMetadataColumn();
        table.setName(metadataTable.getTableName());
        table.setCode(metadataTable.getTableName());
        table.setComment(metadataTable.getTableDec());
        table.setType("2");
        table.setTableId(metadataTable.getTableId());
        for (MetadataColumn metadataColumn : metadataColumnList) {
            DataSetTierTable field = new DataSetTierTable();
            field.setName(metadataColumn.getColumnName());
            field.setCode(metadataTable.getTableName() + "_" + metadataColumn.getColumnName());
            field.setComment(metadataColumn.getColumnComment());
            field.setColumnId(metadataColumn.getColumnId());
            field.setType("3");
            field.setDataType(metadataColumn.getJdbcType());
            field.setJavaType(metadataColumn.getJavaType());
            if (linkedDataSet.booleanValue()) {
                table.addChild(field);
                continue;
            }
            table.addfields(field);
        }
        if (HussarUtils.isNotEmpty((Object)table)) {
            appTables.addChild(table);
        }
    }

    private void dealSlaveTable(List<ModelRelationship> modelRelationships, Map<Long, ModelRelationship> modelRelationshipMap, Map<Long, List<MetaTableInfo>> dataSetTableVoMapList, List<MetadataColumn> metadataColumns, Map<Long, MetadataTable> metadataTableMap, List<MetadataTable> metadataTables) {
        HashSet<Long> tableIds = new HashSet<Long>();
        for (ModelRelationship modelRelationship : modelRelationships) {
            MetadataTable metadataTable;
            Long tableId;
            ModelRelationship parentModelRelationship;
            Long parentId = modelRelationship.getParentId();
            if (HussarUtils.isEmpty((Object)parentId) || HussarUtils.isEmpty((Object)(parentModelRelationship = modelRelationshipMap.get(parentId))) || !HussarUtils.isNotEmpty((Object)metadataTableMap.get(tableId = parentModelRelationship.getTableId())) || !tableIds.add((metadataTable = metadataTables.stream().filter(table -> table.getTableId().equals(modelRelationship.getTableId())).findFirst().get()).getTableId())) continue;
            List<MetadataColumn> metadataColumnList = metadataColumns.stream().filter(metadataColumn -> metadataColumn.getTableId().equals(metadataTable.getTableId())).collect(Collectors.toList());
            final MetaTableInfo metadataTableInfo = new MetaTableInfo();
            metadataTableInfo.setMetadataTable(metadataTable);
            metadataTableInfo.setMetadataColumn(metadataColumnList);
            if (HussarUtils.isNotEmpty(dataSetTableVoMapList.get(tableId))) {
                dataSetTableVoMapList.get(tableId).add(metadataTableInfo);
                continue;
            }
            dataSetTableVoMapList.put(tableId, (List<MetaTableInfo>)new ArrayList<MetaTableInfo>(){
                {
                    this.add(metadataTableInfo);
                }
            });
        }
    }

    private void transFileds(List<DataSetTierTable> appTables, Map<Long, DataSetTierTable> tableMap, List<MetadataColumn> metadataColumns, Boolean linkedDataSet, Map<String, List<MetadataTable>> dataSetTableVoMapList) {
        for (MetadataColumn metadataColumn : metadataColumns) {
            DataSetTierTable table = tableMap.get(metadataColumn.getTableId());
            if (table == null) continue;
            DataSetTierTable field = new DataSetTierTable();
            field.setName(metadataColumn.getColumnName());
            field.setCode(table.getName() + "_" + metadataColumn.getColumnName());
            field.setComment(metadataColumn.getColumnComment());
            field.setColumnId(metadataColumn.getColumnId());
            field.setType("3");
            field.setDataType(metadataColumn.getJdbcType());
            field.setJavaType(metadataColumn.getJavaType());
            if (linkedDataSet.booleanValue()) {
                table.addChild(field);
                continue;
            }
            table.addfields(field);
        }
    }

    private void addDataSetTableVoMap(Map<Long, Map<Long, List<DataSetTableVo>>> dataSetTableVoMap, Long appId, Long masterTableId, DataSetTableVo dataSetTableVo) {
        List<DataSetTableVo> dataSetTableVos;
        Map<Long, List<DataSetTableVo>> appMap = dataSetTableVoMap.get(appId);
        if (HussarUtils.isEmpty(appMap)) {
            appMap = new HashMap<Long, List<DataSetTableVo>>();
            dataSetTableVoMap.put(appId, appMap);
        }
        if (HussarUtils.isEmpty(dataSetTableVos = appMap.get(masterTableId))) {
            dataSetTableVos = new ArrayList<DataSetTableVo>();
            appMap.put(masterTableId, dataSetTableVos);
        }
        dataSetTableVos.add(dataSetTableVo);
    }

    private List<DataSetTableVo> transFormMapToList(Map<Long, Map<Long, List<DataSetTableVo>>> dataSetTableVoMap) {
        ArrayList<DataSetTableVo> dataSetTableVos = new ArrayList<DataSetTableVo>();
        for (Map.Entry<Long, Map<Long, List<DataSetTableVo>>> appEntry : dataSetTableVoMap.entrySet()) {
            Map<Long, List<DataSetTableVo>> tableMap = appEntry.getValue();
            for (Map.Entry<Long, List<DataSetTableVo>> tableEntry : tableMap.entrySet()) {
                List<DataSetTableVo> dataSetTableVoList = tableEntry.getValue();
                dataSetTableVos.addAll(dataSetTableVoList);
            }
        }
        return dataSetTableVos;
    }

    private List<TableInfo> lowCodeList(Long id, String type) throws IOException, LcdpException {
        return this.datasourceDataService.getTableInfoById(id, type);
    }

    private List<DataSetTierTable> lowCodeSqlList(Long id, String type) throws IOException, LcdpException {
        ArrayList<DataSetTierTable> tables = new ArrayList<DataSetTierTable>();
        List tableInfos = this.datasourceDataService.getTableInfoById(id, type);
        for (TableInfo tableInfo : tableInfos) {
            DataSetTierTable table = new DataSetTierTable();
            table.setName(tableInfo.getName());
            table.setCode(tableInfo.getName());
            table.setComment(tableInfo.getComment());
            table.setType("2");
            tables.add(table);
            if (HussarUtils.isEmpty((Object)tableInfo.getFields())) continue;
            for (TableField tableField : tableInfo.getFields()) {
                DataSetTierTable field = new DataSetTierTable();
                field.setName(tableField.getName());
                field.setCode(tableInfo.getName() + "_" + tableField.getName());
                field.setComment(tableField.getComment());
                field.setDataType(tableField.getType());
                field.setType("3");
                table.addChild(field);
            }
        }
        return tables;
    }

    public List<LinkedDataSetVo> lowCodetableList(Long id, String type) throws IOException, LcdpException {
        ArrayList<LinkedDataSetVo> tables = new ArrayList<LinkedDataSetVo>();
        List tableInfos = this.datasourceDataService.getTableInfoById(id, type);
        if (HussarUtils.isEmpty((Object)tableInfos)) {
            ToolUtil.getLogger(DfTableServiceImpl.class).info("\u5f53\u524d\u6570\u636e\u6e90id\u4e3a:{}\uff0c\u672a\u67e5\u8be2\u5230\u8868\u4fe1\u606f!", (Object)id);
            return tables;
        }
        for (TableInfo tableInfo : tableInfos) {
            LinkedDataSetVo table = new LinkedDataSetVo();
            table.setName(tableInfo.getName());
            table.setCode(table.getName());
            table.setComment(tableInfo.getComment());
            table.setType("2");
            table.setTableId(Long.valueOf(LrEngineUtil.nextId()));
            tables.add(table);
            if (HussarUtils.isEmpty((Object)tableInfo.getFields())) continue;
            for (TableField tableField : tableInfo.getFields()) {
                LinkedDataSetVo field = new LinkedDataSetVo();
                field.setName(tableField.getName());
                field.setColumnId(Long.valueOf(LrEngineUtil.nextId()));
                field.setCode(tableInfo.getName() + "_" + tableField.getName());
                field.setRealName(tableField.getRealName());
                field.setComment(tableField.getComment());
                field.setDataType(tableField.getType());
                field.setType("3");
                table.addField(field);
            }
        }
        return tables;
    }
}

