/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.df.data.set.server.dataset.service.impl;

import com.jxdinfo.hussar.df.data.set.api.customsql.model.DfColumnValue;
import com.jxdinfo.hussar.df.data.set.api.dataset.service.DataSetService;
import com.jxdinfo.hussar.df.data.set.api.model.DataSetModel;
import com.jxdinfo.hussar.df.data.set.api.model.DataSetQueryModel;
import com.jxdinfo.hussar.df.data.set.api.model.DataSetSortModel;
import com.jxdinfo.hussar.df.data.set.api.model.DataSetTableField;
import com.jxdinfo.hussar.df.data.set.api.model.DataSetTables;
import com.jxdinfo.hussar.df.data.set.api.model.JoinSubset;
import com.jxdinfo.hussar.df.data.set.api.model.JoinTable;
import com.jxdinfo.hussar.df.data.set.api.model.ProjectionField;
import com.jxdinfo.hussar.df.data.set.server.constant.DataSetSqlConnectEnum;
import com.jxdinfo.hussar.df.data.set.server.constant.JdbcTransform;
import com.jxdinfo.hussar.df.data.set.server.util.DataSetUtil;
import com.jxdinfo.hussar.df.data.set.server.util.DataTypeConverter;
import com.jxdinfo.hussar.df.data.set.server.util.DfDataSourceUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class DataSetServiceImpl
implements DataSetService {
    private static final String whereStr = "<if test = \"${condition}\"> ${where}</if>";
    private static final String tirmStr = "<trim  prefix=\"(\" suffix= \")\" suffixOverrides=\"and\"> %s </trim>";
    private static final String tirmWhere = "<trim  prefix=\"\" suffix= \"\" suffixOverrides=\"and\"> %s </trim>";
    private JdbcTransform jdbcTransform = JdbcTransform.OTHER;
    private Long dataSourceId;
    private Map<String, String> parameterValueTypeMap;

    public ApiResponse<String> generateSql(DataSetModel dataSetModel, boolean isPreview) {
        StringBuilder stringBuilder;
        this.dataSourceId = dataSetModel.getDataSourceId();
        this.jdbcTransform = DfDataSourceUtil.getTransformStr(dataSetModel.getDataSourceId());
        this.parameterValueTypeMap = new HashMap<String, String>();
        for (DfColumnValue parameterValue : dataSetModel.getParameterValues()) {
            this.parameterValueTypeMap.put(parameterValue.getCode(), parameterValue.getType());
        }
        StringBuilder sql = new StringBuilder();
        if (dataSetModel.getTables() == null || HussarUtils.isEmpty((Object)dataSetModel.getTables()) || dataSetModel.getTables().isEmpty()) {
            return ApiResponse.fail((String)"\u6570\u636e\u96c6\u672a\u9009\u62e9\u8868");
        }
        sql.append("SELECT ");
        if (dataSetModel.getProjection() == null || !HussarUtils.isNotEmpty((Object)dataSetModel.getProjection()) || dataSetModel.getProjection().isEmpty()) {
            return ApiResponse.fail((String)"\u6570\u636e\u96c6\u5b57\u6bb5\u914d\u7f6e\u9519\u8bef");
        }
        sql.append((CharSequence)this.combineField(dataSetModel));
        if (HussarUtils.isEmpty((Object)dataSetModel.getRelationship()) && dataSetModel.getTables().size() > 1) {
            return ApiResponse.fail((String)"\u6570\u636e\u96c6\u672a\u914d\u7f6e\u5173\u8054\u5173\u7cfb");
        }
        if (dataSetModel.getTables().size() == 1) {
            sql.append("\n").append("FROM ");
            sql.append(this.jdbcTransform.getStart()).append(((DataSetTables)dataSetModel.getTables().get(0)).getName()).append(this.jdbcTransform.getEnd()).append("\n");
        }
        if (dataSetModel.getRelationship() != null && HussarUtils.isNotEmpty((Object)dataSetModel.getRelationship()) && !dataSetModel.getRelationship().isEmpty()) {
            sql.append("\n").append("FROM ");
            stringBuilder = this.convertJoin(dataSetModel.getRelationship(), dataSetModel);
            if (HussarUtils.isBlank((CharSequence)stringBuilder)) {
                return ApiResponse.fail((String)"\u6570\u636e\u96c6\u5173\u8054\u914d\u7f6e\u9519\u8bef");
            }
            sql.append((CharSequence)stringBuilder);
        }
        if (dataSetModel.getQuery() != null && HussarUtils.isNotEmpty((Object)dataSetModel.getQuery()) && !dataSetModel.getQuery().isEmpty()) {
            stringBuilder = this.convertquery(dataSetModel.getQuery());
            if (stringBuilder == null) {
                return ApiResponse.fail((String)"\u6570\u636e\u96c6\u8fc7\u6ee4\u6761\u4ef6\u914d\u7f6e\u9519\u8bef");
            }
            if (!"".contentEquals(stringBuilder)) {
                if (isPreview) {
                    sql.append("WHERE ").append((CharSequence)stringBuilder);
                } else {
                    String format = String.format(tirmWhere, stringBuilder);
                    sql.append("<where> ").append(format).append("</where>");
                }
            }
        }
        if (dataSetModel.getSort() != null && HussarUtils.isNotEmpty((Object)dataSetModel.getSort()) && !dataSetModel.getSort().isEmpty()) {
            stringBuilder = this.convertSort(dataSetModel.getSort());
            if (HussarUtils.isBlank((CharSequence)stringBuilder)) {
                return ApiResponse.fail((String)"\u6392\u5e8f\u6761\u4ef6\u914d\u7f6e\u9519\u8bef");
            }
            sql.append((CharSequence)stringBuilder);
        }
        return ApiResponse.success((Object)sql.toString(), (String)"\u67e5\u8be2\u6210\u529f\uff01");
    }

    public StringBuilder combineField(DataSetModel dataSetModel) {
        List projectionFields = dataSetModel.getProjection();
        StringBuilder sql = new StringBuilder();
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        for (DataSetTables dataSetTables : dataSetModel.getTables()) {
            for (DataSetTableField dataSetTableField : dataSetTables.getFields()) {
                HashMap field = new HashMap();
                String fieldName = dataSetTables.getName() + "." + dataSetTableField.getName();
                fieldMap.put(dataSetTableField.getColumnId(), fieldName);
            }
        }
        for (ProjectionField projectionField : projectionFields) {
            if ("default".equals(projectionField.getType())) {
                sql.append(this.jdbcTransform.getStart()).append(projectionField.getTable()).append(this.jdbcTransform.getEnd()).append(".").append(this.jdbcTransform.getStart()).append(projectionField.getField()).append(this.jdbcTransform.getEnd());
                if (HussarUtils.isNotEmpty((Object)projectionField.getFieldAlias())) {
                    sql.append(" AS ").append(this.jdbcTransform.getStart()).append(projectionField.getFieldAlias()).append(this.jdbcTransform.getEnd());
                }
                sql.append(",").append("\n");
                continue;
            }
            if (!"calc".equals(projectionField.getType())) continue;
            String expression = projectionField.getExpression();
            String expressionSql = DataSetUtil.replacePlaceholders(expression, fieldMap);
            sql.append(expressionSql);
            sql.append(" AS \"").append(projectionField.getFieldAlias()).append("\"").append(",").append("\n");
        }
        if (!sql.toString().isEmpty()) {
            sql.setLength(sql.length() - 2);
        }
        return sql;
    }

    public StringBuilder convertJoin(List<JoinTable> joinTables, DataSetModel dataSetModel) {
        StringBuilder sql = new StringBuilder();
        int joinTableNum = 1;
        for (JoinTable joinTable : joinTables) {
            int times = 1;
            if (HussarUtils.isBlank((CharSequence)joinTable.getLeftTable()) || HussarUtils.isBlank((CharSequence)joinTable.getRightTable())) {
                return new StringBuilder();
            }
            String joinType = null;
            switch (joinTable.getJoinType()) {
                case "left": {
                    joinType = "LEFT JOIN";
                    break;
                }
                case "right": {
                    joinType = "RIGHT JOIN";
                    break;
                }
                case "inner": {
                    joinType = "INNER JOIN";
                    break;
                }
            }
            if (joinTableNum == 1) {
                sql.append(joinTable.getLeftTable()).append(" ").append(joinType).append(" ").append(this.jdbcTransform.getStart()).append(joinTable.getRightTable()).append(this.jdbcTransform.getEnd()).append(" ON ");
            } else {
                sql.append(joinType).append(" ").append(this.jdbcTransform.getStart()).append(joinTable.getRightTable()).append(this.jdbcTransform.getEnd()).append(" ON ");
            }
            for (JoinSubset joinSubset : joinTable.getChildren()) {
                boolean flag = false;
                for (DataSetTables table : dataSetModel.getTables()) {
                    for (DataSetTableField field : table.getFields()) {
                        if (!joinSubset.getLeftFieldId().equals(field.getColumnId())) continue;
                        joinTable.setLeftTable(table.getName());
                        flag = true;
                        break;
                    }
                    if (!flag) continue;
                    break;
                }
                sql.append(this.jdbcTransform.getStart()).append(joinTable.getLeftTable()).append(this.jdbcTransform.getEnd()).append(".").append(this.jdbcTransform.getStart()).append(joinSubset.getLeftField()).append(this.jdbcTransform.getEnd()).append(" ").append(joinSubset.getCondition()).append(" ").append(this.jdbcTransform.getStart()).append(joinTable.getRightTable()).append(this.jdbcTransform.getEnd()).append(".").append(this.jdbcTransform.getStart()).append(joinSubset.getRightField()).append(this.jdbcTransform.getEnd()).append(" ").append("\n");
                if (times != joinTable.getChildren().size()) {
                    sql.append(joinSubset.getPreCondition()).append(" ");
                }
                ++times;
            }
            ++joinTableNum;
        }
        return sql;
    }

    public StringBuilder convertquery(List<DataSetQueryModel> filterList) {
        StringBuilder sql = new StringBuilder();
        int i = 0;
        for (DataSetQueryModel tableFilter : filterList) {
            if ("constant".equals(tableFilter.getParamType())) {
                tableFilter.setValue(this.fieldType(tableFilter.getFieldType(), tableFilter.getValue(), tableFilter.getCondition()));
            }
            if ("row".equals(tableFilter.getType())) {
                if (HussarUtils.isNotEmpty((Object)tableFilter.getTable()) && HussarUtils.isNotEmpty((Object)tableFilter.getField()) && HussarUtils.isNotEmpty((Object)tableFilter.getCondition()) && (HussarUtils.isNotEmpty((Object)tableFilter.getValue()) || DataSetSqlConnectEnum.isNullOrNotNull(tableFilter.getCondition()))) {
                    if (!this.splitIfCondition(sql, tableFilter, i)) {
                        return null;
                    }
                    if (++i != filterList.size()) continue;
                    if (!sql.toString().toLowerCase().endsWith("</if>")) {
                        sql.setLength(sql.length() - (tableFilter.getPreCondition().length() + 1));
                        continue;
                    }
                    sql.setLength(sql.length() - (tableFilter.getPreCondition().length() + 6));
                    sql.append("</if>");
                    continue;
                }
                return null;
            }
            if ("child".equals(tableFilter.getType()) && HussarUtils.isNotEmpty((Object)tableFilter.getChildren())) {
                StringBuilder convertquery = this.convertquery(tableFilter.getChildren());
                if (convertquery == null) {
                    return null;
                }
                String format = String.format(tirmStr, convertquery);
                sql.append(format).append(" ").append(tableFilter.getPreCondition()).append("\n");
                continue;
            }
            return null;
        }
        return sql;
    }

    private boolean splitIfCondition(StringBuilder sql, DataSetQueryModel tableFilter, int i) {
        StringBuilder whereChild = new StringBuilder();
        StringBuilder queryByType = this.getQueryByType(tableFilter);
        if (queryByType == null) {
            return false;
        }
        whereChild.append((CharSequence)queryByType);
        if ("constant".equals(tableFilter.getParamType()) || HussarUtils.isBlank((CharSequence)tableFilter.getValue().toString().replace("'", ""))) {
            sql.append((CharSequence)whereChild);
        } else {
            String replace = whereStr.replace("${where}", whereChild);
            String replaceStr = tableFilter.getValue().toString().replace("'", "");
            String format = String.format("%s != null", replaceStr);
            String replaceResult = replace.replace("${condition}", format);
            sql.append(replaceResult);
        }
        return true;
    }

    public Object fieldType(String fieldType, Object fieldValue, String condition) {
        if (DataSetSqlConnectEnum._REGEXP.getKey().equals(condition)) {
            return "'" + fieldValue + "'";
        }
        if (DataSetSqlConnectEnum.isNotCommas(condition)) {
            return fieldValue;
        }
        switch (fieldType = DataTypeConverter.dataTypeConverted(fieldType, this.dataSourceId)) {
            case "string": 
            case "date": {
                return "'" + fieldValue + "'";
            }
            case "int": {
                try {
                    return Integer.parseInt(String.valueOf(fieldValue));
                }
                catch (Exception e) {
                    return "'" + fieldValue + "'";
                }
            }
            case "long": {
                try {
                    return Long.parseLong(String.valueOf(fieldValue));
                }
                catch (Exception e) {
                    return "'" + fieldValue + "'";
                }
            }
            case "double": {
                try {
                    return Double.parseDouble(String.valueOf(fieldValue));
                }
                catch (Exception e) {
                    return "'" + fieldValue + "'";
                }
            }
            case "boolean": {
                try {
                    return Boolean.parseBoolean(String.valueOf(fieldValue));
                }
                catch (Exception e) {
                    return "'" + fieldValue + "'";
                }
            }
        }
        return "'" + fieldValue + "'";
    }

    public StringBuilder getQueryByType(DataSetQueryModel tableFilter) {
        StringBuilder sql = new StringBuilder();
        Object value = "variable".equals(tableFilter.getParamType()) ? String.format("#{%s}", tableFilter.getValue()) : tableFilter.getValue();
        sql.append(this.jdbcTransform.getStart()).append(tableFilter.getTable()).append(this.jdbcTransform.getEnd()).append(".");
        DataSetSqlConnectEnum connectEnum = DataSetSqlConnectEnum.getByKey(tableFilter.getCondition().toLowerCase());
        if (connectEnum == null) {
            return null;
        }
        switch (connectEnum) {
            case _GREAT_THAN: 
            case _LESS_THAN: 
            case _EQUAL: 
            case _NOT_EQUAL: 
            case _LESS_AND_THAN: 
            case _GREAT_AND_THAN: 
            case _REGEXP: {
                sql.append(this.jdbcTransform.getStart()).append(tableFilter.getField()).append(this.jdbcTransform.getEnd()).append(" ").append(connectEnum.getValue()).append(" ").append(value).append(" ");
                break;
            }
            case _IN: 
            case _NOT_IN: {
                sql.append(this.jdbcTransform.getStart()).append(tableFilter.getField()).append(this.jdbcTransform.getEnd()).append(" ").append(connectEnum.getValue());
                if ("constant".equals(tableFilter.getParamType())) {
                    sql.append(" (").append(value).append(") ");
                    break;
                }
                if ("variable".equals(tableFilter.getParamType()) && "arrayPrimary".equals(this.parameterValueTypeMap.get((String)tableFilter.getValue()))) {
                    sql.append(" <foreach item=\"item\" index=\"index\" collection=\"").append((String)tableFilter.getValue()).append("\" open=\"(\" separator=\",\" close=\")\">\n #{item}\n</foreach> ");
                    break;
                }
                sql.append(" (").append(value).append(") ");
                break;
            }
            case _FULL_LIKE: {
                value = "variable".equals(tableFilter.getParamType()) ? value : String.format("'%s'", value);
                sql.append(this.jdbcTransform.getStart()).append(tableFilter.getField()).append(this.jdbcTransform.getEnd()).append(" ").append(connectEnum.getValue()).append(" CONCAT('%', ").append(value).append(", '%')");
                break;
            }
            case _LEFT_LIKE: {
                value = "variable".equals(tableFilter.getParamType()) ? value : String.format("'%s'", value);
                sql.append(this.jdbcTransform.getStart()).append(tableFilter.getField()).append(this.jdbcTransform.getEnd()).append(" ").append(connectEnum.getValue()).append(" CONCAT(").append(value).append(", '%')");
                break;
            }
            case _RIGHT_LIKE: {
                value = "variable".equals(tableFilter.getParamType()) ? value : String.format("'%s'", value);
                sql.append(this.jdbcTransform.getStart()).append(tableFilter.getField()).append(this.jdbcTransform.getEnd()).append(" ").append(connectEnum.getValue()).append(" CONCAT('%', ").append(value).append(")");
                break;
            }
            case _NULL: 
            case _IS_NULL: 
            case _NOT_NULL: 
            case _IS_NOT_NULL: {
                sql.append(this.jdbcTransform.getStart()).append(tableFilter.getField()).append(this.jdbcTransform.getEnd()).append(" ").append(connectEnum.getValue()).append(" ");
            }
        }
        sql.append(tableFilter.getPreCondition()).append("\n");
        return sql;
    }

    public StringBuilder convertSort(List<DataSetSortModel> sortConditionList) {
        StringBuilder sql = new StringBuilder();
        sql.append("ORDER BY ");
        for (DataSetSortModel joinSort : sortConditionList) {
            if (DataSetUtil.haveNullFiled(joinSort)) {
                return new StringBuilder();
            }
            sql.append(this.jdbcTransform.getStart()).append(joinSort.getTable()).append(this.jdbcTransform.getEnd()).append(".").append(this.jdbcTransform.getStart()).append(joinSort.getField()).append(this.jdbcTransform.getEnd()).append(" ").append(joinSort.getDirection()).append(",").append("\n");
        }
        sql.deleteCharAt(sql.length() - 2);
        return sql;
    }
}

