/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.df.data.set.server.dataset.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.df.data.set.api.dataset.service.DfDataSetService;
import com.jxdinfo.hussar.df.data.set.api.dataset.vo.DataSetResultVo;
import com.jxdinfo.hussar.df.data.set.api.dataset.vo.DataSetWidget;
import com.jxdinfo.hussar.df.data.set.api.dto.DataSetFieldParamDto;
import com.jxdinfo.hussar.df.data.set.api.dto.DataSetQueryDto;
import com.jxdinfo.hussar.df.data.set.api.model.DfDataTypeConvert;
import com.jxdinfo.hussar.df.data.set.server.function.operation.DataSetMenthodEnums;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.engine.api.service.EngineApiService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.support.choreo.api.entity.ApiNaming;
import com.jxdinfo.hussar.support.choreo.api.service.ApiNamingService;
import com.jxdinfo.hussar.support.engine.api.model.NodeBusiness;
import com.jxdinfo.hussar.support.engine.api.service.NodeBusinessService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class DataSetQueryServiceImpl
implements DfDataSetService {
    private final EngineApiService engineApiService;
    private static final String TABLE_QUERY = "/tableQuery";
    private static final String PATH = "/hussar/df/dataSet/";
    private static final String PATH_PREFIX = "/";
    @Autowired
    private ApiNamingService apiNamingService;
    @Autowired
    private NodeBusinessService nodeBusinessService;

    public DataSetQueryServiceImpl(EngineApiService engineApiService) {
        this.engineApiService = engineApiService;
    }

    public ApiResponse<DataSetResultVo> queryData(DataSetQueryDto dataSetQueryDto) {
        Long dataSetId = dataSetQueryDto.getDataSetId();
        DataSetResultVo dataSetResultVo = new DataSetResultVo();
        String businessId = "POST /hussar/df/dataSet/" + FileUtil.posixPath((String[])new String[]{String.valueOf(dataSetId)}) + TABLE_QUERY;
        ApiNaming apiNaming = this.apiNamingService.getApiNaming(businessId);
        NodeBusiness nodeBusiness = new NodeBusiness();
        ArrayList dataSetWidgetList = new ArrayList();
        List dataSetFieldParamList = new ArrayList();
        if (ToolUtil.isNotEmpty((Object)apiNaming)) {
            nodeBusiness = this.nodeBusinessService.getBusinessByNodeName(apiNaming.getServiceName());
        }
        if (Optional.ofNullable(nodeBusiness).isPresent()) {
            JSONObject jsonObject = JSON.parseObject((String)nodeBusiness.getJsonParams());
            Object object = jsonObject.get((Object)"pmList");
            dataSetFieldParamList = JsonUtil.readList((String)object.toString(), DataSetFieldParamDto.class);
            dataSetFieldParamList.forEach(field -> {
                DataSetWidget dataSetWidget = new DataSetWidget();
                dataSetWidgetList.add(dataSetWidget);
                dataSetWidget.setName(field.getParameterAlias());
                dataSetWidget.setTitle(field.getTitle());
                String dataType = DfDataTypeConvert.convertJavaDataType((String)field.getFunctionJavaType());
                dataSetWidget.setDataType(dataType);
                dataSetWidget.setType(DfDataTypeConvert.dataTypeConvertWidget((String)dataType));
            });
            dataSetResultVo.setDataSetWidgets(dataSetWidgetList);
        }
        dataSetResultVo.setBusinessData(((ApiResponse)this.engineApiService.invokeByReturnEntity(businessId, null, dataSetQueryDto.getParams()).getBody()).getData());
        return ApiResponse.success((Object)dataSetResultVo, (String)"\u64cd\u4f5c\u6210\u529f");
    }

    public ApiResponse<Object> echartQueryDataSet(DataSetQueryDto dataSetQueryDto) {
        Long dataSetId = dataSetQueryDto.getDataSetId();
        String businessId = "POST /hussar/df/dataSet/" + FileUtil.posixPath((String[])new String[]{String.valueOf(dataSetId)}) + "/echartQuery";
        Map params = dataSetQueryDto.getParams();
        ResponseEntity apiResponseResponseEntity = this.engineApiService.invokeByReturnEntity(businessId, null, params);
        return (ApiResponse)apiResponseResponseEntity.getBody();
    }

    public ApiResponse<Object> customDataSetQueryPage(DataSetQueryDto dataSetQueryDto) {
        Long dataSetId = dataSetQueryDto.getDataSetId();
        String businessId = String.format("%s ", DataSetMenthodEnums.CUSTOM_DATASET_QUERY_PAGE.getRequest()) + PATH + FileUtil.posixPath((String[])new String[]{String.valueOf(dataSetId)}) + PATH_PREFIX + DataSetMenthodEnums.CUSTOM_DATASET_QUERY_PAGE.getMenthodName();
        Map params = dataSetQueryDto.getParams();
        ResponseEntity apiResponseResponseEntity = this.engineApiService.invokeByReturnEntity(businessId, null, params);
        return (ApiResponse)apiResponseResponseEntity.getBody();
    }

    public ApiResponse<Object> customDataSetQueryList(DataSetQueryDto dataSetQueryDto) {
        Long dataSetId = dataSetQueryDto.getDataSetId();
        String businessId = String.format("%s ", DataSetMenthodEnums.CUSTOM_DATASET_QUERY_LIST.getRequest()) + PATH + FileUtil.posixPath((String[])new String[]{String.valueOf(dataSetId)}) + PATH_PREFIX + DataSetMenthodEnums.CUSTOM_DATASET_QUERY_LIST.getMenthodName();
        Map params = dataSetQueryDto.getParams();
        ResponseEntity apiResponseResponseEntity = this.engineApiService.invokeByReturnEntity(businessId, null, params);
        return (ApiResponse)apiResponseResponseEntity.getBody();
    }

    public ApiResponse<Object> dataSetPublicQuery(DataSetQueryDto dataSetQueryDto) {
        switch (dataSetQueryDto.getType()) {
            case "0": {
                return this.echartQueryDataSet(dataSetQueryDto);
            }
            case "1": {
                return this.customDataSetQueryList(dataSetQueryDto);
            }
        }
        return this.echartQueryDataSet(dataSetQueryDto);
    }
}

