/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.df.data.set.server.util;

import com.jxdinfo.hussar.datasource.manager.api.entity.MetadataColumn;
import com.jxdinfo.hussar.datasource.manager.api.model.TableInfoDto;
import com.jxdinfo.hussar.df.data.set.api.dto.HeRelationDTO;
import com.jxdinfo.hussar.df.data.set.api.enums.DfRelationEnum;
import com.jxdinfo.hussar.df.data.set.api.model.DataSetSuncModel;
import com.jxdinfo.hussar.df.data.set.api.model.DataSetTableField;
import com.jxdinfo.hussar.df.data.set.api.model.DataSetTables;
import com.jxdinfo.hussar.df.data.set.api.model.JoinSubset;
import com.jxdinfo.hussar.df.data.set.api.model.JoinTable;
import com.jxdinfo.hussar.df.data.set.server.util.DfExternalApiUtil;
import com.jxdinfo.hussar.df.data.set.server.util.DfOperationUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.support.engine.api.dto.ModelPublishDTO;
import com.jxdinfo.hussar.support.engine.api.entity.RelationshipOn;
import com.jxdinfo.hussar.support.engine.api.enums.OperatorType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DfDataModelUtil {
    private static Logger logger = LoggerFactory.getLogger(DfDataModelUtil.class);

    public static HeRelationDTO slaveRelationSync(ModelPublishDTO masterTableInfo, DataSetSuncModel dataSetSuncModel, List<JoinTable> relationships, String functionType) {
        ArrayList<ModelPublishDTO> slaveList = new ArrayList<ModelPublishDTO>();
        for (DataSetTables slaveTable : dataSetSuncModel.getSavleTable()) {
            slaveList.add(DfOperationUtil.MasterModelToEngine(dataSetSuncModel.getProjectionFieldList(), slaveTable, dataSetSuncModel.getTfmodelname(), dataSetSuncModel.getTfModelId()));
        }
        for (ModelPublishDTO mbdto : slaveList) {
            mbdto.setType("master");
            mbdto.setRelation(DfRelationEnum.getValueByKey((String)"association"));
            mbdto.setParentPath(masterTableInfo.getParentPath() + "," + masterTableInfo.getRelatedId());
            Optional<DataSetTables> slaveOp = dataSetSuncModel.getSavleTable().stream().filter(x -> (dataSetSuncModel.getTfModelId() + x.getTableId()).equals(mbdto.getTfmodelId())).findFirst();
            if (!slaveOp.isPresent()) continue;
            DataSetTables slave = (DataSetTables)slaveOp.get();
            mbdto.setParamName(DfDataModelUtil.convertToCamelCase(slave.getName()));
        }
        HashMap<String, String> modelIdNameMap = new HashMap<String, String>();
        List masterFieldsList = dataSetSuncModel.getMasterTable().getFields();
        for (DataSetTableField heDataModelField : masterFieldsList) {
            modelIdNameMap.put(String.valueOf(heDataModelField.getColumnId()), heDataModelField.getRealName());
        }
        for (DataSetTables slave : dataSetSuncModel.getSavleTable()) {
            List slaveFieldsList = slave.getFields();
            for (DataSetTableField heDataModelField : slaveFieldsList) {
                modelIdNameMap.put(String.valueOf(heDataModelField.getColumnId()), heDataModelField.getRealName());
            }
        }
        TableInfoDto metaMasterTableInfo = DfExternalApiUtil.getTableByName(dataSetSuncModel.getMasterTable().getName(), false);
        HashMap<String, Long> masterMetaNameIdMap = new HashMap<String, Long>();
        for (MetadataColumn column : metaMasterTableInfo.getColumnList()) {
            masterMetaNameIdMap.put(column.getColumnName(), column.getColumnId());
        }
        for (JoinTable fieldRelationShip : relationships) {
            TableInfoDto slaveTableInfo = DfExternalApiUtil.getTableByName(fieldRelationShip.getRightTable(), false);
            HashMap<String, Long> slaveMetaNameIdMap = new HashMap<String, Long>();
            for (MetadataColumn column : slaveTableInfo.getColumnList()) {
                slaveMetaNameIdMap.put(column.getColumnName(), column.getColumnId());
            }
            ArrayList<RelationshipOn> ons = new ArrayList<RelationshipOn>();
            Optional<ModelPublishDTO> mbdtoSlaveOp = slaveList.stream().filter(x -> x.getTfmodelId().equals(dataSetSuncModel.getTfModelId() + slaveTableInfo.getTableId())).findFirst();
            if (!mbdtoSlaveOp.isPresent()) continue;
            ModelPublishDTO mpdtoSlave = mbdtoSlaveOp.get();
            for (JoinSubset joinSubset : fieldRelationShip.getChildren()) {
                RelationshipOn relationshipOn = new RelationshipOn();
                Long leftColumnId = null;
                leftColumnId = ToolUtil.isNotEmpty((Object)joinSubset.getLeftFieldId()) && joinSubset.getLeftFieldId() != null ? Long.valueOf(joinSubset.getLeftFieldId()) : (Long)masterMetaNameIdMap.get(joinSubset.getLeftField());
                Long rightColumnId = (Long)slaveMetaNameIdMap.get(joinSubset.getRightField());
                relationshipOn.setLeftColumnId(leftColumnId);
                relationshipOn.setRightColumnId(rightColumnId);
                relationshipOn.setOperatorType(OperatorType.EQ);
                OperatorType.getByValue((String)joinSubset.getCondition());
                ons.add(relationshipOn);
            }
            mpdtoSlave.setOns(ons);
        }
        return new HeRelationDTO.HeRelationDTOBuilder().withMasterPublishDTO(masterTableInfo).withSlavePublishDTO(slaveList).build();
    }

    public static String convertToCamelCase(String tableName) {
        StringBuilder result = new StringBuilder();
        boolean nextUpperCase = false;
        for (int i = 0; i < tableName.length(); ++i) {
            char currentChar = tableName.charAt(i);
            if (currentChar == '_') {
                nextUpperCase = true;
                continue;
            }
            if (nextUpperCase) {
                result.append(Character.toUpperCase(currentChar));
                nextUpperCase = false;
                continue;
            }
            result.append(Character.toLowerCase(currentChar));
        }
        return result.toString();
    }
}

