/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.df.data.set.server.util;

import com.jxdinfo.hussar.datasource.manager.api.entity.MetadataColumn;
import com.jxdinfo.hussar.datasource.manager.api.model.TableInfoDto;
import com.jxdinfo.hussar.df.common.constant.DfTypeConversionEnum;
import com.jxdinfo.hussar.df.data.set.api.dto.DfModelSyncDto;
import com.jxdinfo.hussar.df.data.set.api.model.DataSetModel;
import com.jxdinfo.hussar.df.data.set.api.model.DataSetTableField;
import com.jxdinfo.hussar.df.data.set.api.model.DataSetTables;
import com.jxdinfo.hussar.df.data.set.api.model.ProjectionField;
import com.jxdinfo.hussar.df.data.set.server.util.DfExternalApiUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.external.require.engine.utils.LrEngineUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.api.dto.ModelPublishDTO;
import com.jxdinfo.hussar.support.engine.api.entity.ModelColumns;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class DfOperationUtil {
    private DfOperationUtil() {
    }

    public static ModelPublishDTO ModelToEngine(DataSetModel dataSetModel, String tableName) {
        ArrayList<MetadataColumn> metaColumnList = new ArrayList<MetadataColumn>();
        TableInfoDto tableInfo = DfExternalApiUtil.getTableByName(tableName, false);
        Long tableId = tableInfo.getTableId();
        if (ToolUtil.isEmpty((Object)tableInfo)) {
            return null;
        }
        for (ProjectionField projectionField2 : dataSetModel.getProjection()) {
            for (MetadataColumn metadataColumn : tableInfo.getColumnList()) {
                if (!projectionField2.getField().equals(metadataColumn.getColumnName())) continue;
                metadataColumn.setColumnComment(projectionField2.getRename());
                metadataColumn.setColumnAlias(projectionField2.getFieldAlias());
                metaColumnList.add(metadataColumn);
            }
        }
        List<ProjectionField> calcList = dataSetModel.getProjection().stream().filter(field -> field.getType().equals("calc")).collect(Collectors.toList());
        calcList.forEach(projectionField -> {
            List<MetadataColumn> calcFieldList = DfOperationUtil.getCalcFieldList(tableInfo, projectionField);
            metaColumnList.addAll(calcFieldList);
        });
        ModelPublishDTO mpdto = new ModelPublishDTO();
        mpdto.setRelatedId(Long.valueOf(LrEngineUtil.nextId()));
        mpdto.setTfmodelId(String.valueOf(dataSetModel.getDataSetId()));
        mpdto.setTfmodelName(dataSetModel.getDataSetCode());
        mpdto.setParamName(dataSetModel.getDataSetCode());
        mpdto.setTableId(tableId);
        mpdto.setParentPath("0");
        ArrayList modelColumnsList = new ArrayList();
        List metadataColumnList = metaColumnList.stream().distinct().collect(Collectors.toList());
        Map<String, Long> columnName2Id = metadataColumnList.stream().collect(Collectors.toMap(MetadataColumn::getColumnAlias, MetadataColumn::getColumnId));
        List fields = dataSetModel.getProjection();
        metaColumnList.forEach(field -> {
            ModelColumns modelColumns = new ModelColumns();
            modelColumnsList.add(modelColumns);
            modelColumns.setColumnId((Long)columnName2Id.get(field.getColumnAlias()));
            modelColumns.setColumnName(field.getColumnName());
            modelColumns.setColumnAlias(field.getColumnAlias());
            modelColumns.setTfmodelColumnId(String.valueOf(field.getColumnId()));
            modelColumns.setTfmodelId(String.valueOf(dataSetModel.getDataSetId()));
            modelColumns.setColumnRemark(field.getColumnComment());
        });
        mpdto.setModelColumns(modelColumnsList);
        return mpdto;
    }

    public static List<String> replacePlaceholders(String expression) {
        Pattern pattern = Pattern.compile("\\$\\{(.*?)}");
        Matcher matcher = pattern.matcher(expression);
        ArrayList<String> columnIdList = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String placeholder = matcher.group();
            String id = placeholder.substring(2, placeholder.length() - 1);
            columnIdList.add(id);
        }
        return columnIdList;
    }

    public static List<MetadataColumn> getCalcFieldList(TableInfoDto tableInfo, ProjectionField projectionField) {
        String field = projectionField.getExpression();
        List<String> list = DfOperationUtil.replacePlaceholders(field);
        List columnList = tableInfo.getColumnList();
        ArrayList<MetadataColumn> findColumnList = new ArrayList<MetadataColumn>();
        for (String columnId : list) {
            Optional<MetadataColumn> firstMetadataColumn = columnList.stream().filter(x -> x.getColumnId().toString().equals(columnId)).findFirst();
            if (!firstMetadataColumn.isPresent()) continue;
            findColumnList.add(firstMetadataColumn.get());
        }
        return findColumnList;
    }

    public static ModelPublishDTO MasterModelToEngine(List<ProjectionField> projectionFields, DataSetTables dataSetTables, String name, String tfmodelId) {
        TableInfoDto tableInfo = DfExternalApiUtil.getTableByName(dataSetTables.getName(), false);
        List oldMetaColumnList = tableInfo.getColumnList();
        ArrayList newMetaColumnList = new ArrayList();
        if (ToolUtil.isEmpty((Object)tableInfo)) {
            return new ModelPublishDTO();
        }
        Long tableId = tableInfo.getTableId();
        HashMap<String, ProjectionField> projectionFieldMap = new HashMap<String, ProjectionField>();
        for (ProjectionField projectionField : projectionFields) {
            projectionFieldMap.put(projectionField.getField() + "." + projectionField.getTable(), projectionField);
        }
        ModelPublishDTO mpdto = new ModelPublishDTO();
        mpdto.setRelatedId(Long.valueOf(LrEngineUtil.nextId()));
        if (dataSetTables.isPrimaryTable()) {
            mpdto.setTfmodelId(tfmodelId);
        } else {
            mpdto.setTfmodelId(tfmodelId + tableId);
        }
        mpdto.setTfmodelName(dataSetTables.getName());
        mpdto.setParamName(name);
        mpdto.setTableId(tableId);
        mpdto.setParentPath("0");
        ArrayList modelColumnsList = new ArrayList();
        List<MetadataColumn> metadataColumnList = oldMetaColumnList.stream().distinct().collect(Collectors.toList());
        metadataColumnList.forEach(field -> {
            ModelColumns modelColumns = new ModelColumns();
            ProjectionField projectionField = (ProjectionField)projectionFieldMap.get(field.getColumnName() + "." + field.getTableName());
            if (HussarUtils.isEmpty((Object)projectionField)) {
                projectionField = new ProjectionField();
                projectionField.setFieldId(String.valueOf(field.getColumnId()));
                projectionField.setFieldAlias(field.getTableName() + "_" + field.getColumnAlias());
            }
            modelColumnsList.add(modelColumns);
            modelColumns.setColumnId(field.getColumnId());
            modelColumns.setColumnName(field.getColumnName());
            modelColumns.setColumnAlias(projectionField.getFieldAlias());
            modelColumns.setTfmodelColumnId(projectionField.getFieldId());
            modelColumns.setTfmodelId(tfmodelId);
            modelColumns.setColumnRemark(projectionField.getRename());
        });
        mpdto.setModelColumns(modelColumnsList);
        return mpdto;
    }

    public static DfModelSyncDto conversionFunction(DataSetModel dataModel, String path, String type) {
        String sourceDataModelName = null;
        DfModelSyncDto modelSyncDto = new DfModelSyncDto();
        modelSyncDto.setModelPath(path);
        modelSyncDto.setTfModelId(String.valueOf(dataModel.getDataSetId()));
        modelSyncDto.setNodeType(DfTypeConversionEnum.getValueByKey((String)type));
        modelSyncDto.setTableName(sourceDataModelName);
        modelSyncDto.setParamName(dataModel.getDataSetCode());
        ArrayList<DfModelSyncDto.ModelSyncColumn> columnList = new ArrayList<DfModelSyncDto.ModelSyncColumn>();
        List fields = ((DataSetTables)dataModel.getTables().get(0)).getFields();
        for (DataSetTableField field : fields) {
            DfModelSyncDto.ModelSyncColumn modelSyncColumn = new DfModelSyncDto.ModelSyncColumn();
            modelSyncColumn.setTfColumnId(String.valueOf(dataModel.getDataSetId()));
            modelSyncColumn.setColumnAlias(field.getName());
            columnList.add(modelSyncColumn);
        }
        modelSyncDto.setColumns(columnList);
        return modelSyncDto;
    }

    public static String getRealPath(String path) {
        StringBuffer pathBuffer = new StringBuffer(path);
        pathBuffer.insert(0, '/');
        pathBuffer.append(".dbd");
        int index = pathBuffer.indexOf(".");
        pathBuffer.setCharAt(index, '/');
        return pathBuffer.toString();
    }
}

