/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.df.data.set.server.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.df.common.constant.app.DataSetTypeEnum;
import com.jxdinfo.hussar.df.common.factory.DataSetFactory;
import com.jxdinfo.hussar.df.data.set.api.app.model.SysDataSetInfo;
import com.jxdinfo.hussar.df.data.set.api.app.service.ISysDataSetInfoService;
import com.jxdinfo.hussar.df.data.set.api.model.DataSetModelBase;
import com.jxdinfo.hussar.df.data.set.api.processor.DataSetProcessor;
import com.jxdinfo.hussar.df.data.set.api.processor.DefaultDataSetProcessor;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSetUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataSetUtil.class);
    private static final ISysDataSetInfoService sysDataSetInfoService = (ISysDataSetInfoService)SpringUtil.getBean(ISysDataSetInfoService.class);

    public static DataSetModelBase getDataModelBase(Long modelId) {
        String json = DataSetUtil.getDataSetString(modelId);
        if (HussarUtils.isEmpty((Object)json)) {
            return new DataSetModelBase();
        }
        return (DataSetModelBase)JSON.parseObject((String)json, DataSetModelBase.class);
    }

    public static String getDataSetString(Long modelId) {
        SysDataSetInfo sysDataSetInfo = (SysDataSetInfo)sysDataSetInfoService.getById((Serializable)modelId);
        if (HussarUtils.isEmpty((Object)sysDataSetInfo)) {
            return null;
        }
        String data = sysDataSetInfo.getData();
        JSONObject jsonObject = JSON.parseObject((String)data);
        JSONObject parseObject = JSON.parseObject((String)JSON.toJSONString((Object)sysDataSetInfo));
        jsonObject.putAll((Map)parseObject);
        return jsonObject.toJSONString();
    }

    public static <T extends DataSetModelBase> T getDataModel(String modelId, Class<T> clazz) {
        String json = DataSetUtil.getDataSetString(Long.parseLong(modelId));
        return (T)((DataSetModelBase)JSON.parseObject((String)json, clazz));
    }

    public static boolean haveNullFiled(Object object) {
        if (Objects.isNull(object)) {
            return true;
        }
        try {
            for (Field field : object.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                if (field.get(object) != null && !HussarUtils.isBlank((CharSequence)field.get(object).toString())) continue;
                return true;
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5224\u65ad\u5bf9\u8c61\u662f\u5426\u4e3a\u7a7a", (Throwable)e);
        }
        return false;
    }

    public static String replacePlaceholders(String expression, Map<String, String> map) {
        Pattern pattern = Pattern.compile("\\$\\{(.*?)}");
        Matcher matcher = pattern.matcher(expression);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String placeholder = matcher.group();
            String id = placeholder.substring(2, placeholder.length() - 1);
            String value = map.getOrDefault(id, "");
            matcher.appendReplacement(sb, value);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static String getDataSetType(Long id) throws IOException, LcdpException {
        DataSetModelBase dataSetModelBase = DataSetUtil.getDataModelBase(id);
        return DataSetTypeEnum.parseFunctionType((String)dataSetModelBase.getDataSetType());
    }

    public static DataSetProcessor processor(String type) {
        DataSetProcessor scriptParser = (DataSetProcessor)SpringUtil.getBean(DefaultDataSetProcessor.class);
        String parser = DataSetFactory.get((String)type);
        if (HussarUtils.isEmpty((Object)parser)) {
            LOGGER.error("\u6570\u636e\u96c6\u672a\u6ce8\u518c: {}", (Object)parser);
            return scriptParser;
        }
        try {
            scriptParser = (DataSetProcessor)SpringUtil.getBean((String)parser, DataSetProcessor.class);
        }
        catch (Exception e) {
            LOGGER.error("\u6570\u636e\u96c6\u672a\u6ce8\u518c\uff1a{}", (Object)parser);
        }
        return scriptParser;
    }
}

