/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.df.data.set.server.util;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.extension.toolkit.JdbcUtils;
import com.jxdinfo.hussar.df.data.set.server.util.DfExternalApiUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;

public class DataTypeConverter {
    public static String dataTypeConverted(String fieldType, Long dataSourceId) {
        String dataType = "string";
        String jdbcUrl = DfExternalApiUtil.getDataSourceId(dataSourceId).getJdbcUrl();
        DbType dbType = JdbcUtils.getDbType((String)jdbcUrl);
        if (HussarUtils.isNotBlank((CharSequence)fieldType) && HussarUtils.isNotEmpty((Object)dbType)) {
            fieldType = fieldType.toLowerCase();
            switch (dbType) {
                case DM: {
                    dataType = DataTypeConverter.dmDataTypeConverted(fieldType);
                    break;
                }
                case OSCAR: {
                    dataType = DataTypeConverter.oscarDataTypeConverted(fieldType);
                    break;
                }
                case ORACLE: 
                case ORACLE_12C: {
                    dataType = DataTypeConverter.oracleDataTypeConverted(fieldType);
                    break;
                }
                case HIGH_GO: {
                    dataType = DataTypeConverter.highGoDataTypeConverted(fieldType);
                    break;
                }
                case KINGBASE_ES: {
                    dataType = DataTypeConverter.kingBaseDataTypeConverted(fieldType);
                    break;
                }
                case SQL_SERVER: 
                case SQL_SERVER2005: {
                    dataType = DataTypeConverter.sqlServerDataTypeConverted(fieldType);
                    break;
                }
                case POSTGRE_SQL: {
                    dataType = DataTypeConverter.postgreSqlDataTypeConverted(fieldType);
                    break;
                }
                default: {
                    dataType = DataTypeConverter.mysqlDataTypeConverted(fieldType);
                }
            }
        }
        return dataType;
    }

    public static String mysqlDataTypeConverted(String fieldType) {
        if (HussarUtils.isNotEmpty((Object)fieldType)) {
            if (fieldType.contains("char") || fieldType.contains("text") || fieldType.contains("year")) {
                return "string";
            }
            if (fieldType.contains("bigint")) {
                return "long";
            }
            if (fieldType.contains("int")) {
                return "int";
            }
            if (fieldType.contains("timestamp") || fieldType.contains("date")) {
                return "date";
            }
            if (fieldType.contains("bit")) {
                return "boolean";
            }
            if (fieldType.contains("float") || fieldType.contains("double") || fieldType.contains("decimal")) {
                return "double";
            }
        }
        return "string";
    }

    public static String dmDataTypeConverted(String fieldType) {
        if (HussarUtils.isNotEmpty((Object)fieldType)) {
            if (fieldType.contains("char")) {
                return "string";
            }
            if (fieldType.contains("timestamp") || fieldType.contains("date")) {
                return "date";
            }
            if (fieldType.contains("decimal")) {
                return "long";
            }
            if (fieldType.contains("float")) {
                return "double";
            }
        }
        return "string";
    }

    public static String oscarDataTypeConverted(String fieldType) {
        if (HussarUtils.isNotEmpty((Object)fieldType)) {
            if ("char".equals(fieldType) || "varchar".equals(fieldType)) {
                return "string";
            }
            if ("date".equals(fieldType) || "time".equals(fieldType) || "timestamp".equals(fieldType)) {
                return "date";
            }
            if ("numeric".equals(fieldType)) {
                return "long";
            }
            if ("float".equals(fieldType)) {
                return "double";
            }
        }
        return "string";
    }

    public static String oracleDataTypeConverted(String fieldType) {
        if (HussarUtils.isNotEmpty((Object)fieldType)) {
            String type = fieldType;
            if (type.contains("char")) {
                return "string";
            }
            if (type.contains("date") || type.contains("timestamp")) {
                return "date";
            }
            if (type.contains("number")) {
                return "long";
            }
            if (type.contains("float")) {
                return "double";
            }
        }
        return "string";
    }

    public static String highGoDataTypeConverted(String fieldType) {
        if (HussarUtils.isNotEmpty((Object)fieldType)) {
            if (fieldType.contains("bpchar") || fieldType.contains("text") || fieldType.contains("varchar")) {
                return "string";
            }
            if (fieldType.contains("numeric")) {
                return "long";
            }
            if (fieldType.contains("date") || fieldType.contains("timestamp")) {
                return "date";
            }
            if (fieldType.contains("float4") || fieldType.contains("float8")) {
                return "double";
            }
            if (fieldType.contains("boolean")) {
                return "boolean";
            }
        }
        return "string";
    }

    public static String kingBaseDataTypeConverted(String fieldType) {
        if (HussarUtils.isNotEmpty((Object)fieldType)) {
            if (fieldType.contains("char") || fieldType.contains("text")) {
                return "string";
            }
            if (fieldType.contains("numeric")) {
                return "long";
            }
            if (fieldType.contains("time") || fieldType.contains("date") || fieldType.contains("timestamp")) {
                return "date";
            }
            if (fieldType.contains("bool")) {
                return "boolean";
            }
            if (fieldType.contains("float")) {
                return "double";
            }
        }
        return "string";
    }

    public static String sqlServerDataTypeConverted(String fieldType) {
        if (HussarUtils.isNotEmpty((Object)fieldType)) {
            if (fieldType.contains("char") || fieldType.contains("nvarchar")) {
                return "string";
            }
            if (fieldType.contains("numeric")) {
                return "long";
            }
            if (fieldType.contains("date") || fieldType.contains("datetime") || fieldType.contains("datetime2")) {
                return "date";
            }
            if (fieldType.contains("float") || fieldType.contains("decimal")) {
                return "double";
            }
        }
        return "string";
    }

    public static String postgreSqlDataTypeConverted(String fieldType) {
        if (HussarUtils.isNotEmpty((Object)fieldType)) {
            if ("bpchar".equals(fieldType) || "varchar".equals(fieldType) || "text".equals(fieldType)) {
                return "string";
            }
            if ("numeric".equals(fieldType)) {
                return "long";
            }
            if ("date".equals(fieldType) || "timestamp".equals(fieldType)) {
                return "date";
            }
            if ("float4".equals(fieldType) || "float8".equals(fieldType)) {
                return "double";
            }
            if ("boolean".equals(fieldType)) {
                return "boolean";
            }
        }
        return "string";
    }
}

