/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.df.data.set.server.app.service.impl;

import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.df.common.exception.DfException;
import com.jxdinfo.hussar.df.data.set.api.app.dto.SysDataSetInfoDto;
import com.jxdinfo.hussar.df.data.set.api.app.model.SysDataSetInfo;
import com.jxdinfo.hussar.df.data.set.api.app.service.ISysDataSetInfoService;
import com.jxdinfo.hussar.df.data.set.api.app.vo.SysDataSetGroupVo;
import com.jxdinfo.hussar.df.data.set.api.app.vo.SysDataSetInfoVo;
import com.jxdinfo.hussar.df.data.set.api.app.vo.SysSiftDataSetGroupList;
import com.jxdinfo.hussar.df.data.set.server.app.dao.SysDataSetGroupMapper;
import com.jxdinfo.hussar.df.data.set.server.app.dao.SysDataSetInfoMapper;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.df.data.set.app.service.impl.sysDataSetInfoServiceImpl")
public class SysDataSetInfoServiceImpl
extends HussarServiceImpl<SysDataSetInfoMapper, SysDataSetInfo>
implements ISysDataSetInfoService {
    @Resource
    private SysDataSetInfoMapper sysDataSetInfoMapper;
    @Resource
    private SysDataSetGroupMapper sysDataSetInfoGroupMapper;

    @HussarTransactional(rollbackFor={Exception.class})
    public ApiResponse<Long> addDataSetInfo(SysDataSetInfoDto sysDataSetInfoDto) {
        if (!this.save((BaseEntity)sysDataSetInfoDto)) {
            throw new DfException("\u65b0\u589e\u5931\u8d25\uff01");
        }
        return ApiResponse.success((Object)sysDataSetInfoDto.getDataSetId(), (String)"\u65b0\u589e\u6210\u529f\uff01");
    }

    public ApiResponse<Long> editDataSetInfo(SysDataSetInfoDto sysDataSetInfoDto) {
        if (HussarUtils.isEmpty((Object)this.getById(sysDataSetInfoDto.getDataSetId()))) {
            return this.addDataSetInfo(sysDataSetInfoDto);
        }
        if (!this.updateById((BaseEntity)sysDataSetInfoDto)) {
            throw new BaseException("\u4fee\u6539\u5931\u8d25\uff01");
        }
        return ApiResponse.success((Object)sysDataSetInfoDto.getDataSetId(), (String)"\u4fee\u6539\u6210\u529f\uff01");
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public ApiResponse<Boolean> deleteDataSetInfo(Long dataSetId) {
        if (!this.removeById(dataSetId)) {
            throw new BaseException("\u5220\u9664\u5931\u8d25\uff01");
        }
        return ApiResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    public SysSiftDataSetGroupList getDataSetInfoList(String dataSetName, Long appId, Long groupId) {
        SysSiftDataSetGroupList sysSiftDataSetGroupList = new SysSiftDataSetGroupList();
        List<SysDataSetInfoVo> sysDataSetInfoList = this.sysDataSetInfoMapper.getSysDataSetInfoList(dataSetName, appId, groupId);
        ArrayList<Long> groupIds = new ArrayList<Long>();
        List<Object> sysDataSetInfoGroups = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)groupId) && HussarUtils.isEmpty((Object)dataSetName)) {
            groupIds.add(groupId);
            sysDataSetInfoGroups = this.sysDataSetInfoGroupMapper.getSysDataSetGroupList(appId, groupIds);
        } else if (HussarUtils.isNotEmpty((Object)dataSetName) && HussarUtils.isNotEmpty((Object)groupId)) {
            for (SysDataSetInfoVo sysDataSetInfoVo : sysDataSetInfoList) {
                Long dataSetGroupId = sysDataSetInfoVo.getGroupId();
                if (!HussarUtils.isNotEmpty((Object)dataSetGroupId) || !dataSetGroupId.equals(groupId)) continue;
                groupIds.add(dataSetGroupId);
            }
            if (HussarUtils.isNotEmpty(groupIds)) {
                sysDataSetInfoGroups = this.sysDataSetInfoGroupMapper.getSysDataSetGroupList(appId, groupIds);
            }
        } else if (HussarUtils.isEmpty((Object)groupId) && HussarUtils.isNotEmpty((Object)dataSetName)) {
            for (SysDataSetInfoVo sysDataSetInfoVo : sysDataSetInfoList) {
                Long dataSetGroupId = sysDataSetInfoVo.getGroupId();
                if (!HussarUtils.isNotEmpty((Object)dataSetGroupId)) continue;
                groupIds.add(dataSetGroupId);
            }
            if (HussarUtils.isNotEmpty(groupIds)) {
                sysDataSetInfoGroups = this.sysDataSetInfoGroupMapper.getSysDataSetGroupList(appId, groupIds);
            }
        } else {
            sysDataSetInfoGroups = this.sysDataSetInfoGroupMapper.getSysDataSetGroupList(appId, null);
        }
        if (HussarUtils.isEmpty(sysDataSetInfoList)) {
            sysSiftDataSetGroupList.setHaveGroupList(sysDataSetInfoGroups);
            return sysSiftDataSetGroupList;
        }
        return this.combinedData(sysDataSetInfoList, sysDataSetInfoGroups);
    }

    private SysSiftDataSetGroupList combinedData(List<SysDataSetInfoVo> sysDataSetInfoList, List<SysDataSetGroupVo> sysDataSetGroups) {
        ArrayList<SysDataSetInfoVo> noGroupList = new ArrayList<SysDataSetInfoVo>();
        SysSiftDataSetGroupList sysSiftDataSetGroupList = new SysSiftDataSetGroupList();
        HashMap<Long, SysDataSetGroupVo> sysDataSetGroupVoMap = new HashMap<Long, SysDataSetGroupVo>();
        for (SysDataSetGroupVo sysDataSetGroupVo : sysDataSetGroups) {
            sysDataSetGroupVoMap.put(sysDataSetGroupVo.getGroupId(), sysDataSetGroupVo);
        }
        for (SysDataSetInfoVo sysDataSetInfoVo : sysDataSetInfoList) {
            SysDataSetGroupVo sysDataSetGroupVo = (SysDataSetGroupVo)sysDataSetGroupVoMap.get(sysDataSetInfoVo.getGroupId());
            if (HussarUtils.isEmpty((Object)sysDataSetGroupVo)) {
                noGroupList.add(sysDataSetInfoVo);
                continue;
            }
            if (HussarUtils.isEmpty((Object)sysDataSetGroupVo.getSysDataSetList())) {
                ArrayList dataSetGroupList = new ArrayList();
                sysDataSetGroupVo.setSysDataSetList(dataSetGroupList);
            }
            sysDataSetGroupVo.getSysDataSetList().add(sysDataSetInfoVo);
        }
        sysSiftDataSetGroupList.setHaveGroupList(sysDataSetGroups);
        sysSiftDataSetGroupList.setNoGroupList(noGroupList);
        return sysSiftDataSetGroupList;
    }
}

