/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.df.data.set.server.app.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysApplicationService;
import com.jxdinfo.hussar.df.data.set.api.app.constant.DataSetAppTypeEnum;
import com.jxdinfo.hussar.df.data.set.api.app.model.SysDataSetGroup;
import com.jxdinfo.hussar.df.data.set.api.app.model.SysDataSetInfo;
import com.jxdinfo.hussar.df.data.set.api.app.service.ISysDataSetApplicationService;
import com.jxdinfo.hussar.df.data.set.api.app.service.ISysDataSetGroupService;
import com.jxdinfo.hussar.df.data.set.api.app.service.ISysDataSetInfoService;
import com.jxdinfo.hussar.df.data.set.api.app.vo.DataSetAppInfoVo;
import com.jxdinfo.hussar.df.data.set.api.app.vo.SysDataSetAppVo;
import com.jxdinfo.hussar.df.data.set.api.app.vo.SysDataSetGroupVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class SysDataSetApplicationServiceImpl
implements ISysDataSetApplicationService {
    @Resource
    ISysApplicationService sysApplicationService;
    @Resource
    private ISysDataSetGroupService sysDataSetGroupService;
    @Resource
    private ISysDataSetInfoService sysDataSetInfoService;

    public ApiResponse<List<SysDataSetAppVo>> list() {
        SysDataSetAppVo sysDataSetAppVo;
        SysDataSetGroupVo sysDataSetGroupVo;
        ArrayList<SysDataSetAppVo> sysDataSetAppVos = new ArrayList<SysDataSetAppVo>();
        List sysApplications = this.sysApplicationService.list((Wrapper)Wrappers.lambdaQuery(SysApplication.class).eq(SysApplication::getAppType, (Object)DataSetAppTypeEnum.DATA_SET_APP_TYPE.getValue()));
        List sysDataSetGroups = this.sysDataSetGroupService.list();
        List sysDataSetInfos = this.sysDataSetInfoService.list();
        HashMap<Long, SysDataSetAppVo> sysDataSetAppVoMap = new HashMap<Long, SysDataSetAppVo>();
        for (SysApplication sysApplication : sysApplications) {
            SysDataSetAppVo sysDataSetAppVo2 = (SysDataSetAppVo)JSON.parseObject((String)JSON.toJSONString((Object)sysApplication), SysDataSetAppVo.class);
            sysDataSetAppVoMap.put(sysDataSetAppVo2.getId(), sysDataSetAppVo2);
            sysDataSetAppVos.add(sysDataSetAppVo2);
        }
        HashMap<Long, SysDataSetGroupVo> sysDataSetGroupMap = new HashMap<Long, SysDataSetGroupVo>();
        for (SysDataSetGroup sysDataSetGroup : sysDataSetGroups) {
            sysDataSetGroupVo = (SysDataSetGroupVo)JSON.parseObject((String)JSON.toJSONString((Object)sysDataSetGroup), SysDataSetGroupVo.class);
            sysDataSetGroupMap.put(sysDataSetGroupVo.getGroupId(), sysDataSetGroupVo);
            sysDataSetAppVo = (SysDataSetAppVo)sysDataSetAppVoMap.get(sysDataSetGroupVo.getAppId());
            if (!HussarUtils.isNotEmpty((Object)sysDataSetAppVo)) continue;
            sysDataSetAppVo.useSysSiftDataSetGroupList().addHaveGroup(sysDataSetGroupVo);
        }
        for (SysDataSetInfo sysDataSetInfo : sysDataSetInfos) {
            sysDataSetGroupVo = (SysDataSetGroupVo)sysDataSetGroupMap.get(sysDataSetInfo.getGroupId());
            if (sysDataSetGroupVo == null) {
                sysDataSetAppVo = (SysDataSetAppVo)sysDataSetAppVoMap.get(sysDataSetInfo.getAppId());
                if (sysDataSetAppVo == null) continue;
                sysDataSetAppVo.useSysSiftDataSetGroupList().addNoGroup(sysDataSetInfo);
                continue;
            }
            sysDataSetGroupVo.addSysDataSetInfo(sysDataSetInfo);
        }
        return ApiResponse.success(sysDataSetAppVos);
    }

    public ApiResponse<List<DataSetAppInfoVo>> dataSetList() {
        DataSetAppInfoVo dataSetAppInfoVo;
        ArrayList<DataSetAppInfoVo> dataSetAppInfoVos = new ArrayList<DataSetAppInfoVo>();
        List sysApplications = this.sysApplicationService.list((Wrapper)Wrappers.lambdaQuery(SysApplication.class).eq(SysApplication::getAppType, (Object)DataSetAppTypeEnum.DATA_SET_APP_TYPE.getValue()));
        List sysDataSetInfos = this.sysDataSetInfoService.list();
        HashMap<Long, DataSetAppInfoVo> dataSetAppInfoVoHashMap = new HashMap<Long, DataSetAppInfoVo>();
        for (SysApplication sysApplication : sysApplications) {
            dataSetAppInfoVo = (DataSetAppInfoVo)JSON.parseObject((String)JSON.toJSONString((Object)sysApplication), DataSetAppInfoVo.class);
            dataSetAppInfoVoHashMap.put(dataSetAppInfoVo.getId(), dataSetAppInfoVo);
            dataSetAppInfoVos.add(dataSetAppInfoVo);
        }
        for (SysDataSetInfo sysDataSetInfo : sysDataSetInfos) {
            dataSetAppInfoVo = (DataSetAppInfoVo)dataSetAppInfoVoHashMap.get(sysDataSetInfo.getAppId());
            if (HussarUtils.isEmpty((Object)dataSetAppInfoVo)) continue;
            dataSetAppInfoVo.addSysDataSetInfoList(sysDataSetInfo);
        }
        return ApiResponse.success(dataSetAppInfoVos);
    }
}

